/*
 * Decompiled with CFR 0.152.
 */
package com.sparework.kronos.components.todo;

import com.sparework.kronos.Language;
import com.sparework.kronos.components.ComponentUtility;
import com.sparework.kronos.components.html.HTMLMenu;
import com.sparework.kronos.components.html.HTMLObject;
import com.sparework.kronos.components.todo.ToDoXMLUtility;
import com.sparework.kronos.inputs.Input;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ToDoSharedUtility {
    private static boolean htmlMenuAlreadySetup = false;

    public static void setupHTMLMenu() {
        if (htmlMenuAlreadySetup) {
            return;
        }
        htmlMenuAlreadySetup = true;
        JMenuItem jMenuItem = new JMenuItem(Language.get((String)"todo", (String)"todo"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToDoSharedUtility.exportHTML();
            }
        });
        if (ComponentUtility.hasComponent((String)"html")) {
            HTMLMenu.addToMenu((JMenuItem)jMenuItem);
        }
    }

    public static void exportHTML() {
        if (ComponentUtility.hasComponent((String)"html")) {
            HTMLObject hTMLObject = new HTMLObject();
            hTMLObject.setTitle(Language.get((String)"todo", (String)"todo"));
            hTMLObject.addHeadings((Object[])new String[]{Language.get((String)"todo", (String)"todo"), Language.get((String)"todo", (String)"groups"), Language.get((String)"todo", (String)"urgency"), Language.get((String)"todo", (String)"priority"), Language.get((String)"todo", (String)"progress")});
            String[] stringArray = new String[]{Language.get((String)"todo", (String)"highurgency"), Language.get((String)"todo", (String)"mediumurgency"), Language.get((String)"todo", (String)"lowurgency"), Language.get((String)"todo", (String)"nourgency")};
            NodeList nodeList = ToDoXMLUtility.getNodeList();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                Input input = new Input(ToDoXMLUtility.getInputName(element), (Object)ToDoXMLUtility.getInputValue(element));
                hTMLObject.addData(new Object[]{hTMLObject.createDataElement(input.getXMLValue(), input.getMimeType()), ToDoXMLUtility.getGroup(element), stringArray[ToDoXMLUtility.getUrgency(element)], ToDoXMLUtility.getPriority(element).toString(), ToDoXMLUtility.getProgress(element) + "%"});
            }
            hTMLObject.promptToSave("todo.htm");
        }
    }
}

