/*
 * Decompiled with CFR 0.152.
 */
package com.sparework.kronos.components.reminder;

import com.sparework.kronos.components.ComponentUtility;
import com.sparework.kronos.components.reminder.CalendarUtility;
import com.sparework.kronos.components.reminder.ReminderType;
import com.sparework.kronos.inputs.Input;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ReminderXMLUtility {
    public static String getType(Element element) {
        String string = element.getAttribute("type");
        return string.equals("") ? "once" : string;
    }

    public static long getStartTime(Element element) {
        String string = element.getAttribute("starttime");
        return string.equals("") ? 0L : Long.parseLong(string);
    }

    public static long getEndTime(Element element) {
        String string = element.getAttribute("endtime");
        return string.equals("") ? 0L : Long.parseLong(string);
    }

    public static long getNextTime(Element element) {
        String string = element.getAttribute("nexttime");
        return string.equals("") ? 0L : Long.parseLong(string);
    }

    public static String getInputName(Element element) {
        String string = element.getAttribute("input");
        return string.equals("") ? "text" : string;
    }

    public static String getInputValue(Element element) {
        Text text = (Text)element.getFirstChild();
        return text == null ? " " : text.getNodeValue();
    }

    public static Element createXMLElement(String string, long l, long l2, long l3, Input input) {
        Document document = ComponentUtility.getDocument((String)"reminder.xml");
        Element element = ComponentUtility.createElement((String)"reminder.xml");
        element.setAttribute("type", string);
        element.setAttribute("starttime", String.valueOf(l));
        element.setAttribute("endtime", String.valueOf(l2 <= l ? Long.MAX_VALUE : l2));
        element.setAttribute("nexttime", String.valueOf(l3));
        element.setAttribute("input", input.getName());
        element.appendChild(document.createTextNode(input.getXMLValue()));
        return element;
    }

    public static int addXMLElement(Element element) {
        int n;
        NodeList nodeList = ReminderXMLUtility.getNodeList();
        Document document = ComponentUtility.getDocument((String)"reminder.xml");
        long l = ReminderXMLUtility.getNextTime(element);
        long l2 = 0L;
        int n2 = nodeList.getLength();
        for (n = 0; n < n2 && l > l2; ++n) {
            l2 = ReminderXMLUtility.getNextTime((Element)nodeList.item(n));
        }
        if (l <= l2) {
            document.getDocumentElement().insertBefore(element, nodeList.item(n - 1));
            document.getDocumentElement().insertBefore(document.createTextNode("\n"), nodeList.item(n));
        } else {
            document.getDocumentElement().appendChild(element);
            document.getDocumentElement().appendChild(document.createTextNode("\n"));
        }
        ComponentUtility.saveDocument((String)"reminder.xml");
        return n;
    }

    public static Element deleteXMLElement(int n) {
        Document document = ComponentUtility.getDocument((String)"reminder.xml");
        Element element = (Element)ReminderXMLUtility.getNodeList().item(n);
        document.getDocumentElement().removeChild(element.getNextSibling());
        document.getDocumentElement().removeChild(element);
        ComponentUtility.saveDocument((String)"reminder.xml");
        return element;
    }

    public static int deleteXMLElement(Element element) {
        Document document = ComponentUtility.getDocument((String)"reminder.xml");
        NodeList nodeList = ReminderXMLUtility.getNodeList();
        int n = ReminderXMLUtility.indexOf(element);
        document.getDocumentElement().removeChild(nodeList.item(n).getNextSibling());
        document.getDocumentElement().removeChild(nodeList.item(n));
        ComponentUtility.saveDocument((String)"reminder.xml");
        return n;
    }

    public static StringBuffer[] getAnnualDates(int n, int n2) {
        StringBuffer[] stringBufferArray = new StringBuffer[31];
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        NodeList nodeList = ReminderXMLUtility.getNodeList();
        int n3 = nodeList.getLength();
        for (int i = 0; i < n3; ++i) {
            Element element = (Element)nodeList.item(i);
            long l = ReminderXMLUtility.getStartTime(element);
            gregorianCalendar.setTimeInMillis(l);
            String string = ReminderXMLUtility.getType(element);
            String string2 = element.getFirstChild().getNodeValue().replaceAll("[\\s]+", " ");
            int n4 = gregorianCalendar.get(5) - 1;
            if (!ReminderType.isAnnualDates(gregorianCalendar, n, n2, string)) continue;
            if (stringBufferArray[n4] == null) {
                stringBufferArray[n4] = new StringBuffer();
            } else {
                stringBufferArray[n4].append(", ");
            }
            stringBufferArray[n4].append(string2);
        }
        return stringBufferArray;
    }

    public static ArrayList[] getReminders(int n, int n2) {
        NodeList nodeList = ReminderXMLUtility.getNodeList();
        ArrayList[] arrayListArray = new ArrayList[31];
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n3 = nodeList.getLength();
        for (int i = 0; i < n3; ++i) {
            Element element = (Element)nodeList.item(i);
            long l = ReminderXMLUtility.getStartTime(element);
            long l2 = ReminderXMLUtility.getEndTime(element);
            gregorianCalendar.setTimeInMillis(l);
            String string = ReminderXMLUtility.getType(element);
            String string2 = element.getFirstChild().getNodeValue().replaceAll("[\\s]+", " ");
            l = ReminderType.getReminders(gregorianCalendar, n, n2, string, string2);
            if (l <= -1L) continue;
            GregorianCalendar gregorianCalendar2 = gregorianCalendar;
            gregorianCalendar2.set(2, n2);
            gregorianCalendar2.set(1, n);
            int n4 = gregorianCalendar2.get(5) - 1;
            while (n4 < arrayListArray.length && CalendarUtility.isBetween(l, l2, gregorianCalendar2.getTimeInMillis())) {
                if (arrayListArray[n4] == null) {
                    arrayListArray[n4] = new ArrayList();
                }
                arrayListArray[n4].add(new Integer(i));
                n4 = string.equals("daily") || string.equals("hourly") ? ++n4 : (string.equals("weekly") ? (n4 += 7) : (string.equals("biweekly") ? (n4 += 14) : arrayListArray.length));
                gregorianCalendar2.set(5, n4 + 1);
            }
        }
        return arrayListArray;
    }

    public static int indexOf(Element element) {
        NodeList nodeList = ReminderXMLUtility.getNodeList();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (!element.isEqualNode(element2)) continue;
            return i;
        }
        return -1;
    }

    public static Element updateReminder(Element element) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        long l = ReminderXMLUtility.getEndTime(element);
        long l2 = ReminderXMLUtility.getNextTime(element);
        String string = ReminderXMLUtility.getType(element);
        boolean bl = false;
        gregorianCalendar.setTimeInMillis(l2);
        while (gregorianCalendar.getTimeInMillis() < System.currentTimeMillis() && gregorianCalendar.getTimeInMillis() < l) {
            l2 = gregorianCalendar.getTimeInMillis();
            gregorianCalendar = ReminderType.getNextTime(string, gregorianCalendar);
            bl = true;
        }
        if (bl) {
            if (gregorianCalendar.getTimeInMillis() < l) {
                l2 = gregorianCalendar.getTimeInMillis();
            }
            element.setAttribute("nexttime", String.valueOf(l2));
            ComponentUtility.saveDocument((String)"reminder.xml");
        }
        return element;
    }

    public static NodeList getNodeList() {
        return ComponentUtility.getNodeList((String)"reminder.xml");
    }
}

