/*
 * Decompiled with CFR 0.152.
 */
package com.sparework.kronos.components.reminder;

import com.sparework.kronos.KronosUI;
import com.sparework.kronos.Language;
import com.sparework.kronos.components.ComponentUtility;
import com.sparework.kronos.components.TabsListCellRenderer;
import com.sparework.kronos.components.html.HTMLObject;
import com.sparework.kronos.components.reminder.CalendarUtility;
import com.sparework.kronos.components.reminder.ReminderTab;
import com.sparework.kronos.components.reminder.ReminderTimer;
import com.sparework.kronos.components.reminder.ReminderType;
import com.sparework.kronos.components.reminder.ReminderXMLUtility;
import com.sparework.kronos.components.sticky.StickyMenu;
import com.sparework.kronos.inputs.Input;
import com.sparework.kronos.inputs.InputUtility;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class ReminderUtility
implements ActionListener {
    private JList reminderList;
    private DefaultListModel reminderListModel;
    private JButton addButton;
    private JButton deleteButton;
    private JButton recoverButton;
    private JButton changeButton;
    private JButton searchButton;
    private JButton refreshButton;
    private JComboBox typeCombo;
    private Element xmlDelete;
    private Input currentInput = new Input("text");
    private Input deletedInput;
    private boolean show;

    public ReminderUtility() {
        this.currentInput.addContainerListener((ContainerListener)new ContainerAdapter(){

            public void componentAdded(ContainerEvent containerEvent) {
                if (ReminderUtility.this.show) {
                    ReminderUtility.this.changeButton.setEnabled(true);
                    ReminderUtility.this.deleteButton.setEnabled(true);
                    ReminderUtility.this.searchButton.setEnabled(false);
                    ReminderUtility.this.recoverButton.setEnabled(ReminderUtility.this.xmlDelete != null);
                    ReminderUtility.this.show = false;
                } else {
                    ReminderUtility.this.changeButton.setEnabled(false);
                    ReminderUtility.this.deleteButton.setEnabled(false);
                    ReminderUtility.this.searchButton.setEnabled(true);
                    ReminderUtility.this.recoverButton.setEnabled(ReminderUtility.this.xmlDelete != null);
                }
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.reminderList.setValueIsAdjusting(true);
        String string = actionEvent.getActionCommand();
        long l = CalendarUtility.getDefaultCalendar().getTimeInMillis();
        if (string.equals("Add")) {
            this.addReminder();
        } else if (string.equals("Save")) {
            this.changeReminder();
        } else if (string.equals("Delete")) {
            this.recoverButton.setEnabled(true);
            this.deleteReminder();
        } else if (string.equals("Recover")) {
            this.recoverButton.setEnabled(false);
            this.recoverReminder();
        } else if (string.equals("Search")) {
            this.searchReminder();
        } else if (string.equals("Clear")) {
            this.resetInput();
            this.refreshList();
            ReminderTab.dateViewer.setTime(l);
        }
        CalendarUtility.refreshDateTextField();
        CalendarUtility.setStartTime(l);
        CalendarUtility.setEndTime(Long.MAX_VALUE);
        CalendarUtility.setCountdown(Long.MAX_VALUE);
        this.typeCombo.setSelectedIndex(-1);
        this.reminderList.setValueIsAdjusting(false);
    }

    protected JPanel getReminderInputPanel() {
        if (ComponentUtility.hasComponent((String)"sticky")) {
            this.currentInput.getComponentPopupMenu().add(StickyMenu.createStickyMenuItem());
        }
        return this.currentInput;
    }

    protected JPanel getReminderTypesPane() {
        this.typeCombo = new JComboBox<String>(ReminderType.getTypes());
        this.typeCombo.setSelectedIndex(-1);
        this.typeCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReminderUtility.this.addButton.setEnabled(ReminderUtility.this.typeCombo.getSelectedIndex() != -1);
                if (!ReminderUtility.this.reminderList.getValueIsAdjusting() && ReminderUtility.this.reminderList.getSelectedIndex() == -1) {
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    NodeList nodeList = ReminderXMLUtility.getNodeList();
                    int n = nodeList.getLength();
                    for (int i = 0; i < n; ++i) {
                        Element element = (Element)nodeList.item(i);
                        String string = ReminderXMLUtility.getType(element);
                        String string2 = ReminderType.getXMLValue(ReminderUtility.this.typeCombo.getSelectedIndex());
                        if (ReminderUtility.this.typeCombo.getSelectedIndex() <= -1 || !string.equals(string2)) continue;
                        arrayList.add(new Integer(i));
                    }
                    ReminderUtility.this.refreshList(arrayList);
                }
            }
        });
        return KronosUI.createLabelComponent((String)Language.get((String)"reminder", (String)"remindertype"), (JComponent)this.typeCombo, (String)"West");
    }

    protected JToolBar getButtonPane() {
        this.addButton = KronosUI.createButton((String)"images/add.png", (String)"Add", (String)Language.get((String)"kronos", (String)"add"), (ActionListener)this);
        this.addButton.setEnabled(false);
        this.deleteButton = KronosUI.createButton((String)"images/delete.png", (String)"Delete", (String)Language.get((String)"kronos", (String)"delete"), (ActionListener)this);
        this.deleteButton.setEnabled(false);
        this.changeButton = KronosUI.createButton((String)"images/save.png", (String)"Save", (String)Language.get((String)"kronos", (String)"save"), (ActionListener)this);
        this.changeButton.setEnabled(false);
        this.recoverButton = KronosUI.createButton((String)"images/recover.png", (String)"Recover", (String)Language.get((String)"kronos", (String)"recover"), (ActionListener)this);
        this.recoverButton.setEnabled(false);
        this.searchButton = KronosUI.createButton((String)"images/search.png", (String)"Search", (String)Language.get((String)"kronos", (String)"search"), (ActionListener)this);
        this.refreshButton = KronosUI.createButton((String)"images/new.png", (String)"Clear", (String)Language.get((String)"kronos", (String)"clear"), (ActionListener)this);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add(this.addButton);
        jToolBar.add(this.deleteButton);
        jToolBar.add(this.changeButton);
        jToolBar.add(this.recoverButton);
        jToolBar.add(this.searchButton);
        jToolBar.add(this.refreshButton);
        return jToolBar;
    }

    protected JScrollPane getReminderListScroll() {
        this.reminderListModel = new DefaultListModel();
        this.refreshList();
        this.reminderList = new JList(this.reminderListModel);
        this.reminderList.setCellRenderer(new TabsListCellRenderer());
        this.reminderList.setSelectionMode(0);
        this.reminderList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    if (ReminderUtility.this.reminderList.getSelectedIndex() > -1) {
                        ReminderUtility.this.show = true;
                        ReminderUtility.this.showReminder();
                    } else {
                        ReminderUtility.this.changeButton.setEnabled(false);
                        ReminderUtility.this.deleteButton.setEnabled(false);
                        ReminderUtility.this.searchButton.setEnabled(true);
                        ReminderUtility.this.recoverButton.setEnabled(ReminderUtility.this.xmlDelete != null);
                    }
                }
            }
        });
        this.reminderList.setToolTipText(Language.get((String)"reminder", (String)"reminderlist"));
        JScrollPane jScrollPane = new JScrollPane(this.reminderList, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(1, 100));
        return jScrollPane;
    }

    private void addReminder() {
        if (!this.reminderList.isSelectionEmpty()) {
            this.currentInput.setInput(this.currentInput.getName(), this.currentInput.getRawData());
        }
        Element element = ReminderXMLUtility.createXMLElement(ReminderType.getXMLValue(this.typeCombo.getSelectedIndex()), CalendarUtility.getStartTime(), CalendarUtility.getEndTime(), CalendarUtility.getStartTime(), this.currentInput);
        this.currentInput.useInput(true);
        int n = ReminderXMLUtility.addXMLElement(element);
        ReminderTimer.scheduleReminder(element, n);
        ReminderTab.dateViewer.refreshCalendar();
        this.resetInput();
        this.refreshList();
        this.reminderList.ensureIndexIsVisible(n);
    }

    private void changeReminder() {
        int n = this.reminderList.getSelectedIndex();
        Element element = ReminderXMLUtility.deleteXMLElement(this.reminderList.getSelectedIndex());
        ReminderTimer.cancelReminder(n);
        element = ReminderXMLUtility.createXMLElement(ReminderType.getXMLValue(this.typeCombo.getSelectedIndex()), CalendarUtility.getStartTime(), CalendarUtility.getEndTime(), CalendarUtility.getStartTime(), this.currentInput);
        this.currentInput.useInput(true);
        int n2 = ReminderXMLUtility.addXMLElement(element);
        ReminderTimer.scheduleReminder(element, n2);
        ReminderTab.dateViewer.refreshCalendar();
        this.resetInput();
        this.refreshList();
        this.reminderList.ensureIndexIsVisible(n2);
    }

    private void deleteReminder() {
        int n = this.reminderList.getSelectedIndex();
        this.xmlDelete = ReminderXMLUtility.deleteXMLElement(n);
        ReminderTimer.cancelReminder(n);
        this.deletedInput = new Input(this.currentInput.getName(), (Object)this.currentInput.getXMLValue());
        this.currentInput.useInput(false);
        ReminderTab.dateViewer.refreshCalendar();
        this.resetInput();
        this.refreshList();
    }

    private void recoverReminder() {
        int n = ReminderXMLUtility.addXMLElement(this.xmlDelete);
        ReminderTimer.scheduleReminder(this.xmlDelete, n);
        this.deletedInput.useInput(true);
        ReminderTab.dateViewer.refreshCalendar();
        Object object = this.currentInput.getRawData();
        this.refreshList();
        this.xmlDelete = null;
        this.reminderList.ensureIndexIsVisible(n);
        this.currentInput.removeAll();
        this.currentInput.setInput(this.currentInput.getName(), object);
        this.currentInput.repaint();
        this.currentInput.revalidate();
    }

    private void searchReminder() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        NodeList nodeList = ReminderXMLUtility.getNodeList();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)nodeList.item(i);
            if (!this.currentInput.isEqual(ReminderXMLUtility.getInputName(element), (Object)ReminderXMLUtility.getInputValue(element))) continue;
            arrayList.add(new Integer(i));
        }
        this.refreshList(arrayList);
    }

    private void showReminder() {
        Element element = (Element)ReminderXMLUtility.getNodeList().item(this.reminderList.getSelectedIndex());
        long l = ReminderXMLUtility.getStartTime(element);
        long l2 = ReminderXMLUtility.getEndTime(element);
        long l3 = ReminderXMLUtility.getNextTime(element);
        CalendarUtility.setStartTime(l);
        CalendarUtility.setEndTime(l2);
        CalendarUtility.setNextTime(l3);
        CalendarUtility.setCountdown(l3);
        this.typeCombo.setSelectedItem(Language.get((String)"reminder", (String)("" + ReminderXMLUtility.getType(element))));
        this.currentInput.removeAll();
        this.currentInput.setInput(ReminderXMLUtility.getInputName(element), (Object)ReminderXMLUtility.getInputValue(element));
        this.currentInput.repaint();
        this.currentInput.revalidate();
    }

    private void resetInput() {
        this.show = false;
        this.currentInput.removeAll();
        this.currentInput.setInput(this.currentInput.getName(), null);
        this.currentInput.repaint();
        this.currentInput.revalidate();
    }

    protected void refreshList() {
        this.reminderListModel.clear();
        NodeList nodeList = ReminderXMLUtility.getNodeList();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)nodeList.item(i);
            if (InputUtility.hasInput((String)ReminderXMLUtility.getInputName(element))) {
                Input input = new Input(ReminderXMLUtility.getInputName(element), (Object)ReminderXMLUtility.getInputValue(element));
                this.reminderListModel.addElement(input.getListValue());
                continue;
            }
            this.reminderListModel.addElement(null);
        }
    }

    protected void refreshList(ArrayList arrayList) {
        this.currentInput.removeAll();
        this.currentInput.setInput(this.currentInput.getName(), this.currentInput.getRawData());
        this.currentInput.repaint();
        this.currentInput.revalidate();
        this.reminderListModel.clear();
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        NodeList nodeList = ReminderXMLUtility.getNodeList();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)nodeList.item(i);
            if (arrayList.contains(new Integer(i)) && InputUtility.hasInput((String)ReminderXMLUtility.getInputName(element))) {
                Input input = new Input(ReminderXMLUtility.getInputName(element), (Object)ReminderXMLUtility.getInputValue(element));
                this.reminderListModel.addElement(input.getListValue());
                continue;
            }
            this.reminderListModel.addElement(null);
        }
    }

    protected static void exportHTML() {
        if (ComponentUtility.hasComponent((String)"html")) {
            HTMLObject hTMLObject = new HTMLObject();
            hTMLObject.setTitle(Language.get((String)"reminder", (String)"reminder"));
            hTMLObject.addHeadings((Object[])new String[]{Language.get((String)"reminder", (String)"nextdate"), Language.get((String)"reminder", (String)"reminder"), Language.get((String)"reminder", (String)"remindertype"), Language.get((String)"reminder", (String)"startdate"), Language.get((String)"reminder", (String)"enddate")});
            NodeList nodeList = ReminderXMLUtility.getNodeList();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string;
                Element element = (Element)nodeList.item(i);
                Input input = new Input(ReminderXMLUtility.getInputName(element), (Object)ReminderXMLUtility.getInputValue(element));
                long l = ReminderXMLUtility.getEndTime(element);
                string = l < Long.MAX_VALUE ? (string = CalendarUtility.getFormattedDate(l)) : "";
                hTMLObject.addData(new Object[]{CalendarUtility.getFormattedDate(ReminderXMLUtility.getNextTime(element)), hTMLObject.createDataElement(input.getXMLValue(), input.getMimeType()), Language.get((String)"reminder", (String)("" + ReminderXMLUtility.getType(element))), CalendarUtility.getFormattedDate(ReminderXMLUtility.getStartTime(element)), string});
            }
            hTMLObject.promptToSave("reminder.htm");
        }
    }
}

