/*
 * Decompiled with CFR 0.152.
 */
package com.sparework.kronos.components.reminder;

import com.sparework.kronos.Configuration;
import com.sparework.kronos.KronosUI;
import com.sparework.kronos.Language;
import com.sparework.kronos.components.reminder.CalendarUtility;
import com.sparework.kronos.components.reminder.ReminderPopUp;
import com.sparework.kronos.components.reminder.ReminderTab;
import com.sparework.kronos.components.reminder.ReminderXMLUtility;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequencer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JWindow;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class ReminderTimer {
    private static Sequencer notifySeq = null;
    private static JWindow popupDialog = null;
    private static ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static ArrayList scheduleList = new ArrayList();
    private static ReminderPopUp popupList = new ReminderPopUp();
    private static int initialDelay = 5000;

    ReminderTimer() {
    }

    protected static void loadMidi(String string) {
        try {
            if (notifySeq == null) {
                notifySeq = MidiSystem.getSequencer();
                notifySeq.open();
                notifySeq.setLoopCount(-1);
            }
            notifySeq.setSequence(MidiSystem.getSequence(new File(string)));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static ArrayList getOverdueReminders() {
        int n;
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = ReminderXMLUtility.getNodeList();
        int n2 = nodeList.getLength();
        for (n = 0; n < n2; ++n) {
            Element element = (Element)nodeList.item(n);
            long l = ReminderXMLUtility.getStartTime(element);
            long l2 = ReminderXMLUtility.getEndTime(element);
            long l3 = ReminderXMLUtility.getNextTime(element);
            if (!CalendarUtility.isBetween(l, System.currentTimeMillis(), l3)) continue;
            arrayList.add(ReminderXMLUtility.updateReminder(element));
        }
        n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)arrayList.get(i);
            ReminderXMLUtility.deleteXMLElement(element);
            ReminderXMLUtility.addXMLElement(element);
        }
        return arrayList;
    }

    protected static void scheduleReminder(Element element, int n) {
        long l = ReminderXMLUtility.getEndTime(element);
        if (System.currentTimeMillis() < l) {
            long l2 = ReminderXMLUtility.getNextTime(element);
            long l3 = l2 - System.currentTimeMillis();
            l3 = l3 < 0L ? (long)initialDelay : l3;
            initialDelay = 0;
            ScheduledFuture<?> scheduledFuture = scheduler.schedule(new Runnable(){

                public void run() {
                    if (popupDialog == null) {
                        ReminderTimer.setupLayout();
                    }
                    if (!popupDialog.isVisible()) {
                        if (!notifySeq.isRunning() && Configuration.getConfig((String)"reminder:soundnotify", (String)"false").equals("true")) {
                            notifySeq.start();
                        }
                        popupDialog.setVisible(true);
                    }
                }
            }, l3, TimeUnit.MILLISECONDS);
            if (n >= scheduleList.size()) {
                scheduleList.add(scheduledFuture);
            } else {
                scheduleList.add(n, scheduledFuture);
            }
        }
    }

    protected static void cancelReminder(int n) {
        ((ScheduledFuture)scheduleList.remove(n)).cancel(true);
    }

    private static void setupLayout() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList arrayList = ReminderTimer.getOverdueReminders();
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    Element element = (Element)arrayList.get(i);
                    int n2 = ReminderXMLUtility.indexOf(element);
                    arrayList.set(i, new Integer(n2));
                    ReminderTimer.scheduleReminder(element, n2);
                }
                if (notifySeq != null) {
                    notifySeq.stop();
                    notifySeq.setMicrosecondPosition(0L);
                }
                if (ReminderTab.reminderUtil != null) {
                    ReminderTab.reminderUtil.refreshList();
                }
                if (actionEvent.getActionCommand().equals("see")) {
                    popupList.refreshList(arrayList);
                }
                popupDialog.setVisible(false);
            }
        };
        JButton jButton = new JButton(Language.get((String)"reminder", (String)"seeoverdue"), new ImageIcon("components/reminder/see.png"));
        jButton.setActionCommand("see");
        jButton.addActionListener(actionListener);
        jButton.setVerticalTextPosition(3);
        jButton.setHorizontalTextPosition(0);
        JButton jButton2 = new JButton(Language.get((String)"reminder", (String)"donotseeoverdue"), new ImageIcon("components/reminder/ignore.png"));
        jButton2.addActionListener(actionListener);
        jButton2.setVerticalTextPosition(3);
        jButton2.setHorizontalTextPosition(0);
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.setBorder(BorderFactory.createTitledBorder(Language.get((String)"reminder", (String)"reminder")));
        popupDialog = new JWindow();
        popupDialog.setAlwaysOnTop(true);
        popupDialog.add(jPanel);
        popupDialog.setAlwaysOnTop(true);
        popupDialog.pack();
        Point point = KronosUI.getSystemTrayLocation();
        if (point == null) {
            popupDialog.setLocationRelativeTo(null);
        } else {
            Dimension dimension = popupDialog.getPreferredSize();
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            int n = 16;
            int n2 = dimension2.height - point.y - n;
            int n3 = point.y - n2 - dimension.height;
            int n4 = dimension2.width - dimension.width;
            popupDialog.setLocation(n4, n3);
        }
    }

    protected static void loadReminderTimer() {
        NodeList nodeList = ReminderXMLUtility.getNodeList();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)nodeList.item(i);
            ReminderTimer.scheduleReminder(element, i);
        }
    }
}

