/*
 * Decompiled with CFR 0.152.
 */
package com.sparework.kronos.components.reminder;

import com.sparework.kronos.Configuration;
import com.sparework.kronos.ExtensionFilenameFilter;
import com.sparework.kronos.KronosUI;
import com.sparework.kronos.Language;
import com.sparework.kronos.components.ComponentUtility;
import com.sparework.kronos.components.html.HTMLMenu;
import com.sparework.kronos.components.reminder.CalendarUtility;
import com.sparework.kronos.components.reminder.DateViewer;
import com.sparework.kronos.components.reminder.Holiday;
import com.sparework.kronos.components.reminder.ReminderTimer;
import com.sparework.kronos.components.reminder.ReminderUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.filechooser.FileFilter;

public class ReminderTab {
    protected static ReminderUtility reminderUtil;
    protected static DateViewer dateViewer;
    private JCheckBoxMenuItem soundMenuItem;
    private JMenuItem fileMenuItem;
    protected static String defaultMidi;
    private JPanel reminderPane;
    private JTextField presetText;

    public ReminderTab() {
        ComponentUtility.addDocument((String)"reminder.xml");
        try {
            defaultMidi = new File(".").getCanonicalPath() + defaultMidi;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ReminderTimer.loadReminderTimer();
        if (ComponentUtility.hasComponent((String)"html")) {
            HTMLMenu.addToMenu((JMenuItem)this.getHTMLMenu());
        }
        JMenu jMenu = new JMenu(Language.get((String)"reminder", (String)"reminder"));
        jMenu.add(Holiday.getMenu());
        jMenu.add(this.createPopupHolidayCheckBox());
        jMenu.add(this.setupSoundMenu());
        jMenu.add(this.setupWeekdayStartMenu());
        jMenu.add(this.createPresetTextField());
        KronosUI.addToConfigMenu(null);
        KronosUI.addToConfigMenu((JComponent)jMenu);
        JToggleButton jToggleButton = KronosUI.createNavButton((String)"reminder", (String)"", (String)Language.get((String)"reminder", (String)"reminder"), (ActionListener)new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ReminderTab.this.reminderPane == null) {
                    ReminderTab.this.setupLayout();
                }
                KronosUI.setContentPane((JComponent)ReminderTab.this.reminderPane);
            }
        });
        KronosUI.addToNavPane((JToggleButton)jToggleButton);
    }

    private void setupLayout() {
        reminderUtil = new ReminderUtility();
        dateViewer = new DateViewer();
        dateViewer.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if ((string.equals("yearchange") || string.equals("monthchange") || string.equals("daychange") || string.equals("timechange")) && string.equals("daychange")) {
                    reminderUtil.refreshList((ArrayList)propertyChangeEvent.getNewValue());
                }
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)reminderUtil.getReminderInputPanel(), "North");
        jPanel.add((Component)reminderUtil.getButtonPane(), "South");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add((Component)reminderUtil.getReminderListScroll(), "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(reminderUtil.getReminderTypesPane());
        jPanel3.add(Box.createRigidArea(new Dimension(1, 10)));
        jPanel3.add(CalendarUtility.getUpcomingTimePane());
        jPanel3.add(Box.createRigidArea(new Dimension(1, 10)));
        jPanel3.add(CalendarUtility.getCountdownPane());
        jPanel3.add(Box.createRigidArea(new Dimension(1, 10)));
        jPanel3.add(CalendarUtility.getStartTimePane());
        jPanel3.add(Box.createRigidArea(new Dimension(1, 10)));
        jPanel3.add(CalendarUtility.getEndTimePane());
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jPanel3, "North");
        jPanel4.add((Component)dateViewer, "South");
        jPanel4.setPreferredSize(new Dimension(220, 1));
        this.reminderPane = new JPanel();
        this.reminderPane.setLayout(new BorderLayout());
        this.reminderPane.add((Component)jPanel2, "Center");
        this.reminderPane.add((Component)jPanel4, "East");
    }

    private JMenu setupSoundMenu() {
        String string = Configuration.getConfig((String)"reminder:midi", (String)defaultMidi);
        String string2 = new File(string).getName();
        ReminderTimer.loadMidi(string);
        this.soundMenuItem = new JCheckBoxMenuItem(Language.get((String)"reminder", (String)"sound") + " " + string2);
        this.soundMenuItem.setSelected(Configuration.getConfig((String)"reminder:soundnotify", (String)"false").equals("true"));
        this.soundMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Configuration.setConfig((String)"reminder:soundnotify", (String)String.valueOf(ReminderTab.this.soundMenuItem.isSelected()));
            }
        });
        this.fileMenuItem = new JMenuItem(Language.get((String)"reminder", (String)"choose"));
        this.fileMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = Configuration.getConfig((String)"reminder:midi", (String)defaultMidi);
                JFileChooser jFileChooser = new JFileChooser(string);
                jFileChooser.setSelectedFile(new File(string));
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setFileFilter((FileFilter)new ExtensionFilenameFilter(".mid"));
                int n = jFileChooser.showOpenDialog((JMenuItem)actionEvent.getSource());
                if (n == 0) {
                    ReminderTab.this.soundMenuItem.setText(Language.get((String)"reminder", (String)"sound") + " " + jFileChooser.getSelectedFile().getName());
                    String string2 = jFileChooser.getSelectedFile().getPath();
                    Configuration.setConfig((String)"reminder:midi", (String)string2);
                    ReminderTimer.loadMidi(string2);
                }
            }
        });
        JMenu jMenu = new JMenu(Language.get((String)"reminder", (String)"notify"));
        jMenu.add(this.soundMenuItem);
        jMenu.addSeparator();
        jMenu.add(this.fileMenuItem);
        return jMenu;
    }

    private JCheckBoxMenuItem setupWeekdayStartMenu() {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(Language.get((String)"reminder", (String)"mondaystart"), Configuration.getConfig((String)"reminder:mondaystart", (String)"false").equals("true"));
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = ((JCheckBoxMenuItem)actionEvent.getSource()).isSelected();
                Configuration.setConfig((String)"reminder:mondaystart", (String)String.valueOf(bl));
            }
        });
        return jCheckBoxMenuItem;
    }

    private JPanel createPresetTextField() {
        String string = Configuration.getConfig((String)"reminder:timepresets", (String)"0:00;8:00;9:00;12:00;13:00;17:00;18:00;21:00");
        this.presetText = new JTextField(string);
        this.presetText.setColumns(20);
        this.presetText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                String string = ReminderTab.this.presetText.getText();
                if (string.matches("((([01]\\d)|(\\d)|(2[0-3])):[0-5]\\d(;)?)*")) {
                    Configuration.setConfig((String)"reminder:timepresets", (String)string);
                    KronosUI.setTaskBarText((String)Language.get((String)"kronos", (String)"configok"));
                } else {
                    ReminderTab.this.presetText.setText(Configuration.getConfig((String)"reminder:timepresets", (String)"0:00;8:00;9:00;12:00;13:00;17:00;18:00;21:00"));
                    KronosUI.setTaskBarText((String)(Language.get((String)"kronos", (String)"configerror") + " hh:mm;hh:mm;..."));
                }
            }
        });
        JLabel jLabel = new JLabel("   " + Language.get((String)"reminder", (String)"presettimes"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(jLabel);
        jPanel.add(this.presetText);
        return jPanel;
    }

    private JCheckBoxMenuItem createPopupHolidayCheckBox() {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(Language.get((String)"reminder", (String)"popupholidays"), Configuration.getConfig((String)"reminder:popupholiday", (String)"true").equals("true"));
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Configuration.setConfig((String)"reminder:popupholiday", (String)String.valueOf(((JCheckBoxMenuItem)actionEvent.getSource()).isSelected()));
            }
        });
        return jCheckBoxMenuItem;
    }

    private JMenuItem getHTMLMenu() {
        JMenuItem jMenuItem = new JMenuItem(Language.get((String)"reminder", (String)"reminder"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReminderUtility.exportHTML();
            }
        });
        return jMenuItem;
    }

    static {
        defaultMidi = "/components/reminder/notify.mid";
    }
}

