/*
 * Decompiled with CFR 0.152.
 */
package com.sparework.kronos.components.reminder;

import com.sparework.kronos.Language;
import com.sparework.kronos.components.TabsListCellRenderer;
import com.sparework.kronos.components.reminder.ReminderXMLUtility;
import com.sparework.kronos.inputs.Input;
import com.sparework.kronos.inputs.InputUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class ReminderPopUp
implements ListSelectionListener {
    private JList reminderList;
    private DefaultListModel reminderListModel;
    private Input currentInput = new Input("text");
    private boolean show;
    private JOptionPane popupOptionPane;
    private JPanel popupPane;
    private JDialog popupDialog;

    public ReminderPopUp() {
        this.currentInput.addContainerListener((ContainerListener)new ContainerAdapter(){

            public void componentAdded(ContainerEvent containerEvent) {
                if (ReminderPopUp.this.show) {
                    ReminderPopUp.this.show = false;
                }
            }
        });
        this.popupPane = new JPanel(new BorderLayout());
        this.popupPane.add((Component)this.getReminderInputPanel(), "North");
        this.popupPane.add((Component)this.getReminderListScroll(), "South");
        this.popupOptionPane = new JOptionPane(this.popupPane, -1);
        this.popupDialog = this.popupOptionPane.createDialog(null, Language.get((String)"reminder", (String)"viewreminders"));
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting() && this.reminderList.getSelectedIndex() > -1) {
            this.show = true;
            this.showReminder();
        }
    }

    protected JPanel getReminderInputPanel() {
        this.currentInput.setComponentPopupMenu(null);
        return this.currentInput;
    }

    protected JScrollPane getReminderListScroll() {
        this.reminderListModel = new DefaultListModel();
        this.reminderList = new JList(this.reminderListModel);
        this.reminderList.setCellRenderer(new TabsListCellRenderer());
        this.reminderList.setSelectionMode(0);
        this.reminderList.addListSelectionListener(this);
        this.reminderList.setToolTipText(Language.get((String)"reminder", (String)"reminderlist"));
        JScrollPane jScrollPane = new JScrollPane(this.reminderList, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(1, 200));
        return jScrollPane;
    }

    private void showReminder() {
        Element element = (Element)ReminderXMLUtility.getNodeList().item(this.reminderList.getSelectedIndex());
        this.currentInput.removeAll();
        this.currentInput.setInput(ReminderXMLUtility.getInputName(element), (Object)ReminderXMLUtility.getInputValue(element));
        this.currentInput.repaint();
        this.currentInput.revalidate();
    }

    protected void refreshList(ArrayList arrayList) {
        this.currentInput.removeAll();
        this.currentInput.setInput(this.currentInput.getName(), this.currentInput.getRawData());
        this.currentInput.repaint();
        this.currentInput.revalidate();
        this.reminderListModel.clear();
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        NodeList nodeList = ReminderXMLUtility.getNodeList();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)nodeList.item(i);
            if (arrayList.contains(new Integer(i)) && InputUtility.hasInput((String)ReminderXMLUtility.getInputName(element))) {
                Input input = new Input(ReminderXMLUtility.getInputName(element), (Object)ReminderXMLUtility.getInputValue(element));
                this.reminderListModel.addElement(input.getListValue());
                continue;
            }
            this.reminderListModel.addElement(null);
        }
        this.popupDialog.setVisible(true);
    }
}

