/*
 * Decompiled with CFR 0.152.
 */
package com.sparework.kronos.components.reminder;

import com.sparework.kronos.Language;
import com.sparework.kronos.components.reminder.DateChooser;
import com.sparework.kronos.components.reminder.ReminderXMLUtility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class DateViewer
extends DateChooser {
    private ArrayList[] hasReminders;

    public DateViewer() {
        JSpinner.DateEditor dateEditor = (JSpinner.DateEditor)this.yearSpinner.getEditor();
        dateEditor.getFormat().applyPattern(Language.get((String)"reminder", (String)"dateviewerformat"));
        dateEditor.getTextField().setColumns(1);
        try {
            dateEditor.commitEdit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.refreshCalendar();
    }

    protected ActionListener getDayActionListener() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = Integer.parseInt(actionEvent.getActionCommand());
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(DateViewer.this.yearSpinnerModel.getDate());
                gregorianCalendar.set(5, n);
                DateViewer.this.yearSpinnerModel.setValue(gregorianCalendar.getTime());
                DateViewer.this.firePropertyChange("daychange", null, (Object)DateViewer.this.hasReminders[n - 1]);
            }
        };
        return actionListener;
    }

    protected ChangeListener getSpinnerChangeListener() {
        ChangeListener changeListener = new ChangeListener(){
            private Calendar tempCal = Calendar.getInstance();

            public void stateChanged(ChangeEvent changeEvent) {
                if (DateViewer.this.doFireProperty) {
                    if (DateViewer.this.yearSpinnerModel.getCalendarField() == 1) {
                        int n = DateViewer.this.cal.get(1);
                        this.tempCal.setTime(DateViewer.this.yearSpinnerModel.getDate());
                        int n2 = this.tempCal.get(1);
                        if (n != n2) {
                            DateViewer.this.cal.set(1, n2);
                            DateViewer.this.refreshCalendar();
                            DateViewer.this.firePropertyChange("yearchange", n, n2);
                        }
                    } else if (DateViewer.this.yearSpinnerModel.getCalendarField() == 5) {
                        this.tempCal.setTime(DateViewer.this.yearSpinnerModel.getDate());
                        int n = this.tempCal.get(5);
                        DateViewer.this.firePropertyChange("daychange", null, DateViewer.this.hasReminders[n - 1]);
                    } else {
                        DateViewer.this.firePropertyChange("timechange", 0, 1);
                    }
                }
            }
        };
        return changeListener;
    }

    protected void refreshCalendar() {
        super.refreshCalendar();
        int n = this.cal.get(1);
        int n2 = this.cal.get(2);
        this.hasReminders = ReminderXMLUtility.getReminders(n, n2);
        StringBuffer[] stringBufferArray = ReminderXMLUtility.getAnnualDates(n, n2);
        int n3 = this.cal.getActualMaximum(5);
        for (int i = 0; i < n3; ++i) {
            this.highlightDay(i, this.hasReminders[i] != null, stringBufferArray[i]);
        }
        this.dayPane.revalidate();
        this.dayPane.repaint();
    }

    protected Component getTimePane() {
        super.getTimePane();
        return Box.createRigidArea(new Dimension(0, 0));
    }

    private void highlightDay(int n, boolean bl, StringBuffer stringBuffer) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.dayButton[n].getToolTipText() != null) {
            stringBuilder.append(this.dayButton[n].getToolTipText());
        }
        this.dayButton[n].setForeground(bl ? Color.MAGENTA.darker() : null);
        if (stringBuffer != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(stringBuffer.toString());
            this.dayButton[n].setBorder(BorderFactory.createLineBorder(Color.RED));
            this.dayButton[n].setToolTipText(stringBuilder.toString());
        }
    }
}

