/*
 * Decompiled with CFR 0.152.
 */
package com.sparework.kronos.components.reminder;

import com.sparework.kronos.Configuration;
import com.sparework.kronos.Language;
import com.sparework.kronos.components.reminder.Holiday;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class DateChooser
extends JPanel {
    protected JComboBox monthCombo;
    protected SpinnerDateModel yearSpinnerModel;
    protected JButton[] dayButton = new JButton[31];
    protected JPanel dayPane;
    protected GregorianCalendar cal;
    protected boolean doFireProperty;
    protected boolean mondayFirst;
    protected JSpinner yearSpinner;
    protected JSlider hourSlider;
    protected JSlider minuteSlider;
    protected JFormattedTextField timeText;
    protected JComboBox presetsCombo;

    public DateChooser() {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createEtchedBorder());
        this.doFireProperty = true;
        this.cal = new GregorianCalendar();
        this.cal.set(14, 0);
        this.cal.set(13, 0);
        this.mondayFirst = Configuration.getConfig((String)"reminder:mondaystart", (String)"false").equals("true");
        this.add((Component)this.getDatePane(), "North");
        this.add((Component)this.getDayPane(), "Center");
        this.add(this.getTimePane(), "East");
        String[] stringArray = Holiday.getHolidays(this.cal.get(1), this.cal.get(2));
        boolean bl = Configuration.getConfig((String)"reminder:popupholiday", (String)"true").equals("true");
        if (bl && stringArray[this.cal.get(5) - 1] != null) {
            JOptionPane.showMessageDialog(null, Language.get((String)"reminder", (String)"today") + ":\n" + stringArray[this.cal.get(5) - 1]);
        }
    }

    protected long getTime() {
        this.cal.setTime(this.yearSpinnerModel.getDate());
        this.cal.set(2, this.monthCombo.getSelectedIndex());
        return this.cal.getTimeInMillis();
    }

    protected void setTime(int n, int n2) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(this.getTime());
        gregorianCalendar.set(11, n);
        gregorianCalendar.set(12, n2);
        this.setTime(gregorianCalendar.getTimeInMillis());
    }

    protected void setTime(long l) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(l);
        this.getTime();
        this.doFireProperty = false;
        this.monthCombo.setSelectedIndex(gregorianCalendar.get(2));
        this.yearSpinnerModel.setValue(gregorianCalendar.getTime());
        this.hourSlider.setValue(gregorianCalendar.get(11));
        this.minuteSlider.setValue(gregorianCalendar.get(12));
        this.cal.setTimeInMillis(l);
        this.refreshCalendar();
        this.doFireProperty = true;
    }

    protected ActionListener getDayActionListener() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = Integer.parseInt(actionEvent.getActionCommand());
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(DateChooser.this.yearSpinnerModel.getDate());
                gregorianCalendar.set(5, n);
                DateChooser.this.yearSpinnerModel.setValue(gregorianCalendar.getTime());
                DateChooser.this.firePropertyChange("daychange", null, n);
            }
        };
        return actionListener;
    }

    protected ActionListener getMonthActionListener() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DateChooser.this.doFireProperty && DateChooser.this.cal.get(2) != DateChooser.this.monthCombo.getSelectedIndex()) {
                    int n = DateChooser.this.cal.get(2);
                    int n2 = DateChooser.this.monthCombo.getSelectedIndex();
                    DateChooser.this.cal.set(2, n2);
                    DateChooser.this.refreshCalendar();
                    DateChooser.this.firePropertyChange("monthchange", n, n2);
                }
            }
        };
        return actionListener;
    }

    protected ChangeListener getSpinnerChangeListener() {
        ChangeListener changeListener = new ChangeListener(){
            private Calendar tempCal = Calendar.getInstance();

            public void stateChanged(ChangeEvent changeEvent) {
                if (DateChooser.this.doFireProperty) {
                    if (DateChooser.this.yearSpinnerModel.getCalendarField() == 1) {
                        int n = DateChooser.this.cal.get(1);
                        this.tempCal.setTime(DateChooser.this.yearSpinnerModel.getDate());
                        int n2 = this.tempCal.get(1);
                        if (n != n2) {
                            DateChooser.this.cal.set(1, n2);
                            DateChooser.this.refreshCalendar();
                            DateChooser.this.firePropertyChange("yearchange", n, n2);
                        }
                    } else if (DateChooser.this.yearSpinnerModel.getCalendarField() == 5) {
                        this.tempCal.setTime(DateChooser.this.yearSpinnerModel.getDate());
                        int n = this.tempCal.get(5);
                        DateChooser.this.firePropertyChange("daychange", null, n);
                    } else {
                        this.tempCal.setTime(DateChooser.this.yearSpinnerModel.getDate());
                        DateChooser.this.doFireProperty = false;
                        DateChooser.this.hourSlider.setValue(this.tempCal.get(11));
                        DateChooser.this.minuteSlider.setValue(this.tempCal.get(12));
                        DateChooser.this.presetsCombo.setSelectedIndex(0);
                        DateChooser.this.doFireProperty = true;
                        DateChooser.this.firePropertyChange("timechange", 0, 1);
                    }
                }
            }
        };
        return changeListener;
    }

    protected ChangeListener getTimeChangeListener() {
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (DateChooser.this.doFireProperty) {
                    DateChooser.this.setTime(DateChooser.this.hourSlider.getValue(), DateChooser.this.minuteSlider.getValue());
                    DateChooser.this.presetsCombo.setSelectedIndex(0);
                    DateChooser.this.firePropertyChange("timechange", 0, 1);
                }
            }
        };
        return changeListener;
    }

    protected Component getTimePane() {
        this.hourSlider = new JSlider(1, 0, 23, 12);
        this.hourSlider.setPreferredSize(new Dimension(20, 1));
        this.hourSlider.setInverted(true);
        this.hourSlider.addChangeListener(this.getTimeChangeListener());
        this.minuteSlider = new JSlider(1, 0, 59, 0);
        this.minuteSlider.setInverted(true);
        this.minuteSlider.setPreferredSize(new Dimension(20, 1));
        this.minuteSlider.addChangeListener(this.getTimeChangeListener());
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.add(this.hourSlider);
        jPanel.add(this.minuteSlider);
        String string = Configuration.getConfig((String)"reminder:timepresets", (String)"0:00;8:00;9:00;12:00;13:00;17:00;18:00;21:00");
        string = "--;" + string;
        this.presetsCombo = new JComboBox<String>(new DefaultComboBoxModel<String>(string.split(";")));
        this.presetsCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DateChooser.this.doFireProperty && DateChooser.this.presetsCombo.getSelectedIndex() > 0) {
                    String[] stringArray = DateChooser.this.presetsCombo.getSelectedItem().toString().split(":");
                    DateChooser.this.setTime(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
                    DateChooser.this.firePropertyChange("timechange", 0, 1);
                }
            }
        });
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        jPanel2.add((Component)this.presetsCombo, "South");
        return jPanel2;
    }

    private JPanel getDatePane() {
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols();
        this.monthCombo = new JComboBox<String>(dateFormatSymbols.getMonths());
        this.monthCombo.removeItemAt(12);
        this.monthCombo.setMaximumRowCount(12);
        this.monthCombo.setSelectedIndex(this.cal.get(2));
        this.monthCombo.addActionListener(this.getMonthActionListener());
        ((JLabel)((Object)this.monthCombo.getRenderer())).setHorizontalAlignment(4);
        this.yearSpinnerModel = new SpinnerDateModel();
        this.yearSpinner = new JSpinner(this.yearSpinnerModel);
        this.yearSpinner.addChangeListener(this.getSpinnerChangeListener());
        JSpinner.DateEditor dateEditor = new JSpinner.DateEditor(this.yearSpinner);
        dateEditor.getFormat().applyPattern(Language.get((String)"reminder", (String)"calendardate"));
        dateEditor.getTextField().setBackground(null);
        dateEditor.getTextField().setBorder(BorderFactory.createEmptyBorder());
        dateEditor.getTextField().setColumns(Language.get((String)"reminder", (String)"calendardate").replaceAll("\\s", "").length() + 2);
        this.yearSpinner.setEditor(dateEditor);
        this.doFireProperty = false;
        this.yearSpinnerModel.setValue(this.cal.getTime());
        this.doFireProperty = true;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.monthCombo);
        jPanel.add(this.yearSpinner);
        return jPanel;
    }

    private JPanel getDayPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        String[] stringArray = !this.mondayFirst ? new String[]{Language.get((String)"reminder", (String)"sunday"), Language.get((String)"reminder", (String)"monday"), Language.get((String)"reminder", (String)"tuesday"), Language.get((String)"reminder", (String)"wednesday"), Language.get((String)"reminder", (String)"thursday"), Language.get((String)"reminder", (String)"friday"), Language.get((String)"reminder", (String)"saturday")} : new String[]{Language.get((String)"reminder", (String)"monday"), Language.get((String)"reminder", (String)"tuesday"), Language.get((String)"reminder", (String)"wednesday"), Language.get((String)"reminder", (String)"thursday"), Language.get((String)"reminder", (String)"friday"), Language.get((String)"reminder", (String)"saturday"), Language.get((String)"reminder", (String)"sunday")};
        JPanel jPanel2 = new JPanel(new GridLayout(1, 7));
        for (int i = 0; i < 7; ++i) {
            JLabel jLabel = new JLabel(stringArray[i], 0);
            jLabel.setForeground(Color.GRAY);
            jPanel2.add(jLabel);
        }
        jPanel.add(jPanel2);
        ActionListener actionListener = this.getDayActionListener();
        for (int i = 0; i < this.dayButton.length; ++i) {
            this.dayButton[i] = new JButton(String.valueOf(i + 1));
            this.dayButton[i].addActionListener(actionListener);
            this.dayButton[i].setBorder(BorderFactory.createEmptyBorder());
        }
        this.dayPane = new JPanel();
        this.dayPane.setLayout(new GridLayout(6, 7));
        jPanel.add(this.dayPane);
        return jPanel;
    }

    protected void refreshCalendar() {
        this.dayPane.removeAll();
        Dimension dimension = new Dimension(20, 20);
        this.cal.set(5, 1);
        int n = 1;
        int n2 = this.cal.get(7);
        if (this.mondayFirst) {
            n2 = n == n2 ? 7 : --n2;
        }
        while (n < n2) {
            this.dayPane.add(Box.createRigidArea(dimension));
            ++n;
        }
        int n3 = this.cal.get(1);
        int n4 = this.cal.get(2);
        String[] stringArray = Holiday.getHolidays(n3, n4);
        int n5 = this.cal.getActualMaximum(5);
        for (int i = 0; i < n5; ++i) {
            this.highlightDay(i, stringArray[i]);
            this.dayPane.add(this.dayButton[i]);
            this.cal.roll(5, 1);
            this.dayButton[i].setBackground(null);
        }
        Calendar calendar = Calendar.getInstance();
        int n6 = calendar.get(5) - 1;
        if (calendar.get(2) == n4 && calendar.get(1) == n3) {
            String string = this.dayButton[n6].getToolTipText();
            string = Language.get((String)"reminder", (String)"today") + (string != null ? ": " + string : "");
            this.dayButton[n6].setToolTipText(string);
            this.dayButton[n6].setBackground(new Color(102, 153, 255));
        }
        for (int i = 0; i < 42 - n5 - n; ++i) {
            this.dayPane.add(Box.createRigidArea(dimension));
        }
        this.dayPane.revalidate();
        this.dayPane.repaint();
    }

    private void highlightDay(int n, String string) {
        if (string != null) {
            this.dayButton[n].setBorder(BorderFactory.createLineBorder(Color.RED));
            this.dayButton[n].setToolTipText(string);
        } else {
            this.dayButton[n].setBorder(BorderFactory.createCompoundBorder(null, null));
            this.dayButton[n].setToolTipText(null);
        }
    }
}

