/*
 * Decompiled with CFR 0.152.
 */
package com.sparework.kronos.components.reminder;

import com.sparework.kronos.KronosUI;
import com.sparework.kronos.Language;
import com.sparework.kronos.components.reminder.DateChooser;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JWindow;

class CalendarUtility {
    private static JTextField countdownText;
    private static SimpleDateFormat simpleDateFormat;
    private static JFormattedTextField upcomingTime;
    private static long startTime;
    private static long endTime;
    private static long nextTime;
    private static JToggleButton startTimeButton;
    private static JToggleButton endTimeButton;
    private static Color futureColor;
    private static Color pastColor;

    CalendarUtility() {
    }

    protected static String getFormattedDate(long l) {
        return simpleDateFormat.format(new Date(l));
    }

    protected static GregorianCalendar getDefaultCalendar() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        gregorianCalendar.add(12, 1);
        return gregorianCalendar;
    }

    protected static long getStartTime() {
        return startTime;
    }

    protected static void setStartTime(long l) {
        startTime = l;
        CalendarUtility.setButtonText(startTimeButton, startTime);
    }

    protected static long getEndTime() {
        return endTime;
    }

    protected static void setEndTime(long l) {
        endTime = l;
        if (endTime == Long.MAX_VALUE) {
            endTimeButton.setText(" ");
        } else {
            CalendarUtility.setButtonText(endTimeButton, endTime);
        }
    }

    protected static void setNextTime(long l) {
        nextTime = l;
        CalendarUtility.setUpcomingTextField(nextTime);
    }

    protected static void setCountdown(long l) {
        if (l == Long.MAX_VALUE) {
            countdownText.setText("");
            return;
        }
        long l2 = l < System.currentTimeMillis() ? -1 : 1;
        long l3 = (l - System.currentTimeMillis()) / 1000L / 60L * l2;
        int n = (int)(l3 / 24L / 60L);
        int n2 = (int)((l3 -= (long)(n * 24 * 60)) / 60L);
        countdownText.setText((l2 == -1L ? "- " : "") + String.valueOf(n) + " " + Language.get((String)"reminder", (String)"days") + " " + String.valueOf(n2) + " " + Language.get((String)"reminder", (String)"hours") + " " + String.valueOf(l3 -= (long)(n2 * 60)) + " " + Language.get((String)"reminder", (String)"minutes"));
        countdownText.setDisabledTextColor(l2 == -1L ? pastColor : futureColor);
        countdownText.setCaretPosition(0);
    }

    protected static boolean isBetween(long l, long l2, long l3) {
        return l3 >= l2 && l == l2 || l <= l3 && l3 <= l2;
    }

    protected static JPanel getCountdownPane() {
        countdownText = new JTextField();
        countdownText.setHorizontalAlignment(0);
        countdownText.setBorder(BorderFactory.createEmptyBorder());
        countdownText.setEditable(false);
        countdownText.setEnabled(false);
        return KronosUI.createLabelComponent((String)Language.get((String)"reminder", (String)"nextnotify"), (JComponent)countdownText, (String)"North");
    }

    protected static JPanel getUpcomingTimePane() {
        upcomingTime = new JFormattedTextField(simpleDateFormat);
        upcomingTime.setHorizontalAlignment(0);
        upcomingTime.setBorder(BorderFactory.createEmptyBorder());
        upcomingTime.setEditable(false);
        upcomingTime.setEnabled(false);
        CalendarUtility.setNextTime(CalendarUtility.getDefaultCalendar().getTimeInMillis());
        return KronosUI.createLabelComponent((String)Language.get((String)"reminder", (String)"nextdate"), (JComponent)upcomingTime, (String)"North");
    }

    private static void setButtonText(JToggleButton jToggleButton, long l) {
        jToggleButton.setText(CalendarUtility.getFormattedDate(l));
        jToggleButton.setForeground(System.currentTimeMillis() < l ? futureColor : pastColor);
    }

    private static void setUpcomingTextField(long l) {
        upcomingTime.setValue(new Date(l));
        upcomingTime.setDisabledTextColor(System.currentTimeMillis() < l ? futureColor : pastColor);
    }

    protected static void refreshDateTextField() {
        upcomingTime.setValue(null);
    }

    private static ActionListener getTimeListener() {
        ActionListener actionListener = new ActionListener(){
            private JWindow dateWindow;
            private DateChooser datePicker;

            public void actionPerformed(ActionEvent actionEvent) {
                JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
                boolean bl = jToggleButton == startTimeButton;
                boolean bl2 = jToggleButton.isSelected();
                if (this.dateWindow == null) {
                    this.datePicker = new DateChooser();
                    this.dateWindow = new JWindow(KronosUI.getProgFrame());
                    this.dateWindow.getContentPane().add(this.datePicker);
                }
                if (bl2) {
                    if (bl) {
                        this.datePicker.setTime(startTime);
                    } else {
                        this.datePicker.setTime(endTime == Long.MAX_VALUE ? startTime : endTime);
                    }
                    this.dateWindow.pack();
                    int n = jToggleButton.getWidth() - this.dateWindow.getWidth();
                    Point point = jToggleButton.getLocationOnScreen();
                    point.translate(n, jToggleButton.getHeight());
                    this.dateWindow.setLocation(point);
                    this.dateWindow.setVisible(true);
                    this.dateWindow.toFront();
                    this.dateWindow.requestFocus();
                } else {
                    if (bl) {
                        CalendarUtility.setStartTime(this.datePicker.getTime());
                    } else {
                        long l = this.datePicker.getTime();
                        if (l <= startTime) {
                            l = Long.MAX_VALUE;
                        }
                        CalendarUtility.setEndTime(l);
                    }
                    this.dateWindow.setVisible(false);
                }
            }
        };
        return actionListener;
    }

    protected static JPanel getStartTimePane() {
        startTimeButton = new JToggleButton();
        CalendarUtility.setStartTime(CalendarUtility.getDefaultCalendar().getTimeInMillis());
        startTimeButton.addActionListener(CalendarUtility.getTimeListener());
        return KronosUI.createLabelComponent((String)Language.get((String)"reminder", (String)"startdate"), (JComponent)startTimeButton, (String)"North");
    }

    protected static JPanel getEndTimePane() {
        endTimeButton = new JToggleButton();
        CalendarUtility.setEndTime(Long.MAX_VALUE);
        endTimeButton.addActionListener(CalendarUtility.getTimeListener());
        return KronosUI.createLabelComponent((String)Language.get((String)"reminder", (String)"enddate"), (JComponent)endTimeButton, (String)"North");
    }

    static {
        simpleDateFormat = new SimpleDateFormat(Language.get((String)"reminder", (String)"dateformat"));
        futureColor = Color.GREEN.darker();
        pastColor = Color.RED;
    }
}

