/*
 * Decompiled with CFR 0.152.
 */
package com.sparework.kronos.components.html;

import com.sparework.kronos.Configuration;
import com.sparework.kronos.ExtensionFilenameFilter;
import com.sparework.kronos.KronosUtility;
import com.sparework.kronos.Language;
import com.sparework.kronos.components.ComponentUtility;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HTMLObject {
    private Document xmlDoc;
    private Element xmlTable;
    private static JFileChooser exportFileChooser;

    public HTMLObject() {
        String string = Configuration.getConfig((String)"html:template", (String)"components/html/template.htm");
        this.setTemplate(string);
        this.setLogo(null, "file://" + KronosUtility.getCurrentPath() + "/images/logo.png");
    }

    public void setTemplate(String string) {
        this.xmlDoc = KronosUtility.getFromFile((Object)string);
        NodeList nodeList = this.xmlDoc.getElementsByTagName("table");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.xmlTable = (Element)nodeList.item(i);
            if (this.xmlTable.getAttribute("id").equals("data")) break;
        }
    }

    public Node createDataElement(String string, String string2) {
        Node node = null;
        if (string2.startsWith("image/")) {
            node = this.xmlDoc.createElement("img");
            node.setAttribute("src", "file://" + ComponentUtility.getDataDirectory((boolean)true) + "/" + string);
        } else if (string2.startsWith("audio/")) {
            node = this.xmlDoc.createElement("a");
            node.setAttribute("href", "file://" + ComponentUtility.getDataDirectory((boolean)true) + "/" + string);
            node.setTextContent("Download");
        } else {
            node = string2.startsWith("text/") ? this.xmlDoc.createTextNode(string) : this.xmlDoc.createTextNode("Not supported");
        }
        return node;
    }

    public void setLogo(String string, String string2) {
        Element element;
        int n;
        NodeList nodeList = this.xmlDoc.getElementsByTagName("img");
        for (n = 0; n < nodeList.getLength(); ++n) {
            element = (Element)nodeList.item(n);
            if (!element.getAttribute("id").equals("logo")) continue;
            element.setAttribute("src", string2);
            break;
        }
        if (string != null) {
            nodeList = this.xmlDoc.getElementsByTagName("a");
            for (n = 0; n < nodeList.getLength(); ++n) {
                element = (Element)nodeList.item(n);
                if (!element.getAttribute("id").equals("logo")) continue;
                element.setAttribute("href", string);
                break;
            }
        }
    }

    public void setTitle(String string) {
        NodeList nodeList = this.xmlDoc.getElementsByTagName("span");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            if (!element.getAttribute("id").equals("title")) continue;
            element.setTextContent("Kronos - " + string);
            break;
        }
        ((Element)this.xmlDoc.getElementsByTagName("title").item(0)).setTextContent("Kronos - " + string);
    }

    public void addHeadings(Object[] objectArray) {
        Element element = this.makeRow(objectArray);
        element.setAttribute("class", "heading");
        this.xmlTable.appendChild(element);
        this.xmlTable.appendChild(this.xmlDoc.createTextNode("\n"));
    }

    public void addData(Object[] objectArray) {
        this.xmlTable.appendChild(this.makeRow(objectArray));
        this.xmlTable.appendChild(this.xmlDoc.createTextNode("\n"));
    }

    private Element makeRow(Object[] objectArray) {
        Element element = this.xmlDoc.createElement("tr");
        for (int i = 0; i < objectArray.length; ++i) {
            Element element2 = this.xmlDoc.createElement("td");
            element2.setAttribute("class", "cells");
            if (objectArray[i] instanceof String) {
                element2.appendChild(this.xmlDoc.createTextNode(objectArray[i].toString()));
            } else if (objectArray[i] instanceof Node) {
                element2.appendChild((Node)objectArray[i]);
            }
            element.appendChild(element2);
        }
        return element;
    }

    public void promptToSave(String string) {
        int n;
        String string2 = Configuration.getConfig((String)"html:exportpath", (String)ComponentUtility.getDataDirectory((boolean)true));
        if (exportFileChooser == null) {
            exportFileChooser = new JFileChooser(string2);
            exportFileChooser.setFileSelectionMode(0);
            exportFileChooser.setDialogTitle(Language.get((String)"html", (String)"html"));
            exportFileChooser.setFileFilter((FileFilter)new ExtensionFilenameFilter(".htm"));
        }
        exportFileChooser.setSelectedFile(new File(string));
        while ((n = exportFileChooser.showSaveDialog(null)) == -1) {
        }
        if (n == 0) {
            string2 = exportFileChooser.getCurrentDirectory().getAbsolutePath();
            Configuration.setConfig((String)"html:exportpath", (String)string2);
            KronosUtility.saveToFile((Document)this.xmlDoc, (String)(string2 + "/" + exportFileChooser.getSelectedFile().getName()));
        }
    }
}

