/*
 * Decompiled with CFR 0.152.
 */
package com.sparework.kronos.inputs.text;

import com.sparework.kronos.Language;
import com.sparework.kronos.inputs.InputInterface;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class Text
extends JScrollPane
implements InputInterface {
    private JTextArea msgText;
    private String defaultMsg;

    public Text() {
        this.setupLayout();
        this.defaultMsg = Language.get((String)"text", (String)"defaultmsg");
        this.msgText.setText(this.defaultMsg);
        this.msgText.setCaretPosition(0);
    }

    public Text(String string) {
        this.setupLayout();
        this.defaultMsg = Language.get((String)"text", (String)"defaultmsg");
        this.msgText.setText(string);
        this.msgText.setCaretPosition(0);
    }

    public void useInput(boolean bl) {
    }

    public Object getRawData() {
        return this.msgText.getText();
    }

    public String getMimeType() {
        return "text/plain";
    }

    public Object getListValue() {
        return this.msgText.getText().replaceAll("[\\s]", " ");
    }

    public String getXMLValue() {
        return this.msgText.getText();
    }

    public boolean isEqual(String string, Object object) {
        return string.equals("text") && object.toString().toLowerCase().indexOf(this.msgText.getText().toLowerCase()) > -1;
    }

    public boolean isEmpty() {
        String string = this.msgText.getText();
        return string.equals(Language.get((String)"text", (String)"defaultmsg")) || string.equals("");
    }

    private void setupLayout() {
        this.msgText = new JTextArea();
        this.msgText.setLineWrap(true);
        this.msgText.setWrapStyleWord(true);
        this.msgText.setFocusTraversalKeys(0, null);
        this.msgText.setFocusTraversalKeys(1, null);
        this.msgText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                if (Text.this.msgText.getText().equals(Text.this.defaultMsg)) {
                    Text.this.msgText.setText("");
                }
            }

            public void focusLost(FocusEvent focusEvent) {
                if (Text.this.msgText.getText().length() == 0) {
                    Text.this.msgText.setText(Text.this.defaultMsg);
                }
            }
        });
        this.setAlignmentY(0.0f);
        this.setViewportView(this.msgText);
        this.msgText.setInheritsPopupMenu(true);
        this.getViewport().setInheritsPopupMenu(true);
        this.setInheritsPopupMenu(true);
    }
}

