        PAGE    60,132
NAME    KeyRate
        TITLE   KeyRate.com version 1.3

COMMENT |

What Is KeyRate For
*******************

KeyRate changes the speed at which your AT keyboard repeats.


This program may be freely copied and used for any purpose
except military.

Usage:

To control your typematic delay and repeat rate insert this
command near the end of your autoexec.bat file:

KeyRate repeat-rate repeat-delay

e.g.  KeyRate

or

e.g.  KeyRate 10 3

The repeat-rate codes are as follows:
0 = 30.0 cps
1 = 26.7 cps
2 = 24.0 cps
3 = 21.8 cps
4 = 20.0 cps
5 = 18.5 cps
6 = 17.1 cps
7 = 16.0 cps
8 = 15.0 cps
9 = 13.3 cps
10= 12.0 cps
11= 10.9 cps
12= 10.0 cps

In other words the larger the rate code the slower the repeating.

The repeat-delay codes are as follows:
0 = 250 ms
1 = 500 ms
2 = 750 ms
3 = 1000 ms

In other words, the larger the delay code, the longer you have to
hold the key down before it starts to repeat.

Using KeyRate without parameters is equivalent to:

KeyRate 0 0


Please report bugs and problems to:

Roedy Green
Canadian Mind Products
#208 - 525 Ninth Street
New Westminster BC Canada
V5H 2N6
tel:(604) 777-1804
mailto:roedy@mindprod.com
http://mindprod.com


Version History
***************

Version 1.3 1998 November 8
- embed Barker address

Version 1.2 1996 October 25
- embed POB 707 Quathiaski Cove address

Version 1.1 released 1993 June 8
- new address

Version 1.0 released 1990 July 3 to BIX

How Does KeyRate Work
********************

KeyRate just pokes a command to microprocessor inside your
keyboard, then exits.  It is not a TSR.  It used the BIOS INT 16
function 0305.  Some similar programs that go directly to
hardware fail on fast machines such as 25 MHz cached 80386s.

Keyrate will not work on ATs with BIOS's dated prior to 11/15/85
since they do not support the INT 16 function 0305 BIOS call
that KeyRate uses.  For those, you could use the PC Powertools
program FastATKb.Com.

| ; end of comment

CODE    SEGMENT PARA

        ASSUME  CS:CODE,DS:CODE
        ORG     100H

;==============================================================

; Configuration EQUATES

MinRate         EQU     0       ; low bound on Rate cod
DefaultRate     EQU     0       ; default Rate code, fastest possible
MaxRate         EQU     12d     ; high bound on Rate code

MinDelay        EQU     0       ; low bound on Delay code
DefaultDelay    EQU     0       ; default Delay code, fastest possible
MaxDelay        EQU     3d      ; high bound on Delay code

;==============================================================

;       Register Conventions
;
;       All subroutines are permitted to trash whatever registers
;       they like.  It is the caller's responsibility to save
;       and restore registers.  For speed, callers cheat and only
;       save registers they know the called program changes.
;       In a few cases, subroutines do save/restore some registers.

;==============================================================

SAY     MACRO   Msg
;;      display message on screen
        LEA     DX,&Msg         ;; use LEA rather than
                                ;; MOV Offset for more generality
        MOV     AH,09h          ;; some assemblers will optimise this.
        INT     21h
        ENDM

;==============================================================

; MAINLINE PROGRAM

KeyRate  PROC    FAR
START:
        Say     CopyRightMsg    ; CopyRight banner
        CALL    Parse           ; parse duration and frequency on
                                ; command line
        CALL    SetKeyboard     ; poke command to keyboard
                                ; exit to DOS
        MOV  AX, 4C00H          ; ERRORLEVEL = 0
        INT 21H                 ; NORMAL BYE

;==============================================================

Parse   Proc    Near
;       Parse the command line for the optional rate and delay
        Call    CommandLine     ; get first parm - rate
        MOV     BX,1
        Call    NthParm
        JCXZ    NoRate          ; leave as default
        Call    ASCIIToBin
        MOV     BX,MinRate      ; low bound on Rate usu 0
        MOV     CX,MaxRate      ; high bound on Rate usu 12
        Call    Corral
        MOV     Rate,AX

        Call    CommandLine     ; get second parm -- delay
        MOV     BX,2
        Call    NthParm
        JCXZ    NoDelay         ; leave as default
        Call    ASCIIToBin      ; DX:AX is result
        MOV     BX,MinDelay     ; low bound usu 0
        MOV     CX,MaxDelay     ; high bound usu 3
        Call    Corral
        MOV     Delay,AX
NoRate:
NoDelay:
        RET
Parse   EndP

;==============================================================

CommandLine Proc        Near
;       Gets command line string into ES:DI
;       Command line does not include the program name.
;       ES already set since we are a COM file
                                ; counted string at HEX 80
                                ; contains command line.
                                ; It has no trailing null.
        MOV     DI,81h
        XOR     CH,CH
        MOV     CL,DS:80h       ; CX contains length of command
        RET
CommandLine EndP

;==============================================================

NthParm Proc    Near
;       Parses string for Nth Parameter delimited by blanks
;       e.g.  "  250 554" with BX=1 would give string "250"
;       ES:DI - string
;       CX - length of string
;       BX - which parm wanted 1=parm1 2=parm2 etc.
;       NthParm only finds one parm per call.
;       On exit ES:SI points to string and CX is its length.
;       If there is no parm, the length will be 0.
;       It also handles multiple leading/trailing blanks on parms.
        MOV     AL,20h          ; AL = blank  -- the search char
ParmLoop:
;       Remove leading blanks on parm
        JCXZ    NullParm        ; jump if null string
        REPE    SCASB           ; scan ES:DI forwards till hit non blank
                                ; DI points just after it
                                ; CX is one too small, or 0 if none found
        JE      NullParm        ; jump if entire string was blank
        INC     CX              ; CX is length of remainder of string
        DEC     DI              ; DI points to non-blank
        MOV     SI,DI           ; remember start of string
;       Search for terminating blank on parm
        JCXZ    NullParm        ; jump if null string
        REPNE   SCASB           ; scan ES:DI forwards till hit blank
                                ; DI points just after it
                                ; CX is one too small, or 0 if none found
        JNE     NoBlank         ; jump if entire string was non blank
        INC     CX              ; CX is length of remainder of string
        DEC     DI              ; backup DI to point to blank at string end
NoBlank:
                                ; DI=addr tail end of command string,
                                ; CX=len tail end of command string
                                ; SI=addr parm just parsed
;       Major loop for each parm
        DEC     BX
        JNZ     ParmLoop        ; loop once for each parm

        MOV     CX,DI
        SUB     CX,SI           ; CX is length of parameter.
        RET
NullParm:                       ; was no nth parameter
        MOV     CX,0
        RET
NthParm EndP

;==============================================================

ASCIIToBin      PROC    Near
;       on entry DS:SI points to start of decimal ASCII string of digits.
;       String should contain only the decimal digits 0..9.
;       If there are bad chars we abort.
;       CX contains length of string > 0
;       On exit DX:AX contains binary equivalent of string.
        PUSH    BX              ; save regs we will trash
        PUSH    CX
        PUSH    SI
        PUSH    DI
        XOR     AX,AX
        MOV     DX,AX           ; accumulate in DX:AX

OneDigitLoop:

; multiply accumulated number by 10
                                ; Works because 10*X = 2*X + 8*X
                                ; use DI:BX as working register
        SHL     AX,1
        RCL     DX,1            ; DX:AX = x*2
        MOV     BX,AX
        MOV     DI,DX
        SHL     BX,1
        RCL     DI,1
        SHL     BX,1
        RCL     DI,1            ; DI:BX = x*8
        ADD     BX,AX
        ADC     DI,DX           ; DI:BX = x*2 + x*8

; add on the next digit
        XOR     DX,DX
        MOV     AH,DH
        LODSB                   ; get next digit in AL
        SUB     AL,"0"          ; convert 1 digit ASCII to bin
        JB      NumTrouble      ; ensure 0..9
        CMP     AL,9
        JA      NumTrouble
        ADD     AX,BX           ; add it onto accumulated product
        ADC     DX,DI

        LOOP    OneDigitLoop    ; loop once for each digit

        POP     DI              ; restore regs
        POP     SI
        POP     CX
        POP     BX

        RET
NumTrouble:
;       Some problem, give standard Error message.
        Say     TroubleMsg
; ABORT
        MOV     AX,4C01H        ; EXIT back to DOS
                                ; with ERRORLEVEL 1
        INT     21H
;
ASCIIToBin      ENDP

;==============================================================

Corral  Proc    Near
;       on entry AX=number BX=low bound CX=high bound
;       on exit AX is safel corralled into the range BX:CX
        CMP     AX,BX
        JAE     BigEnough       ; use unsigned compares
        MOV     AX,BX
BigEnough:
        CMP     CX,AX
        JAE     SmallEnough
        MOV     AX,CX
SmallEnough:
        RET
Corral  EndP

;==============================================================

SetKeyboard     PROC    Near
;       Send commands to keyboard to set the delay and rate
        MOV     AX,0305h        ; function to set rate
        MOV     BH,BYTE PTR Delay
        MOV     BL,BYTE PTR Rate
        INT     16H             ; BIOS keyboard interrupt
        RET
SetKeyboard     ENDP

;==============================================================

; Messages

CopyRightMsg    LABEL BYTE
        DB      ' KeyRate 1.3 ۲  Adjusts keyboard typematic rates.',13,10
        DB      13,10
        DB      'For help type:  KeyRate /H',13,10
        DB      13,10
        DB      'Copyright (c) 1990-1999 Roedy Green',13,10
        DB      'Canadian Mind Products',13,10
        DB      '#208 - 525 Ninth Street, New Westminster, BC Canada V3M 5T9',13,10
        DB      'tel:(604) 777-1804   mailto:roedy@mindprod.com   http://mindprod.com',13,10
        DB      'This program may be freely copied and used for any purpose except military.',13,10,'$'

TroubleMsg      LABEL BYTE
        DB      13,10
        DB      'Usage:',13,10,7
        DB      'KeyRate               by itself without parameters is equivalent to KeyRate 0 0',13,10
        DB      '                      giving maxium speed.',13,10
        DB      'KeyRate 12 3          would change the rate of repeating to code 12=10.0 cps',13,10
        DB      '                      and the delay before repeating to code 3=1000 ms.',13,10
        DB      'The rate codes are:   0=30.0  1=26.7  2=24.0  3=21.8  4=20.0 cps',13,10
        DB      '                      5=18.5  6=17.1  7=16.0  8=15.0  9=13.3 cps',13,10
        DB      '                     10=12.0 11=10.9 12=10.0 cps',13,10
        DB      '                      Larger rate codes mean slower repeating.',13,10
        DB      'The delay codes are:  0=250 1=500 2=750 3=1000 ms',13,10
        DB      '                      Larger delay codes mean more delay to start repeat.',13,10
        DB      '$'
;==============================================================

; VARIABLES

Delay   DW      DefaultDelay    ; Delay code
Rate    DW      DefaultRate     ; Rate code

;==============================================================


KeyRate ENDP

CODE    ENDS
        END     START
