// Note: This program must be compiled with WATCOM C/C++ 11.0
//       and linked with directive "SYSTEM NT"

// You can see next topics in WIN32.HLP (Win32 SDK Reference Help from
// WATCOM C/C++ 11.0):
// LoadKeyboardLayout, ActivateKeyboardLayout, GetKeyboardLayout,
// GetKeyboardLayoutName, MAKELANGID, UnloadKeyboardLayout

#include <stdio.h>
#include <conio.h>
#include <wtypes.h>
#include <winuser.h>

#define MaxName 80
#define MaxLayouts 20

char nameOfLayoutToLoad[MaxLayouts][MaxName];
char nameOfLayoutCurrent[MaxName];
int i, NumOfLayoutToLoad, NotQuiet = 1;

void logoAndVersion(void) {
    printf("\n\  KBDLDR: VIT(R) MS Windows Keyboard Layout Loader\n\
  Version 1.0  Copyright (C) VIV 07.02.1999\n\n");
}

void usage (void) {
    logoAndVersion();
    printf("\
  Usage: KBDLDR [switches] nameOfLayoutToLoad1 [nameOfLayoutToLoad2] ...\n\
    switches:\n\
     -q          - Quiet mode\n\
     -h          - This help message\n\
    nameOfLayoutToLoad:\n\
     For example, U.S. English has a language identifier of '00000409',\n\
     Russian has a language identifier of '00000419',\n\
     Russian (Typewriter) has a language identifier of '00010419',\n\
     other available language identifiers see in the registry under the key\n\
     [HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Control\\keyboard layouts]\n\
    Note!\n\
     You can replace any .KBD-file (e.g. KBDRU.KBD) in %%windir%%\\SYSTEM\n\
     directory, then run KBDLDR with necessary language identifiers and\n\
     use new keyboard layouts - your WIN95/98 becomes MultiUser! :)\n\
\n\
");
    exit(1);
}

//void pause (void) {
//    #define Esc 0x001B
//    unsigned int pausekey = 0;
//    fprintf(stderr, "press any key to continue, ESC to exit...");
//    while(!pausekey) {
//        if(kbhit()) {
//            if((pausekey = getch()) == 0) pausekey = getch() * 256;
//            if(pausekey == Esc) {
//                printf("\n*** Exiting by ESCAPE ***\n");
//                exit(255);
//            }
//        }
//    }
//    fprintf(stderr, "\r                                         \r");
//}

void getarg (int argc, char *argv[]) {
    NumOfLayoutToLoad = 0;
    while(--argc > 0) {
        argv++;
        if(((*argv)[0] == '-') || ((*argv)[0] == '/')) { // if switch in cmdln
            switch((*argv)[1]) {
                case 'h':
                case 'H':
                    usage();
                case 'q':
                case 'Q':
                    NotQuiet = 0;
                    continue;
                default:
                    printf("invalid switch in command line: '%s'\n", &(*argv)[0]);
                    usage();
            }
        } else { // if non-switch argument:
            strcpy(&nameOfLayoutToLoad[NumOfLayoutToLoad][0], &(*argv)[0]);
            NumOfLayoutToLoad++;
        }
    }
    if(NumOfLayoutToLoad == 0) usage();
}

void main(int argc, char *argv[]) {
    HKL hkl1;
    HKL hkl[MaxLayouts];

    getarg(argc, argv);
    if(NotQuiet) logoAndVersion();

    i = GetKeyboardLayoutList(MaxLayouts, hkl);
    if(i == 0) i = MaxLayouts;
    for(; i-- != 0;) {
        if(NotQuiet) printf("Unloading KeyboardLayout HKL=0x%lX...\n", (long)hkl[i]);
        UnloadKeyboardLayout(hkl[i]);
    }

    hkl1 = GetKeyboardLayout(NULL);
    GetKeyboardLayoutName(nameOfLayoutCurrent);
    hkl1 = LoadKeyboardLayout(nameOfLayoutCurrent, KLF_ACTIVATE|KLF_REPLACELANG);
    //if(NotQuiet) printf("Unloading KeyboardLayout '%s' (HKL=0x%lX)...\n", nameOfLayoutCurrent, (long)hkl1);
    UnloadKeyboardLayout(hkl1);

    while(NumOfLayoutToLoad) {
        NumOfLayoutToLoad--;
        if(NotQuiet) printf("Loading KeyboardLayout '%s'...\n", &nameOfLayoutToLoad[NumOfLayoutToLoad][0]);
        if(LoadKeyboardLayout(&nameOfLayoutToLoad[NumOfLayoutToLoad][0], KLF_ACTIVATE|KLF_REPLACELANG|KLF_REORDER) == NULL)
            printf("KBDLDR: Can't LoadKeyboardLayout(%s)", &nameOfLayoutToLoad[NumOfLayoutToLoad][0]);
    }
    exit(0);
}
