Comment
==================================================================

This section contains the logic for processing IF statements. I'm
writing an interpreter language in MarxMenu. You can add your own
conditionals for IniTyme here.

==================================================================
EndComment

Var
  SearchList
  SearchListNot
  HardwareList
  HardwareRead
  GroupList
  DsGroupList
  GroupsRead
  GettingString
  DsConnectionType
  DsIniArray
  DsContext
  DsUserTyped
  DsUserTypeless
  DsRan
  DsFileName
  Assume
  ExitFlag


Procedure PushStack (V)
   AppendArray(Stack,V)
EndProc


Procedure PopStack
   if NumberOfElements(Stack) = 0
      Error ('Stack Empty!',LoopIndex)
   endif
   Return PopArray(Stack)
EndProc


Procedure Nugget
var Word P FirstChar
   Trim(IfLine)
   FirstChar = Left(IfLine,1)
   Word = NextWord(IfLine)

   if FirstChar Within('0','9')
      PushStack(Value(Word))

   elseif (FirstChar = '"') or (FirstChar = "'")
      PushStack(Word)

   else
      P = Hash('!' + Word)
      if P <> Nil
         Run P
      else
         if GettingString
            PushStack(Word)
         else
            Error ('Word "' + Word + '" not Recognized!',LoopIndex)
         endif
      endif
   endif
   GettingString Off

EndProc


Procedure Interpret
   while IfLine > ''
      Nugget
   endwhile
EndProc


Procedure ExecValueOf
var V P
   V = UpperCase(NextString)
   if Right(V,1) <> '=' then V = V + '='
   P = FindLine(V)
   if P = 0
      PushStack('')
   else
      PushStack RightOfEqual Orig[P]
   endif
EndProc


Procedure ExecValue
   PushStack(Value(NextParam))
EndProc


Procedure ExecString
   PushStack(Str(NextParam))
EndProc


Procedure NextParam
   Nugget
   Return PopStack
EndProc


Procedure NextString
   GettingString On
   Nugget
   Return PopStack
EndProc


Procedure ExecLeftParen
var OldParenLevel
   OldParenLevel = ParenLevel
   ParenLevel = ParenLevel + 1
   repeat
      Nugget
   until ParenLevel = OldParenLevel
EndProc


Procedure ExecRightParen
   ParenLevel = ParenLevel - 1
EndProc


Procedure ExecFileWriteln
var St
   Interpret
   Loop Stack
      St = St + LoopVal
   EndLoop
   dispose(Stack)
   ChangeOrAddLine(St,0)
EndProc


Procedure ExecWrite
   Interpret
   Loop Stack
      Write LoopVal
   EndLoop
   dispose(Stack)
EndProc


Procedure ExecWriteln
   ExecWrite
   Writeln
EndProc


Procedure ExecIf
var B
   Interpret

   ;- Multiple conditionals are ANDed

   B = PopStack
   while NumberOfElements Stack > 0
      B = B and PopStack
   endwhile

   if not B
      LoopIndex = GoToList[LoopIndex]
   endif
EndProc


Procedure ExecGoTo
   LoopIndex = GoToList[LoopIndex]
EndProc


Procedure DsIni
var X St Done

   if DsRan then Return

   Swapping On
   Execute 'DSINI.EXE ' + DsFileName

   if TestMode
      if not ExistFile(DsFileName)
         DsFileName = 'DS.INI'
      endif
   endif

   ReadTextFile(DsFileName,DsIniArray)
   if DsFileName <> 'DS.INI' then DelFile(DsFileName)

   X = PosInListLeft('CONNECTIONTYPE',DsIniArray)
   if X > 0
      DsConnectionType = RightOfEqual(DsIniArray[X])
   endif

   if DsConnectionType = 'NDS'

      X = PosInListLeft('CONTEXT',DsIniArray)
      if X > 0
         DsContext = RightOfEqual(DsIniArray[X])
      endif

      X = PosInListLeft('USERTYPELESS',DsIniArray)
      if X > 0
         DsUserTypeless = RightOfEqual(DsIniArray[X])
      endif

      X = PosInListLeft('USERTYPED',DsIniArray)
      if X > 0
         DsUserTyped = RightOfEqual(DsIniArray[X])
      endif

      X = PosInList('[GroupsImIn]',DsIniArray)
      if X > 0
         repeat
            X = X + 1
            St = DsIniArray[X]
            Done = (St = '') or (St StartsWith '[')
            if not Done
               AppendArray(DsGroupList,RightOfEqual(St))
            endif
         until X = NumberOfElements(DsIniArray) or Done
      endif

   endif

   dispose(DsIniArray)

   St = %GROUPS%
   if St = ''
      St = %S_GROUPS%
   endif

   while St > ''
      AppendArray(DsGroupList,UpperCase(NextWord(St)))
   endwhile

   DsRan = True
EndProc


Procedure ReadGroupList
var St
   if GroupsRead then Return

   if NovConnection > 0
      NovReadGroups(NovLoginName,GroupList)
   endif

   St = %GROUPS%
   if St = ''
      St = %S_GROUPS%
   endif

   while St > ''
      AppendArray(GroupList,UpperCase(NextWord(St)))
   endwhile

   GroupsRead = True
EndProc


Procedure AddHW (St)
   AppendArray(HardwareList,St)
EndProc


Procedure SetupHardwareList
var C Dev
   if HardwareRead then Return
   if ColorScreen
      AddHW('COLOR')
   else
      AddHW('MONO')
   endif

   C = DisplayType
   if C = 0
      AddHW('HERC')

   elseif C = 1
      AddHW('CGA')

   elseif C = 2
      AddHW('MCGA')

   elseif C = 3
      AddHW('EGA')

   elseif C = 4
      AddHW('VGA')

   endif

   C = CpuClass
   if C = 1
      AddHW('8086')

   elseif C = 2
      AddHW('80286')

   elseif C = 3
      AddHW('80386')

   elseif C = 4
      AddHW('80486')

   endif

   Devices(Dev)
   Loop Dev
      AddHW(LoopVal)
   EndLoop

   if EmsInstalled then AddHW('EMS')
   if XmsInstalled then AddHW('XMS')
   if Mouse then AddHW('MOUSE')
   if McpClass > 0 then AddHW('MATH')
   if DpmiInstalled then AddHW('DPMI')
   if VcpiInstalled then AddHW('VCPI')

   SortArray(HardwareList)
{
   Writeln
   Loop HardwareList
      Writeln LoopVal
   EndLoop
   Writeln
}
   HardwareRead
EndProc


Procedure MakeSearchList
var P St St2
   if IfLine StartsWith '='
      delete(IfLine,1,1)
      Trim(IfLine)
   endif

   P = Pos(' ',IfLine)
   if P = 0 then P = Length(IfLine) + 1

   St = left(IfLine,P-1)
   delete(IfLine,1,P)

   dispose(SearchList)
   dispose(SearchListNot)

   while St > ''
      St2 = Uppercase(NextWordDelim(St,',;"'+"'"))
      if St2 StartsWith '!'
         delete(St2,1,1)
         AppendArray(SearchListNot,St2)
      else
         AppendArray(SearchList,St2)
      endif
   endwhile
EndProc


Procedure ExecFile
   MakeSearchList

   Assume False
   Loop SearchListNot
      Assume True
      if ExistFile(LoopVal)
         PushStack False
         Return
      endif
   EndLoop

   Loop SearchList
      Assume False
      if ExistFile(LoopVal)
         PushStack True
         Return
      endif
   EndLoop

   PushStack Assume
EndProc


Procedure ExecDir
   MakeSearchList

   Assume False
   Loop SearchListNot
      Assume True
      if ExistDir(LoopVal)
         PushStack False
         Return
      endif
   EndLoop

   Loop SearchList
      Assume False
      if ExistDir(LoopVal)
         PushStack True
         Return
      endif
   EndLoop

   PushStack Assume
EndProc


Procedure ExecContext
   DsIni
   MakeSearchList

   Assume False
   Loop SearchListNot
      Assume True
      if LoopVal = DsContext
         PushStack False
         Return
      endif
   EndLoop

   Loop SearchList
      Assume False
      if LoopVal = DsContext
         PushStack True
         Return
      endif
   EndLoop

   PushStack Assume
EndProc


Procedure FindGroup (Group)
   if PosInList(Group,GroupList) > 0
      Return True
   endif
   Return False
EndProc


Procedure ExecGroups
   ReadGroupList
   MakeSearchList

   Assume False
   Loop SearchListNot
      Assume True
      if FindGroup(LoopVal)
         PushStack False
         Return
      endif
   EndLoop

   Loop SearchList
      Assume False
      if FindGroup(LoopVal)
         PushStack True
         Return
      endif
   EndLoop

   PushStack Assume
EndProc


Procedure FindDsGroup (Group)
   if PosInList(Group,DsGroupList) > 0
      Return True

   elseif PosInListLeft('CN=' + Group + '.',DsGroupList) > 0
      Return True

   elseif PosInListLeft(Group + '.',DsGroupList) > 0
      Return True

   endif
   Return False
EndProc


Procedure ExecDsGroups
   DsIni
   MakeSearchList

   Assume False
   Loop SearchListNot
      Assume True
      if FindDsGroup(LoopVal)
         PushStack False
         Return
      endif
   EndLoop

   Loop SearchList
      Assume False
      if FindDsGroup(LoopVal)
         PushStack True
         Return
      endif
   EndLoop

   PushStack Assume
EndProc


Procedure ExecInGroup
var Group
   ReadGroupList
   Group = UpperCase(NextWord(IfLine))
   PushStack(FindGroup(Group))
EndProc


Procedure ExecDsInGroup
var Group
   DsIni
   Group = UpperCase(NextWord(IfLine))
   PushStack(FindDsGroup(Group))
EndProc


Procedure ExecHardware
   SetupHardwareList
   MakeSearchList

   Assume False
   Loop SearchListNot
      Assume True
      if PosInSortedList(LoopVal,HardwareList) > 0
         PushStack False
         Return
      endif
   EndLoop

   Loop SearchList
      Assume False
      if PosInSortedList(LoopVal,HardwareList) > 0
         PushStack True
         Return
      endif
   EndLoop

   PushStack Assume
EndProc


Procedure ExecStation
var S
   if NovConnection > 0
      S = NovStationAddress
   else
      S = %STATION%
      if S = ''
         S = %S_STATION%
      endif
   endif
   PushStack(S)
EndProc


Procedure ExecStations
var S
   if NovConnection > 0
      S = NovStationAddress
   else
      S = %STATION%
      if S = ''
         S = %S_STATION%
      endif
   endif
   MakeSearchList

   if S = ''
      PushStack False
      Return
   endif

   Assume False
   Loop SearchListNot
      Assume True
      if pos(LoopVal,S) > 0
         PushStack False
         Return
      endif
   EndLoop

   Loop SearchList
      Assume False
      if pos(LoopVal,S) > 0
         PushStack True
         Return
      endif
   EndLoop

   PushStack Assume
EndProc


Procedure ExecNetwork
var N
   if NovConnection > 0
      N = 'NOVELL'
   else
      N = %NETWORK%
      if N = ''
         N = %S_NETWORK%
      endif
   endif
   MakeSearchList

   if N = ''
      PushStack False
      Return
   endif

   Assume False
   Loop SearchListNot
      Assume True
      if LoopVal = N
         PushStack False
         Return
      endif
   EndLoop

   Loop SearchList
      Assume False
      if LoopVal = N
         PushStack True
         Return
      endif
   EndLoop

   PushStack Assume
EndProc


Procedure ExecUsers
var U
   if NovConnection > 0
      U = NovLoginName
   else
      U = %USER%
      if U = ''
         U = %S_USER%
      endif
   endif

   MakeSearchList

   if U = ''
      PushStack False
      Return
   endif

   Assume False
   Loop SearchListNot
      Assume True
      if LoopVal = U
         PushStack False
         Return
      endif
   EndLoop

   Loop SearchList
      Assume False
      if LoopVal = U
         PushStack True
         Return
      endif
   EndLoop

   PushStack Assume
EndProc


;- Not Supported
Procedure ExecRev
   IfLine = ''
   dispose(Stack)
   PushStack True
EndProc


Procedure ExecPlus
var A B
   B = NextParam
   A = PopStack
   PushStack(A + B)
EndProc


Procedure ExecMinus
var A B
   B = NextParam
   A = PopStack
   PushStack(A - B)
EndProc


Procedure ExecTimes
var A B
   B = NextParam
   A = PopStack
   PushStack(A * B)
EndProc


Procedure ExecDiv
var A B
   B = NextParam
   A = PopStack
   PushStack(A / B)
EndProc


Procedure ExecEqual
var A B
   B = NextParam
   A = PopStack
   PushStack(A = B)
EndProc


Procedure ExecNotEqual
var A B
   B = NextParam
   A = PopStack
   PushStack(A <> B)
EndProc


Procedure ExecGreater
var A B
   B = NextParam
   A = PopStack
   PushStack(A > B)
EndProc


Procedure ExecLess
var A B
   B = NextParam
   A = PopStack
   PushStack(A < B)
EndProc


Procedure ExecGreaterEqual
var A B
   B = NextParam
   A = PopStack
   PushStack(A >= B)
EndProc


Procedure ExecLessEqual
var A B
   B = NextParam
   A = PopStack
   PushStack(A <= B)
EndProc


Procedure ExecAnd
var A B
   B = NextParam
   A = PopStack
   PushStack(A and B)
EndProc


Procedure ExecOr
var A B
   B = NextParam
   A = PopStack
   PushStack(A or B)
EndProc


Procedure ExecXor
var A B
   B = NextParam
   A = PopStack
   PushStack(A Xor B)
EndProc


Procedure ExecNot
   PushStack(not NextParam)
EndProc


Procedure ExecUpperCase
   PushStack(UpperCase(NextParam))
EndProc


Procedure ExecExistFile
   PushStack(ExistFile(NextString))
EndProc


Procedure ExecExistDir
   PushStack(ExistDir(NextString))
EndProc


Procedure ExecEnvVar
   PushStack(ReadEnv(NextString))
EndProc


Procedure ExecInMem
   PushStack(InMem(UpperCase(NextString)))
EndProc


Procedure ExecVlmLoaded
   PushStack(VlmLoaded)
EndProc


Procedure ExecShellLoaded
   PushStack(NovShellLoaded)
EndProc


Procedure ExecCPU
   PushStack(CPUClass)
EndProc


Procedure ExecMathChip
   PushStack(McpClass > 0)
EndProc


Procedure ExecUserName
   if NovConnection > 0
      PushStack(NovLoginName)
   else
      if %USER% > ''
         PushStack(%USER%)
      else
         PushStack(%S_USER%)
      endif
   endif
EndProc


Procedure ExecDsUserTyped
   DsIni
   PushStack(DsUserTyped)
EndProc


Procedure ExecDsUserTypeless
   DsIni
   PushStack(DsUserTypeless)
EndProc


Procedure ExecDsContext
   DsIni
   PushStack(DsContext)
EndProc


Procedure ExecDsConnectionType
   DsIni
   PushStack(DsConnectionType)
EndProc


Procedure ExecDisplay
var Disp
   Disp = DisplayType

   if Disp = 0
      PushStack 'HERC'

   elseif Disp = 1
      PushStack 'CGA'

   elseif Disp = 3
      PushStack 'EGA'

   elseif Disp = 4
      PushStack 'VGA'

   else
      PushStack ''

   endif
EndProc


Procedure ExecDayOfWeek
var D
   D = DayOfWeek

   if D = 0
      PushStack 'SUN'

   elseif D = 1
      PushStack 'MON'

   elseif D = 2
      PushStack 'TUE'

   elseif D = 3
      PushStack 'WED'

   elseif D = 4
      PushStack 'THU'

   elseif D = 5
      PushStack 'FRI'

   elseif D = 6
      PushStack 'SAT'

   endif
EndProc


Procedure ExecMonth
var D
   D = Month

   if D = 1
      PushStack 'JAN'

   elseif D = 2
      PushStack 'FEB'

   elseif D = 3
      PushStack 'MAR'

   elseif D = 4
      PushStack 'APR'

   elseif D = 5
      PushStack 'MAY'

   elseif D = 6
      PushStack 'JUN'

   elseif D = 7
      PushStack 'JUL'

   elseif D = 8
      PushStack 'AUG'

   elseif D = 9
      PushStack 'SEP'

   elseif D = 10
      PushStack 'OCT'

   elseif D = 11
      PushStack 'NOV'

   elseif D = 12
      PushStack 'DEC'

   endif
EndProc


Procedure ExecTrue
   PushStack(True)
EndProc


Procedure ExecFalse
   PushStack(False)
EndProc


Procedure ExecExit
   ExitFlag On
EndProc


Procedure SetupLibWords
   Hash ('!(')                     = Loc ExecLeftParen
   Hash ('!)')                     = Loc ExecRightParen
   Hash ('!+')                     = Loc ExecPlus
   Hash ('!-')                     = Loc ExecMinus
   Hash ('!<')                     = Loc ExecLess
   Hash ('!<=')                    = Loc ExecLessEqual
   Hash ('!<>')                    = Loc ExecNotEqual
   Hash ('!=')                     = Loc ExecEqual
   Hash ('!>')                     = Loc ExecGreater
   Hash ('!>=')                    = Loc ExecGreaterEqual
   Hash ('!AND')                   = Loc ExecAnd
   Hash ('!CONTEXT')               = Loc ExecContext
   Hash ('!CPU')                   = Loc ExecCPU
   Hash ('!DAYOFWEEK')             = Loc ExecDayOfWeek
   Hash ('!DIR')                   = Loc ExecDir
   Hash ('!DISPLAY')               = Loc ExecDisplay
   Hash ('!DSCONNECTIONTYPE')      = Loc ExecDsConnectionType
   Hash ('!DSCONTEXT')             = Loc ExecDsContext
   Hash ('!DSGROUPS')              = Loc ExecDsGroups
   Hash ('!DSINGROUP')             = Loc ExecDsInGroup
   Hash ('!DSUSERTYPED')           = Loc ExecDsUserTyped
   Hash ('!DSUSERTYPELESS')        = Loc ExecDsUserTypeless
   Hash ('!ENVVAR')                = Loc ExecEnvVar
   Hash ('!EXISTDIR')              = Loc ExecExistDir
   Hash ('!EXISTFILE')             = Loc ExecExistFile
   Hash ('!EXIT')                  = Loc ExecExit
   Hash ('!FALSE')                 = Loc ExecFalse
   Hash ('!FILE')                  = Loc ExecFile
   Hash ('!FILEWRITELN')           = Loc ExecFileWriteln
   Hash ('!GOTO')                  = Loc ExecGoto
   Hash ('!GROUPS')                = Loc ExecGroups
   Hash ('!HARDWARE')              = Loc ExecHardWare
   Hash ('!IF')                    = Loc ExecIf
   Hash ('!INGROUP')               = Loc ExecInGroup
   Hash ('!INMEM')                 = Loc ExecInMem
   Hash ('!MATHCHIP')              = Loc ExecMathChip
   Hash ('!MONTH')                 = Loc ExecMonth
   Hash ('!NETWORK')               = Loc ExecNetwork
   Hash ('!NOT')                   = Loc ExecNot
   Hash ('!OR')                    = Loc ExecOr
   Hash ('!READENV')               = Loc ExecEnvVar
   Hash ('!REV')                   = Loc ExecRev
   Hash ('!SHELLLOADED')           = Loc ExecShellLoaded
   Hash ('!STATION')               = Loc ExecStation
   Hash ('!STATIONS')              = Loc ExecStations
   Hash ('!STRING')                = Loc ExecString
   Hash ('!TRUE')                  = Loc ExecTrue
   Hash ('!UPPERCASE')             = Loc ExecUpperCase
   Hash ('!USERNAME')              = Loc ExecUserName
   Hash ('!USERS')                 = Loc ExecUsers
   Hash ('!VALUE')                 = Loc ExecValue
   Hash ('!VALUEOF')               = Loc ExecValueOf
   Hash ('!VLMLOADED')             = Loc ExecVlmLoaded
   Hash ('!WRITE')                 = Loc ExecWrite
   Hash ('!WRITELN')               = Loc ExecWriteln
   Hash ('!XOR')                   = Loc ExecXor
EndProc

