// tr3.cpp : Defines the entry point for the application.
//

#include "stdafx.h"
#include "windows.h"
#include "resource.h"
#include "commctrl.h"
#include "commdlg.h"
#include <shellapi.h>
#include "mmsystem.h"
#include "shlobj.h"
#include "stdio.h"
#include "tr3.h"       
#include <time.h>      
#include <dlgs.h>
#include <SYS\STAT.H>
#define  MAX_LOADSTRING 100
#pragma  comment(linker, "/SECTION:.shared,RWS")
#pragma  data_seg(".shared")
HWND hDialog = 0;

BOOL          bEnableTestMode = FALSE;
HWND          hListView = GetDeskTopListView();
HWND          hMainWnd = 0;
ICNDATA       *pICNData = 0;
//#pragma  data_seg()
// Global Variables:
HINSTANCE     hInst;                                       // current instance

TCHAR         szTitle[MAX_LOADSTRING];                     // The title bar text
TCHAR         szWindowClass[MAX_LOADSTRING];               // The title bar text
int           wpUseCount = 0;
CHAR          szVerInfo[30];
LPSTR         lpParms;
OSVERSIONINFO vi;
// Foward declarations of functions included in this code module:

ATOM MyRegisterClass(HINSTANCE hInstance);
BOOL InitInstance(HINSTANCE,int);
LRESULT CALLBACK WndProc(HWND,UINT,WPARAM,LPARAM);
ICSETTINGS    icSettings;
TCHAR         szMsgBox[200];

BOOL          bIconsAreScrambled = FALSE;
//BOOL          pICNData->bDancinFools = FALSE; // true = dancing active and can be started by dance routine
BOOL          bDanceStarting = TRUE;                       // true = positions need to be saved
BOOL          bHotKeyIsActive = FALSE;
BOOL          xpDropShadow = IsXPatLeast()
    && (BOOL)
    RegReadDWord("Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Advanced", "ListviewShadow");

CHAR          szWallPaper[MAX_PATH+1] = "";
CHAR          szPrevWallPaper[MAX_PATH+1] = "";
lpfnSHGetSettings m_pSHGetSettings = (lpfnSHGetSettings)
    GetProcAddress(GetModuleHandle(_T("Shell32.DLL")), "SHGetSettings");
lpfnEndTask   m_pEndTask = (lpfnEndTask)
    GetProcAddress(GetModuleHandle(_T("User32.DLL")), "EndTask");
lpfnSetLayeredWindowAttributes m_pSetLayeredWindowAttributes = (lpfnSetLayeredWindowAttributes)
    GetProcAddress(GetModuleHandle(_T("USER32.DLL")), "SetLayeredWindowAttributes");
lpfnLockWorkStation m_LockWorkstation = (lpfnLockWorkStation)
    GetProcAddress(GetModuleHandle(_T("USER32.DLL")), "LockWorkStation");
lpfnPrintWindow m_PrintWindow = (lpfnPrintWindow)
    GetProcAddress(GetModuleHandle(_T("USER32.DLL")), "PrintWindow");
lpfnSHGetSpecialFolderPath m_SHGetSpecialFolderPath = (lpfnSHGetSpecialFolderPath)
    GetProcAddress(GetModuleHandle(_T("Shell32.DLL")), "SHGetSpecialFolderPathA");
lpfnEnumDisplayDevices m_EnumDisplayDevices = (lpfnEnumDisplayDevices)
    GetProcAddress(GetModuleHandle(_T("User32.DLL")), "EnumDisplayDevicesA");
lpfnModule32First m_Module32First = (lpfnModule32First)
    GetProcAddress(GetModuleHandle(_T("Kernel32.DLL")), "Module32First");
lpfnProcess32First m_Process32First = (lpfnProcess32First)
    GetProcAddress(GetModuleHandle(_T("Kernel32.DLL")), "Process32First");
lpfnProcess32Next m_Process32Next = (lpfnProcess32Next)
    GetProcAddress(GetModuleHandle(_T("Kernel32.DLL")), "Process32Next");
lpfnCreateToolhelp32Snapshot m_CreateToolhelp32Snapshot = (lpfnCreateToolhelp32Snapshot)
    GetProcAddress(GetModuleHandle(_T("Kernel32.DLL")), "CreateToolhelp32Snapshot");
//-------------------------------------------------------------------------
//
//

int APIENTRY WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow)
{
    // TODO: Place code here.
    MSG           msg;
    HACCEL        hAccelTable;
    WNDCLASSEX    wcex;
    WNDCLASS      winclass;
    INITCOMMONCONTROLSEX ic;
    TCHAR         szFileName[MAX_PATH];
    // Initialize global strings
          
    hInst = hInstance;
    lpParms = lpCmdLine;
    ParseCommandLine(lpCmdLine);

    if (bStop)
        return 0;
    CreateMutex(NULL, FALSE, "IconoidMutex");
    if (GetLastError() == ERROR_ALREADY_EXISTS)
    {
        HWND          hWnd;

        hWnd = FindWindow("Iconoid", 0);

        EnableWindow(hWnd, TRUE);
        SetWindowPos(hWnd, HWND_TOP, 0, 0, 0, 0, SWP_NOMOVE|SWP_NOSIZE|SWP_SHOWWINDOW);
        SetForegroundWindow(hWnd);
        return  FALSE;
    } 
          
    vi.dwOSVersionInfoSize = sizeof OSVERSIONINFO;
    GetVersionEx(&vi);
    LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
    strcpy(szWindowClass, "Iconoid");
// Version stuff
    GetModuleFileName(hInst, szFileName, MAX_PATH);
    DWORD         dwVerSize;

    dwVerSize = GetFileVersionInfoSize(szFileName, 0);

    if (dwVerSize)
    {
        VS_FIXEDFILEINFO *lpvsFixedFileInfo;
        UINT          iLen;
        VOID          *pBuffer;
        VOID          *lpsVerInfo;
        CHAR          sVerInfo[0x350];

        lpsVerInfo = &sVerInfo;
        iLen = sizeof VS_FIXEDFILEINFO;
        lpsVerInfo = malloc(dwVerSize);
        GetFileVersionInfo(szFileName, 0, dwVerSize, lpsVerInfo);
        VerQueryValue(lpsVerInfo, "\\", &pBuffer, &iLen);
        lpvsFixedFileInfo = (VS_FIXEDFILEINFO *)pBuffer;
        wsprintf(szVerInfo, "%i.%i.%i",                    //
            HIWORD(lpvsFixedFileInfo->dwFileVersionMS),    //
            LOWORD(lpvsFixedFileInfo->dwFileVersionMS),    //
            HIWORD(lpvsFixedFileInfo->dwFileVersionLS));
        free(lpsVerInfo);
    } 
// Window stuff
    winclass.style = CS_HREDRAW|CS_VREDRAW;
    winclass.lpfnWndProc = SampleWndProc;
    winclass.cbClsExtra = 0;
    winclass.cbWndExtra = 0;
    winclass.hInstance = hInstance;
    winclass.hIcon = NULL;
    winclass.hCursor = LoadCursor(NULL, IDC_ARROW);
    winclass.hbrBackground = 0;                            // (HBRUSH) (ABOUTBOXCOLOR + 1) ;
    winclass.lpszMenuName = NULL;
    winclass.lpszClassName = TEXT("IconoidSample");
    RegisterClass(&winclass);

    winclass.style = CS_HREDRAW|CS_VREDRAW;
    winclass.lpfnWndProc = SampleTXWndProc;
    winclass.cbClsExtra = 0;
    winclass.cbWndExtra = 0;
    winclass.hInstance = hInstance;
    winclass.hIcon = NULL;
    winclass.hCursor = LoadCursor(NULL, IDC_ARROW);
    winclass.hbrBackground = 0;                            // (HBRUSH) (ABOUTBOXCOLOR + 1) ;
    winclass.lpszMenuName = NULL;
    winclass.lpszClassName = TEXT("IconoidSampText");
    RegisterClass(&winclass);
    //winclass.cbSize = sizeof(WNDCLASSEX);

    winclass.style = CS_HREDRAW|CS_VREDRAW;
    winclass.lpfnWndProc = (WNDPROC)DlgWndProc;
    winclass.cbClsExtra = 0;
    winclass.cbWndExtra = DLGWINDOWEXTRA;
    winclass.hInstance = hInstance;
    winclass.hIcon = LoadIcon(hInstance, (LPCTSTR)IDI_TR3);
    winclass.hCursor = LoadCursor(NULL, IDC_ARROW);
    winclass.hbrBackground = (HBRUSH)(COLOR_MENU+1);
    winclass.lpszMenuName = NULL;                          // (LPCSTR)IDC_TR3;
    winclass.lpszClassName = szWindowClass;
    //winclass.hIconSm = LoadIcon(winclass.hInstance, (LPCTSTR)IDI_SMALL);
    // winclass.hIconSm = 0;
    RegisterClass(&winclass);
    wcex.cbSize = sizeof(WNDCLASSEX);

    wcex.style = CS_HREDRAW|CS_VREDRAW;
    wcex.lpfnWndProc = (WNDPROC)WndProc;
    wcex.cbClsExtra = 0;
    wcex.cbWndExtra = 0;
    wcex.hInstance = hInstance;
    wcex.hIcon = LoadIcon(hInstance, (LPCTSTR)IDI_TR3);
    wcex.hCursor = LoadCursor(NULL, IDC_ARROW);
    wcex.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
    wcex.lpszMenuName = NULL;                              // (LPCSTR)IDC_TR3;
    wcex.lpszClassName = "IconoidHidden";
    //wcex.hIconSm = LoadIcon(wcex.hInstance, (LPCTSTR)IDI_SMALL);
    wcex.hIconSm = 0;
    RegisterClassEx(&wcex);

    hMainWnd = CreateWindow("IconoidHidden", "Iconoid Hidden Window",  //
        WS_OVERLAPPEDWINDOW,                               //
        CW_USEDEFAULT, 0, 100, 200,                        //
        NULL, NULL, hInstance, NULL);

#ifdef   skipthis
    ULONG         iUpTime = GetTickCount();
    FILbETIME     CreationTime;
    FILETIME      ExitTime;
    FILETIME      KernelTime;
    FILETIME      UserTime;
    typedef union _ULARGE_INTEGER
    {
        struct
        {
            DWORD         LowPart;
            DWORD         HighPart;
        } 
        ;
        ULONGLONG     QuadPart;
    } 
    ULARGE_INTEGER;
    ULARGE_INTEGER u,t;

    Var2X(procId, hProc);
    GetProcessTimes(hProc, &CreationTime, &ExitTime, &KernelTime, &UserTime);
    t.LowPart = CreationTime.dwLowDateTime;
    t.HighPart = CreationTime.dwHighDateTime;
    GetSystemTimeAsFileTime(&UserTime);
    u.LowPart = UserTime.dwLowDateTime;
    u.HighPart = UserTime.dwHighDateTime;
    u.QuadPart /= 10000000;
    t.QuadPart /= 10000000;
    u.QuadPart = u.QuadPart-t.QuadPart;
    iWaitTime = (UINT)max((INT)1, (INT)iWaitTime-(INT)u.LowPart);
    CloseHandle(hProc);
    return  FALSE;

    if (iWaitTime)
    {
        iWaitTime = min(10, iWaitTime);
        iWaitTime = max(iWaitTime, 0);
        iCountDown = max(1, iWaitTime);
        DialogBox(hInst, "Startbox", GetDesktopWindow(), WaitWndProc);
        hListView = GetDeskTopListView();
        icSettings.bNoShowStartup = iCountDown;

    } 
#endif
    ic.dwSize = sizeof ic;
    ic.dwICC = ICC_TAB_CLASSES;
    InitCommonControlsEx(&ic);
    hAccelTable = LoadAccelerators(hInstance, (LPCTSTR)IDC_TR3);
    // Main message loop:

    while (GetMessage(&msg, NULL, 0, 0))
    {
        if (!IsDialogMessage(hDialog, &msg))
        {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        } 
    } 
    return (int)msg.wParam;
} 

BOOL CheckForStartup()
{
    DWORD         procId;
    HANDLE        hProc = 0;
    BOOL          found = TRUE;

    GetWindowThreadProcessId(hListView = GetDeskTopListView(), &procId);
    hProc = OpenProcess(PROCESS_QUERY_INFORMATION, FALSE, procId);
    if (hProc == 0)
    {
        found = FALSE;
    } 
    else
        CloseHandle(hProc);
    hListView = GetDeskTopListView();
    return  found;
} 

BOOL StartPlayingTheGame(HWND hMainWnd)
{
    if (SetHook(TRUE))
    {
        GetICSettings(&icSettings, FALSE, TRUE);           // Get settings from registry
        pICNData = (PICNDATA)LocateSharedData();
        pICNData->icnFgColor = (COLORREF)SendMessage(hListView, LVM_GETTEXTCOLOR, 0, 0);
        pICNData->icnBkColor = (COLORREF)SendMessage(hListView, LVM_GETTEXTBKCOLOR, 0, 0);
        hDialog = CreateDialog(hInst, "MAINDIALOG", hMainWnd, DlgWndProc);
        if (!hDialog)
        {
            ProcessLastErr();
            SendMessage(hMainWnd, WM_CLOSE, 0, 0);
            return  FALSE;
        } 
          
        ShowWindow(hDialog, icSettings.bHideWhenStarted?SW_HIDE:SW_SHOW);
        return  TRUE;
    } 
    else
    {
        MessageBox(0, TEXT("Unable to set hook to desktop." //
            "\n\nIconoid can not sample the screen."       //
            "\n\nThis may be because \"Show Desktop\""     //
            "\nwas active when Iconoid started."           //
            "\nIf so, make sure at least one window"       //
            "\nis showing and restart Iconoid."            //
            ),                                             //
            szTitle, MB_ICONHAND|MB_APPLMODAL);
        return  FALSE;
    } 
} 

//
// FUNCTION: WndProc(HWND, unsigned, WORD, LONG)
//
// PURPOSE:  Processes messages for the main window.
//
// WM_COMMAND  - process the application menu
// WM_PAINT    - Paint the main window
// WM_DESTROY  - post a quit message and return
//
//

LRESULT CALLBACK WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
    switch (message)
    {
        case  WM_CREATE :
                        // set startup on timer because if explorer isn't up when iconoid starts
                        // and the dialog is run from WM_CREATE, all Hell breaks loose.
            SetTimer(hWnd, 100, 100, 0);
            return 0;
        case  WM_TIMER :
            KillTimer(hWnd, 100);
            if (!(CheckForStartup() && StartPlayingTheGame(hWnd)))
                SetTimer(hWnd, 100, 1000, 0);
            return 0;
        case  WM_DESTROY :
            PostQuitMessage(0);
            break;
        default  :
            if (message == iTaskBarCreatedMsg)
            {
                SendMessage(hDialog, iTaskBarCreatedMsg, 0, 0);
            } 
            return  DefWindowProc(hWnd, message, wParam, lParam);
    } 
    return 0;
} 

void SetDesktopHide()
{
    if (icSettings.bAlwaysHide)
    {
        HideDesktopIcons(icSettings.bHideTaskBar);
    } 
    else
    {
        ShowWindow(hListView, SW_SHOW);
        ShowTaskbar();
    } 
} 

void SelectColor(HWND hControl,COLORREF *crInputColor)
{
    CHOOSECOLOR   cc;
    int           i;
    bool          bFound;
    COLORREF      crCustColors[16] = 
    {
        0x0,0x800000,0x8000,0x808000,0x80,0x800080,0x8080,0xC0C0C0,0x808080,0xFF0000,0xFF00,0xFFFF00,0xFF,0xFF00FF,0xFFFF,0xFFFFFF,
    } 
    ;
    cc.lStructSize = sizeof cc;
    cc.hwndOwner = hControl;
    cc.hInstance = 0;                                      // not needed
    cc.rgbResult = *crInputColor;
    cc.lpCustColors = crCustColors;
    cc.Flags = CC_ANYCOLOR|CC_RGBINIT|CC_FULLOPEN;
    cc.lCustData = 0;                                      // not needed
    cc.lpfnHook = 0;                                       // not needed
    cc.lpTemplateName = "";                                // not needed
    bFound = false;
    bUserPressedEscape = FALSE;
    for (i = 0; i < 16; i++)
        if (*crInputColor == crCustColors[i])
            bFound = true;
    if (!bFound)
        crCustColors[0] = *crInputColor;
    if (ChooseColor(&cc))
        *crInputColor = cc.rgbResult;
    else
        bUserPressedEscape = TRUE;
} 

VOID APIENTRY DisplayContextMenu(HWND hwnd,POINT pt)
{
    HMENU         hmenu;                                   // top-level menu
    HMENU         hmenuTrackPopup;                         // shortcut menu
    BOOL          bKeyRetrieved = FALSE;
    TCHAR         szKeyName[18] = "Software\\SillySot";
    // Load the menu resource.

    if ((hmenu = LoadMenu(hInst, (LPCSTR)IDC_TR3)) == NULL)
        return ;
    // TrackPopupMenu cannot display the menu bar so get
    // a handle to the first shortcut menu.
    hmenuTrackPopup = GetSubMenu(hmenu, 0);
    // Set up items in the menu
    // ModifyMenu(hmenuTrackPopup, IDM_EXIT, MF_BYCOMMAND|MF_STRING, IDM_EXIT, //
    // (icSettings.bNeverEnd&!icSettings.bConfirmExit)?"&Hide":"&Exit");
    ModifyMenu(hmenuTrackPopup, IDM_EXIT, MF_BYCOMMAND|MF_STRING, IDM_EXIT,  //
        "&Exit");
    //  if (!(icSettings.bNeverEnd&!icSettings.bConfirmExit))
    //       if (!IsWindowVisible(hListView))
    //           EnableMenuItem(hmenu, IDM_EXIT, MF_GRAYED);
    if (icSettings.bShowHelp)
        InsertMenu(hmenuTrackPopup, 1, MF_BYPOSITION|MF_STRING, ID_CMDHELP, "Help...");

    if (icSettings.bShowSaveRest || pICNData->bDancinFools)
    {
        InsertMenu(hmenuTrackPopup, IDM_EXIT, MF_BYCOMMAND|MF_STRING, IDM_SAVEICONS, "Save Icon Positions");
        InsertMenu(hmenuTrackPopup, IDM_EXIT, MF_BYCOMMAND|MF_STRING, IDM_RESTOREICONS, "Restore Icon Positions");
        InsertMenu(hmenuTrackPopup, IDM_EXIT, MF_BYCOMMAND|MF_SEPARATOR, NULL, NULL);
        if (!IsActiveDesktop())
        {
            if ((icSettings.bShowDance && icSettings.bShowSaveRest) || pICNData->bDancinFools)
            {
                InsertMenu(hmenuTrackPopup, IDM_EXIT, MF_BYCOMMAND|MF_STRING, IDM_DANCE, "Do the Icon Dance");
                InsertMenu(hmenuTrackPopup, IDM_EXIT, MF_BYCOMMAND|MF_SEPARATOR, NULL, NULL);
                CheckMenuItem(hmenu, IDM_DANCE, pICNData->bDancinFools?MF_CHECKED:MF_UNCHECKED);
            } 
        } 
    } 

    if (icSettings.bShowIconBackgroundOptions)
    {
        InsertMenu(hmenuTrackPopup, IDM_EXIT, MF_BYCOMMAND|MF_STRING, IDM_TRANSPARENT, "Transparent Background");
        if (!IsActiveDesktop())
            InsertMenu(hmenuTrackPopup, IDM_EXIT, MF_BYCOMMAND|MF_STRING, IDM_RESAMPLE, "Resample Background");
        InsertMenu(hmenuTrackPopup, IDM_EXIT, MF_BYCOMMAND|MF_SEPARATOR, NULL, NULL);
        CheckMenuItem(hmenu, IDM_TRANSPARENT, icSettings.bTransparent?MF_CHECKED:MF_UNCHECKED);
        EnableMenuItem(hmenu, IDM_TRANSPARENT, CheckXPDropShadow()?MF_GRAYED:MF_ENABLED);
        EnableMenuItem(hmenu, IDM_RESAMPLE, CheckXPDropShadow()?MF_GRAYED:MF_ENABLED);
    } 
    if (icSettings.bShowHidingOptions)
    {
        InsertMenu(hmenuTrackPopup, IDM_EXIT, MF_BYCOMMAND|MF_STRING, IDM_NEVERHIDE, "Show Icons Always");
        InsertMenu(hmenuTrackPopup, IDM_EXIT, MF_BYCOMMAND|MF_STRING, IDM_AUTOHIDE, "Show Icons as Needed");
        InsertMenu(hmenuTrackPopup, IDM_EXIT, MF_BYCOMMAND|MF_STRING, IDM_ALWAYSHIDE, "Hide Icons Always");
        CheckMenuItem(hmenu, IDM_AUTOHIDE, (icSettings.bAutoHide)?MF_CHECKED:MF_UNCHECKED);
        CheckMenuItem(hmenu, IDM_ALWAYSHIDE, (icSettings.bAlwaysHide)?MF_CHECKED:MF_UNCHECKED);
        CheckMenuItem(hmenu, IDM_NEVERHIDE, (!(icSettings.bAutoHide || icSettings.bAlwaysHide))?MF_CHECKED:MF_UNCHECKED);
        InsertMenu(hmenuTrackPopup, IDM_EXIT, MF_BYCOMMAND|MF_SEPARATOR, NULL, NULL);
    } 

    bKeyRetrieved =                                        //
        (CheckForSavedRelative() && !icSettings.bAbsolutePosition) //
            || (CheckForSavedAbsolute() && icSettings.bAbsolutePosition);
    EnableMenuItem(hmenu, IDM_RESTOREICONS, bKeyRetrieved?MF_ENABLED:MF_GRAYED); //
    EnableMenuItem(hmenu, IDM_SAVEICONS, bIconsAreScrambled?MF_GRAYED:MF_ENABLED); //
    // Display the shortcut menu. Track the right mouse
    // button.

    HMENU         hPop;
          
    hPop = LoadMenu(hInst, (LPCSTR)IDR_BETAMENU);
    if (bEnableTestMode)
        InsertMenu(hmenuTrackPopup, IDM_EXIT, MF_BYCOMMAND|MF_STRING|MF_POPUP, (LRESULT)hPop, "[ Test ]");
    SetForegroundWindow(hwnd);

    TrackPopupMenu(hmenuTrackPopup, TPM_LEFTALIGN|TPM_RIGHTBUTTON|TPM_NONOTIFY, pt.x, pt.y, 0, hwnd, NULL);
    PostMessage(hwnd, WM_NULL, 0, 0);
    // Destroy the menu.

    DestroyMenu(hmenu);

    if (bEnableTestMode)
        DestroyMenu(hPop);
} 

void ShowTaskbarConditionally()
{
    RECT          rectTrayPos;
    POINT         ptCursor;
          
    GetCursorPos(&ptCursor);
    GetWindowRect(FindWindow("Shell_TrayWnd", NULL), &rectTrayPos);
    if (PtInRect(&rectTrayPos, ptCursor))
    {
        ShowTaskbar();
        SetTimer(hDialog, IDT_TIMER8, TASKBAR_REHIDE_TIME, (TIMERPROC)ReHideTaskbarProc);
    } 
} 

void ShowTaskbar()
{
    ShowWindow(FindWindow("Shell_TrayWnd", NULL), SW_SHOW);
} 

void HideTaskbar()
{
    ShowWindow(FindWindow("Shell_TrayWnd", NULL), SW_HIDE);
} 

int ConditionalMessageBox(HWND hwnd,LPCTSTR msg,LPCTSTR title,UINT icon)
{
    return (bQuiet)?IDOK:MessageBox(hwnd, msg, title, icon);
} 

void ReinitializeSharedData(HWND hWnd)
{
    pICNData = (PICNDATA)LocateSharedData();
    pICNData->bShowContextMenu = icSettings.bContextMenu;
    pICNData->bShowIconsWhenClickDesktop = icSettings.bShowIconsInAlways;
    if (icSettings.bAlwaysHide)
        pICNData->iCheckState = ID_CHKALWAYSHIDE;
    else
        if (icSettings.bAutoHide)
            pICNData->iCheckState = ID_CHKAUTOHIDE;
        else
            pICNData->iCheckState = ID_CHKNEVERHIDE;
    //   pICNData->icnFgColor = (COLORREF)SendMessage(hListView, LVM_GETTEXTCOLOR, 0, 0);
    //  pICNData->icnBkColor = (COLORREF)SendMessage(hListView, LVM_GETTEXTBKCOLOR, 0, 0);
} 

HWND Restart(HWND hWnd)
{
    DWORD         dummy;
    ULONG         threadid;

    KillTimer(hWnd, IDT_TIMER_SAVESETTINGS);
    ReinitializeSharedData(hWnd);
    SetHook2(FALSE, hWnd);
    CreateThread(NULL, 0, CallSetHook2, &dummy, NULL, &threadid);
    SendMessage(hWnd, ID_SETTINGCHANGE, SPI_SETDESKWALLPAPER, (LPARAM)0);
    SetTimer(hWnd, IDT_TIMER_SAVESETTINGS, 2000, (TIMERPROC)SaveSettingsTimer);
    return  FindWindow("Progman", 0);
} 

VOID MoveDisplayProperties(HWND hwndDisp,BOOL bForce)
{
    if (hwndDisp)
    {
        RECT          rect,rectD;
        int           width,height;
          
        GetWindowRect(hDialog, &rect);
        GetWindowRect(hwndDisp, &rectD);
        width = rectD.right-rectD.left;
        height = rectD.bottom-rectD.top;
        int           size = GetSystemMetrics(SM_CXMENUSIZE);

        if (bForce)
        {
            if (rect.left < width)
                OffsetRect(&rectD, rect.right-rectD.left, rect.top-rectD.top); // force to right
            else
                OffsetRect(&rectD, (rect.left-width-rectD.left), rect.top-rectD.top); // force to left
        } 
        else
        {
            if (rectD.left <= rect.left)                   // should be right but rect are coordinates from after move
                OffsetRect(&rectD, (rect.left-width-rectD.left), rect.top-rectD.top); // force to left
            else
                OffsetRect(&rectD, rect.right-rectD.left, rect.top-rectD.top); // force to right
        } 
        MoveWindow(hwndDisp, rectD.left, rectD.top, width, height, TRUE);
    } 
} 

VOID ShowDisplayProperties()
{
//  rundll32 shell32.dll,Control_RunDLL desk.cpl,,0
    CHAR          systemroot[MAX_PATH];

    CHAR          command[MAX_PATH+50];
    HWND          hwndDisp = FindWindow(0, "Display Properties");
          
    GetWindowsDirectory(systemroot, (ULONG)MAX_PATH);
    wsprintf(command, "%s\\system32\\rundll32.exe", systemroot);
    LRESULT       shrc = (LRESULT)ShellExecute(hDialog, "open", command, "shell32.dll,Control_RunDLL desk.cpl,,0", NULL, SW_SHOWNORMAL);

    if (shrc <= 32)
    {
        GetWindowsDirectory(systemroot, (ULONG)MAX_PATH);
        wsprintf(command, "%s\\rundll32.exe", systemroot);
        ShellExecute(hDialog, "open", command, "shell32.dll,Control_RunDLL desk.cpl,,0", NULL, SW_SHOWNORMAL);
    } 
    hwndDisp = FindWindow(0, "Display Properties");
    for (int a = 0; a < 20 && !hwndDisp; a++)
    {
        Sleep(100);
        hwndDisp = FindWindow(0, "Display Properties");
    } 
    MoveDisplayProperties(hwndDisp, TRUE);
} 

BOOL WallpaperHasChanged()
{
    static FILETIME oldFtime = 
    {
        -1,-1
    } 
    ;
    FILETIME      newFtime;
    BOOL          same = FALSE;
    static BOOL   bOldTiled = 49 == RegReadDWord("Control Panel\\Desktop", "TileWallpaper");
    static BOOL   bOldStretched = 50 == RegReadDWord("Control Panel\\Desktop", "WallpaperStyle");
    BOOL          bNewTiled = 49 == RegReadDWord("Control Panel\\Desktop", "TileWallpaper");
    BOOL          bNewStretched = 50 == RegReadDWord("Control Panel\\Desktop", "WallpaperStyle");
          
    GetCurrentWallpaper(szWallPaper);
    WIN32_FIND_DATA fd;

    if (*szWallPaper)
    {
        HANDLE        hFile = FindFirstFile(szWallPaper, &fd);
          
        if (hFile != INVALID_HANDLE_VALUE)
        {
            newFtime.dwHighDateTime = fd.ftCreationTime.dwHighDateTime;
            newFtime.dwLowDateTime = fd.ftCreationTime.dwLowDateTime;
        } 
        else
            newFtime.dwHighDateTime = newFtime.dwLowDateTime = -1;
    } 
    else
        newFtime.dwHighDateTime = newFtime.dwLowDateTime = -1;
    same = !memcmp(&oldFtime, &newFtime, sizeof FILETIME);
    if (same)
        same = !strcmp(szPrevWallPaper, szWallPaper);
    if (same)
        same = (bNewTiled == bOldTiled) && (bNewStretched == bOldStretched);
    memcpy(&oldFtime, &newFtime, sizeof FILETIME);
    strcpy(szPrevWallPaper, szWallPaper);
    bOldStretched = bNewStretched;
    bOldTiled = bNewTiled;
    return !same;
} 

UINT_PTR CALLBACK OFNHookProc(HWND hdlg,UINT uiMsg,WPARAM wParam,LPARAM lParam)
{
    switch (uiMsg)
    {
        case  WM_NOTIFY :
            {
                NMHDR         *pnmhdr;
                OFNOTIFY      *pof;
          
                pnmhdr = (LPNMHDR)lParam;
                pof = (LPOFNOTIFY)lParam;
         //       if (CDN_FOLDERCHANGE == pof->hdr.code)
                {
                    HWND          hList = GetDlgItem(GetParent(hdlg), lst2);
          
                    hList = FindWindowEx(hList, NULL, WC_LISTVIEW, NULL);
                    if (hList)
                    {
                        CHAR          path[MAX_PATH];
          
                        path[0] = 0;
                        SendMessage(GetParent(hdlg), CDM_GETFOLDERPATH, MAX_PATH, (LPARAM)path);
                        strcat(path, "\\");
                        LRESULT       itemcount = (LRESULT)SendMessage(hList, LVM_GETITEMCOUNT, 0, 0);
          
                        for (LRESULT ic = itemcount-1; ic >= 0; ic--)
                        {
                            CHAR          txt[MAX_PATH];
                            WCHAR         wtxt[MAX_PATH];
                            WCHAR         wid[100];
                            CHAR          atxt[MAX_PATH];
                            CHAR          aid[100];
                            CHAR          fullname[MAX_PATH];
                            LVITEM        lvitem;
          
                            ZeroMemory(&lvitem, sizeof(lvitem));
                            lvitem.mask = LVIF_TEXT;
                            lvitem.cchTextMax = MAX_PATH-1;
                            lvitem.pszText = txt;
                            SendMessage(hList, LVM_GETITEMTEXT, ic, (LPARAM)&lvitem);
                            strcpy(fullname, path);
                            strcat(fullname, txt);
                            struct _stat  filestats;       // should be changed to findfirstfile etc
          
                            _stat(fullname, &filestats);
                            if ((filestats.st_mode&_S_IFREG) != 0)
                            {
                                BOOL          verify = TRUE;
                                FILE          *f;
          
                                if (Is2K())
                                {
                                    f = fopen(fullname, "rb");
                                    if (f)
                                    {
                                        if (NULL != fgetws(wtxt, MAX_PATH, f))
                                        {
                                            wcscpy(wid, L"Windows Registry Editor Version 5.00");
                                            verify = 0 == wcsncmp(wtxt+1, wid, wcslen(wid));
                                        } 
                                        if (verify && NULL != fgetws(wtxt, MAX_PATH, f))
                                            verify = 2 == wcslen(wtxt);
                                        if (verify && NULL != fgetws(wtxt, MAX_PATH, f))
                                        {
                                            wcscpy(wid, L"[HKEY_CURRENT_USER\\Software\\SillySot]");
                                            verify = 0 == wcsncmp(wtxt, wid, wcslen(wid));
                                        } 
                                        fclose(f);

                                    } 
                                    else
                                        verify = FALSE;
                                    if (!verify)           // try ansi
                                    {
                                        f = fopen(fullname, "r");
                                        if (f)
                                        {
                                            if (NULL != fgets(atxt, MAX_PATH, f))
                                            {
                                                strcpy(aid, "Windows Registry Editor Version 5.00");
                                                verify = 0 == strncmp(atxt, aid, strlen(aid));
                                            } 
                                            if (verify && NULL != fgets(atxt, MAX_PATH, f))
                                                verify = 2 >= strlen(atxt);
                                            if (verify && NULL != fgets(atxt, MAX_PATH, f))
                                            {
                                                strcpy(aid, "[HKEY_CURRENT_USER\\Software\\SillySot]");
                                                verify = 0 == strncmp(atxt, aid, strlen(aid));
                                            } 
                                            fclose(f);
                                        } 
                                        else
                                            verify = FALSE;
                                    } 
                                } 
                                else                       // win9x
                                {
                                    f = fopen(fullname, "r");
                                    if (f)
                                    {
                                        if (NULL != fgets(atxt, MAX_PATH, f))
                                        {
                                            strcpy(aid, "REGEDIT4");
                                            verify = 0 == strncmp(atxt, aid, strlen(aid));
                                        } 
                                        if (verify && NULL != fgets(atxt, MAX_PATH, f))
                                            verify = 2 >= strlen(atxt);
                                        if (verify && NULL != fgets(atxt, MAX_PATH, f))
                                        {
                                            strcpy(aid, "[HKEY_CURRENT_USER\\Software\\SillySot]");
                                            verify = 0 == strncmp(atxt, aid, strlen(aid));
                                        } 
                                        fclose(f);
                                    } 
                                    else
                                        verify = FALSE;
                                } 
                                if (!verify)
                                    SendMessage(hList, LVM_DELETEITEM, ic, 0);

                            } 
                        } 
                    } 
                } 
                break;
            } 
    } 
    return  DefWindowProc(hdlg, uiMsg, wParam, lParam);
} 

void ImportExportSettings(BOOL bImport)
{
    OPENFILENAME  ofn;
    CHAR          filename[MAX_PATH];
    CHAR          fileonly[MAX_PATH];
    CHAR          savePath[MAX_PATH];
    CHAR          initPath[MAX_PATH+50];
    CHAR          systemroot[MAX_PATH];
    CHAR          buffer[MAX_PATH+80];
    CHAR          command[MAX_PATH+50];
          
    EnableWindow(hDialog, FALSE);
    ZeroMemory(&ofn, sizeof ofn);
    ofn.lStructSize = Is2K()?sizeof ofn:OPENFILENAME_SIZE_VERSION_400;
    ofn.hwndOwner = hMainWnd;
    ofn.hInstance = NULL;
    ofn.lpstrFilter = "Registry Files\0*.reg";
    ofn.lpstrCustomFilter = NULL;
    ofn.nMaxCustFilter = 0;
    ofn.nFilterIndex = 1;
    ofn.lpstrFile = filename;
    ofn.nMaxFile = MAX_PATH;
    ofn.lpstrFileTitle = fileonly;
    ofn.nMaxFileTitle = MAX_PATH;
    ofn.lpstrInitialDir = NULL;
    ofn.Flags = OFN_ENABLESIZING|OFN_HIDEREADONLY|OFN_NOREADONLYRETURN|OFN_OVERWRITEPROMPT|OFN_PATHMUSTEXIST|OFN_EXPLORER;
    ofn.Flags = ofn.Flags|OFN_NOCHANGEDIR|OFN_NONETWORKBUTTON|OFN_EXTENSIONDIFFERENT;
    ofn.nFileOffset = 0;
    ofn.nFileExtension = 0;
    ofn.lpstrDefExt = "reg";
    ofn.lCustData = NULL;
    ofn.lpfnHook = NULL;
    ofn.lpTemplateName = "";
    ofn.pvReserved = NULL;
    ofn.dwReserved = 0;
    ofn.FlagsEx = OFN_EX_NOPLACESBAR;
    time_t        timet;
          
    time(&timet);
    strftime(filename, MAX_PATH, "Iconoid settings %Y.%m.%d %H.%M.reg", localtime(&timet));
    if (m_SHGetSpecialFolderPath)
    {
        if (m_SHGetSpecialFolderPath(hDialog, savePath, CSIDL_APPDATA, TRUE))
        {
            wsprintf(initPath, "%s\\Iconoid", savePath);
            strcpy(savePath, initPath);
            CreateDirectory(savePath, NULL);
            if (bImport)
                strcat(savePath, "\\*.reg");
            else
                wsprintf(savePath, "%s\\%s", initPath, filename);
            strcpy(filename, savePath);
        } 
    } 
    GetWindowsDirectory(systemroot, (ULONG)MAX_PATH);
    wsprintf(command, "%s\\regedit.exe", systemroot);
    SHELLEXECUTEINFO ShExecInfo;
          
    ZeroMemory(&ShExecInfo, sizeof ShExecInfo);
    ShExecInfo.cbSize = sizeof SHELLEXECUTEINFO;
    ShExecInfo.fMask = SEE_MASK_NOCLOSEPROCESS;
    ShExecInfo.hwnd = hDialog;
    ShExecInfo.lpVerb = NULL;
    ShExecInfo.lpDirectory = NULL;
    ShExecInfo.nShow = SW_SHOWNORMAL;
    ShExecInfo.hInstApp = NULL;
    if (bImport)
    {
        ofn.Flags = ofn.Flags|OFN_ENABLEHOOK;
        ofn.lpfnHook = OFNHookProc;
        ofn.lpstrTitle = "Import Iconoid Settings";
        ofn.Flags = ofn.Flags|OFN_FILEMUSTEXIST;
        if (GetOpenFileName(&ofn))
        {
            if (0 == (ofn.Flags&OFN_EXTENSIONDIFFERENT))
            {
                KillTimer(hDialog, IDT_TIMER2);
                KillTimer(hDialog, IDT_TIMER_SAVESETTINGS);
                UnregisterHotKey(hDialog, 0xBFFC);
                UnregisterHotKey(hDialog, 0xBFFD);
                UnregisterHotKey(hDialog, 0xBFFE);
                UnregisterHotKey(hDialog, 0xBFFF);

                wsprintf(buffer, "/s \"%s\"", filename);
                ShExecInfo.lpFile = command;
                ShExecInfo.lpParameters = buffer;
                ShellExecuteEx(&ShExecInfo);
                WaitForSingleObject(ShExecInfo.hProcess, INFINITE);
                wsprintf(buffer, "Imported from %s", fileonly);
                SetWindowText(ItemHWnd(IDC_STATUSBAR), buffer);
                GetICSettings(&icSettings, FALSE, FALSE);  // refetch settings
                                                        //
                ReInitializeControlSettings(hDialog);
                SetMainTimer(hDialog);
                SetTimer(hDialog, IDT_TIMER_SAVESETTINGS, 2000, (TIMERPROC)SaveSettingsTimer);
                int           oldTrayWarningShown = TrayWarningShown;

                TrayWarningShown = 1;
                SendMessage(hDialog, WM_COMMAND, ID_CHKAUTOSTART, 0);
                SendMessage(hDialog, WM_COMMAND, ID_CHKAUTOSTART, 0);
                SendMessage(hDialog, WM_COMMAND, ID_CHKHIDEATSTART, 0);
                SendMessage(hDialog, WM_COMMAND, ID_CHKHIDEATSTART, 0);
                SendMessage(hDialog, WM_COMMAND, IDC_CHKSTATUSBAR, 0);
                SendMessage(hDialog, WM_COMMAND, IDC_CHKSTATUSBAR, 0);
                SendMessage(hDialog, WM_COMMAND, IDC_CONTEXTMENU, 0);
                SendMessage(hDialog, WM_COMMAND, IDC_CONTEXTMENU, 0);
                SendMessage(hDialog, WM_COMMAND, ID_CHKTASKBAR, 0);
                SendMessage(hDialog, WM_COMMAND, ID_CHKTASKBAR, 0);
                if (icSettings.bAlwaysHide)
                    SendMessage(hDialog, WM_COMMAND, ID_CHKALWAYSHIDE, 0);
                else
                    if (icSettings.bAutoHide)
                        SendMessage(hDialog, WM_COMMAND, ID_CHKAUTOHIDE, 0);
                    else
                        SendMessage(hDialog, WM_COMMAND, ID_CHKNEVERHIDE, 0);
                TrayWarningShown = oldTrayWarningShown;
                SetHotKeys();
            } 
            else
                MessageBox(hDialog,                        //
                    "The fileextension must be \".reg\".\n" //
                    "Settings were not saved.", szTitle, MB_OK|MB_ICONEXCLAMATION);
        } 
        else
            SetWindowText(ItemHWnd(IDC_STATUSBAR), "Settings not imported");
    } 
    else                                                   // Export
    {
        ofn.lpstrTitle = "Export Iconoid Settings";
        if (GetSaveFileName(&ofn))
        {
            if (0 == (ofn.Flags&OFN_EXTENSIONDIFFERENT))
            {
                wsprintf(buffer, "/e \"%s\" HKEY_CURRENT_USER\\Software\\SillySot", filename);
                ShExecInfo.lpFile = command;
                ShExecInfo.lpParameters = buffer;
                ShellExecuteEx(&ShExecInfo);
                WaitForSingleObject(ShExecInfo.hProcess, INFINITE);
                wsprintf(buffer, "Saved to %s", fileonly);
                SetWindowText(ItemHWnd(IDC_STATUSBAR), buffer);
            } 
            else
                MessageBox(hDialog, "The extension must be \".reg\".\nSettings were not imported.", szTitle, MB_OK|MB_ICONEXCLAMATION);
        } 
        else
            SetWindowText(ItemHWnd(IDC_STATUSBAR), "Settings not saved");
    } 
    EnableWindow(hDialog, TRUE);
    SetWindowPos(hDialog, HWND_TOP, 0, 0, 0, 0, SWP_NOMOVE|SWP_NOSIZE|SWP_SHOWWINDOW);
    SetActiveWindow(hDialog);
} 

HANDLE        hProcess;
unsigned int  v_size = 0;
LPVOID valloc(unsigned int size)
{
    v_size = size;
    LPVOID        addr = VirtualAlloc(NULL, size, MEM_RESERVE|MEM_COMMIT, PAGE_READWRITE);

    if (!addr)
        ProcessLastErr();
    return  addr;
} 

VOID vfree(LPVOID ptr)
{
    VirtualFree(ptr, 0, MEM_RELEASE);
    v_size = 0;
} 

unsigned int v_msize(LPVOID x)
{
    return  v_size;
} 
