#include "stdafx.h"
#include "windows.h"
#include "tr3.h"
INT_PTR CALLBACK KeysWndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
    static HWND   hShowHideEditBox,hRefreshEditBox,hCycleEditBox,hPositionEditBox;
    static BOOL   Alt,Ctrl,Shift;
    static HBRUSH hBrush = 0;
    static UINT   KeyValues[4];
    static UINT   KeyOn[4];
    HFONT         hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
    POINT         ptCursor;
    RECT          rectWinPos,rect;
    TEXTMETRIC    tm;

    switch (message)
    {
        case  WM_INITDIALOG :
            HDC           hdc;
          
            hdc = GetDC(hWnd);
            GetTextMetrics(hdc, &tm);
            ReleaseDC(hWnd, hdc);
            INT           iLeft;
            RECT          rectThis;
            RECT          rectParent;
          
            KeyOn[0] = icSettings.bShowHideKey;
            KeyOn[1] = icSettings.bRefreshKey;
            KeyOn[2] = icSettings.bCycleKey;
            KeyOn[3] = icSettings.bPositionKey;
            GetWindowRect(hWnd, &rect);
            GetWindowRect(GetDlgItem(hWnd, ID_CHKREFRESH), &rectWinPos);
            OffsetRect(&rectWinPos, -rect.left, -rect.top);
            iLeft = rectWinPos.right;
            hRefreshEditBox = CreateWindowEx(0,            // no extended styles
                HOTKEY_CLASS,                              // class name
                "",                                        // no title (caption)
                WS_CHILD|WS_VISIBLE|WS_TABSTOP,            // style
                iLeft, rectWinPos.top-4-GetSystemMetrics(SM_CXSIZE),  // position
                tm.tmAveCharWidth *18, tm.tmHeight+2,      // size
                hWnd,                                      // parent window
                NULL,                                      // uses class menu
                hInst,                                     // instance
                NULL                                       // no WM_CREATE parameter
                );
          
            GetWindowRect(GetDlgItem(hWnd, ID_CHKSHOWHIDE), &rectWinPos);
            OffsetRect(&rectWinPos, -rect.left, -rect.top);
            hShowHideEditBox = CreateWindowEx(0,           // no extended styles
                HOTKEY_CLASS,                              // class name
                "",                                        // no title (caption)
                WS_CHILD|WS_VISIBLE|WS_TABSTOP,            //
                iLeft, rectWinPos.top-4-GetSystemMetrics(SM_CXSIZE),  // position
                tm.tmAveCharWidth *18, tm.tmHeight+2,      // size
                hWnd,                                      // parent window
                NULL,                                      // uses class menu
                hInst,                                     // instance
                NULL                                       // no WM_CREATE parameter
                );
          
            GetWindowRect(GetDlgItem(hWnd, ID_CHECKCYCLE), &rectWinPos);
            OffsetRect(&rectWinPos, -rect.left, -rect.top);
            hCycleEditBox = CreateWindowEx(0,              // no extended styles
                HOTKEY_CLASS,                              // class name
                "",                                        // no title (caption)
                WS_CHILD|WS_VISIBLE|WS_TABSTOP,            // style
                iLeft, rectWinPos.top-4-GetSystemMetrics(SM_CXSIZE),  // position
                tm.tmAveCharWidth *18, tm.tmHeight+2,      // size
                hWnd,                                      // parent window
                NULL,                                      // uses class menu
                hInst,                                     // instance
                NULL                                       // no WM_CREATE parameter
                );
          
            GetWindowRect(GetDlgItem(hWnd, ID_CHECKPOSITION), &rectWinPos);
            OffsetRect(&rectWinPos, -rect.left, -rect.top);
            hPositionEditBox = CreateWindowEx(0,           // no extended styles
                HOTKEY_CLASS,                              // class name
                "",                                        // no title (caption)
                WS_CHILD|WS_VISIBLE|WS_TABSTOP,            // style
                iLeft, rectWinPos.top-4-GetSystemMetrics(SM_CXSIZE),  // position
                tm.tmAveCharWidth *18, tm.tmHeight+2,      // size
                hWnd,                                      // parent window
                NULL,                                      // uses class menu
                hInst,                                     // instance
                NULL                                       // no WM_CREATE parameter
                );
          
            SetWindowPos(hShowHideEditBox, GetDlgItem(hWnd, ID_CHKSHOWHIDE), 0, 0, 0, 0, SWP_NOMOVE|SWP_NOSIZE);
            SetWindowPos(hRefreshEditBox, GetDlgItem(hWnd, ID_CHKREFRESH), 0, 0, 0, 0, SWP_NOMOVE|SWP_NOSIZE);
            SetWindowPos(hCycleEditBox, GetDlgItem(hWnd, ID_CHECKCYCLE), 0, 0, 0, 0, SWP_NOMOVE|SWP_NOSIZE);
            SetWindowPos(hPositionEditBox, GetDlgItem(hWnd, ID_CHECKPOSITION), 0, 0, 0, 0, SWP_NOMOVE|SWP_NOSIZE);
            SendMessage(hShowHideEditBox, HKM_SETRULES, (WPARAM)HKCOMB_NONE|HKCOMB_S,  // invalid key combinations
                MAKELPARAM(HOTKEYF_ALT, 0));               // add ALT to invalid entries
            SendMessage(hRefreshEditBox, HKM_SETRULES, (WPARAM)HKCOMB_NONE|HKCOMB_S,  // invalid key combinations
                MAKELPARAM(HOTKEYF_ALT, 0));               // add ALT to invalid entries
            SendMessage(hCycleEditBox, HKM_SETRULES, (WPARAM)HKCOMB_NONE|HKCOMB_S,  // invalid key combinations
                MAKELPARAM(HOTKEYF_ALT, 0));               // add ALT to invalid entries
            SendMessage(hPositionEditBox, HKM_SETRULES, (WPARAM)HKCOMB_NONE|HKCOMB_S,  // invalid key combinations
                MAKELPARAM(HOTKEYF_ALT, 0));               // add ALT to invalid entries
            SendMessage(hShowHideEditBox, HKM_SETHOTKEY, icSettings.iShowHideKey, 0);
            SendMessage(hRefreshEditBox, HKM_SETHOTKEY, icSettings.iRefreshKey, 0);
            SendMessage(hCycleEditBox, HKM_SETHOTKEY, icSettings.iCycleKey, 0);
            SendMessage(hPositionEditBox, HKM_SETHOTKEY, icSettings.iPositionKey, 0);
            SendMessage(hShowHideEditBox, WM_SETFONT, (WPARAM)hFont, 0);
            SendMessage(hRefreshEditBox, WM_SETFONT, (WPARAM)hFont, 0);
            SendMessage(hCycleEditBox, WM_SETFONT, (WPARAM)hFont, 0);
            SendMessage(hPositionEditBox, WM_SETFONT, (WPARAM)hFont, 0);
            CheckDlgButton(hWnd, ID_CHKSHOWHIDE, KeyOn[0]?BST_CHECKED:BST_UNCHECKED);
            CheckDlgButton(hWnd, ID_CHKREFRESH, KeyOn[1]?BST_CHECKED:BST_UNCHECKED);
            CheckDlgButton(hWnd, ID_CHECKCYCLE, KeyOn[2]?BST_CHECKED:BST_UNCHECKED);
            CheckDlgButton(hWnd, ID_CHECKPOSITION, KeyOn[3]?BST_CHECKED:BST_UNCHECKED);
            EnableWindow(GetDlgItem(hWnd, ID_CHKSHOWHIDE), icSettings.bTrayIcon);
            EnableWindow(hShowHideEditBox, KeyOn[0] || !icSettings.bTrayIcon);
            EnableWindow(hRefreshEditBox, KeyOn[1]);
            EnableWindow(hCycleEditBox, KeyOn[2]);
            EnableWindow(hPositionEditBox, KeyOn[3]);
            GetWindowRect(hWnd, &rectThis);
            GetWindowRect(hDialog, &rectParent);
            if (rectParent.right < GetSystemMetrics(SM_CXSCREEN)-(rectThis.right-rectThis.left)-15)
            {
                OffsetRect(&rectThis, rectParent.right-rectThis.left, rectParent.top-rectThis.top);
                MoveWindow(hWnd, rectThis.left, rectThis.top, rectThis.right-rectThis.left, rectThis.bottom-rectThis.top, TRUE);
            } 
            else
                if (rectParent.left > (rectThis.right-rectThis.left)+15)
                {
                    OffsetRect(&rectThis, rectParent.left-(rectThis.right-rectThis.left)-rectThis.left, rectParent.top-rectThis.top);
                    MoveWindow(hWnd, rectThis.left, rectThis.top, rectThis.right-rectThis.left, rectThis.bottom-rectThis.top, TRUE);
                } 
            ShowWindow(hWnd, SW_SHOW);
            SetFocus(hPositionEditBox);                    // focus to 1st available field if any
            SetFocus(hCycleEditBox);                       // focus to 1st available field if any
            SetFocus(hRefreshEditBox);                     // focus to 1st available field if any
            SetFocus(hShowHideEditBox);
                        // kludge below is because cursor is hourglass if dialog pops up
                        // with the cursor in one of the hotkey controls.
            GetCursorPos(&ptCursor);
            GetWindowRect(hShowHideEditBox, &rectWinPos);
            if (PtInRect(&rectWinPos, ptCursor))
                SetCursorPos(rectWinPos.right, rectWinPos.bottom);
            else
            {
                GetWindowRect(hRefreshEditBox, &rectWinPos);
                if (PtInRect(&rectWinPos, ptCursor))
                    SetCursorPos(rectWinPos.right, rectWinPos.bottom);
                else
                {
                    GetWindowRect(hCycleEditBox, &rectWinPos);
                    if (PtInRect(&rectWinPos, ptCursor))
                        SetCursorPos(rectWinPos.right, rectWinPos.bottom);
                    else
                    {
                        GetWindowRect(hPositionEditBox, &rectWinPos);
                        if (PtInRect(&rectWinPos, ptCursor))
                            SetCursorPos(rectWinPos.right, rectWinPos.bottom);
                    } 
                } 

            } 
            return 0;
            break;
        case  WM_COMMAND :
            switch (wParam)
            {
                case  ID_CHKSHOWHIDE :
                    KeyOn[0] = IsDlgButtonChecked(hWnd, ID_CHKSHOWHIDE);
                    EnableWindow(hShowHideEditBox, KeyOn[0] || !icSettings.bTrayIcon);
                    if (!KeyOn[0])
                    {
                        if (!icSettings.bTrayIcon)
                            SendMessage(hDialog, WM_COMMAND, ID_CHKTASKBAR, 0);
                        EnableWindow(ItemHWnd(ID_CHKTASKBAR), TRUE);
                    } 
                    SetFocus(hShowHideEditBox);
                    return  TRUE;

                case  ID_CHKREFRESH :
                    KeyOn[1] = IsDlgButtonChecked(hWnd, ID_CHKREFRESH);
                    EnableWindow(hRefreshEditBox, KeyOn[1]);
                    SetFocus(hRefreshEditBox);
                    return  TRUE;

                case  ID_CHECKCYCLE :
                    KeyOn[2] = IsDlgButtonChecked(hWnd, ID_CHECKCYCLE);
                    EnableWindow(hCycleEditBox, KeyOn[2]);
                    SetFocus(hCycleEditBox);
                    return  TRUE;

                case  ID_CHECKPOSITION :
                    KeyOn[3] = IsDlgButtonChecked(hWnd, ID_CHECKPOSITION);
                    EnableWindow(hPositionEditBox, KeyOn[3]);
                    SetFocus(hPositionEditBox);
                    return  TRUE;

                case  ID_HOTDEF :
                    KeyOn[0] = icDefaults.bShowHideKey;
                    KeyOn[1] = icDefaults.bRefreshKey;
                    KeyOn[2] = icDefaults.bCycleKey;
                    KeyOn[3] = icDefaults.bPositionKey;
                    SendMessage(hShowHideEditBox, HKM_SETHOTKEY, icDefaults.iShowHideKey, 0);
                    SendMessage(hRefreshEditBox, HKM_SETHOTKEY, icDefaults.iRefreshKey, 0);
                    SendMessage(hCycleEditBox, HKM_SETHOTKEY, icDefaults.iCycleKey, 0);
                    SendMessage(hPositionEditBox, HKM_SETHOTKEY, icDefaults.iPositionKey, 0);
                    CheckDlgButton(hWnd, ID_CHKSHOWHIDE, KeyOn[0]?BST_CHECKED:BST_UNCHECKED);
                    CheckDlgButton(hWnd, ID_CHKREFRESH, KeyOn[1]?BST_CHECKED:BST_UNCHECKED);
                    CheckDlgButton(hWnd, ID_CHECKCYCLE, KeyOn[2]?BST_CHECKED:BST_UNCHECKED);
                    CheckDlgButton(hWnd, ID_CHECKPOSITION, KeyOn[3]?BST_CHECKED:BST_UNCHECKED);
                    EnableWindow(hShowHideEditBox, KeyOn[0] || !icSettings.bTrayIcon);
                    EnableWindow(hRefreshEditBox, KeyOn[1]);
                    EnableWindow(hCycleEditBox, KeyOn[2]);
                    EnableWindow(hPositionEditBox, KeyOn[3]);
                    SetFocus(hPositionEditBox);            // focus to 1st available field if any
                    SetFocus(hCycleEditBox);               // focus to 1st available field if any
                    SetFocus(hRefreshEditBox);             // focus to 1st available field if any
                    SetFocus(hShowHideEditBox);
                    return  TRUE;

                case  IDCANCEL :
                    EndDialog(hWnd, 0);
                    return  TRUE;

                case  IDOK :
                                // Set Keys here
                    if (FALSE == icSettings.bTrayIcon      //
                        && (0 == KeyOn[0] || !SendMessage(hShowHideEditBox, HKM_GETHOTKEY, 0, 0)))
                    {
                        MessageBox(hWnd, "You have disabled the icon in the system tray.""\nYou must specify a Show/Hide hot key.", szTitle,
                            MB_APPLMODAL|MB_ICONASTERISK);
                        SetFocus(hShowHideEditBox);
                    } 
                    else
                    {
                        icSettings.bShowHideKey = KeyOn[0];
                        icSettings.bRefreshKey = KeyOn[1];
                        icSettings.bCycleKey = KeyOn[2];
                        icSettings.bPositionKey = KeyOn[3];
                        icSettings.iShowHideKey = SendMessage(hShowHideEditBox, HKM_GETHOTKEY, 0, 0);
                        icSettings.iRefreshKey = SendMessage(hRefreshEditBox, HKM_GETHOTKEY, 0, 0);
                        icSettings.iCycleKey = SendMessage(hCycleEditBox, HKM_GETHOTKEY, 0, 0);
                        icSettings.iPositionKey = SendMessage(hPositionEditBox, HKM_GETHOTKEY, 0, 0);
                        EndDialog(hWnd, 1);
                    } 
                    return  TRUE;

                default  :
                    {
                        LONG          id = LOWORD(wParam);

                        switch (HIWORD(wParam))
                        {
                            case  EN_SETFOCUS :
//                                SendDlgItemMessage(hWnd, id, WM_SETTEXT, 0, (LPARAM)"Focus");
//                                return 0;
//                                break;
                            case  EN_KILLFOCUS :
           //SendDlgItemMessage(hWnd, id, WM_SETTEXT, 0, (LPARAM)"Not Focus");
                                InvalidateRect(GetDlgItem(hWnd, id), 0, TRUE);
                                return 0;
                        } 
                    } 
            } 
    } 
    return  FALSE;
} 

BOOL SetHotKeys()
{
    UINT          uVKey,uCode;
    int           iModifierKeys;
    TCHAR         szMsg[200],szKey[40];

    SendMessage(hDialog, WM_COMMAND, ID_HOTKEYSET, 0);
    BOOL          bNeedTrayIcon = FALSE;

    bHotKeyIsActive = FALSE;
    if (icSettings.bShowHideKey && 0 != icSettings.iShowHideKey)
    {
        uCode = ((UINT)icSettings.iShowHideKey&0x0000FF00) >> 8;
        uVKey = (UINT)icSettings.iShowHideKey&255;
        iModifierKeys =                                    //
            ((uCode&HOTKEYF_CONTROL)?MOD_CONTROL:0)        //
                |((uCode&HOTKEYF_ALT)?MOD_ALT:0)           //
                    |((uCode&HOTKEYF_SHIFT)?MOD_SHIFT:0);
        if (!RegisterHotKey(hDialog, 0xBFFF,               //
            iModifierKeys,                                 //
            uVKey))                                        // ctrl-shift-A Default
        {
 //           ProcessLastErr();
            InterpretHotKey((UINT)icSettings.iShowHideKey, szKey);
            wsprintf(szMsg, "Unable to register %s as a hot key.""\n\nAnother program may be using %s."
                "\n\nYou do not have an active  \"Show/Hide\" hot key""\nso the Tray Icon has been enabled.", szKey, szKey);
            ConditionalMessageBox(hDialog, szMsg, szTitle, MB_APPLMODAL|MB_ICONHAND);
            bNeedTrayIcon = TRUE;
        } 
        else
            bHotKeyIsActive = TRUE;
    } 
    else
    {
        bNeedTrayIcon = TRUE;
    } 
    if (bNeedTrayIcon)
    {
        if (!icSettings.bTrayIcon)
            SendMessage(hDialog, WM_COMMAND, ID_CHKTASKBAR, 0);
//        EnableWindow(ItemHWnd(ID_CHKTASKBAR), FALSE);
    } 
        // now do the 2nd hot key
    if (icSettings.bRefreshKey && 0 != icSettings.iRefreshKey)
    {
        uCode = ((UINT)icSettings.iRefreshKey&0x0000FF00) >> 8;
        uVKey = (UINT)icSettings.iRefreshKey&255;
        iModifierKeys =                                    //
            ((uCode&HOTKEYF_CONTROL)?MOD_CONTROL:0)        //
                |((uCode&HOTKEYF_ALT)?MOD_ALT:0)           //
                    |((uCode&HOTKEYF_SHIFT)?MOD_SHIFT:0);
        if (!RegisterHotKey(hDialog, 0xBFFE,               //
            iModifierKeys,                                 //
            uVKey))                                        // ctrl-F5 Default
        {
            InterpretHotKey((UINT)icSettings.iRefreshKey, szKey);
            wsprintf(szMsg, "Unable to register %s as a hot key.""\nAnother program may be using %s."
                "\n\nYou do not have an active  \"Show Icons\" hot key.", szKey, szKey);
            ConditionalMessageBox(hDialog, szMsg, szTitle, MB_APPLMODAL|MB_ICONHAND);
        } 
    } 
        // now do the 3rd hot key
    if (icSettings.bCycleKey && 0 != icSettings.iCycleKey)
    {
        uCode = ((UINT)icSettings.iCycleKey&0x0000FF00) >> 8;
        uVKey = (UINT)icSettings.iCycleKey&255;
        iModifierKeys =                                    //
            ((uCode&HOTKEYF_CONTROL)?MOD_CONTROL:0)        //
                |((uCode&HOTKEYF_ALT)?MOD_ALT:0)           //
                    |((uCode&HOTKEYF_SHIFT)?MOD_SHIFT:0);
        if (!RegisterHotKey(hDialog, 0xBFFD,               //
            iModifierKeys,                                 //
            uVKey))                                        // Alt-X Default
        {
            InterpretHotKey((UINT)icSettings.iCycleKey, szKey);
            wsprintf(szMsg, "Unable to register %s as a hot key.""\nAnother program may be using %s."
                "\n\nYou do not have an active  \"Cycle Layout\" hot key.", szKey, szKey);
            ConditionalMessageBox(hDialog, szMsg, szTitle, MB_APPLMODAL|MB_ICONHAND);
        } 
    } 
        // now do the 4thd hot key
    if (icSettings.bPositionKey && 0 != icSettings.iPositionKey)
    {
        uCode = ((UINT)icSettings.iPositionKey&0x0000FF00) >> 8;
        uVKey = (UINT)icSettings.iPositionKey&255;
        iModifierKeys =                                    //
            ((uCode&HOTKEYF_CONTROL)?MOD_CONTROL:0)        //
                |((uCode&HOTKEYF_ALT)?MOD_ALT:0)           //
                    |((uCode&HOTKEYF_SHIFT)?MOD_SHIFT:0);
        if (!RegisterHotKey(hDialog, 0xBFFC,               //
            iModifierKeys,                                 //
            uVKey))                                        // ctrl-alt-Z Default
        {
            InterpretHotKey((UINT)icSettings.iPositionKey, szKey);
            wsprintf(szMsg, "Unable to register %s as a hot key.""\nAnother program may be using %s."
                "\n\nYou do not have an active  \"Position\" hot key.", szKey, szKey);
            ConditionalMessageBox(hDialog, szMsg, szTitle, MB_APPLMODAL|MB_ICONHAND);
        } 
    } 
    return  TRUE;
} 

void InterpretHotKey(UINT setting,TCHAR *szKeyName)
{
    BOOL          Ctrl,Alt,Shift;
    UINT          WorkKey,uCode,uVKey;

    uCode = (setting&0x0000FF00) >> 8;
    uVKey = setting&255;
    *szKeyName = 0;
    Ctrl = uCode&HOTKEYF_CONTROL;
    Alt = uCode&HOTKEYF_ALT;
    Shift = uCode&HOTKEYF_SHIFT;
    strcat(szKeyName, Ctrl?"Ctrl + ":"");
    strcat(szKeyName, Alt?"Alt + ":"");
    strcat(szKeyName, Shift?"Shift + ":"");
    WorkKey = MapVirtualKey(uVKey, 0);
    if (uCode&0x00000008)                                  // extended key
        WorkKey = 0x03000000|(WorkKey << 16);
    else
        WorkKey = 0x02000000|(WorkKey << 16);
    GetKeyNameText(WorkKey, szKeyName+strlen(szKeyName), 100);
} 
