#include "StdAfx.h"
#include <stdio.h>     
#include <mmsystem.h>
#include "tr3.h"
#define  MaxWidth      5
RGBTRIPLE *pBMPdata = NULL;
DWORD         oldSysColor = GetSysColor(COLOR_DESKTOP);
TCHAR         szBMPfile[MAX_PATH+31] = "";
void AddPixel(RGBQUAD rgbQuad);
int           wptime = 5;
CHAR          szLastBitmapDirectory[MAX_PATH] = "";
CHAR          szCurrentBitmapDirectory[MAX_PATH] = "";
HBITMAP ReadWallPaper()
{
    HBITMAP       hbmp = NULL;
    BITMAP        bmpx;
          
    GetCurrentWallpaper(szWallPaper);
    wpUseCount++;
    SetTimer(hDialog, 29, 500, 0);
    hbmp = (HBITMAP)LoadImage(hInst, szWallPaper, IMAGE_BITMAP, 0, 0, LR_LOADFROMFILE);
    if (!hbmp)
        ProcessLastErr();
    else
    {
        if (GetObject(hbmp, sizeof(BITMAP), (LPSTR)&bmpx))
        {
            int           a = (bmpx.bmWidth+3)&~3;
          
            if (v_msize(NULL) < a *bmpx.bmHeight *sizeof(RGBTRIPLE))
            {
                if (rgbBMPArray)
                    vfree(rgbBMPArray);
                rgbBMPArray = (RGBTRIPLE *)valloc(a *bmpx.bmHeight *sizeof(RGBTRIPLE));
                HDC           hdc = GetDC(0);

                ZeroMemory(&bmi, sizeof(bmi));
                bmi.bmiHeader.biSize = sizeof BITMAPINFOHEADER;
                bmi.bmiHeader.biWidth = bmpx.bmWidth;
                bmi.bmiHeader.biHeight = bmpx.bmHeight;
                bmi.bmiHeader.biPlanes = 1;
                bmi.bmiHeader.biBitCount = 24;
                bmi.bmiHeader.biCompression = BI_RGB;
                GetDIBits(hdc, hbmp, 0, bmpx.bmHeight, rgbBMPArray, &bmi, DIB_RGB_COLORS);
                ReleaseDC(0, hdc);
            } 
        } 
        else
            ProcessLastErr();
    } 
    return  hbmp;
} 

void CreateBMPFile(LPTSTR pszFile,HBITMAP hBMP,HDC hDC);
// SetWindowBackgroundColor reads the bitmap file that was used to
// the desktop background if one is in use. If the bitmap is BI_RGB
// (device independent, no compression), it evaluates the bitmap and
// sets colors accordingly.
////////////////////////////////////////////////////////////////////////////////////
// MarkBorderPixels  - determine boundaries of image within borders
////////////////////////////////////////////////////////////////////////////////////

void MarkBorderPixels(int& top,int& bottom,int& left,int& right,RGBTRIPLE *rgbBMPArray,LONG bmpWidth,LONG bmpHeight)
{
        // 0: Not checked
        // 1: Part of Border
        // 2: Checked and not part of border
    int           r,c;
    RGBTRIPLE     *pixel;
    int           scanwidth = (3+bmi.bmiHeader.biWidth *3)&~3;
          
    top = bottom = left = right = -1;
//
    for (r = 0; r < bmpHeight && bottom == -1; r++)
    {
        pixel = (RGBTRIPLE *)(((BYTE *)rgbBMPArray)+(r *scanwidth));
        for (c = 0; c < bmpWidth && bottom == -1; c++)
        {
            if ((64 < abs((int)pixel->rgbtRed-(int)(*rgbBMPArray).rgbtRed)) //
                || (64 < abs((int)pixel->rgbtGreen-(int)(*rgbBMPArray).rgbtGreen)) //
                || (64 < abs((int)pixel->rgbtBlue-(int)(*rgbBMPArray).rgbtBlue)) //
                )
                bottom = r;
            pixel++;
        } 
    } 
//
    for (r = bmpHeight-1; r >= 0 && top == -1; r--)
    {
        pixel = (RGBTRIPLE *)(((BYTE *)rgbBMPArray)+(r *scanwidth));
        for (c = 0; c < bmpWidth && top == -1; c++)
        {
            if ((64 < abs((int)pixel->rgbtRed-(int)(*rgbBMPArray).rgbtRed)) //
                || (64 < abs((int)pixel->rgbtGreen-(int)(*rgbBMPArray).rgbtGreen)) //
                || (64 < abs((int)pixel->rgbtBlue-(int)(*rgbBMPArray).rgbtBlue)) //
                )
                top = r;
            pixel++;
        } 
    } 
//
    for (c = 0; c < bmpWidth && left == -1; c++)
        for (r = bottom+1; r < top && left == -1; r++)
        {
            pixel = (RGBTRIPLE *)(((BYTE *)rgbBMPArray)+(r *scanwidth+c *3));
            if ((64 < abs((int)pixel->rgbtRed-(int)(*rgbBMPArray).rgbtRed)) //
                || (64 < abs((int)pixel->rgbtGreen-(int)(*rgbBMPArray).rgbtGreen)) //
                || (64 < abs((int)pixel->rgbtBlue-(int)(*rgbBMPArray).rgbtBlue)) //
                )
                left = c;
        } 
//
    for (c = bmpWidth-1; c >= 0 && right == -1; c--)
        for (r = bottom+1; r < top && right == -1; r++)
        {
            pixel = (RGBTRIPLE *)(((BYTE *)rgbBMPArray)+(r *scanwidth+c *3));
            if ((64 < abs((int)pixel->rgbtRed-(int)(*rgbBMPArray).rgbtRed)) //
                || (64 < abs((int)pixel->rgbtGreen-(int)(*rgbBMPArray).rgbtGreen)) //
                || (64 < abs((int)pixel->rgbtBlue-(int)(*rgbBMPArray).rgbtBlue)) //
                )
                right = c;
        } 
//
    if (top == -1 || bottom == -1 || left == -1 || right == -1)
    {                                                      // no border - set to outside dimentions
        top = bmpHeight-1;
        bottom = 0;
        left = 0;
        right = bmpWidth-1;
    } 
//    wsprintf(szDebug, "top:%d, bottom:%d,  left:%d,  right:%d", top, bottom, left, right);
//    SetWindowText(ItemHWnd(IDC_STATUSBAR), szDebug);
//    InvalidateRect(ItemHWnd(IDC_STATUSBAR), 0, TRUE);
} 

////////////////////////////////////////////////////////////////////////////////////
// SetWindowBackgroundColor (call calculate, and use result)
////////////////////////////////////////////////////////////////////////////////////

void SetWindowBackgroundColor()
{
    COLORREF      crBackground;
//      static CHAR szPrevWallPaper[MAX_PATH] = "";
    static ULONG  nexttime = 0;

    if (icSettings.bSetDesk)
    {
        BOOL          bWPCovers;                           // true will mean that wallpaper bmp smaller than screen
          
        crBackground = CalculateWindowBackgroundColor(icSettings.bIgnoreBorder, &bWPCovers);
        if (crBackground != (COLORREF)-1)                  // && !bWPCovers)
        {
            SetDesktopBackgroundColor(crBackground);
            oldSysColor = GetSysColor(COLOR_DESKTOP);
        } 
    } 
} 

////////////////////////////////////////////////////////////////////////////////////
// CalculateWindowBackgroundColor
////////////////////////////////////////////////////////////////////////////////////

COLORREF CalculateWindowBackgroundColor(BOOL bRemoveBorder,BOOL *bWPCovers)
{
    COLORREF      crBackground;
    ULONG         iRed = 0;
    ULONG         iGreen = 0;
    ULONG         iBlue = 0;

    ULONG         Width,Height;
    BOOL          bBorder = TRUE;
    ULONG         iSampleSize = 0;
    int           top,bottom,right,left;
    RGBTRIPLE     *pixel;
    int           scanwidth;
    BOOL          bDoSides;
    BOOL          bDoTopBottom;

    if (icSettings.bNormalize)
    {
        FLOAT         BMPratio = ((FLOAT)bmi.bmiHeader.biWidth)/(FLOAT)bmi.bmiHeader.biHeight;
        FLOAT         ScreenRatio = ((FLOAT)GetSystemMetrics(SM_CXSCREEN))/(FLOAT)GetSystemMetrics(SM_CYSCREEN);
          
        bDoSides = BMPratio <= ScreenRatio;
        bDoTopBottom = BMPratio >= ScreenRatio;
    } 
    else
        bDoSides = bDoTopBottom = TRUE;
  //  Var2(bDoSides, bDoTopBottom);
    *bWPCovers = FALSE;                                    // assume walpaper does not cover screen
    crBackground = (COLORREF)-1;
    if (rgbBMPArray && bmi.bmiHeader.biWidth != 0)
    {
        Height = bmi.bmiHeader.biHeight;
        Width = bmi.bmiHeader.biWidth;

        *bWPCovers = ((GetSystemMetrics(SM_CXSCREEN) <= (int)Width) //
            && (GetSystemMetrics(SM_CYSCREEN) <= (int)Height) && !icSettings.bNormalize);
        if (!*bWPCovers)
        {
//                      Var(RegReadDWord("Control Panel\\Desktop", "TileWallpaper"));
            *bWPCovers = (RegReadDWord("Control Panel\\Desktop", "TileWallpaper") == 49) || ((RegReadDWord("Control Panel\\Desktop", 
                "WallpaperStyle") == 50) && icSettings.bNormalize);
        } 
        MarkBorderPixels(top, bottom, left, right, rgbBMPArray, Width, Height);
        bBorder = (top != (LONG)Height-1 && bottom != 0 && left != 0 && right != (LONG)Width-1);
        iRed = iGreen = iBlue = iSampleSize = 0;
        if ((bBorder && bRemoveBorder) || !bBorder)
        {
            if (!icSettings.bIgnoreBorder)
            {
                left = 0;
                right = Width-1;
                top = Height-1;
                bottom = 0;
            } 

            int           r,c;
            int           minLeft = left+MaxWidth;
            int           maxRight = right-MaxWidth;
            int           maxTop = top-MaxWidth;
            int           minBottom = bottom+MaxWidth;
//          Var2(left,right);
          
            scanwidth = (3+bmi.bmiHeader.biWidth *3)&~3;
            for (r = bottom; r <= top; r++)
            {
                int           offset = r *scanwidth+left *3;
          
                for (c = left; c <= right; c++)
                {
                //    int           offset = r *scanwidth+c *3;
                    if (icSettings.bSampWhole              //
                        || (                               //
                        (bDoSides && (c < minLeft || c > maxRight)) //
                        || (bDoTopBottom && (r < minBottom || r > maxTop)) //
                        ))
                    {
                        pixel = (RGBTRIPLE *)(((BYTE *)rgbBMPArray)+offset);
                        iRed += pixel->rgbtRed;
                        iGreen += pixel->rgbtGreen;
                        iBlue += pixel->rgbtBlue;
                        iSampleSize++;
                    } 
                    offset += 3;
                } 
            } 
        } 
        if (!iSampleSize)
        {
            iRed = rgbBMPArray[0].rgbtRed;
            iGreen = rgbBMPArray[0].rgbtGreen;
            iBlue = rgbBMPArray[0].rgbtBlue;
        } 
        else
        {
            iRed /= iSampleSize;
            iGreen /= iSampleSize;
            iBlue /= iSampleSize;
        } 
        if (!icSettings.bCompliment)
            crBackground = RGB(iRed, iGreen, iBlue);
        else
            crBackground = RGB(255-iRed, 255-iGreen, 255-iBlue);
    } 
    return  crBackground;
} 

void GetCurrentWallpaper(CHAR *sDataRet)
{
    *sDataRet = 0;
    SystemParametersInfo(SPI_GETDESKWALLPAPER, MAX_PATH, sDataRet, 0); // W2K and up
    if (!*sDataRet)                                        // Win9x
    {
        ULONG         dwDataSize;
        HKEY          hKey;
        TCHAR         sKeyName[23] = "Control Panel\\Desktop";
        TCHAR         sValue[60] = "Wallpaper";
        DWORD         dwType = REG_SZ;

        hKey = 0;
        RegOpenKeyEx(HKEY_CURRENT_USER, sKeyName, NULL, KEY_ALL_ACCESS, &hKey);
        if (hKey)
        {
            if (!RegQueryValueEx(hKey, sValue, NULL, &dwType, NULL, &dwDataSize))
            {
                RegQueryValueEx(hKey, sValue, NULL, &dwType, (BYTE *)sDataRet, &dwDataSize);
            } 
            RegCloseKey(hKey);
        } 
    } 
} 

DWORD WINAPI ScaleWallpaper(LPVOID lpBMP) // This is only going to work with single monitor - but the background is duplicated to others anyway rather than stretched across all
{
    HBITMAP       hOrigBMP = *((HBITMAP *)lpBMP);
    HBITMAP       hScaledBMP;
    static BOOL   inuse = FALSE;
    static int    wait = 0;                                // don't lose any requests, just do them consecutively

    if (!inuse)
    {
        inuse = TRUE;
        do
        {
            wait = 0;
            if (!hOrigBMP)
            {
                GetCurrentWallpaper(szWallPaper);
                hOrigBMP = (HBITMAP)LoadImage(hInst, szWallPaper, IMAGE_BITMAP, 0, 0, LR_LOADFROMFILE);
            } 
            if (hOrigBMP)
            {
                //HLOCAL        pbmi = NULL;
                BITMAP        bmp;
                SIZE          sz;
                                // Retrieve the bitmap color format, width, and height.
          
                GetObject(hOrigBMP, sizeof(BITMAP), (LPSTR)&bmp);
                CalculateWallpaperScaling(bmp, GetSystemMetrics(SM_CXSCREEN), GetSystemMetrics(SM_CYSCREEN), &sz);
                                //*************************
                HDC           hdcScreen = GetDC(0);
                HDC           hdcSource = CreateCompatibleDC(hdcScreen);
                HDC           hdcScaled = CreateCompatibleDC(hdcScreen);
          
                SetStretchBltMode(hdcScaled, HALFTONE);
                hScaledBMP = CreateCompatibleBitmap(hdcScreen, sz.cx, sz.cy);
                SelectObject(hdcSource, hOrigBMP);
                SelectObject(hdcScaled, hScaledBMP);
                StretchBlt(hdcScaled, 0, 0, sz.cx, sz.cy, hdcSource, 0, 0, bmp.bmWidth, bmp.bmHeight, SRCCOPY);
                if (!lpBMP)
                    DeleteObject(hOrigBMP);
                DeleteDC(hdcSource);
                CreateBMPFile(szBMPfile, hScaledBMP, hdcScaled);
                                //--------------------------
                CHAR          szStyle[2] = "";
                CHAR          szWallPaper[MAX_PATH+1] = "";
                CHAR          szSaveName[MAX_PATH+1] = "";
                WIN32_FIND_DATA FindFileData;
          
                GetCurrentWallpaper(szWallPaper);
                strcpy(szSaveName, szWallPaper);
                strcat(szSaveName, "X");
                HANDLE        hFind = FindFirstFile(szWallPaper, &FindFileData);
          
                if (hFind != INVALID_HANDLE_VALUE)
                {
                    if (FindFileData.dwFileAttributes&FILE_ATTRIBUTE_READONLY)
                    {
                        if (IDYES == MessageBox(hDialog, "The wallpaper file was read-only." //
                            "The screen image was not resized." //
                            "\nTo maintain the aspect ratio of wallpaper images" //
                            "\n\nIconoid needs to temporarily rename wallpaper files." //
                            "\nDo you want to turn off the aspect ratio setting on the" //
                            "\nDesktop tab?", szTitle, MB_ICONWARNING|MB_YESNO))
                        {
                            CheckDlgButton(hDialog, IDC_NORMALIZE, icSettings.bNormalize = FALSE);
                            SendMessage(hDialog, WM_COMMAND, IDC_NORMALIZE, 0);
                        } 
                    } 
                    else
                    {
                        if (CopyFile(szWallPaper, szSaveName, FALSE))
                        {
                            CopyFile(szBMPfile, szWallPaper, FALSE);
                            szStyle[0] = '0';
                            RegWriteSz("Control Panel\\Desktop", "WallpaperStyle", szStyle);
                            szStyle[0] = '0';
                            RegWriteSz("Control Panel\\Desktop", "TileWallpaper", szStyle);
                            SystemParametersInfo(SPI_SETDESKWALLPAPER, 0, szWallPaper, 0);
                            CopyFile(szSaveName, szWallPaper, FALSE);
                            DeleteFile(szSaveName);
                            if (!bEnableTestMode)
                                DeleteFile(szBMPfile);
                        } 
                        else
                        {
                            DeleteFile(szSaveName);
                            MessageBox(hDialog,            //
                                "Iconoid could not create the temporary wallpaper file that" //
                                "\nit uses to resize \"stretched\" wallpaper." //
                                "\n\nThe option to normalize stretched wallpaper has been turned off.", szTitle, 0);
                            CheckDlgButton(hDialog, IDC_NORMALIZE, icSettings.bNormalize = FALSE);
                            SendMessage(hDialog, WM_COMMAND, IDC_NORMALIZE, 0);
                        } 
                    } 
                    FindClose(hFind);
                } 
                                //---------------------------
                ReleaseDC(NULL, hdcScreen);
                DeleteObject(hScaledBMP);
                DeleteDC(hdcScaled);
            } 
            else
                ProcessLastErr();
        }  while (wait > 0);
        inuse = FALSE;
    } 
    else
        wait++;
    return 0;
} 

void SetDesktopBackgroundColor(COLORREF crBackground)
{
    CHAR          szDebug[20];
    int           iDesktop = COLOR_DESKTOP;

    if (!SetSysColors(1, &iDesktop, &crBackground))
        ConditionalMessageBox(hDialog, "SetSysColors Failed!", "Iconoid", MB_APPLMODAL);
    crBackground = GetSysColor(COLOR_DESKTOP);
    wsprintf(szDebug, "#%02X%02X%02X", GetRValue(crBackground), GetGValue(crBackground), GetBValue(crBackground));
    SetWindowText(ItemHWnd(ID_HEXCOLOR), szDebug);
    InvalidateRect(hDialog, 0, TRUE);                      // ??? setsyscolor causes paint errs
    UpdateWindow(hDialog);                                 // ???
    SettingsChangedCount++;
} 

void ShowNewWallpaper(int action)
{
    CHAR          dirname[MAX_PATH];
    CHAR          fullname[MAX_PATH];
    CHAR          filename[MAX_PATH] = "";
    HWND          hListbox = ItemHWnd(IDC_LIST1);
    HBITMAP       hOrigBMP = NULL;
    CHAR          work[MAX_PATH+50];
    CHAR          szStyle[2] = "";
    static LRESULT current = 0;
          
    switch (action)
    {
        case -1 :
            current = SendMessage(hListbox, LB_GETCURSEL, NULL, NULL);
            if (LB_ERR != current)
                current -= 2;
            break;
        case 0 :
            current = SendMessage(hListbox, LB_GETCURSEL, NULL, NULL);
            if (LB_ERR == current)
                current = SendMessage(hListbox, LB_GETCOUNT, NULL, NULL);
            else
                current--;                                 // back up 1
            break;
        case 1 :
            current = SendMessage(hListbox, LB_GETCURSEL, NULL, NULL);
            break;
    } 
    LRESULT       count = SendMessage(hListbox, LB_GETCOUNT, NULL, NULL);

    if (++current >= count)
        current = 0;
    else
        if (current < 0)
            current = count-1;
    GetWindowText(ItemHWnd(IDC_WPCOMBO), dirname, MAX_PATH-50);
    if (LB_ERR != SendMessage(hListbox, LB_GETTEXT, current, (LPARAM)filename))
    {
        wsprintf(fullname, "%s\\%s.bmp", dirname, filename);
        SendMessage(hListbox, LB_SETCURSEL, current, NULL);
        SetWindowText(ItemHWnd(IDC_STATUSBAR), "");
        if (hOrigBMP = (HBITMAP)LoadImage(0, fullname, IMAGE_BITMAP, 0, 0, LR_LOADFROMFILE))
        {
            BITMAP        bmp;
                        // Retrieve the bitmap color format, width, and height.
          
            if (GetObject(hOrigBMP, sizeof(BITMAP), (LPSTR)&bmp))
            {
                DeleteObject(hOrigBMP);
                wsprintf(work, "%s (%dx%d)", filename, bmp.bmWidth, bmp.bmHeight);
                SetWindowText(ItemHWnd(IDC_WPFN), work);
                szStyle[0] = (bmp.bmHeight > 256)?(icSettings.bNormalize?'2':'0'):'1';
                RegWriteSz("Control Panel\\Desktop", "WallpaperStyle", szStyle);
                szStyle[0] = (bmp.bmHeight > 256)?'0':'1';
                RegWriteSz("Control Panel\\Desktop", "TileWallpaper", szStyle);
                RegWriteSz("Control Panel\\Desktop", "Wallpaper", fullname);
                SystemParametersInfo(SPI_SETDESKWALLPAPER, 0, fullname, 0);
                DWORD         dummy;
                ULONG         threadid;
          
                CreateThread(NULL, 0, BroadcastChange, &dummy, NULL, &threadid);
            } 
            else
                ProcessLastErr();
        } 
        else
        {
            ProcessLastErr();
            SetWindowText(ItemHWnd(IDC_WPH), "");
            SetWindowText(ItemHWnd(IDC_WPFN), "");
            ShowWindow(ItemHWnd(IDC_PROGRESS), SW_HIDE);
        } 
    } 
} 

void CreateBMPFile(LPTSTR pszFile,HBITMAP hBMP,HDC hDC)
{
    HANDLE        hf;                                      // file handle
    BITMAPFILEHEADER hdr;                                  // bitmap file-header
    BITMAPINFO    bmi = 
    {
        0
    } 
    ;
    DWORD         dwTmp;
    BITMAP        bmp;
    LPBYTE        lpBits;
          
    GetObject(hBMP, sizeof(BITMAP), (LPSTR)&bmp);
    bmi.bmiHeader.biSize = sizeof BITMAPINFOHEADER;
    bmi.bmiHeader.biWidth = bmp.bmWidth;
    bmi.bmiHeader.biHeight = bmp.bmHeight;
    bmi.bmiHeader.biPlanes = 1;
    bmi.bmiHeader.biBitCount = 24;
    bmi.bmiHeader.biCompression = BI_RGB;
//      int bitsSize=((bmp.bmWidth+3)&~3)*bmp.bmHeight *sizeof(RGBTRIPLE);
    int           bitsSize = ((sizeof(RGBTRIPLE)*bmp.bmWidth+3)&~3)*bmp.bmHeight;
          
    bmi.bmiHeader.biSizeImage = bitsSize;
    lpBits = (LPBYTE)GlobalAlloc(GMEM_FIXED, bitsSize);
    if (lpBits)
    {
        int           rc;
          
        if (rc = GetDIBits(hDC, hBMP, 0, (WORD)bmp.bmHeight, lpBits, &bmi, DIB_RGB_COLORS))
        {
            hf = CreateFile(pszFile, GENERIC_READ|GENERIC_WRITE, (DWORD)0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, (HANDLE)NULL);
            if (hf != INVALID_HANDLE_VALUE)
            {
                hdr.bfType = 0x4d42;                       // 0x42 = "B" 0x4d = "M"
                hdr.bfSize = (DWORD)(sizeof(BITMAPFILEHEADER)+bmi.bmiHeader.biSize+bitsSize);
                hdr.bfReserved1 = 0;
                hdr.bfReserved2 = 0;
                hdr.bfOffBits = (DWORD)sizeof(BITMAPFILEHEADER)+bmi.bmiHeader.biSize;
                if (WriteFile(hf, (LPVOID)&hdr, sizeof(BITMAPFILEHEADER), (LPDWORD)&dwTmp, NULL))
                {
                    if (WriteFile(hf, (LPVOID)&bmi, sizeof(BITMAPINFOHEADER), (LPDWORD)&dwTmp, NULL))
                    {
                        WriteFile(hf, (LPSTR)lpBits, bitsSize, (LPDWORD)&dwTmp, NULL);
                    } 
                } 
                CloseHandle(hf);                           // Close the .BMP file
            } 
        } 
        else
        {
            ProcessLastErr();
        } 
        GlobalFree((HGLOBAL)lpBits);
    } 
    else
        ProcessLastErr();
} 

void CalculateWallpaperScaling(BITMAP bmp,LONG targetX,LONG targetY,LPSIZE sz)
{
    FLOAT         BMPratio,ScreenRatio;
          
    BMPratio = ((FLOAT)bmp.bmWidth)/(FLOAT)bmp.bmHeight;
    ScreenRatio = ((FLOAT)targetX)/(FLOAT)targetY;
    //CheckDlgButton(hDialog, IDC_STRETCH_INNER, icSettings.bStretchInner);
    if (((ScreenRatio < BMPratio) && !icSettings.bStretchInner) ||  //
        ((ScreenRatio >= BMPratio) && icSettings.bStretchInner))
    {
        sz->cx = targetX;
        sz->cy = (INT)((FLOAT)bmp.bmHeight *((10.0*(FLOAT)targetX)/(FLOAT)bmp.bmWidth))/10;
    } 
    else
    {
        sz->cy = targetY;
        sz->cx = (INT)((FLOAT)bmp.bmWidth *((10.0*(FLOAT)targetY)/(FLOAT)bmp.bmHeight))/10;
    } 

} 

#ifdef   selfread
////////////////////////////////////////////////////////////////////////////////////
// AddPixel  - add a pixel (3 bytes) to linear array of pixels
////////////////////////////////////////////////////////////////////////////////////
void AddPixel(RGBQUAD rgbQuad)

{
    pBMPdata->rgbtRed = rgbQuad.rgbRed;
    pBMPdata->rgbtGreen = rgbQuad.rgbGreen;
    pBMPdata->rgbtBlue = rgbQuad.rgbBlue;
    pBMPdata++;
} 

////////////////////////////////////////////////////////////////////////////////////
// ReadBitMapIntoArray
////////////////////////////////////////////////////////////////////////////////////

void ReadBitMapIntoArray()
{
    BITMAPFILEHEADER bmfh;
    FILE          *fp;
    RGBQUAD       *ColorTable;
    RGBQUAD       rgbQuad;
    RGBTRIPLE     rgbTriple;
    WORD          rgbWord;
    UCHAR         rgbByte;
    COLORREF      crBackground;
    INT           iColorTableSize = 0;
    ULONG         iPixels = 0;
    ULONG         iLineStart = 0;
    INT           iPixelWidth;
    ULONG         Width,Height;
    ULONG         iInitialCol;
    RGBQUAD       uCurrentPixel;
    size_t        iBytesRead = 0;
    const ULONG   iBorderDepth = 3;
    ULONG         iColorIndex[256] = 
    {
        0
    } 
    ;
    UINT          b;                                       // general counter
    static BOOL   bErrorMessageShown = FALSE;
          
    crBackground = (COLORREF)-1;
    GetCurrentWallpaper(szWallPaper);
    if ((szWallPaper[0]) && ((fp = fopen(szWallPaper, "rb")) != NULL))
    {
        fread(&bmfh, sizeof(bmfh), 1, fp);                 /* read bitmap file header                                                     */
        iBytesRead = fread(&bmi.bmiHeader, sizeof(bmi.bmiHeader), 1, fp); // read bitmap info header
        if (bmfh.bfType != 19778)
        {
            fclose(fp);
            return ;
        } 
        Width = bmi.bmiHeader.biWidth;
        Height = bmi.bmiHeader.biHeight;
        iPixels = Height *Width;
        if (BI_RGB == bmi.bmiHeader.biCompression)
        {
            b = 0;
            do
            {
                if (rgbBMPArray == NULL)
                    rgbBMPArray = (RGBTRIPLE *)valloc(iPixels *sizeof(RGBTRIPLE));
                else
                    if (iPixels *sizeof(RGBTRIPLE) > v_msize(rgbBMPArray))
                    {
                                        //      Var2X (iPixels *sizeof(RGBTRIPLE) , _msize(rgbBMPArray));
//                        realloc( rgbBMPArray, iPixels *sizeof(RGBTRIPLE));
                        vfree(rgbBMPArray);
                        rgbBMPArray = (RGBTRIPLE *)valloc(iPixels *sizeof(RGBTRIPLE));
                    } 
                if (rgbBMPArray && iPixels *sizeof(RGBTRIPLE) <= v_msize(rgbBMPArray))
                {
                    ZeroMemory(rgbBMPArray, iPixels *sizeof(RGBTRIPLE));
                    pBMPdata = rgbBMPArray;
                    pBMPdata->rgbtBlue = 0;
                    SetWindowText(hDialog, szTitle);
                } 
                else
                {
                    SetWindowText(hDialog, "Iconoid [Out of Memory]");
                    if (rgbBMPArray)
                        vfree(rgbBMPArray);
                    rgbBMPArray = NULL;
                } 
            }  while (b++ < 4 && NULL == rgbBMPArray);
            if (!rgbBMPArray)
            {
                fclose(fp);
                if (!bErrorMessageShown)
                {
                    bErrorMessageShown = TRUE;
                    ConditionalMessageBox(hDialog, "Iconoid was unable to allocate enough memory""\nto hold your current wallpaper."
//                        "\n\nThis may be because the actual picture file""\nis larger than the screen size."
                        "\n\nWhen this occurs, automatic text color and""\nAutomatic background color detection will fail."
                        "\nYou may want to turn these options off.",  //
                        "Iconoid [Out of Memory]", MB_APPLMODAL|MB_ICONHAND);
                } 
                return ;
            } 
            iColorTableSize = bmi.bmiHeader.biClrUsed;
            if (bmi.bmiHeader.biBitCount <= 8)
                if (!iColorTableSize)
                    iColorTableSize = 0x2 << (bmi.bmiHeader.biBitCount-1);
            switch (bmi.bmiHeader.biBitCount)
            {
                case 24 :
                    iPixelWidth = 3;
                    break;
                case 16 :
                    iPixelWidth = 2;
                    break;
                case 32 :
                    iPixelWidth = 4;
                    break;
                default  :
                    iPixelWidth = 1;
                    break;
            } 
            ColorTable = NULL;
            if (iColorTableSize)
            {
                ColorTable = (RGBQUAD *)malloc(iColorTableSize *sizeof(RGBQUAD));
                if (ColorTable)
                    iBytesRead = fread(ColorTable, sizeof(RGBQUAD), (size_t)iColorTableSize, fp);
                else
                {
                    MessageBox(hDialog, "Bitmat decoding: Color table allocation failed", szTitle, MB_APPLMODAL);
                    fclose(fp);
                    return ;
                } 
            } 
            ULONG         iBorderLength,iAbs;

            iBorderLength = min(iPixels, (ULONG)(Width *iBorderDepth));
            iAbs = abs(iPixels-iBorderLength);
            size_t        iSampleSize = 0;
            size_t        iBytesPerLine = iPixelWidth *Width;
            size_t        iRealWidth = 4*((iBytesPerLine+3)/4);
            size_t        iPad = iRealWidth-iBytesPerLine;

            iLineStart = 0;
            for (ULONG Row = 0; Row < Height && 0 < iBytesRead; Row++)
                for (ULONG Col = 0; Col < Width && 0 < iBytesRead; )
                {
                    iInitialCol = Col;
                    switch (bmi.bmiHeader.biBitCount)
                    {
                        case 1 :
                            iBytesRead = fread(&rgbByte, 1, 1, fp);
                            for (b = 0; b < 8; b++)
                            {
                                AddPixel(ColorTable[(rgbByte&0x80)?1:0]);
                                rgbByte <<= 1;             // shift byte to get next pixel
                            } 
                            Col += 8;                      // bump by 8 pixelspixels
                            break;
                        case 4 :
                            iBytesRead = fread(&rgbByte, 1, 1, fp);
                            AddPixel(ColorTable[rgbByte >> 4]);
                            AddPixel(ColorTable[rgbByte&0x0F]);
                            Col += 2;                      // bump by 2 pixelspixels
                            break;
                        case 8 :
                            iBytesRead = fread(&rgbByte, 1, 1, fp);
                            AddPixel(ColorTable[rgbByte]);
                            Col++;                         // bump by pixelspixels
                            break;
                        case 16 :
                            iBytesRead = fread(&rgbWord, sizeof(rgbWord), 1, fp);
                            uCurrentPixel.rgbBlue = (rgbWord&0x001F) << 3; //
                            uCurrentPixel.rgbGreen = (rgbWord&0x03E0) >> 2; //
                            uCurrentPixel.rgbRed = (rgbWord&0x7C00) >> 7;
                            AddPixel(uCurrentPixel);
                            Col++;                         // bump by pixels
                            break;
                        case 24 :
                            iBytesRead = fread(&rgbTriple, sizeof(rgbTriple), 1, fp);
                            uCurrentPixel.rgbRed = rgbTriple.rgbtRed; //
                            uCurrentPixel.rgbGreen = rgbTriple.rgbtGreen; //
                            uCurrentPixel.rgbBlue = rgbTriple.rgbtBlue;
                            AddPixel(uCurrentPixel);
                            Col++;                         // bump by pixels
                            break;
                        case 32 :
                            iBytesRead = fread(&rgbQuad, sizeof(rgbQuad), 1, fp);
                            AddPixel(rgbQuad);
                            Col++;                         // bump by pixelspixels
                            break;
                        default  :
                            Col++;                         // just do nothing and handle the loop increment
                    } 
                    if (Col > Width-1 && iPad > 0)
                    {
                        iBytesRead = fread(&rgbQuad, sizeof(char), iPad, fp);
                    } 
                } 
            if (ColorTable)
                free(ColorTable);
        } 
        fclose(fp);
    } 
    if ((rgbBMPArray && !szWallPaper[0]))
        bmi.bmiHeader.biWidth = 0;
    return ;
} 

#endif