#include "stdafx.h"
#include "commctrl.h"
#include "mmsystem.h"
#include "string.h"
#include <shellapi.h>  
#include "tr3.h"
VOID HideWindows(void);

BOOL          bCursorTimerRunning = FALSE;

/******************************************************************************************************************************************/
/* TimerProc is the main timer.  It handles looking at the cursor.                                                                        */
/* TimerProc fires every 100 milliseconds.                                                                                                */
/******************************************************************************************************************************************/

TIMERPROC TimerProc(HWND hWnd,                             // handle to window
                     UINT uMsg,                            // WM_TIMER message
                     UINT_PTR idEvent,                     // timer identifier
                     DWORD dwTime                          // current system time
)
{

    BOOL          isDesktop;
    static BOOL   bLastLocation = ONDESKTOP;
    static POINT  ptOldPos = 
    {
        1,1
    } 
    ,ptOldPosCsr = 
    {
        1,1
    } 
    ,ptNewPos = 
    {
        2,2
    } 
    ;
    static LRESULT NextTick = 0;
    static LRESULT TickCursorNonMovementHide = 0;
    static LRESULT TickCursorOnDesktopShow = -1;
    static BOOL   enableBoss = true;
    static LRESULT iCheckForHide = 10*SendMessage(ItemHWnd(IDC_TEMPSHOWTIME), TBM_GETPOS, 0, 0); // 5 * .1 = 5 seconds
    HWND          hCWindow;                                // window under cursor
    TCHAR         szMsg[40];
    LPARAM        lParam = 0;

    GetCursorPos(&ptNewPos);
    if (icSettings.bCursorHide)
    {
        if (ptNewPos.x != ptOldPosCsr.x || ptNewPos.y != ptOldPosCsr.y)
        {
            ptOldPosCsr = ptNewPos;
            KillTimer(hWnd, IDT_TIMERCSR);
            bCursorTimerRunning = FALSE;
            if (!pICNData->CursorState)
                SendMessage(hListView, pICNData->ShowHideCursor, 0, 0);
        } 
        else
        {
            if ((!bCursorTimerRunning)                     //
                && IsDlgButtonChecked(hWnd, ID_CHKALWAYSHIDE) == BST_CHECKED)
            {
                bCursorTimerRunning = TRUE;
                SetTimer(hWnd, IDT_TIMERCSR, HIDE_TIMEOUT, (TIMERPROC)CursorProc);
            } 
        } 
    } 
    else
        if (!pICNData->CursorState)
            SendMessage(hListView, pICNData->ShowHideCursor, 0, 0);
    ShowTaskbarConditionally();
    //   CheckForShowDesktop();

    HideWindows();
    if ((ptNewPos.x == 0 || ptNewPos.y == 0 || ptNewPos.x == GetSystemMetrics(SM_CXSCREEN)-1 || ptNewPos.y == GetSystemMetrics(SM_CYSCREEN)
        -1))
    {
        if (IsDlgButtonChecked(hWnd, ID_BOSS) == BST_CHECKED)
        {
            BOOL          v;

            if (Is95() || (SystemParametersInfo(SPI_GETSCREENSAVERRUNNING, 0, &v, 0) && (!v)))
            {
                if (!IsShowDesktop())
                {
                    if (icSettings.iHideMethod == DROPDOWN_HIDEWINDOWS)
                    {
                        FindSCFfile();
                        if (icSettings.szSCFfile[0])
                        {
                            ShowWindow(hListView, SW_SHOW);
                            ShowTaskbar();
                            ShellExecute(0, "open", icSettings.szSCFfile, NULL, NULL, SW_SHOWNORMAL);
                        } 
                        else
                            EnumWindows(EnumWinProc, lParam);
                    } 
                    else
                        if (icSettings.iHideMethod == DROPDOWN_SCREENSAVER)
                        {
                            if (enableBoss)
                                SendMessage(GetDesktopWindow(), WM_SYSCOMMAND, SC_SCREENSAVE, 0);
                            enableBoss = false;
                        } 
                        else                               // icSettings.iHideMethod == DROPDOWN_LOCKDESKTOP
                            if (m_LockWorkstation)
                                m_LockWorkstation();
                } 
            } 
        } 
    } 
    else
        enableBoss = true;

    if (icSettings.bAutoHide)
    {
        hCWindow = WindowFromPoint(ptNewPos);
        isDesktop = (WindowFromPoint(ptNewPos) == hListView //
            || WindowFromPoint(ptNewPos) == GetParent(hListView)); //
        isDesktop = FindWindow("Progman", 0) == hCWindow   //
            || hCWindow == hListView                       //
            || hCWindow == GetParent(hListView)            //
                || GetParent(hCWindow) == GetParent(hListView); //
        if (isDesktop)
        {
            if (bLastLocation == OFFDESKTOP)
            {
                if (icSettings.bShowDelay)
                {
                    if (TickCursorOnDesktopShow == -1)
                        TickCursorOnDesktopShow = (LONG)dwTime+(icSettings.tmrShowDelay-1)*100;
                } 
                else

                    TickCursorOnDesktopShow = -1;
            } 
            bLastLocation = ONDESKTOP;
            NextTick = (LRESULT)dwTime+1000*icSettings.tmrOffDesktop;
            if (TickCursorOnDesktopShow < 0 || TickCursorOnDesktopShow <= (LONG)dwTime)
            {
                if (ptOldPos.x == ptNewPos.x && ptOldPos.y == ptNewPos.y) // on desktop, no move
                {
                    if (TickCursorNonMovementHide > 0 && TickCursorNonMovementHide <= (LONG)dwTime)
                    {
                        TickCursorNonMovementHide = -1;
                        if (icSettings.bOnDesktop)
                        {
                            HideDesktopIcons(icSettings.bHideTaskBar);
                            if (icSettings.bCursorHide && !bCursorTimerRunning)
                            {
                                bCursorTimerRunning = TRUE;
                                SetTimer(hWnd, IDT_TIMERCSR, HIDE_TIMEOUT, (TIMERPROC)CursorProc);
                            } 
                        } 
                    } 
                } 
                else                                       // ' on desktop && cursor moved
                {
                    ShowWindow(hListView, SW_SHOWNA);
                    ShowTaskbar();
                    TickCursorNonMovementHide = (LONG)dwTime+icSettings.tmrOnDesktop *1000;

                    TickCursorOnDesktopShow = -1;
                } 
            } 
        } 
        else                                              // 'If ptOldPos.x <> ptNewPos.x Or ptOldPos.y <> ptNewPos.y ) ' not on desktop
        {

            bLastLocation = OFFDESKTOP;
            TickCursorOnDesktopShow = -1;
            if (icSettings.bOffDesktop)
            {
                if (NextTick != 0 && (LONG)dwTime >= NextTick)
                {
                    HideDesktopIcons(icSettings.bHideTaskBar);
                    NextTick = 0;
                } 
            } 
            // restore toolbar to visible if mouse over its location

            RECT          rectTrayPos;

            GetWindowRect(FindWindow("Shell_TrayWnd", NULL), &rectTrayPos);
            if (PtInRect(&rectTrayPos, ptNewPos))
            {
                ShowTaskbar();
                NextTick = (LONG)dwTime+1000*icSettings.tmrOffDesktop;
            } 
            //end restore toolbar visibility
        } 
        if (TickCursorOnDesktopShow == -1)
            ptOldPos = ptNewPos;
    } 
    else
    {
        if (icSettings.bAlwaysHide)
        {
            if (IsWindowVisible(hListView))
            {
                int           sw = (TABHIDING == SendMessage(ItemHWnd(ID_TABBOX), TCM_GETCURSEL, 0, 0))?SW_SHOW:SW_HIDE;
          
                if (pICNData->bMouseMoved)
                {
                    iCheckForHide = 10*icSettings.tmrShowIconsInAlwaysHide; // 5 * .1 = 5 seconds
                    pICNData->bMouseMoved = FALSE;         // reset mouse move indicator so timer won't reset
                } 
                if (sw)
                {
                    LRESULT       q = iCheckForHide/10;
          
                    SendMessage(ItemHWnd(IDC_PROGCOUNT), PBM_SETRANGE, 0, MAKELPARAM(0, icSettings.tmrShowIconsInAlwaysHide *10));
                    SendMessage(ItemHWnd(IDC_PROGCOUNT), PBM_SETPOS, iCheckForHide, 0);
                    wsprintf(szMsg, "%d.%d seconds left", q, iCheckForHide%10);
                    SetWindowText(ItemHWnd(IDC_SHOWCOUNTDOWN), szMsg);
                    ShowWindow(ItemHWnd(IDC_SHOWCOUNTDOWN), sw);
                    ShowWindow(ItemHWnd(IDC_PROGCOUNT), sw);
                    InvalidateRect(ItemHWnd(IDC_SHOWCOUNTDOWN), 0, TRUE);
                } 
                if (--iCheckForHide)
                {
                    EnableWindow(ItemHWnd(IDC_TEMPSHOWTIME), FALSE);
                    EnableWindow(ItemHWnd(IDC_TEMPSHOWTXT), FALSE);
                    EnableWindow(ItemHWnd(IDC_TEMPSHOWINFO), FALSE);
                    EnableWindow(ItemHWnd(IDC_MINSHOWMSG), FALSE);
                    EnableWindow(ItemHWnd(IDC_ZERO4), FALSE);
                    EnableWindow(ItemHWnd(IDC_SIXTY4), FALSE);
                } 
                else
                {
                    iCheckForHide = 10*icSettings.tmrShowIconsInAlwaysHide; // 5 * .1 = 5 seconds
                    HideDesktopIcons(icSettings.bHideTaskBar);
                    SetWindowText(ItemHWnd(IDC_SHOWCOUNTDOWN), "");
                    InvalidateRect(ItemHWnd(IDC_SHOWCOUNTDOWN), 0, TRUE);
                    ShowWindow(ItemHWnd(IDC_SHOWCOUNTDOWN), SW_HIDE);
                    ShowWindow(ItemHWnd(IDC_PROGCOUNT), SW_HIDE);
                    EnableWindow(ItemHWnd(IDC_TEMPSHOWTIME), TRUE);
                    EnableWindow(ItemHWnd(IDC_TEMPSHOWTXT), TRUE);
                    EnableWindow(ItemHWnd(IDC_TEMPSHOWINFO), TRUE);
                    EnableWindow(ItemHWnd(IDC_MINSHOWMSG), TRUE);
                    EnableWindow(ItemHWnd(IDC_ZERO4), TRUE);
                    EnableWindow(ItemHWnd(IDC_SIXTY4), TRUE);
                } 
            } 
            else
                iCheckForHide = 10*icSettings.tmrShowIconsInAlwaysHide; // 5 * .1 = 5 seconds
        } 
    } 
    return 0;
} 

// ------------ This section processes the two second wait to minimize windows

VOID HideWindows()
{
    static POINT  ptLastPoint = 
    {
        -2,-2
    } 
    ;
    static ULONG  ToggleTime = 0;
    POINT         pt;
    BOOL          ActiveCorner;
    int           ScreenX,ScreenY;
    DWORD         lParam = 0;

    if (icSettings.bHotCorner)
    {
        GetCursorPos(&pt);
        ScreenX = GetSystemMetrics(SM_CXSCREEN)-1;
        ScreenY = GetSystemMetrics(SM_CYSCREEN)-1;
        ActiveCorner = FALSE;
        switch (icSettings.cornernum)
        {
            case 0 :
                ActiveCorner = (pt.x == 0 && pt.y == 0);
                break;
            case 1 :
                ActiveCorner = (pt.x == ScreenX && pt.y == 0);
                break;
            case 2 :
                ActiveCorner = (pt.y == ScreenY && pt.x == 0);
                break;
            case 3 :
                ActiveCorner = (pt.y == ScreenY && pt.x == ScreenX);
                break;
        } 
        if (ActiveCorner && !IsShowDesktop())              //
        {
            if (!icSettings.bTwoSecondWait)
            {
                if ((pt.x != ptLastPoint.x || pt.y != ptLastPoint.y))
                {
                    if (icSettings.iHideMethod == DROPDOWN_HIDEWINDOWS)
                    {
                        FindSCFfile();
                        if (icSettings.szSCFfile[0])
                        {
                            ShowWindow(hListView, SW_SHOW);
                            ShowTaskbar();
                            ShellExecute(0, "open", icSettings.szSCFfile, NULL, NULL, SW_SHOWNORMAL);
                        } 
                        else
                            EnumWindows(EnumWinProc, lParam);
                    } 
                    else
                        if (icSettings.iHideMethod == DROPDOWN_SCREENSAVER)
                            SendMessage(GetDesktopWindow(), WM_SYSCOMMAND, SC_SCREENSAVE, 0);
                        else                               // icSettings.iHideMethod == DROPDOWN_LOCKDESKTOP
                            if (m_LockWorkstation)
                                m_LockWorkstation();
                } 
            } 
            else
                if (GetTickCount() >= ToggleTime && ToggleTime > 0)
                {
                    ToggleTime = -1;                       // ' indicate minimizing activity in progress
                    if (icSettings.iHideMethod == DROPDOWN_HIDEWINDOWS)
                    {
                        FindSCFfile();
                        if (icSettings.szSCFfile[0])
                        {
                            ShowWindow(hListView, SW_SHOW);
                            ShowTaskbar();
                            ShellExecute(0, "open", icSettings.szSCFfile, NULL, NULL, SW_SHOWNORMAL);
                        } 
                        else
                            EnumWindows(EnumWinProc, lParam);
                    } 
                    else
                        if (icSettings.iHideMethod == DROPDOWN_SCREENSAVER)
                            SendMessage(GetDesktopWindow(), WM_SYSCOMMAND, SC_SCREENSAVE, 0);
                        else                               // icSettings.iHideMethod == DROPDOWN_LOCKDESKTOP
                            if (m_LockWorkstation)
                                m_LockWorkstation();
                    ToggleTime = 0;
                } 
                else
                    if (ToggleTime == 0)
                    {
                        if ((pt.x != ptLastPoint.x || pt.y != ptLastPoint.y))
                        {
                            ToggleTime = GetTickCount()+1000; // ' We lied - it is really 1 seconds
                        } 
                    } 
        } 
        else
            ToggleTime = 0;                                // ' kill the wait for the next minimize
        ptLastPoint = pt;
    } 
} 

/******************************************************************************************************************************************/
/* SaveSettingsTimer is executed every 2 seconds.  It does periodic saves when needed                                                     */
/******************************************************************************************************************************************/

TIMERPROC SaveSettingsTimer(HWND hWnd,                     // handle to window
                             UINT uMsg,                    // WM_TIMER message
                             UINT_PTR idEvent,             // timer identifier
                             DWORD dwTime)                 // current system time
{
    static HWND   hOriginalProgman = FindWindow("Progman", 0);
    static ICSETTINGS icLast = 
    {
        0
    } 
    ;

    static void   *lastSettingsPtr = 0;
    static void   *currentSettingsPtr = 0;
    // first check to see if colors need changing.
    // This is not available when 'show desktop' is active from the taskbar icon
    //  if (!IsActiveDesktop())
// Check to see if any settings have changed and if so save settings.
// This is done because with always hide option, exit never happens.

    if (!lastSettingsPtr)
    {
        lastSettingsPtr = &icLast;
        currentSettingsPtr = &icSettings;
        memcpy(lastSettingsPtr, currentSettingsPtr, sizeof icSettings);

    } 
    if (memcmp(currentSettingsPtr, lastSettingsPtr, sizeof icSettings))
    {
        SaveICSettings(icSettings, hDialog);
        memcpy(lastSettingsPtr, currentSettingsPtr, sizeof icSettings);
        EnableDisableFunctions();
    } 
    if (hOriginalProgman != FindWindow("Progman", 0))
    {
        static int    countdown = 10;
          
        if (CheckForStartup() || !countdown)
        {

            KillTimer(hWnd, IDT_TIMER_SAVESETTINGS);
            countdown = 10;
            hListView = GetDeskTopListView();
            SetHook(FALSE);
            if (SetHook(TRUE))
            {
                hOriginalProgman = Restart(hWnd);
                ReInitializeTabs(hDialog);
            } 
            else
            {
                KillTimer(hWnd, IDT_TIMER_SAVESETTINGS);
                MessageBox(hWnd, "Iconoid can no longer find the desktop." //
                    "\nThe desktop probably crashed."      //
                    "\n\nPlease restart Iconoid manually.", szTitle, MB_OK);
                SendMessage(hDialog, WM_CLOSE, (WPARAM)0, (LPARAM)0);
            } 
        } 
        else
        {
            countdown--;
            CHAR          msg[80];
          
            wsprintf(msg, "Attempting to reaquire desktop: %d attempts left", countdown);
            SetWindowText(ItemHWnd(IDC_STATUSBAR), msg);
        } 
    } 

    return 0;
} 

BOOL IsShowDesktop()
{
    HWND          hCWindow,hParent;

    hParent = hListView;
    do
    {
        hCWindow = hParent;
        hParent = GetParent(hCWindow);
    }  while (hParent);
    return (0 == hParent && hCWindow != FindWindow("Progman", 0));
} 

VOID SetMainTimer(HWND hWnd)
{
    if (icSettings.bAutoHide || icSettings.bHotCorner || icSettings.bAlwaysHide)
        SetTimer(hWnd, IDT_TIMER2, 100, (TIMERPROC)TimerProc);
    else
        KillTimer(hWnd, IDT_TIMER2);
} 

TIMERPROC CursorProc(HWND hwnd,                            // handle to window
                      UINT uMsg,                           // WM_TIMER message
                      UINT_PTR idEvent,                    // timer identifier
                      DWORD dwTime                         // current system time
)
{
    KillTimer(hDialog, IDT_TIMERCSR);
    if (icSettings.bCursorHide)                            // if still wanting hide
        if (pICNData->CursorState)
            SendMessage(GetDeskTopListView(), pICNData->ShowHideCursor, 0, 0);

    bCursorTimerRunning = FALSE;
    return 0;
} 

TIMERPROC ReHideTaskbarProc(HWND hwnd,                     // handle to window
                             UINT uMsg,                    // WM_TIMER message
                             UINT_PTR idEvent,             // timer identifier
                             DWORD dwTime                  // current system time
)
{
    RECT          rectTrayPos;
    POINT         ptCursor;
    HWND          hTaskbar = FindWindow("Shell_TrayWnd", NULL);

    KillTimer(hDialog, IDT_TIMER8);
    if (icSettings.bHideTaskBar)
    {
        GetCursorPos(&ptCursor);
        GetWindowRect(hTaskbar, &rectTrayPos);
        if (IsWindowVisible(hTaskbar) && !IsWindowVisible(hListView))
            if (PtInRect(&rectTrayPos, ptCursor))
                SetTimer(hwnd, IDT_TIMER8, TASKBAR_REHIDE_TIME, (TIMERPROC)ReHideTaskbarProc);
            else
                HideTaskbar();
    } 
    return 0;
} 

int const     NUMBER_OF_RETRIES = 40;
int           iSettingsChangeTimerRepeat = NUMBER_OF_RETRIES;
TIMERPROC TimerSettingsChange(HWND hwnd,                   // handle to window
                               UINT uMsg,                  // WM_TIMER message
                               UINT_PTR idEvent,           // timer identifier
                               DWORD dwTime                // current system time
)
{
        // because the registry does not get updated immediately by changes, this will
        // poll up to 10 seconds until it sees a change.  Why in the hell XP would broadcast
        // a wm_settingchange message *before* it really makes the change is anyone's guess.
        // SPI_SETCURSORSHADOW has the same problem.  Damn XP
    BOOL          oldxpDropShadow = xpDropShadow;
    CHAR          *const keyName = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Advanced";
    CHAR          *const valueName = "ListviewShadow";
          
    hListView = GetDeskTopListView();
    if (!iSettingsChangeTimerRepeat--)
    {
        KillTimer(hwnd, ID_TIMER_SETTINGSCHANGE);
        iSettingsChangeTimerRepeat = NUMBER_OF_RETRIES;
    } 
    if (pICNData->bDancinFools && IsActiveDesktop())
        SendMessage(hDialog, WM_COMMAND, IDM_DANCE, 0);
    xpDropShadow = IsXPatLeast() && (BOOL)RegReadDWord(keyName, valueName);
    if (oldxpDropShadow != xpDropShadow && TABCOLORS == SendMessage(ItemHWnd(ID_TABBOX), TCM_GETCURSEL, 0, 0))
    {
        KillTimer(hwnd, ID_TIMER_SETTINGSCHANGE);
        iSettingsChangeTimerRepeat = NUMBER_OF_RETRIES;
        ReInitializeTabs(hDialog);
    } 
    else
        EnableDisableFunctions();
    return 0;
} 
