#include "StdAfx.h"
#include <stdio.h>
#include <mmsystem.h>
#include "shellapi.h"
#include "tr3.h"
CHAR comboDirname[MAX_PATH];
CHAR          picfullname[MAX_PATH];
LRESULT CALLBACK WPListboxWndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)

{
    switch (message)
    {
        case  WM_KEYUP :
            if (VK_RETURN == wParam)
                ShowNewWallpaper(0);
            break;

        case  WM_SETFOCUS :
        case  WM_KILLFOCUS :
            InvalidateRect(hWnd, 0, true);
            break;
    } 
    return  CallWindowProc(oldListboxWndProc, hWnd, message, wParam, lParam);
} 

LRESULT CALLBACK WPComboWndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)

{
    switch (message)
    {
        case  WM_MOUSEMOVE :
            {
                TTTOOLINFOA   ti;

                GetWindowText(ItemHWnd(IDC_WPCOMBO), comboDirname, sizeof comboDirname);
                ti.cbSize = sizeof ti;                     // tooltip structure size
                ti.uFlags = TTF_IDISHWND|TTF_SUBCLASS;     // tool is a window
                ti.hinst = hInst;                          // instance
                ti.hwnd = hDialog;                         // handle to window owning tooltip dialog
                ti.uId = (UINT)ItemHWnd(IDC_WPCOMBO);      // handle to window for which tooltip is used
                ti.lpszText = comboDirname;
                SendMessage(                               // returns LRESULT in lResult
                    hwndTip,                               // handle to destination control
                    TTM_ADDTOOL,                           // message ID
                    0,                                     // = 0; not used, must be zero
                    (LPARAM)(LPTOOLINFO)&ti                // = (LPARAM) (LPTOOLINFO) lpti;
                    );
            } 
            return 0;
    } 
    return  CallWindowProc(oldComboWndProc, hWnd, message, wParam, lParam);
} 

void PopulateBitmapList(CHAR *dirname,bool recurse)
{
    WIN32_FIND_DATA FindFileData;
    HANDLE        hFind;
    CHAR          fullname[MAX_PATH];

    if (CB_ERR != SendMessage(ItemHWnd(IDC_WPCOMBO), CB_FINDSTRINGEXACT, -1, (LPARAM)dirname))
        return ;
    wsprintf(fullname, "%s\\*.bmp", dirname);
    hFind = FindFirstFile(fullname, &FindFileData);
    if (hFind != INVALID_HANDLE_VALUE)
    {
        SendMessage(ItemHWnd(IDC_WPCOMBO), CB_ADDSTRING, 0, (LPARAM)dirname);
        FindClose(hFind);
    } 
    wsprintf(fullname, "%s\\*", dirname);
    hFind = FindFirstFile(fullname, &FindFileData);
    BOOL          bFound = TRUE;

    if (recurse)
        do
        {
            if (FindFileData.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY && FindFileData.cFileName[0] != '.')
            {
                wsprintf(fullname, "%s\\%s", dirname, FindFileData.cFileName);
                PopulateBitmapList(fullname, true);
            } 
            bFound = FindNextFile(hFind, &FindFileData);
        }  while (bFound);
    FindClose(hFind);
} 

void InitBetaTab()
{
    WIN32_FIND_DATA FindFileData;
    HANDLE        hFind;
    CHAR          dirname[MAX_PATH];
    CHAR          fullname[MAX_PATH];
    CHAR          searchname[MAX_PATH];

    GetWindowText(ItemHWnd(IDC_WPCOMBO), dirname, MAX_PATH-50);
    wsprintf(fullname, "%s\\*.bmp", dirname);
    SendMessage(ItemHWnd(IDC_LIST1), LB_RESETCONTENT, NULL, NULL);
    hFind = FindFirstFile(fullname, &FindFileData);
    if (hFind != INVALID_HANDLE_VALUE)
    {
        strcpy(searchname, dirname);
        while (searchname[0] && searchname[strlen(searchname)-1] == '\\')
            searchname[strlen(searchname)-1] = 0;
        if (CB_ERR == SendMessage(ItemHWnd(IDC_WPCOMBO), CB_FINDSTRINGEXACT, -1, (LPARAM)searchname))
            SendMessage(ItemHWnd(IDC_WPCOMBO), CB_ADDSTRING, 0, (LPARAM)dirname);
        if (strcmp(szLastBitmapDirectory, dirname))
        {
            strcpy(szLastBitmapDirectory, szCurrentBitmapDirectory);
            strcpy(szCurrentBitmapDirectory, dirname);
        } 

        BOOL          bFound = TRUE;
        do
        {
            CHAR          fn[MAX_PATH];
            CHAR          *p;

            strcpy(fn, FindFileData.cFileName);
            if (p = strrchr(fn, '.'))
                *p = 0;
            SendMessage(ItemHWnd(IDC_LIST1), LB_ADDSTRING, NULL, (LPARAM)fn);
            bFound = FindNextFile(hFind, &FindFileData);
        }  while (bFound);
        FindClose(hFind);
    } 
    LRESULT       count = SendMessage(ItemHWnd(IDC_LIST1), LB_GETCOUNT, NULL, NULL);

    wsprintf(fullname, "%ld files", count);
    SendMessage(ItemHWnd(IDC_LIST1), LB_SETCURSEL, 0, NULL);
    SetWindowText(ItemHWnd(IDC_WPFN), fullname);
    SetWindowText(ItemHWnd(IDC_WPH), "");

    EnableWindow(ItemHWnd(IDC_WPSTART), (count > 0));
    EnableWindow(ItemHWnd(IDC_WPPREV), (count > 1));
    EnableWindow(ItemHWnd(IDC_WPNEXT), (count > 1));
} 

DWORD WINAPI BroadcastChange(LPVOID x)
{
    SendMessage(hDialog, ID_SETTINGCHANGE, SPI_SETDESKWALLPAPER, 0); //
        // Really should notify everyone...
   // SendMessageTimeout(HWND_BROADCAST, WM_SETTINGCHANGE, 0, 0, SMTO_NORMAL, 1000, 0);
    return 0;
} 

void EnableTestMode()
{
    RECT          rect,rect2;

    if (!bEnableTestMode)
    {
        TCITEM        tc;
        CHAR          appPath[MAX_PATH];
        CHAR          szCurrentWallpaper[MAX_PATH];
        CHAR          *wppath = NULL,*wpfile,*i;
        LRESULT       pathindex = -1,fileindex = -1;
          
        bEnableTestMode = TRUE;
        SendMessage(ItemHWnd(IDC_WPCOMBO), CB_RESETCONTENT, 0, 0);
        PopulateBitmapList("C:\\TEMP", true);
        if (m_SHGetSpecialFolderPath)
        {
            if (m_SHGetSpecialFolderPath(hDialog, appPath, CSIDL_PROFILE, TRUE))
                PopulateBitmapList(appPath, true);
        } 
        GetWindowsDirectory(szCurrentWallpaper, sizeof szCurrentWallpaper);
        PopulateBitmapList(szCurrentWallpaper, false);
        GetCurrentWallpaper(szCurrentWallpaper);
        wpfile = strrchr(szCurrentWallpaper, '\\');
        if (wpfile)
        {
            wpfile[0] = 0;                                 // null terminate path
            wpfile++;                                      // position to file name
            wppath = szCurrentWallpaper;
            i = strrchr(wpfile, '.');
            if (i)
                *i = 0;                                    // remove .bmp extension from file name
            PopulateBitmapList(wppath, false);
        } 
        GetWindowRect(hDialog, &rect);
        MoveWindow(hDialog, rect.left, rect.top, dwWindowWidth += 47, dwWindowHeight, TRUE);
        GetWindowRect(ItemHWnd(ID_TABBOX), &rect2);
        MoveWindow(ItemHWnd(ID_TABBOX), 4, 1, (rect2.right-rect2.left)+47, (rect2.bottom-rect2.top), TRUE);
        tc.mask = TCIF_TEXT;
        tc.pszText = "[ Test ]";
        SendMessage(ItemHWnd(ID_TABBOX), TCM_INSERTITEM, TABBETA, (LPARAM)&tc);
        CHAR          systemroot[MAX_PATH];
          
        if (!*szCurrentBitmapDirectory)
        {
            GetWindowsDirectory(systemroot, (ULONG)MAX_PATH);
            SetWindowText(ItemHWnd(IDC_WPCOMBO), systemroot);
        } 
        else
            SetWindowText(ItemHWnd(IDC_WPCOMBO), szCurrentBitmapDirectory);
        InitBetaTab();
        if (wppath)
            if (CB_ERR != (pathindex = SendMessage(ItemHWnd(IDC_WPCOMBO), CB_FINDSTRINGEXACT, -1, (LPARAM)wppath)))
            {
                SendMessage(ItemHWnd(IDC_WPCOMBO), CB_SETCURSEL, pathindex, 0);
                InitBetaTab();
                fileindex = SendMessage(ItemHWnd(IDC_LIST1), LB_FINDSTRING, -1, (LPARAM)wpfile);
                if (LB_ERR != fileindex)
                    SendMessage(ItemHWnd(IDC_LIST1), LB_SETCURSEL, fileindex, 0);
            } 
        SendMessage(ItemHWnd(ID_TABBOX), TCM_SETCURSEL, TABBETA, 0);
    } 
    else
    {
        SendMessage(ItemHWnd(ID_TABBOX), TCM_SETCURSEL, TABABOUT, 0);
        bEnableTestMode = FALSE;
        GetWindowRect(hDialog, &rect);
        MoveWindow(hDialog, rect.left, rect.top, dwWindowWidth -= 47, dwWindowHeight, TRUE);
        GetWindowRect(ItemHWnd(ID_TABBOX), &rect2);
        MoveWindow(ItemHWnd(ID_TABBOX), 4, 1, (rect2.right-rect2.left)-47, (rect2.bottom-rect2.top), TRUE);
        SendMessage(ItemHWnd(ID_TABBOX), TCM_DELETEITEM, TABBETA, (LPARAM)0);
    } 
    ReInitializeTabs(hDialog);
    CHAR          msg[200];
          
    wsprintf(msg, "Test mode is %s", bEnableTestMode?"Enabled":"Disabled");
    SetAutoStart(true);
    DebugStatus(msg);
} 

LRESULT CALLBACK TestImageWndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
    static bool   dbl = false;
          
    switch (message)
    {
        case  WM_PAINT :
            {
                PAINTSTRUCT   ps;
                RECT          rect;
                CHAR          dirname[MAX_PATH];
                CHAR          filename[MAX_PATH];
                CHAR          fullname[MAX_PATH];
                HWND          hListbox = ItemHWnd(IDC_LIST1);
                LRESULT       current = SendMessage(hListbox, LB_GETCURSEL, NULL, NULL);
                RECT          rectNormalized;
                BOOL          bOldStretchInner = icSettings.bStretchInner;
          
                BeginPaint(hWnd, &ps);
                GetWindowText(ItemHWnd(IDC_WPCOMBO), dirname, sizeof dirname);
                if (LB_ERR != SendMessage(hListbox, LB_GETTEXT, current, (LPARAM)filename))
                {
                    wsprintf(fullname, "%s\\%s.bmp", dirname, filename);
                    HBITMAP       hOrigBMP = (HBITMAP)LoadImage(hInst, fullname, IMAGE_BITMAP, 0, 0, LR_LOADFROMFILE);
          
                    if (hOrigBMP)
                    {
                        BITMAP        bmp;
                        SIZE          sz;
                                        // Retrieve the bitmap color format, width, and height.
          
                        GetObject(hOrigBMP, sizeof(BITMAP), (LPSTR)&bmp);
                        GetWindowRect(hWnd, &rect);
                        HBRUSH        hbr = GetSysColorBrush(COLOR_BTNFACE);
          
                        CopyRect(&rectNormalized, &rect);
                        OffsetRect(&rectNormalized, -rect.left, -rect.top);
                        FillRect(ps.hdc, &rectNormalized, hbr);

                        icSettings.bStretchInner = FALSE;
                        CalculateWallpaperScaling(bmp, rect.right-rect.left, rect.bottom-rect.top, &sz);
                        icSettings.bStretchInner = bOldStretchInner;
                                        //*************************
                        HDC           hdcScreen = GetDC(0);
                        HDC           hdcSource = CreateCompatibleDC(hdcScreen);
          
                        SetStretchBltMode(ps.hdc, HALFTONE);
                        HBITMAP       hScaledBMP = CreateCompatibleBitmap(hdcScreen, sz.cx, sz.cy);
          
                        SelectObject(hdcSource, hOrigBMP);
                        SelectObject(ps.hdc, hScaledBMP);
                        StretchBlt(ps.hdc, (rectNormalized.right-sz.cx)/2, (rectNormalized.bottom-sz.cy)/2, sz.cx, sz.cy, hdcSource, 0, 0, 
                            bmp.bmWidth, bmp.bmHeight, SRCCOPY);
                        DeleteObject(hOrigBMP);
                        DeleteDC(hdcSource);
                        ReleaseDC(NULL, hdcScreen);
                        DeleteObject(hScaledBMP);
                    } 
                } 
                EndPaint(hWnd, &ps);
            } 
            break;
        case  WM_LBUTTONDBLCLK :                           // double click - new wall paper
            {
                dbl = true;
                KillTimer(hDialog, 9);
                HWND          hListbox = ItemHWnd(IDC_LIST1);
                LRESULT       current = SendMessage(hListbox, LB_GETCURSEL, NULL, NULL);
                CHAR          dirname[MAX_PATH];
                CHAR          filename[MAX_PATH];
                CHAR          fullname[MAX_PATH];
          
                GetWindowText(ItemHWnd(IDC_WPCOMBO), dirname, sizeof dirname);
                if (LB_ERR != SendMessage(hListbox, LB_GETTEXT, current, (LPARAM)filename))
                {
                    wsprintf(fullname, "%s\\%s.bmp", dirname, filename);
                    ShellExecute(0, "open", fullname, NULL, NULL, SW_SHOWNORMAL);
                } 
            } 
            break;
        case  WM_LBUTTONDOWN :                             // single click - open picture
            dbl = false;
            break;
        case  WM_LBUTTONUP :                               // single click - open picture
            {
                if (!dbl)
                    SetTimer(hDialog, 9, GetDoubleClickTime()+100, 0);
            } 
            break;
        case  WM_RBUTTONDBLCLK :                           // right double click - open folder
            {
                CHAR          dirname[MAX_PATH];
          
                GetWindowText(ItemHWnd(IDC_WPCOMBO), dirname, sizeof dirname);
                ShellExecute(0, "open", dirname, NULL, NULL, SW_SHOWNORMAL);
            } 
            break;
        case  WM_MOUSEMOVE :
            {
                TTTOOLINFOA   ti;
                HWND          hListbox = ItemHWnd(IDC_LIST1);
                CHAR          filename[MAX_PATH];
                CHAR          dirname[MAX_PATH];
                LRESULT       current = SendMessage(hListbox, LB_GETCURSEL, NULL, NULL);
          
                picfullname[0] = 0;
                GetWindowText(ItemHWnd(IDC_WPCOMBO), dirname, sizeof dirname);
                if (LB_ERR != SendMessage(hListbox, LB_GETTEXT, current, (LPARAM)filename))
                    wsprintf(picfullname, "%s\\%s.bmp"     //
                        "\n\nLeft Click\tSet as wallpaper" //
                        "\nLeft DblClick\tOpen in default viewer" //
                        "\nRight DblClick\tOpen containing folder",  //
                        dirname, filename);
                ti.cbSize = sizeof ti;                     // tooltip structure size
                ti.uFlags = TTF_IDISHWND|TTF_SUBCLASS;     // tool is a window
                ti.hinst = hInst;                          // instance
                ti.hwnd = hDialog;                         // handle to window owning tooltip dialog
                ti.uId = (UINT)hWnd;                       // handle to window for which tooltip is used
                ti.lpszText = picfullname;
                SendMessage(                               // returns LRESULT in lResult
                    hwndTip,                               // handle to destination control
                    TTM_ADDTOOL,                           // message ID
                    0,                                     // = 0; not used, must be zero
                    (LPARAM)(LPTOOLINFO)&ti                // = (LPARAM) (LPTOOLINFO) lpti;
                    );
                SetCursor(LoadCursor(NULL, idc_hand));     // hand
            } 
            return 0;
    } 
    return  DefWindowProc(hWnd, message, wParam, lParam);
} 
