#include "stdafx.h"
#include "tr3.h"
void SaveIcons(HWND hWnd,BOOL bShowAutoArrangeMessage)
{
    LRESULT       a,iItemCount;
    DWORD         dwStyle;
    int           scrHeight,scrWidth;
    LRESULT       binPos;
    HKEY          hKey;
    SECURITY_ATTRIBUTES secattr;
    BYTE          regString[32000];
    TCHAR         WorkString[300];
    BOOL          offScreen;
    DWORD         disposition;
    TCHAR         szValue[30];
    TCHAR         szKeyName[18] = "Software\\SillySot";

    if (GetSystemMetrics(SM_CMONITORS) > 1)
    {
        scrWidth = GetSystemMetrics(SM_CXVIRTUALSCREEN);
        scrHeight = GetSystemMetrics(SM_CYVIRTUALSCREEN);
    } 
    else
    {
        scrWidth = GetSystemMetrics(SM_CXSCREEN);
        scrHeight = GetSystemMetrics(SM_CYSCREEN);
    } 

    if (icSettings.bAbsolutePosition)
        wsprintf(szValue, "SavedIcons_%d_%d", scrWidth, scrHeight);
    else
        strcpy(szValue, "SavedIcons_Relative");
    dwStyle = GetWindowLong(hListView, GWL_STYLE);
    if (LVS_AUTOARRANGE == (dwStyle&LVS_AUTOARRANGE) && bShowAutoArrangeMessage)
        if (IDNO == MessageBox(hWnd,                       //
            "The desktop is in \"Auto Arrange\" mode."     //
            "\n\nDo you want to save the icon positions?",  //
            szTitle, MB_ICONQUESTION|MB_APPLMODAL|MB_YESNO))
            return ;
    iItemCount = SendMessage(hListView, LVM_GETITEMCOUNT, 0, 0);
    if (iItemCount == 0)
    {
        ConditionalMessageBox(hWnd, "No icons found", szTitle, MB_ICONHAND|MB_APPLMODAL);
        return ;
    } 

    offScreen = FALSE;
    regString[0] = (BYTE)iItemCount;
    binPos = 1;                                            // skip 1st byte because it contans # of elements
    if (iItemCount <= MAX_EXISTING_ICONS-5)
    {
        EnterCriticalSection(&crObject);
        for (a = 0; a < iItemCount; a++)
        {
            SendMessage(hListView, pICNData->GetPosition, a, (LPARAM)pICNData);
            if (pICNData->icnptPosition.x >= scrWidth || pICNData->icnptPosition.x < 0 ||  //
                pICNData->icnptPosition.y >= scrHeight || pICNData->icnptPosition.y < 0)
                offScreen = TRUE;
            if (!icSettings.bAbsolutePosition)
            {
                pICNData->icnptPosition.x = (pICNData->icnptPosition.x *32768+scrWidth-1)/scrWidth;
                pICNData->icnptPosition.y = (pICNData->icnptPosition.y *32768+scrHeight-1)/scrHeight;
            } 
            memcpy(&regString[binPos], &pICNData->icnptPosition, sizeof POINT);

            binPos += sizeof POINT;
            if (binPos > (LRESULT)sizeof(regString)-pICNData->icnTxtLength-1)
            {
                MessageBox(hWnd, "Too many icons to save.""\nIconoid can only save 32000 bytes of data about icons."
                    "\n\nIcon positions were not saved.", szTitle, MB_ICONHAND|MB_APPLMODAL);
                binPos = 0;
            } 
            else
            {
                memcpy(&regString[binPos], &pICNData->icnIconText, pICNData->icnTxtLength);
                binPos += pICNData->icnTxtLength;
                regString[binPos++] = '\0';                // insure null terminated. icnTxtLength does not
            } 
        } 
        LeaveCriticalSection(&crObject);
    } 
    else
    {
        wsprintf(WorkString, "Too many icons to save.\nIconoid can only save %d icons.""\n\nIcon positions were not saved.", 
            MAX_EXISTING_ICONS-5);
        MessageBox(hWnd, WorkString, szTitle, MB_ICONHAND|MB_APPLMODAL);
        binPos = 0;
    } 

    if (binPos > 0                                         //
        && offScreen                                       //
        && IDNO == ConditionalMessageBox(hWnd, "Some icons are at least partially off screen."
        "\n\nDo you want to continue saving the icon positions?", szTitle, MB_ICONQUESTION|MB_YESNO|MB_APPLMODAL))
        binPos = 0;

    if (binPos)
    {
        secattr.nLength = sizeof SECURITY_ATTRIBUTES;
        secattr.lpSecurityDescriptor = 0;
        secattr.bInheritHandle = 1;
        if (ERROR_SUCCESS == RegCreateKeyEx(HKEY_CURRENT_USER, szKeyName, 0, "", 0, KEY_ALL_ACCESS, &secattr, &hKey, &disposition))
            if (hKey)
            {
                if (RegSetValueEx(hKey, szValue, NULL, REG_BINARY, regString, (DWORD)binPos))
                    RegDeleteValue(hKey, szValue);
                RegCloseKey(hKey);
            } 
    } 
} 

