// Sampler window - samples pixels for auto background detection
//

#include "stdafx.h"
#include "tr3.h"
#include "commctrl.h"
#include "mmsystem.h"
// Global Variables:
// Foward declarations of functions included in this code module:
LRESULT CALLBACK SamplerWndProc(HWND,UINT,WPARAM,LPARAM)

{
    return (LRESULT)0;
} 

LRESULT CALLBACK UserSamplerWndProc(HWND,UINT,WPARAM,LPARAM);
COLORREF SampleAreaNearCursor(HDC);
BOOL          bButtonDown = FALSE;                         // indicator of RIGHT button down for screen sampling
COLORREF      crSampledColor;
//-------------------------------------------------------------------------
//
//
void ShowVar(char *text,UINT var)
{
    TCHAR         szMsgBox[200];

    wsprintf(szMsgBox, text, var);
    MessageBox(0, szMsgBox, "Debug thingy", MB_APPLMODAL);
} 

void SampleScreen(HWND hOwner,LPCOLORREF crNewColor,BOOL bUserSelect)
{
    // TODO: Place code here.
    MSG           msg;
    WNDCLASSEX    wcex;
    HWND          hWnd;

    if (!bUserSelect)
    {
        GetCurrentWallpaper(szWallPaper);
        if (!*szWallPaper)
        {
            *crNewColor = GetSysColor(COLOR_DESKTOP);
            return ;
        } 
        else
        {
            SetTimer(hDialog, 29, 500, 0);
            EnableWindow(ItemHWnd(ID_CMDAUTO), FALSE);
            HBITMAP       hbmp = ReadWallPaper();
          
            if (hbmp)
                DeleteObject(hbmp);
            *crNewColor = SamplePartialScreen1(*crNewColor);
            EnableWindow(ItemHWnd(ID_CMDAUTO), TRUE);
            wpUseCount--;
            return ;
        } 
    } 

    wcex.cbSize = sizeof(WNDCLASSEX);
    wcex.style = CS_HREDRAW|CS_VREDRAW;
    wcex.lpfnWndProc = bUserSelect?(WNDPROC)UserSamplerWndProc:(WNDPROC)SamplerWndProc;
    wcex.cbClsExtra = 0;
    wcex.cbWndExtra = 0;
    wcex.hInstance = hInst;
    wcex.hIcon = 0;                                        // LoadIcon(hInstance, (LPCTSTR)IDI_TR3);
    wcex.hCursor = 0;                                      // LoadCursor(NULL, IDC_ARROW);
    wcex.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
    wcex.lpszMenuName = 0;                                 // (LPCSTR)IDC_TR3;
    wcex.lpszClassName = "ICSampler";
    wcex.hIconSm = 0;                                      // LoadIcon(wcex.hInstance, (LPCTSTR)IDI_SMALL);
    RegisterClassEx(&wcex);
    // Perform application initialization:
    hWnd = CreateWindowEx(WS_EX_TOPMOST, "ICSampler", "Sampler", WS_VISIBLE|WS_POPUP, 0, 0, GetSystemMetrics(SM_CXSCREEN), GetSystemMetrics
        (SM_CXSCREEN), hOwner, NULL, hInst, NULL);
    crSampledColor = *crNewColor;
    ShowWindow(hWnd, SW_SHOW);
    UpdateWindow(hWnd);
// Main message loop:
    while (GetMessage(&msg, NULL, 0, 0))
    {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
    } 
    UnregisterClass("ICSampler", hInst);
    *crNewColor = crSampledColor;
    return ;
} 

//

COLORREF SampleAreaNearCursor(HDC hdc)
{
    ULONG         iRed = 0,iGreen = 0,iBlue = 0,iPixelCount = 0;
    COLORREF      crPixel;
    int           x,y;
    POINT         ptCsr;
    int           minX,minY,maxX,maxY,deltaX,deltaY;

    GetCursorPos(&ptCsr);
    maxX = GetSystemMetrics(SM_CXSCREEN);
    maxY = GetSystemMetrics(SM_CYSCREEN);
    deltaX = 15;                                           // sample up to 30 pixels up and down
    deltaY = 15;                                           // sample up to 30 pixels left and right
    minX = max(0, ptCsr.x-deltaX);
    maxX = min(maxX, ptCsr.x+deltaX);
    minY = max(0, ptCsr.y-deltaY);
    maxY = min(maxY, ptCsr.y+deltaY);
    for (x = minX; x < maxX; x += 1)
        for (y = minY; y < maxY; y += 1)
        {
            iPixelCount++;
            crPixel = GetPixel(hdc, x, y);
            iRed += GetRValue(crPixel);
            iGreen += GetGValue(crPixel);
            iBlue += GetBValue(crPixel);
        } 
    iRed /= iPixelCount;
    iGreen /= iPixelCount;
    iBlue /= iPixelCount;
    return  RGB(iRed, iGreen, iBlue);
} 

LRESULT CALLBACK UserSamplerWndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
    POINT         pt;
    static HDC    hdc;
    static const CHAR *szInstructions = "  Left click=Single Pixel,Right click= Area Average  ";
    HBRUSH        hBrush;
    HFONT         hfnt,hOldFont = NULL;
    ;
    HPEN          hPen;

    SIZE          sz;
    static RECT   rect,rect2;
    static int    scrHeight = GetSystemMetrics(SM_CYSCREEN);
    static int    scrWidth = GetSystemMetrics(SM_CXSCREEN);
    static HRGN   rgn1,rgn2;
    static RECT   textRect;
    static RECT   rectText;

    switch (message)
    {
        case  WM_CREATE :
            SetCursor(LoadCursor(NULL, IDC_CROSS));
            SetWindowPos(hWnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE|SWP_NOSIZE|SWP_SHOWWINDOW);
            SetWindowPos(hWnd, HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOMOVE|SWP_NOSIZE|SWP_SHOWWINDOW);
            hfnt = (HFONT)GetStockObject(SYSTEM_FONT);
            hdc = GetDC(hWnd);
            bUserPressedEscape = FALSE;
            SetRect(&rect, 0, 0, 0, 0);
            SetRect(&rect2, 0, 0, 0, 0);
            break;
        case  WM_CHAR :
            if (wParam == VK_ESCAPE)
            {
                bUserPressedEscape = TRUE;
                SendMessage(hWnd, WM_CLOSE, 0, 0);
            } 
            break;
        case  WM_MOUSEMOVE :
            {
                pt.x = LOWORD(lParam);
                pt.y = HIWORD(lParam);
                InvalidateRect(hWnd, &textRect, TRUE);
           //     InvalidateRect(hWnd, &rect, TRUE);
          //      InvalidateRect(hWnd, &rect2, TRUE);
                hfnt = (HFONT)GetStockObject(ANSI_VAR_FONT);
                hOldFont = (HFONT)SelectObject(hdc, hfnt);
                GetTextExtentPoint32(hdc, szInstructions, (int)strlen(szInstructions), &sz);
                SetRect(&textRect,                         //
                    min(scrWidth-4-sz.cx, pt.x+15),        //
                    min(scrHeight-sz.cy-60, pt.y+15),      //
                    min(scrWidth, pt.x+25+sz.cx),          //
                    min(scrHeight-50, pt.y+sz.cy+25));
                                          //
                rgn1 = CreateRectRgn(rect.left-3, rect.top-3, rect.right+3, rect.bottom+3);
                rgn2 = CreateRectRgn(rect2.left-3, rect2.top-3, rect2.right+3, rect2.bottom+3);
                rect.left = textRect.left+10;
                rect.top = textRect.bottom+4;
                rect.right = rect.left+80;
                rect.bottom = rect.top+40;
                CopyRect(&rect2, &rect);
                OffsetRect(&rect2, 90, 0);
                HRGN          rgn3 = CreateRectRgn(rect.left+3, rect.top+3, rect.right-3, rect.bottom-3);
                HRGN          rgn4 = CreateRectRgn(rect2.left+3, rect2.top+3, rect2.right-3, rect2.bottom-3);
          
                CombineRgn(rgn1, rgn1, rgn3, RGN_XOR);
                CombineRgn(rgn2, rgn2, rgn4, RGN_XOR);
                InvalidateRgn(hWnd, rgn1, TRUE);
                InvalidateRgn(hWnd, rgn2, TRUE);
                UpdateWindow(hWnd);
                DeleteObject(rgn1);
                DeleteObject(rgn2);
                DeleteObject(rgn3);
                DeleteObject(rgn4);

                hPen = (HPEN)CreatePen(PS_SOLID, 3, WHITE);
                hPen = (HPEN)SelectObject(hdc, hPen);
                hBrush = CreateSolidBrush(GetPixel(hdc, pt.x, pt.y));
                hBrush = (HBRUSH)SelectObject(hdc, hBrush);
                RoundRect(hdc, rect.left, rect.top, rect.right, rect.bottom, (rect.top-rect.bottom)/3, (rect.top-rect.bottom)/3);
                DeleteObject(SelectObject(hdc, hBrush));
                hBrush = CreateSolidBrush(SampleAreaNearCursor(hdc));
                hBrush = (HBRUSH)SelectObject(hdc, hBrush);
                RoundRect(hdc, rect2.left, rect2.top, rect2.right, rect2.bottom, (rect2.top-rect2.bottom)/3, (rect2.top-rect2.bottom)/3);
                DeleteObject(SelectObject(hdc, hBrush));

                DeleteObject((HPEN)SelectObject(hdc, hPen));
                hBrush = CreateSolidBrush(RGB(255, 255, 255));
                hBrush = (HBRUSH)SelectObject(hdc, hBrush);
                Rectangle(hdc, textRect.left, textRect.top, textRect.right, textRect.bottom);
                DeleteObject(SelectObject(hdc, hBrush));

                DrawText(hdc, szInstructions, (int)strlen(szInstructions), &textRect, DT_CENTER|DT_VCENTER|DT_SINGLELINE);
                SelectObject(hdc, hOldFont);
                SetTimer(hWnd, 22, 2000, NULL);
            } 
            return 0;
        case  WM_TIMER :
            KillTimer(hWnd, 22);
            InvalidateRect(hWnd, &textRect, TRUE);
            rgn1 = CreateRectRgn(rect.left-3, rect.top-3, rect.right+3, rect.bottom+3);
            rgn2 = CreateRectRgn(rect2.left-3, rect2.top-3, rect2.right+3, rect2.bottom+3);

            InvalidateRgn(hWnd, rgn1, TRUE);
            InvalidateRgn(hWnd, rgn2, TRUE);
            UpdateWindow(hWnd);
            DeleteObject(rgn1);
            DeleteObject(rgn2);
            return 0;
        case  WM_LBUTTONDOWN :
            crSampledColor = GetPixel(hdc, LOWORD(lParam), HIWORD(lParam));
            SendMessage(hWnd, WM_CLOSE, 0, 0);
            return 0;
        case  WM_RBUTTONDOWN :
            bButtonDown = TRUE;
            return 0;
        case  WM_RBUTTONUP :
            if (bButtonDown)
            {
                crSampledColor = SampleAreaNearCursor(hdc);
                bButtonDown = FALSE;
                SendMessage(hWnd, WM_CLOSE, 0, 0);
            } 
            return 0;
        case  WM_PAINT :
            {
                PAINTSTRUCT   ps;

                BeginPaint(hWnd, &ps);
                PaintDesktop(ps.hdc);
                EndPaint(hWnd, &ps);
            } 
            break;
        case  WM_DESTROY :
            KillTimer(hWnd, 22);
            ReleaseDC(hWnd, hdc);
            SetCursor(LoadCursor(NULL, IDC_ARROW));
            PostQuitMessage(0);
            break;
        default  :
            return  DefWindowProc(hWnd, message, wParam, lParam);
    } 
    return 0;
} 

COLORREF GetAutoFG()
{
    COLORREF      crAutomatic;

    if (icSettings.bAutoFG)
    {
        UINT          iRGBSum;

        iRGBSum = GetRValue(icSettings.crBackColor)+       //
            GetGValue(icSettings.crBackColor)+             //
                GetBValue(icSettings.crBackColor);         //
        crAutomatic = (iRGBSum <= 390)?RGB(255, 255, 255):0;
        //      ShowVar("Rgb Sum : %d",iRGBSum);
    } 
    else
    {
        crAutomatic = RGB(                                 //
            ((128 > GetRValue(icSettings.crBackColor))?255:0),  //
            ((128 > GetGValue(icSettings.crBackColor))?255:0),  //
            ((128 > GetBValue(icSettings.crBackColor))?255:0) //
            );
    } 

    return  crAutomatic;
} 

COLORREF SamplePartialScreen1(COLORREF crStart)
{
    LONG          bmpWidth;
    LONG          bmpHeight;
    LRESULT       a,iItemCount,X,Y;
    int           iPixelCount = 0;
    int           iRed = 0,iGreen = 0,iBlue = 0;
    RGBTRIPLE     crPixel,rgbtBackground;
    COLORREF      crBackground;
    POINT         ptItemPosition = 
    {
        0,0
    } 
    ;
    BOOL          bTiled = 49 == RegReadDWord("Control Panel\\Desktop", "TileWallpaper");
    BOOL          bStretched = 50 == RegReadDWord("Control Panel\\Desktop", "WallpaperStyle");
    LONG          scrWidth = GetSystemMetrics(SM_CXSCREEN);
    LONG          scrHeight = GetSystemMetrics(SM_CYSCREEN);
    LRESULT       iX = 0,iY = 0,iLeftBnd = 0,iRightBnd = 0,iTopBnd = 0,iBottomBnd = 0;
    BOOL          iValidPixel;
//      crBackground=crStart;
          
    crBackground = GetSysColor(COLOR_DESKTOP);
    if (rgbBMPArray && bmi.bmiHeader.biWidth != 0)
    {
 //   RGBTRIPLE     *pixel;
        int           scanwidth = (3+bmi.bmiHeader.biWidth *3)&~3;
          
        bmpWidth = bmi.bmiHeader.biWidth;
        bmpHeight = bmi.bmiHeader.biHeight;
        if (!bTiled && !bStretched)
        {
            iLeftBnd = max(0, (scrWidth-bmpWidth)/2);
            iRightBnd = min(scrWidth, iLeftBnd+bmpWidth+1);
            iTopBnd = max(0, (scrHeight-bmpHeight)/2);
            iBottomBnd = min(scrHeight, iTopBnd+bmpHeight+1);
            rgbtBackground.rgbtRed = GetRValue(crBackground);
            rgbtBackground.rgbtGreen = GetGValue(crBackground);
            rgbtBackground.rgbtBlue = GetBValue(crBackground);
        } 
        iItemCount = SendMessage(hListView, LVM_GETITEMCOUNT, 0, 0);
        if (iItemCount == 0)
        {
            if (!IsShowDesktop())
                MessageBox(0, "No icons found.\n\nUnable to sample screen colors.", szTitle, MB_ICONHAND|MB_APPLMODAL);
            return  crBackground;                          // default to current background color
        } 

        EnterCriticalSection(&crObject);
        for (a = 0; a < iItemCount; a++)
        {
            SetRectEmpty(&pICNData->icnRect);
            pICNData->icnRect.left = LVIR_LABEL;
            SendMessage(hListView, pICNData->GetPosition, a, 0);
            for (X = pICNData->icnRect.left-8; X <= pICNData->icnRect.right+8; X++)
                for (Y = pICNData->icnRect.top-8; Y <= pICNData->icnRect.bottom+8; Y++)
                    if ((X < pICNData->icnRect.left || X > pICNData->icnRect.right) || (Y < pICNData->icnRect.top || Y > 
                        pICNData->icnRect.bottom))
                    {
                        iValidPixel = FALSE;
                        if (bTiled)                        // Tiled
                        {
                            iX = X%bmpWidth;
                            iY = bmpHeight-Y%bmpHeight;
                        } 
                        else
                            if (bStretched)                // Stretched
                            {
                                iX = (X *bmpWidth)/scrWidth;
                                iY = ((scrHeight-Y)*bmpHeight)/scrHeight;
                            } 
                            else                           // Centered
                                if (X < iLeftBnd || X > iRightBnd || Y < iTopBnd || Y > iBottomBnd)
                                {
                                    if (X < scrWidth && Y < scrHeight && X >= 0 && Y >= 0)
                                    {
                                        crPixel = rgbtBackground;
                                        iValidPixel = TRUE;
                                    } 
                                } 
                                else
                                {
                                    iX = X-iLeftBnd;
                                    iY = (scrHeight-Y)-iTopBnd;
                                } 
                        if (!iValidPixel)
                            if (iX < bmpWidth && iY < bmpHeight && iX >= 0 && iY >= 0)
                            {
                                //i = iY *bmpWidth+iX;
                                //crPixel = rgbBMPArray[i];
                                crPixel = *((RGBTRIPLE *)(((BYTE *)rgbBMPArray)+(iY *scanwidth+3*iX)));
                                iValidPixel = TRUE;
                            } 
                        if (iValidPixel)
                            if (iPixelCount < 0xFFFF00)
                            {
                                iRed += crPixel.rgbtRed;
                                iGreen += crPixel.rgbtGreen;
                                iBlue += crPixel.rgbtBlue;
                                iPixelCount = iPixelCount+1;
                            } 
                    } 
        } 
        LeaveCriticalSection(&crObject);
        if (iPixelCount)
        {
            iRed /= iPixelCount;
            iGreen /= iPixelCount;
            iBlue /= iPixelCount;
        } 
        return  RGB(iRed, iGreen, iBlue);
    } 
    else
    {
        return  crBackground;                              // default to current background color
    } 
} 
