#include "stdafx.h"
#include "tr3.h"
void RestoreIcons(HWND hWnd)

{
 // The save and restore icon logic is a stinking, wretched, execrable mess and could be cleaned up
 // significantly.  Better structure (subroutines), better use of CopyMemory etc.
// The basic idea is to stablize the saved (known) locations,) stablize the new (unknown) icons that
 // don// t overlay saved positions, and) find a home for the new icons that do overlay either
 // the saved icons or the stablized new ones.  That last part is slow because right now we do a
 // scan of the desktop a pixel location at a time and loop through all the icon positions.
 // In a real programming language, we could do a decent data structure to speed this up.
 // A bit of intelligent skipping is added here.
    DWORD         dwStyle;

    TCHAR         szKeyName[18] = "Software\\SillySot";
    LONG          spacingX,spacingY;
    LRESULT       ItemCount,c,r;
    LRESULT       NumberOfSavedIcons,d,a;
    LRESULT       binPos;
    LRESULT       dx,dy,iLowX,iLowY;
    LRESULT       iconWidth;
    LONG          scrHeight,scrWidth;
    DWORD         dwType;
    HKEY          hKey;
    TCHAR         WorkString[32000];
    DWORD         dwDataSize;
    BOOL          KeyRetrieved = FALSE,bOccupied;
    POINT         SavedPT[MAX_EXISTING_ICONS];
    char          *SavedIconTexts[MAX_EXISTING_ICONS];
    RECT          rectTemp,rectTemp2;
    char          CurrentIconTexts[250][MAX_EXISTING_ICONS];
    POINT         ptCurrent[MAX_EXISTING_ICONS];
    BOOL          bPositionLocked[MAX_EXISTING_ICONS];
    RECT          LabelRECT[MAX_EXISTING_ICONS];
    LRESULT       iRetry,lastR;
    BOOL          NoMoreEmpties;
    char          szValue[64];

    if (pICNData->bDancinFools)
    {
        pICNData->bDancinFools = FALSE;
        Sleep(200);
    } 
    ItemCount = SendMessage(hListView, LVM_GETITEMCOUNT, 0, 0);
    dwStyle = GetWindowLong(hListView, GWL_STYLE);
    if (LVS_AUTOARRANGE == (dwStyle&LVS_AUTOARRANGE))
    {
        TCHAR         outmsg[200];

        strcpy(outmsg, "Icons can not be restored while"   //
            "\nthe desktop is in \"Auto Arrange\" mode."   //
            "\n\nUncheck Arrange Icons->Auto Arrange on the" //
            "\ndesktop to disable \"Auto Arrange\" mode.");
        if (icSettings.bAutoRestore)
            strcat(outmsg,                                 //
                "\n\nIconoid is disabling automatic repositioning" //
                "\non its \"Positions\" tab.");
        ConditionalMessageBox(hWnd, outmsg, szTitle, MB_APPLMODAL|MB_ICONASTERISK);
        icSettings.bAutoRestore = FALSE;
        CheckDlgButton(hWnd, ID_AUTORESTORE, icSettings.bAutoRestore);

        return ;
    } 

    if (ItemCount > MAX_EXISTING_ICONS)
    {
        wsprintf(WorkString, "Iconoid can only restore icon positions when" //
            "\nthere are %d icons or less on the screen."  //
            "\nYou currently have %d icons displayed",     //
            MAX_EXISTING_ICONS, ItemCount);
        ConditionalMessageBox(hWnd, WorkString, szTitle, MB_APPLMODAL|MB_ICONASTERISK);

        return ;
    } 

    iconWidth = GetSystemMetrics(SM_CXICON);
    spacingY = (long)SendMessage(hListView, LVM_GETITEMSPACING, FALSE, 0);
    spacingX = HIWORD(spacingY);
    spacingY = LOWORD(spacingY);

    if (GetSystemMetrics(SM_CMONITORS) > 1)
    {
        scrWidth = GetSystemMetrics(SM_CXVIRTUALSCREEN);
        scrHeight = GetSystemMetrics(SM_CYVIRTUALSCREEN);
    } 
    else
    {
        scrWidth = GetSystemMetrics(SM_CXSCREEN);
        scrHeight = GetSystemMetrics(SM_CYSCREEN);
    } 

    if (icSettings.bAbsolutePosition)
        wsprintf(szValue, "SavedIcons_%d_%d", scrWidth, scrHeight);
    else
        strcpy(szValue, "SavedIcons_Relative");
    hKey = 0;
    RegOpenKeyEx(HKEY_CURRENT_USER, szKeyName, NULL, KEY_ALL_ACCESS, &hKey);
    if (hKey)
    {
        if (ERROR_SUCCESS == RegQueryValueEx(hKey, szValue, NULL, &dwType, NULL, &dwDataSize))
        {
            RegQueryValueEx(hKey, szValue, NULL, &dwType, (BYTE *)&WorkString, &dwDataSize);
            KeyRetrieved = TRUE;
        } 
        ;
        RegCloseKey(hKey);
    } 

    if (KeyRetrieved)
    {
        binPos = 1;
        NumberOfSavedIcons = (unsigned char)WorkString[0];
        for (a = 0; a < NumberOfSavedIcons; a++)
        {
            memcpy(&SavedPT[a], &WorkString[binPos], sizeof POINT);
            binPos += sizeof POINT;
            SavedIconTexts[a] = &WorkString[binPos];
            if (!icSettings.bAbsolutePosition)
            {
                SavedPT[a].x = (SavedPT[a].x *scrWidth)/32768;
                SavedPT[a].y = (SavedPT[a].y *scrHeight)/32768;
            } 
            binPos = binPos+1+strlen(SavedIconTexts[a]);   // skip the string and zero byte
        } 
//
        ShowWindow(hListView, SW_HIDE);

        for (iRetry = 1; iRetry <= 3; iRetry++)            // ***** CHANGE THIS BACK TO 3 ***************
        {
            for (a = 0; a < ItemCount; a++)
                bPositionLocked[a] = FALSE;
            NoMoreEmpties = FALSE;                         // assume there are still open places for icons
            binPos = 0;
 // -------------------------------------------------------------------------
 // Lock the existing saved icons into position
 // -------------------------------------------------------------------------
 //

            EnterCriticalSection(&crObject);
            for (a = 0; a < ItemCount; a++)
            {
                SendMessage(hListView, pICNData->GetPosition, a, 0);
 // Move icons back on the screen

                if (pICNData->icnptPosition.x < 0          //
                    || pICNData->icnptPosition.x >= scrWidth //
                    || pICNData->icnptPosition.y < 0       //
                    || pICNData->icnptPosition.y >= scrHeight)
                {
                    pICNData->icnptPosition.x = min(pICNData->icnptPosition.x, scrWidth-spacingX);
                    pICNData->icnptPosition.x = max(pICNData->icnptPosition.x, 0);
                    pICNData->icnptPosition.y = min(pICNData->icnptPosition.y, scrHeight-spacingY);
                    pICNData->icnptPosition.y = max(pICNData->icnptPosition.y, 0);

                    SendMessage(hListView, pICNData->SetPosition, a, 0);
                    SendMessage(hListView, pICNData->GetPosition, a, 0);

                } 
                ptCurrent[a] = pICNData->icnptPosition;
                strcpy(CurrentIconTexts[a], pICNData->icnIconText);
                LabelRECT[a] = pICNData->icnRectBounds;
                for (d = 0; d < NumberOfSavedIcons && !bPositionLocked[a]; d++)
                    if (!strcmp(CurrentIconTexts[a], SavedIconTexts[d]))
                    {
                        bPositionLocked[a] = TRUE;
                        ptCurrent[a] = SavedPT[d];
                        pICNData->icnptPosition = ptCurrent[a];
                        SendMessage(hListView, pICNData->SetPosition, a, 0);
                        SendMessage(hListView, pICNData->GetPosition, a, 0);
                        LabelRECT[a] = pICNData->icnRectBounds;

                        SavedIconTexts[d][0] = 0;          // clear text so similarly named icons don't use it

                    } 
            } 
// ----------------------------------------------------------------------
// Get origin of grid by moving something to 0,0, aligning it, getting the position, and
// then moving everything back --- there must be an easier way, but I can't find it.
// ----------------------------------------------------------------------

            pICNData->icnptPosition.x = 0;
            pICNData->icnptPosition.y = 0;
            SendMessage(hListView, pICNData->SetPosition, 0, 0);
            SendMessage(hListView, LVM_ARRANGE, LVA_SNAPTOGRID, 0);
            SendMessage(hListView, pICNData->GetPosition, 0, 0);
            iLowX = pICNData->icnptPosition.x;
            iLowY = pICNData->icnptPosition.y;
            LeaveCriticalSection(&crObject);
 // -------------------------------------------------------------------------
 // Lock all new (not saved) icons that have no conflicts with saved ones.
 // -------------------------------------------------------------------------
 //

            if (iRetry < 3)                                // if we aren't desparately looking for space
                for (a = 0; a < ItemCount; a++)
                {
                    if (!bPositionLocked[a])
                    {
                        bOccupied = FALSE;
                        for (d = 0; d < ItemCount; d++)
                            if (bPositionLocked[d])
                            {
                                if (IntersectRect(&rectTemp, &LabelRECT[a], &LabelRECT[d])) // Position occupied?
                                {
                                    bOccupied = TRUE;
                                    d = ItemCount+10;      // exit for loop
                                } 
                            } 
                        bPositionLocked[a] = !bOccupied;   // reserve space for new icons that have no conflicts
                    } 
                } 
 // -------------------------------------------------------------------------
 // at this point icons that still have no home have bPositionLocked=FALSE.
 // Search for a home for the still homeless new icons.
 // -------------------------------------------------------------------------
 //
            if (iRetry < 3)
            {
                dx = spacingX;
                dy = spacingY;
            } 
            else
                dx = dy = 1;

            lastR = iLowY;
            for (a = 0; a < ItemCount; a++)
            {
                bOccupied = FALSE;
                if (!bPositionLocked[a])
                {
                    for (r = lastR; r <= scrHeight-spacingX; r += dy)
                    {
                        for (c = iLowX; c <= scrWidth-spacingY; c += dx)
                        {
                            bOccupied = FALSE;
                            for (d = 0; d < ItemCount; d++)
                                if (d != a && bPositionLocked[d])
                                {
                                    if (iRetry < 3)
                                    {
                                        SetRect(&rectTemp, (long)c, (long)r, (long)c+spacingX, (long)r+spacingY);
                                        if (IntersectRect(&rectTemp2, &rectTemp, &LabelRECT[d])) // redo this
                                        {
                                            bOccupied = TRUE;
                                            d = ItemCount+10; // Exit For
                                        } 
                                    } 
                                    else                   // iRetry = 3 : try rects instead of grid
                                    {
                                        rectTemp.top = (long)r;
                                        rectTemp.bottom = (long)r+LabelRECT[a].bottom-LabelRECT[a].top;
                                        rectTemp.left = (long)c;
                                        rectTemp.right = (long)c+LabelRECT[a].right-LabelRECT[a].left;

                                        if (IntersectRect(&rectTemp2, &rectTemp, &LabelRECT[d]))
                                        {
                                            bOccupied = TRUE;
                                            c = rectTemp.right+1; // skip the offending rectangle
                                            d = ItemCount+10; // Exit For
                                        } 
                                    } 
                                } 

                            if (!bOccupied)
                            {
                                bPositionLocked[a] = TRUE;
                                LabelRECT[a] = rectTemp;
                                ptCurrent[a].y = (long)r;
                                ptCurrent[a].x = (long)c;
                                if (3 == iRetry)
                                {
                                    ptCurrent[a].x += max(0, ptCurrent[a].x-LabelRECT[a].left);
                                } 
                                c = scrWidth;              // Exit For
                            } 
                        } 
                        lastR = r;
                        if (bPositionLocked[a])
                            r = scrHeight;                 // exit for
                    } 
                }                                          // end if
                if (!bPositionLocked[a])
                {
                    NoMoreEmpties = TRUE;
                    a = ItemCount+10;                      // Exit For
                } 
            }                                              // Next a
            if (NoMoreEmpties)
            {
                if (1 == iRetry)                           // OK, no space. Try arranging all icons and do it all again.
                    SendMessage(hListView, LVM_ARRANGE, LVA_SNAPTOGRID, 0);
            } 
            else                                           // NoMoreEmpties is FALSE
                iRetry = 4;                                // Exit For -- everything was positioned. Don't do it again.
        } 

        EnterCriticalSection(&crObject);
        for (a = 0; a < ItemCount; a++)
        {
            pICNData->icnptPosition = ptCurrent[a];
            SendMessage(hListView, pICNData->SetPosition, a, 0);
        } 
        LeaveCriticalSection(&crObject);
        if (NoMoreEmpties)
        {
            ConditionalMessageBox(hWnd, "Iconoid could not find enough empty spaces for icons" //
                "\nwhich were created since the last \"Save\" or are off the screen." //
                "\n\nSome icons may overlap or remain off screen.", szTitle, MB_APPLMODAL|MB_ICONHAND);
        } 
    } 
    if (icSettings.bAutoAuto && !icSettings.bTransparent)
        SendMessage(hWnd, WM_COMMAND, ID_CMDAUTO, 0);
    ShowWindow(hListView, icSettings.bAlwaysHide?SW_HIDE:SW_SHOW);
    bIconsAreScrambled = FALSE;
    EnableWindow(ItemHWnd(IDC_CMDSAVERELATIVE), TRUE);
} 

#ifdef   scramble
void RandomizeIcons()
{
    DWORD         dwStyle;
    LRESULT       a,b,spacingX,spacingY,iLowX,iLowY;
    LRESULT       ItemCount;
    LRESULT       scrHeight,scrWidth;

    dwStyle = GetWindowLong(hListView, GWL_STYLE);
    ItemCount = SendMessage(hListView, LVM_GETITEMCOUNT, 0, 0);
    if (LVS_AUTOARRANGE == (dwStyle&LVS_AUTOARRANGE))
    {
        if (pICNData->bDancinFools)
        {
            pICNData->bDancinFools = FALSE;
            Sleep(200);
            ReInitializeTabs(hDialog);
        } 
        MessageBox(hDialog, "Icons can not be randomized while" //
            "\nthe desktop is in \"Auto Arrange\" mode."   //
            "\n\n\nUncheck Arrange Icons->Auto Arrange.",  //
            szTitle, MB_APPLMODAL|MB_ICONASTERISK);
        return ;
    } 

    spacingY = SendMessage(hListView, LVM_GETITEMSPACING, FALSE, 0);
    spacingX = HIWORD(spacingY);
    spacingY = LOWORD(spacingY);

    if (GetSystemMetrics(SM_CMONITORS) > 1)
    {
        scrWidth = GetSystemMetrics(SM_CXVIRTUALSCREEN)-spacingX;
        scrHeight = GetSystemMetrics(SM_CYVIRTUALSCREEN)-spacingY;
    } 
    else
    {
        scrWidth = GetSystemMetrics(SM_CXSCREEN)-spacingX;
        scrHeight = GetSystemMetrics(SM_CYSCREEN)-spacingY;
    } 
    ShowWindow(hListView, SW_HIDE);
    EnterCriticalSection(&crObject);
    for (a = 0; a < ItemCount; a++)
    {
        pICNData->icnptPosition.y = -3*(long)spacingY;
        pICNData->icnptPosition.x = -3*(long)spacingX;

        SendMessage(hListView, pICNData->SetPosition, a, 0);
    } 
// ----------------------------------------------------------------------
// Get origin of grid by moving something to 0,0, aligning it, getting the position, and
// then moving everything back --- there must be an easier way, but I can't find it.
// ----------------------------------------------------------------------

    pICNData->icnptPosition.x = 0;
    pICNData->icnptPosition.y = 0;
    SendMessage(hListView, pICNData->SetPosition, 0, 0);
    SendMessage(hListView, LVM_ARRANGE, LVA_SNAPTOGRID, 0);
    SendMessage(hListView, pICNData->GetPosition, 0, (LPARAM)pICNData);
    iLowX = pICNData->icnptPosition.x;
    iLowY = pICNData->icnptPosition.y;
    pICNData->icnptPosition.y = -3*(long)spacingY;
    pICNData->icnptPosition.x = -3*(long)spacingX;
    SendMessage(hListView, pICNData->SetPosition, 0, 0);
// ----------------------------------------------------------------------
    for (a = 0; a < ItemCount; a++)
    {
        for (b = 0; b < 30; b++)
        {
// pICNData->icnptPosition.y = iLowY+((rand()%scrHeight)/spacingY)*spacingY;
// pICNData->icnptPosition.x = iLowX+((rand()%scrWidth)/spacingX)*spacingX;
            pICNData->icnptPosition.y = (long)iLowY+((rand()%(long)scrHeight));
            pICNData->icnptPosition.x = (long)iLowX+((rand()%(long)scrWidth));
            pICNData->LVHitTestInfo.pt = pICNData->icnptPosition;
            pICNData->LVHitTestInfo.flags = 0;
            SendMessage(hListView, pICNData->HitTest, 0, 0);

            if (pICNData->LVHitTestInfo.flags&LVHT_NOWHERE)
            {
                pICNData->LVHitTestInfo.pt = pICNData->icnptPosition;
                pICNData->LVHitTestInfo.pt.x = pICNData->icnptPosition.x+(long)spacingX-1;
                pICNData->LVHitTestInfo.pt.y = pICNData->icnptPosition.y+(long)spacingY-1;
                pICNData->LVHitTestInfo.flags = 0;
                SendMessage(hListView, pICNData->HitTest, 0, 0);
            } 
            if (pICNData->LVHitTestInfo.flags&LVHT_NOWHERE)
            {
                pICNData->LVHitTestInfo.pt = pICNData->icnptPosition;
                pICNData->LVHitTestInfo.pt.x = pICNData->icnptPosition.x+(long)spacingX-1;
                pICNData->LVHitTestInfo.flags = 0;
                SendMessage(hListView, pICNData->HitTest, 0, 0);
            } 
            if (pICNData->LVHitTestInfo.flags&LVHT_NOWHERE)
            {
                pICNData->LVHitTestInfo.pt = pICNData->icnptPosition;
                pICNData->LVHitTestInfo.pt.y = pICNData->icnptPosition.y+(long)spacingY-1;
                pICNData->LVHitTestInfo.flags = 0;
                SendMessage(hListView, pICNData->HitTest, 0, 0);
            } 
            if (pICNData->LVHitTestInfo.flags&LVHT_NOWHERE)
                b = 33;
        } 

        SendMessage(hListView, pICNData->SetPosition, a, 0);
    } 
    LeaveCriticalSection(&crObject);
 // SendMessage(hListView, LVM_ARRANGE, LVA_SNAPTOGRID, 0);
    ShowWindow(hListView, SW_SHOW);
    bIconsAreScrambled = TRUE;
    EnableWindow(GetDlgItem(hDialog, IDC_CMDSAVERELATIVE), FALSE);
    EnableWindow(GetDlgItem(hDialog, ID_CHKSAVEREST), FALSE);
} 

#endif