#include "stdAfx.h"
#include "commctrl.h"
#include "tr3.h"
#include "winerror.h"
extern COLORREF crUserFore;
ICSETTINGS    icDefaults = 
{
    sizeof(ICSETTINGS),                                    //
        (COLORREF)RGB(0, 128, 128),                        // crBackColor
        (COLORREF)0xFFFFFF,                                // crForeColor
        (COLORREF)0x80A0A0,                                // crDeskColor
        TRUE,                                              // bTransparent
        TRUE,                                              // bAutoHide
        FALSE,                                             // bAlwaysHide
        FALSE,                                             // bAutoAuto
        TRUE,                                              // bOnDesktop
        TRUE,                                              // bOffDesktop
        TRUE,                                              // bShowDelay
        TRUE,                                              // bShowIconsInAlways
        TRUE,                                              // bConfirmExit
        FALSE,                                             // bAutoStart
        FALSE,                                             // bHideWhenStarted
        FALSE,                                             // bHotCorner
        TRUE,                                              // bTwoSecondWait
        TRUE,                                              // bTrayIcon
        FALSE,                                             // bStretchInner
        TRUE,                                              // bShowHidingOptions
        TRUE,                                              // bShowHelp
        TRUE,                                              // bShowSaveRest
        TRUE,                                              // bShowIconBackgroundOptions
        FALSE,                                             // bBoss
        FALSE,                                             // bAutoRestore
        FALSE,                                             // bAbsolutePosition
        TRUE,                                              // bStatusBar
        FALSE,                                             // bNeverEnd
        FALSE,                                             // bTrayDance
        0,                                                 // iHideMethod
        FALSE,                                             // bFade
        TRUE,                                              // bContextMenu
        FALSE,                                             // bSetDesk
        FALSE,                                             // bCompliment
        TRUE,                                              // bIgnoreBorder
        FALSE,                                             // bSampWhole
        FALSE,                                             // bDeskColorOnStart
        FALSE,                                             // bCursorHide
        TRUE,                                              // bHideTaskBar
        FALSE,                                             // bNoShowStartup
        FALSE,                                             // bNormalize
        BST_CHECKED,                                       // bAutoFG
        TRUE,                                              // bShowHideKey
        TRUE,                                              // bRefreshKey
        FALSE,                                             // bCycleKey
        FALSE,                                             // bPositionKey
        TRUE,                                              // bLeaveDeskColorAlone
        0x00000341,                                        // iShowHideKey - ctrl-shift-a
        0x00000274,                                        // iRefreshKey - ctrl-f5
        0x00000458,                                        // iCycleKey - alt-X
        0x0000065A,                                        // iPositionKey - ctrl-alt-Z
        1,                                                 // cornernum
        1234,                                              // dwSettingsStillOK
        10,                                                // tmrOnDesktop
        5,                                                 // tmrOffdesktop
        4,                                                 // tmrShowDelay
        10,                                                // tmrShowIconsInAlwaysHide
        "",                                                // szSCFfile[40]
        -1,                                                // iWindowTop
        -1                                                 // iWindowLeft
} ;

void GetICSettings(LPICSETTINGS icInOut,BOOL bDefaults,BOOL bLoadDefaultsOnError)
{
    ULONG         dwDataSize = sizeof(icDefaults);
    HKEY          hKey;
    TCHAR         szKeyName[18] = "Software\\SillySot";
    TCHAR         szValue[60] = "Settings";
    DWORD         dwType = REG_BINARY;
    ICSETTINGS    icReturnedData;

    if (bDefaults)
    {
        *icInOut = icDefaults;
    } 
    else
    {
        hKey = 0;
        icReturnedData.size = 0;
        if (ERROR_SUCCESS == RegOpenKeyEx(HKEY_CURRENT_USER, szKeyName, NULL, KEY_READ, &hKey))
        {
            if (hKey)
            {
                if (ERROR_SUCCESS == RegQueryValueEx(hKey, szValue, NULL, &dwType, NULL, &dwDataSize))
                    if (dwDataSize == sizeof ICSETTINGS)
                        RegQueryValueEx(hKey, szValue, NULL, &dwType, (BYTE *)&icReturnedData, &dwDataSize);
                    else
                        if (bLoadDefaultsOnError)
                            *icInOut = icDefaults;
                        else
                            MessageBox(hDialog, "Registry settings that were imported are invalid." //
                                "\nThey may have been from a previous release of Iconoid." //
                                "\n\nSettings remain unchanged.", szTitle, MB_OK|MB_ICONWARNING);
                RegCloseKey(hKey);
            } 
            if (sizeof(icDefaults) == icReturnedData.size)
            {
                *icInOut = icReturnedData;
            } 
        } 
        else
            *icInOut = icDefaults;

        icSettings.dwSettingsStillOK = 1234;
        icSettings.szSCFfile[0] = 0;
        crUserFore = icSettings.crForeColor;
    } 
} 

void SaveICSettings(ICSETTINGS icIn,HWND hWnd)
{
    DWORD         dwDataSize;
    HKEY          hKey;
    DWORD         disposition;
    DWORD         errcode;
    SECURITY_ATTRIBUTES secattr;                           // security parm for regcreatekeyex

    icIn.size = sizeof ICSETTINGS;
    icIn.tmrOffDesktop = SendMessage(ItemHWnd(ID_SCROFFDESKTOP), TBM_GETPOS, 0, 0);
    icIn.tmrOnDesktop = SendMessage(ItemHWnd(ID_SCRONDESKTOP), TBM_GETPOS, 0, 0);
    icIn.tmrShowIconsInAlwaysHide = SendMessage(ItemHWnd(IDC_TEMPSHOWTIME), TBM_GETPOS, 0, 0);
    icIn.tmrShowDelay = SendMessage(ItemHWnd(ID_SCRSHOWDELAY), TBM_GETPOS, 0, 0);
    dwDataSize = sizeof ICSETTINGS;
    secattr.nLength = sizeof secattr;
    secattr.lpSecurityDescriptor = NULL;
    secattr.bInheritHandle = TRUE;
    if (0 != icSettings.tmrOnDesktop+icSettings.tmrOffDesktop+icSettings.tmrShowDelay)
    {
        errcode = RegCreateKeyEx(HKEY_CURRENT_USER,        //
            "Software\\SillySot",                          //
            0, "", 0,                                      //
            KEY_ALL_ACCESS,                                //
            NULL,                                          // &secattr,
            &hKey, &disposition);
        if (ERROR_SUCCESS == errcode)
            if (hKey)
            {
                if (RegSetValueEx(hKey, "Settings", NULL, REG_BINARY, (BYTE *)&icIn, dwDataSize))
                    RegDeleteValue(hKey, "Settings");
                RegCloseKey(hKey);
            } 
            else
                ShowVar("Could not save settings: hKey==%d after RegCreateKeyEx", errcode);
        else
            ShowVar("RegCreateKeyEx %d", errcode);
    } 
} 

BOOL CheckForSavedRelative()
{
    ULONG         dwDataSize;
    HKEY          hKey;
    TCHAR         szKeyName[18] = "Software\\SillySot";
    TCHAR         szValue[20] = "SavedIcons_Relative";
    DWORD         dwType = REG_BINARY;
    BOOL          bRetVal;

    bRetVal = FALSE;
    hKey = 0;
    if (ERROR_SUCCESS == RegOpenKeyEx(HKEY_CURRENT_USER, szKeyName, NULL, KEY_ALL_ACCESS, &hKey))
        if (hKey)
        {
            if (ERROR_SUCCESS == RegQueryValueEx(hKey, szValue, NULL, &dwType, NULL, &dwDataSize))
                bRetVal = TRUE;
            RegCloseKey(hKey);
        } 
    return  bRetVal;
} 

BOOL CheckForSavedAbsolute()
{
    ULONG         dwDataSize;
    HKEY          hKey;
    TCHAR         szKeyName[18] = "Software\\SillySot";
    TCHAR         szValue[40];
    DWORD         dwType = REG_BINARY;
    BOOL          bRetVal;

    bRetVal = FALSE;

    wsprintf(szValue,                                      //
        "SavedIcons_%d_%d",                                //
        GetSystemMetrics(SM_CXSCREEN),                     //
        GetSystemMetrics(SM_CYSCREEN));
    hKey = 0;
    if (ERROR_SUCCESS == RegOpenKeyEx(HKEY_CURRENT_USER, szKeyName, NULL, KEY_ALL_ACCESS, &hKey))
        if (hKey)
        {
            if (ERROR_SUCCESS == RegQueryValueEx(hKey, szValue, NULL, &dwType, NULL, &dwDataSize))
            {
                bRetVal = TRUE;
            } 
            RegCloseKey(hKey);
        } 
    return  bRetVal;
} 

void SetXPDesktopSettings(DWORD lValue)
{
    DWORD         dwDataSize;
    HKEY          hKey;
    DWORD         disposition;
    SECURITY_ATTRIBUTES secattr;                           // security parm for regcreatekeyex

    if (IsXPatLeast())
        if (lValue >= 0)
        {
            dwDataSize = sizeof lValue;
            secattr.nLength = sizeof secattr;
            secattr.lpSecurityDescriptor = NULL;
            secattr.bInheritHandle = TRUE;
            if (ERROR_SUCCESS == RegCreateKeyEx(HKEY_CURRENT_USER,  //
                "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Advanced",  //
                0, "", 0, KEY_ALL_ACCESS, NULL,            // &secattr,
                &hKey, &disposition))
                if (hKey)
                {
                    RegSetValueEx(hKey, "ListviewShadow", NULL, REG_DWORD, (BYTE *)&lValue, dwDataSize);
//   RegSetValueEx(hKey, "ListviewWatermark", NULL, REG_DWORD, (BYTE *)&lValue, dwDataSize);
                    xpDropShadow = FALSE;
                    RegCloseKey(hKey);
                } 
        } 
} 

BOOL CheckXPDropShadow()
{
    return  xpDropShadow;
} 

VOID RegReadString(HKEY hKeyType,CHAR *szKeyName,CHAR *szValue,CHAR *szRetValue)
{
    ULONG         dwDataSize;
    HKEY          hKey;
    DWORD         dwType = REG_SZ;
    DWORD         dwData;
    DWORD         disposition;

    *szRetValue = 0;
    hKey = 0;
    dwData = 0;
    if (ERROR_SUCCESS == RegCreateKeyEx(hKeyType,          //
        szKeyName,                                         //
        0, "", 0, KEY_ALL_ACCESS, NULL,                    // &secattr,
        &hKey, &disposition))
    {
        if (hKey)
        {
            if (ERROR_SUCCESS == RegQueryValueEx(hKey, szValue, NULL, &dwType, NULL, &dwDataSize))
            {
                RegQueryValueEx(hKey, szValue, NULL, &dwType, (BYTE *)szRetValue, &dwDataSize);
            } 
            else
                ProcessLastErr();

            RegCloseKey(hKey);
        } 
    } 
} 

VOID RegWriteSz(TCHAR *szKeyName,TCHAR *lpValueName,TCHAR *lpData)
{
    DWORD         dwDataSize;
    HKEY          hKey;
    DWORD         disposition;
    static BOOL   bSettingChanged = false;
    SECURITY_ATTRIBUTES secattr;                           // security parm for regcreatekeyex

    dwDataSize = (DWORD)strlen(lpData);
    secattr.nLength = sizeof secattr;
    secattr.lpSecurityDescriptor = NULL;
    secattr.bInheritHandle = TRUE;
    if (ERROR_SUCCESS == RegCreateKeyEx(HKEY_CURRENT_USER,  //
        szKeyName,                                         //
        0, "", 0, KEY_ALL_ACCESS, NULL,                    // &secattr,
        &hKey, &disposition))
        if (hKey)
        {
            RegSetValueEx(hKey, lpValueName, NULL, REG_SZ, (BYTE *)lpData, dwDataSize);
            RegCloseKey(hKey);
        } 
} 
