#include "stdafx.h"
#include "windows.h"   
#include <process.h>
#include <shellapi.h>
#include <tlhelp32.h>
#include "tr3.h"
#include "LangTable.h"
BOOL CALLBACK EnumDesktopProc(LPTSTR lpszDesktop,LPARAM lParam)
{
    DWORD         dwWritten;

    WriteFile((HANDLE)lParam, lpszDesktop, (DWORD)strlen(lpszDesktop), &dwWritten, NULL);
    WriteFile((HANDLE)lParam, ", ", 2, &dwWritten, NULL);
    return  TRUE;
} 

bool SystemInfo()
{
    CHAR          *SupportMessage = "\r\nThank you for using Iconoid." //
        "\r\n\r\nPlease read the Frequently Asked Questions (FAQ) before reporting" //
          
        " a problem.""\r\n\r\nIf you are reporting a problem, please try the" //
        " latest version from the web site first.""\r\nSmall fixes are often added without a change to the version number." //
        "\r\nIf the problem persists then please send a report and provide" //
        "\r\nas much detail as possible in your description of the problem." //
        "\r\n\r\nPlease include"                           //
        "\r\n  *  This file (or its contents pasted into your note)" //
        "\r\n  *  Steps to recreate the problem and a complete description of the error" //
        "\r\n  *  Anything you've tried to work around the problem" //
        "\r\n  *  Relevant system settings (video drivers, possible program conflicts, etc)" //
        "\r\n\r\nPlease send reports to \r\n\t\t\tsillysotsoftware@yahoo.com\r\n\r\n";
    WIN32_FIND_DATA fd;
    CHAR          szSysInfoFile[MAX_PATH+20];
    DWORD         dwWritten;
          
    GetTempPath(sizeof szSysInfoFile, szSysInfoFile);
    strcat(szSysInfoFile, "iconoid.sysinfo.txt");
    HANDLE        hFile = FindFirstFile(szSysInfoFile, &fd);
          
    hFile = CreateFile((LPTSTR)szSysInfoFile,              // file name
        GENERIC_READ|GENERIC_WRITE,                        // open for read/write
        0,                                                 // do not share
        NULL,                                              // no security
        CREATE_ALWAYS,                                     // overwrite existing file
        FILE_ATTRIBUTE_NORMAL,                             // normal file
        NULL);                                             // no attr. template
    if (hFile == INVALID_HANDLE_VALUE)
    {
        ProcessLastErr();
        MessageBox(hDialog, "Could not create temporary system information text file.", szTitle, MB_APPLMODAL);
        return  false;
    } 
    else
    {

        MEMORYSTATUS  ms;
        CHAR          szDate[100];
        CHAR          szWork[7000];
        static CHAR   *Months[12] = 
        {
            "Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"
        } 
        ;
        CHAR          Day[4];
        CHAR          Month[4];
        CHAR          Year[5];
        CHAR          *p;
        CHAR          *szOS = "";
        int           i,m;

        wsprintf(szWork, "Iconoid Diagnostic Information\r\nThis file is stored as %s\r\n", szSysInfoFile);
        WriteFile(hFile, szWork, (DWORD)strlen(szWork), &dwWritten, NULL);
        for (i = 0; i < 100; i++)
            WriteFile(hFile, "-", 1, &dwWritten, NULL);

        WriteFile(hFile, SupportMessage, (DWORD)strlen(SupportMessage), &dwWritten, NULL);
        for (i = 0; i < 100; i++)
            WriteFile(hFile, "-", 1, &dwWritten, NULL);
        strcpy(szDate, __DATE__);
        for (p = szDate; *p; p++)
            if (' ' == *p)
                *p = '0';
        strncpy(Year, szDate+7, 4);
        strncpy(Day, szDate+4, 2);
        Year[4] = Day[2] = 0;
        for (m = 0; m < 12 && memcmp(szDate, Months[m], 3); m++)
            ;
        wsprintf(Month, "%d", 101+m);

        wsprintf(szWork, "\r\n\r\nIconoid Version ......... %s %s-%s-%s\r\n", szVerInfo, Year+2, Month+1, Day);
        WriteFile(hFile, szWork, (DWORD)strlen(szWork), &dwWritten, NULL);
        szOS = "Unknown";
        if (vi.dwMajorVersion == 4)
        {
            if (vi.dwMinorVersion == 0)
            {
                if (vi.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS)
                    szOS = "Win95";
                else
                    if (vi.dwPlatformId == VER_PLATFORM_WIN32_NT)
                        szOS = "WinNT";
            } 
            if (vi.dwMinorVersion == 10)
                szOS = "Win98";
            if (vi.dwMinorVersion == 90)
                szOS = "WinMe";
        } 
        else
            if (vi.dwMajorVersion == 5)
            {
                if (vi.dwMinorVersion == 0)
                    szOS = "Win2K";
                if (vi.dwMinorVersion == 1)
                    szOS = "WinXP";
                if (vi.dwMinorVersion == 2)
                    szOS = "Win2003";
            } 
            else
                if (vi.dwMajorVersion == 6)
                {
                    if (vi.dwMinorVersion == 0)
                        szOS = "Windows Vista";
                    if (vi.dwMinorVersion == 1)
                        szOS = "Windows 7";
                } 

        wsprintf(szWork, "Operating System ........ %s\r\n", szOS);
        WriteFile(hFile, szWork, (DWORD)strlen(szWork), &dwWritten, NULL);
        wsprintf(szDate, "Major:%d, Minor:%d, Platform id: %d", vi.dwMajorVersion, vi.dwMinorVersion, vi.dwPlatformId);
        wsprintf(szWork, "Operating System ........ %s\r\n", szDate);
        WriteFile(hFile, szWork, (DWORD)strlen(szWork), &dwWritten, NULL);
        wsprintf(szDate, "%4X", 0x10000+(ULONG)GetSystemDefaultLangID());
        wsprintf(szWork, "System Lang ID .......... %s ", szDate+1);
        LANGID        langid = GetSystemDefaultLangID();
          
        for (i = 0; i < sizeof langTable/sizeof langTable[0]; i++)
            if (langTable[i].langid == langid)
            {
                strcat(szWork, langTable[i].description);
            } 
        strcat(szWork, "\r\n");
        WriteFile(hFile, szWork, (DWORD)strlen(szWork), &dwWritten, NULL);
        SYSTEM_INFO   syo;
          
        GetSystemInfo(&syo);

        strcpy(szWork, "Processor Architecture .. ");
        switch (syo.wProcessorArchitecture)
        {
            case  PROCESSOR_ARCHITECTURE_UNKNOWN :
                strcat(szWork, "UNKNOWN\r\n");
                break;
            case  PROCESSOR_ARCHITECTURE_INTEL :
                strcat(szWork, "Intel\r\n");
                break;
            case  PROCESSOR_ARCHITECTURE_IA64 :
                strcat(szWork, "IA64\r\n");
                break;
            case  PROCESSOR_ARCHITECTURE_IA32_ON_WIN64 :
                strcat(szWork, "IA32on Win64\r\n");
                break;
            case  PROCESSOR_ARCHITECTURE_AMD64 :
                strcat(szWork, "AMD64\r\n");
                break;
            default  :
                strcat(szWork, "Unknown\r\n");
        } 
        WriteFile(hFile, szWork, (DWORD)strlen(szWork), &dwWritten, NULL);

        wsprintf(szDate, "%4X", 0x10000+(ULONG)syo.wProcessorRevision);
        wsprintf(szWork, "Processor revision ...... Model %c%c, Stepping %c%c\r\n", szDate[1], szDate[2], szDate[3], szDate[4]);
        WriteFile(hFile, szWork, (DWORD)strlen(szWork), &dwWritten, NULL);

        wsprintf(szWork, "Number of processors .... %d\r\n", syo.dwNumberOfProcessors);
        WriteFile(hFile, szWork, (DWORD)strlen(szWork), &dwWritten, NULL);

        GlobalMemoryStatus(&ms);
        wsprintf(szWork, "Physical Memory ......... %dMB\r\nVirtual Memory .......... %dMB\r\nAvailable Virtual ....... %dMB\r\n", 
            ms.dwTotalPhys/1048576, ms.dwTotalVirtual/1048576, ms.dwAvailVirtual/1048576);
        WriteFile(hFile, szWork, (DWORD)strlen(szWork), &dwWritten, NULL);

        wsprintf(szWork, "Number of icons ......... %d\r\n", SendMessage(hListView, LVM_GETITEMCOUNT, 0, 0));
        WriteFile(hFile, szWork, (DWORD)strlen(szWork), &dwWritten, NULL);

        wsprintf(szWork, "Icon size .. ............ X:%d Y:%d\r\n", GetSystemMetrics(SM_CXICON), GetSystemMetrics(SM_CYICON));
        WriteFile(hFile, szWork, (DWORD)strlen(szWork), &dwWritten, NULL);

        wsprintf(szWork, "Icon spacing ............ X:%d Y:%d\r\n", GetSystemMetrics(SM_CXICONSPACING)-GetSystemMetrics(SM_CXICON), 
            GetSystemMetrics(SM_CYICONSPACING)-GetSystemMetrics(SM_CYICON));
        WriteFile(hFile, szWork, (DWORD)strlen(szWork), &dwWritten, NULL);

        DWORD         dwStyle = GetWindowLong(hListView, GWL_STYLE);
        BOOL          bAutoArrange = (LVS_AUTOARRANGE == (dwStyle&LVS_AUTOARRANGE));
          
        wsprintf(szWork, "AutoArrange ............. %s\r\n", bAutoArrange?"Yes":"No");
        WriteFile(hFile, szWork, (DWORD)strlen(szWork), &dwWritten, NULL);
        HWINSTA       hwinsta = GetProcessWindowStation();
          
        if (hwinsta)
        {
            wsprintf(szWork, "Desktops ................ ");
            WriteFile(hFile, szWork, (DWORD)strlen(szWork), &dwWritten, NULL);
            EnumDesktops(hwinsta, EnumDesktopProc, (LPARAM)hFile);
            WriteFile(hFile, "\r\n", 2, &dwWritten, NULL);
        } 
        wsprintf(szWork, "Number of monitors ...... %d\r\n", GetSystemMetrics(SM_CMONITORS));
        WriteFile(hFile, szWork, (DWORD)strlen(szWork), &dwWritten, NULL);

        if (m_EnumDisplayDevices && m_Module32First)
        {
            DISPLAY_DEVICE dd;
          
            i = 0;
            dd.cb = sizeof(dd);
            while (m_EnumDisplayDevices(NULL, i, &dd, 0))
            {
                int           j;
                CHAR          *state = (dd.StateFlags&DISPLAY_DEVICE_PRIMARY_DEVICE)?"* ":" .";
          
                wsprintf(szWork, "Display Device %d%s....... %s, %s\r\n", i, state, dd.DeviceName, dd.DeviceString);
                WriteFile(hFile, szWork, (DWORD)strlen(szWork), &dwWritten, NULL);
                DISPLAY_DEVICE dd2;
          
                dd2.cb = sizeof(dd2);
                CHAR          dvname[256];
          
                strncpy(dvname, dd.DeviceName, 255);
                j = 0;
                if (m_EnumDisplayDevices(dvname, j, &dd2, 0))
                {
                    wsprintf(szWork, "  Display Monitor .......   %s\r\n", dd.DeviceString);
                    WriteFile(hFile, szWork, (DWORD)strlen(szWork), &dwWritten, NULL);
                    j++;
                    DEVMODE       dm;
          
                    dm.dmSize = sizeof(DEVMODE);
                    if (EnumDisplaySettings(dvname, ENUM_CURRENT_SETTINGS, &dm))
                    {
                        wsprintf(szWork, "  Device Name ...........   %s\r\n", dm.dmDeviceName);
                        WriteFile(hFile, szWork, (DWORD)strlen(szWork), &dwWritten, NULL);
                        wsprintf(szWork, "  Width,Height,Depth.....   %d, %d, %d\r\n", dm.dmPelsWidth, dm.dmPelsHeight, dm.dmBitsPerPel);
                        WriteFile(hFile, szWork, (DWORD)strlen(szWork), &dwWritten, NULL);
                    } 
                } 

                i++;
            } 
        } 
        GetCurrentWallpaper(szDate);
        wsprintf(szWork, "Wallpaper file .......... %s\r\n", szDate);
        WriteFile(hFile, szWork, (DWORD)strlen(szWork), &dwWritten, NULL);

        if (*szDate)
        {
            HBITMAP       hbm = (HBITMAP)LoadImage(0, szWallPaper, IMAGE_BITMAP, 0, 0, LR_LOADFROMFILE|LR_CREATEDIBSECTION);
            BITMAP        bmp;
          
            if (GetObject(hbm, sizeof bmp, &bmp))
            {
                wsprintf(szWork, "Wallpaper dimensions .... %dx%d, Depth:%d\r\n", bmp.bmWidth, bmp.bmHeight, bmp.bmBitsPixel);
                DeleteObject(hbm);
            } 
            else
                strcpy(szWork, "Wallpaper dimensions .... Unavailable\r\n");

            WriteFile(hFile, szWork, (DWORD)strlen(szWork), &dwWritten, NULL);
        } 

        BOOL          bTiled = 49 == RegReadDWord("Control Panel\\Desktop", "TileWallpaper");
        DWORD         dwWPStyle = (char)RegReadDWord("Control Panel\\Desktop", "WallpaperStyle");

        wsprintf(szWork, "Wallpaper Tile Setting .. %s\r\n", bTiled?"True":"False");
        WriteFile(hFile, szWork, (DWORD)strlen(szWork), &dwWritten, NULL);

        wsprintf(szWork, "Wallpaper Style ......... %s\r\n", (dwWPStyle == '2')?"Stretched":((dwWPStyle == '0')?"Centered":"Tiled"));
        WriteFile(hFile, szWork, (DWORD)strlen(szWork), &dwWritten, NULL);

        wsprintf(szWork, "Screen Size ............. %dx%d\r\n", GetSystemMetrics(SM_CXSCREEN), GetSystemMetrics(SM_CYSCREEN));
        WriteFile(hFile, szWork, (DWORD)strlen(szWork), &dwWritten, NULL);

        wsprintf(szWork, "Virtual Screen Size ..... %dx%d\r\n", GetSystemMetrics(SM_CXVIRTUALSCREEN), GetSystemMetrics(SM_CYVIRTUALSCREEN));
        WriteFile(hFile, szWork, (DWORD)strlen(szWork), &dwWritten, NULL);

        wsprintf(szWork, "Active Desktop .......... %s\r\n", IsActiveDesktop()?"Yes":"No");
        WriteFile(hFile, szWork, (DWORD)strlen(szWork), &dwWritten, NULL);

        wsprintf(szWork, "Show Desktop ............ %s\r\n", IsShowDesktop()?"Yes":"No");
        WriteFile(hFile, szWork, (DWORD)strlen(szWork), &dwWritten, NULL);

        wsprintf(szWork, "Drop Shadows ............ %s\r\n", CheckXPDropShadow()?"Yes":"No");
        WriteFile(hFile, szWork, (DWORD)strlen(szWork), &dwWritten, NULL);

        WriteFile(hFile, "\r\nIconoid Settings ", 19, &dwWritten, NULL);
        for (i = 0; i < 82; i++)
            WriteFile(hFile, "-", 1, &dwWritten, NULL);
        WriteFile(hFile, "\r\n", 2, &dwWritten, NULL);
        WriteFile(hFile, "Windows Registry Editor Version 5.00\r\n\r\n[HKEY_CURRENT_USER\\Software\\SillySot]\r\n", 79, &dwWritten, NULL);
        WriteFile(hFile, "\"Settings\"=hex:", 15, &dwWritten, NULL);
        UCHAR         *u = (UCHAR *)&icSettings;
        int           j = 4;                               // skip space on 1st line
          
        for (i = 0; i < sizeof icSettings; i++)
        {
            wsprintf(szWork, "%2x", 256+*u++);
            strcpy(szWork, szWork+1);
            if (i < sizeof(icSettings)-1)
                strcat(szWork, ",");
            if (25 <= ++j)
            {
                strcat(szWork, "\\\r\n ");
                j = 0;
            } 
            WriteFile(hFile, szWork, (DWORD)strlen(szWork), &dwWritten, NULL);
        } 
        if (m_Process32First && m_CreateToolhelp32Snapshot)
        {
            PROCESSENTRY32 pe;
            MODULEENTRY32 me;
            CHAR          line[3*MAX_PATH];
            int           processcount = 0;
            HANDLE        hProcessSnapshot = m_CreateToolhelp32Snapshot(TH32CS_SNAPALL, 0);
          
            if (hProcessSnapshot != INVALID_HANDLE_VALUE)
            {
                pe.dwSize = sizeof(pe);
                if (m_Process32First(hProcessSnapshot, &pe))
                {
                    do
                    {
                        if (pe.th32ProcessID)
                            processcount++;
                    }  while (m_Process32Next(hProcessSnapshot, &pe));
                    CloseHandle(hProcessSnapshot);
                } 

                wsprintf(szWork, "\r\n\r\nRunning processes (%d including duplicates) ", processcount);
                for (i = 0; i < 100; i++)
                    strcat(szWork, "-");
                strcpy(szWork+100, "\r\n");

                WriteFile(hFile, szWork, (DWORD)strlen(szWork), &dwWritten, NULL);

                CHAR          **lines;
                lines = (CHAR **)malloc((processcount+20)*8*sizeof(CHAR *));
                for (i = 0; i < processcount; i++)
                    lines[i] = 0;
                processcount = 0;
                hProcessSnapshot = m_CreateToolhelp32Snapshot(TH32CS_SNAPALL, 0);
                if (hProcessSnapshot != INVALID_HANDLE_VALUE)
                {
                    pe.dwSize = sizeof(pe);
                    if (m_Process32First(hProcessSnapshot, &pe))
                    {
                        do
                        {
                            if (pe.th32ProcessID)
                            {
                                HANDLE        hModuleSnapshot = m_CreateToolhelp32Snapshot(TH32CS_SNAPMODULE, pe.th32ProcessID);
          
                                if (hModuleSnapshot != INVALID_HANDLE_VALUE)
                                {
                                    me.dwSize = sizeof(me);
                                    if (m_Module32First(hModuleSnapshot, &me))
                                    {
                       // do
                                        {
                                            wsprintf(line, "\t%-20s %s\r\n", pe.szExeFile, (vi.dwMajorVersion == 4)?"":me.szExePath);
                                            lines[processcount] = (CHAR *)malloc(strlen(line)+1);
                                            strcpy(lines[processcount++], line);
                                            ;
                                        } 
                                                // while (Module32Next(hModuleSnapshot, &me));
                                    } 
                                    else
                                    {
                                        wsprintf(line, "\t%-20s\r\n", pe.szExeFile);
                                        lines[processcount] = (CHAR *)malloc(strlen(line)+1);
                                        strcpy(lines[processcount++], line);
                                    } 
                                    CloseHandle(hModuleSnapshot);
                                } 
                                else
                                {
                                    wsprintf(line, "\t%-20s\r\n", pe.szExeFile);
                                    lines[processcount] = (CHAR *)malloc(strlen(line)+1);
                                    strcpy(lines[processcount++], line);
                                } 
                            } 
                        }  while (m_Process32Next(hProcessSnapshot, &pe));
                        CloseHandle(hProcessSnapshot);

                    } 

                    for (i = 0; i < processcount-1; i++)
                        for (int j = i+1; j < processcount; j++)
                            if (0 < strcmp(lines[i], lines[j]))
                            {
                                CHAR          *p = lines[j];
          
                                lines[j] = lines[i];
                                lines[i] = p;
                            } 
                    for (i = 0; i < processcount; i++)
                    {
                        if (i == 0 || strcmp(lines[i], lines[i-1]))
                            WriteFile(hFile, lines[i], (DWORD)strlen(lines[i]), &dwWritten, NULL);
                    } 
                    for (i = 0; i < processcount; i++)
                        free(lines[i]);
                    free(lines);
                } 

            } 
            else
                ProcessLastErr();
        } 
        CloseHandle(hFile);
        hFile = CreateFile((LPTSTR)szSysInfoFile,          // file name
            GENERIC_READ,                                  // open for read/write
            FILE_SHARE_READ,                               // do not share
            NULL,                                          // no security
            OPEN_EXISTING,                                 // overwrite existing file
            FILE_ATTRIBUTE_NORMAL,                         // normal file
            NULL);                                         // no attr. template
        if (hFile != INVALID_HANDLE_VALUE)
        {
            DWORD         dwRead;
            DWORD         fs = GetFileSize(hFile, NULL);
          
            if (fs)
            {
                CHAR          *buff = new CHAR[fs+1];
          
                ReadFile(hFile, buff, fs, &dwRead, NULL);
                if (dwRead == fs)
                {
                    if (OpenClipboard(hDialog))
                    {
                        EmptyClipboard();
                        HGLOBAL       hglbCopy = GlobalAlloc(GMEM_MOVEABLE, (fs+1)*sizeof(TCHAR));
                        LPTSTR        lptstrCopy = (LPTSTR)GlobalLock(hglbCopy);
          
                        memcpy(lptstrCopy, buff, fs);
                        lptstrCopy[fs] = 0;                // null character
                        GlobalUnlock(hglbCopy);
                        SetClipboardData(CF_TEXT, hglbCopy);
                        CloseClipboard();
                        GlobalFree(hglbCopy);
                    } 
                    else
                        ProcessLastErr();
                    delete        buff;
                } 
            } 
          
            CloseHandle(hFile);
        } 
        else
        {
            ProcessLastErr();
            MessageBox(hDialog, "Could not open written system information text file\nto place diagnostic data in the clipboard.", szTitle, 
                MB_APPLMODAL);
            return  false;
        } 
          
        ShellExecute(hDialog, "open", szSysInfoFile, NULL, NULL, SW_SHOWNORMAL);
        return  true;
    } 
} 

void HelpRequest()
{
    CHAR          szURL[7000];

    if (IDCANCEL != MessageBox(hDialog,                    //
        "Thank you for using Iconoid."                     //
        "\r\n\r\nWhen you press OK, you will see a file open with system information." //
        "\r\nPlease read the beginning of that file for important information and" //
        "\r\ninclude that file, or the contents of that file with your error report." //
        "\n\nFor your convenience, the same data will also be placed in the clipboard so that." //
        "\r\nyou can paste the information directly into your email." //
        "\r\n\r\nYour mail program should also start when you press OK.  If it doesn't, you can" //
        " send email directly to\r\n\t\t\tsillysotsoftware@yahoo.com" //
        "\r\n\r\nThank you for taking the time to read this entire message.",  //
        "Iconoid Problem Reporting Information", MB_APPLMODAL|MB_OKCANCEL|MB_ICONEXCLAMATION))
    {
        MEMORYSTATUS  ms;
        CHAR          szDate[40];
        CHAR          szWork[7000];
        static CHAR   *Months[12] = 
        {
            "Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"
        } 
        ;
        CHAR          Day[4];
        CHAR          Month[4];
        CHAR          Year[5];
        CHAR          *p;
        CHAR          *szOS = "";
        int           m;

        strcpy(szDate, __DATE__);
        for (p = szDate; *p; p++)
            if (' ' == *p)
                *p = '0';
        strncpy(Year, szDate+7, 4);
        strncpy(Day, szDate+4, 2);
        Year[4] = Day[2] = 0;
        for (m = 0; m < 12 && memcmp(szDate, Months[m], 3); m++)
            ;
        wsprintf(Month, "%d", 101+m);

        wsprintf(szURL, "%s%%20%%28V%%20%s%%2C%%20%s-%s-%s%%2C%%20",  //
            SUPPORT_URL,                                   //
            szVerInfo, Year+2, Month+1, Day);

        if (vi.dwMajorVersion == 4)
        {
            if (vi.dwMinorVersion == 0)
            {
                if (vi.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS)
                    szOS = "Win95";
                else
                    if (vi.dwPlatformId == VER_PLATFORM_WIN32_NT)
                        szOS = "WinNT";
            } 
            if (vi.dwMinorVersion == 10)
                szOS = "Win98";
            if (vi.dwMinorVersion == 90)
                szOS = "WinMe";
        } 
        else
            if (vi.dwMajorVersion == 5)
            {
                if (vi.dwMinorVersion == 0)
                    szOS = "Win2K";
                if (vi.dwMinorVersion == 1)
                    szOS = "WinXP";
                if (vi.dwMinorVersion == 2)
                    szOS = "Win2003";
            } 
            else
                if (vi.dwMajorVersion == 6)
                {
                    if (vi.dwMinorVersion == 0)
                        szOS = "Vista";
                    if (vi.dwMinorVersion == 1)
                        szOS = "Win7";
                } 
        strcat(szURL, szOS);
        GlobalMemoryStatus(&ms);
        wsprintf(szWork,                                   //
            "%%2C%dMB", ms.dwTotalPhys/1048576);

        strcat(szURL, szWork);
        wsprintf(szWork,                                   //
            "%%2C%dx%d", GetSystemMetrics(SM_CXSCREEN), GetSystemMetrics(SM_CYSCREEN));

        strcat(szURL, szWork);
        strcat(szURL, IsActiveDesktop()?"%2C%20ActDesktop":"%2C%20NoActDesktop");
        strcat(szURL, "%29");
        RegReadString(HKEY_LOCAL_MACHINE, "SOFTWARE\\Classes\\mailto\\shell\\open\\command", "", szWork);
        if (strstr(szWork, "agent.exe"))                   // MS Outlook & Lotus notes are broken so just do this for Agent
        {
            strcat(szURL, "&body=");

            wsprintf(szWork, "%%0dIconoid%%20Version%%20....%%20%s%%0a", szVerInfo);
            strcat(szURL, szWork);
            wsprintf(szWork, "Compile%%20Date:%%20......%%20%s-%s-%s%%0D", Year+2, Month+1, Day);
            strcat(szURL, szWork);

            wsprintf(szWork, "Operating%%20System%%20...%%20%s%%0d", szOS);
            strcat(szURL, szWork);

            GlobalMemoryStatus(&ms);
            wsprintf(szWork, "Physical%%20Memory:%%20...%%20%dMB%%0d" //
                "Total%%20Virtual:%%20.....%%20%dMB%%0d"   //
                "Available%%20Virtual%%20..%%20%dMB%%0d",  //
                ms.dwTotalPhys/1048576, ms.dwTotalVirtual/1048576, ms.dwAvailVirtual/1048576);

            strcat(szURL, szWork);
            wsprintf(szWork, "Active%%20Desktop%%20.....%%20%s%%0D", IsActiveDesktop()?"Yes":"No");
            strcat(szURL, szWork);
            strcat(szURL, "%0d");
        } 
        ShellExecute(hDialog, "open", szURL, NULL, NULL, SW_SHOWNORMAL);
        SystemInfo();
    } 
} 

