#include "stdafx.h"
#include "tr3.h"
#include <shellapi.h>
#include <stdio.h>     
#include <direct.h>
void CaptureScreenAndSaveBitmap(FILE *f,HWND hWnd,CHAR *title);

BOOL CALLBACK EnumWinProc(HWND hWnd,LPARAM lParam)
{
    DWORD         dwStyle;

    if (hWnd != hDialog && GetParent(hWnd) == 0)
    {
        dwStyle = GetWindowLong(hWnd, GWL_STYLE);
        if (dwStyle != 0                                   //
            && IsWindowEnabled(hWnd)                       //
            && ((dwStyle&MINIMIZABLE) == MINIMIZABLE)      //
            && (((dwStyle)&(WS_MINIMIZE^0xffffffff)) == dwStyle) //
            )
        {
            ShowWindow(hWnd, SW_HIDE);
            ShowWindow(hWnd, SW_SHOWMINIMIZED);
        } 
    } 
//
//  The following code kills ACDSee and Agent on Boss Mouse activation
//
    if (bKillAgentAndACDSee)                               // if -kill parameter was specified
    {
        TCHAR         szClassName[200];

        GetClassName(hWnd, szClassName, 200);
        if ((!strcmp(szClassName, "ACDViewer"))            //
            || (!strcmp(szClassName, "ACDBrowser")) || (!strcmp(szClassName, "ForteAgent:Main")))
        {
            if (m_pEndTask)
                m_pEndTask(hWnd, 0, TRUE);
            else
                SendMessage(hWnd, WM_CLOSE, 0, 0);
        } 
    } 
    return  TRUE;
} 

#ifdef   CAPTURE
BOOL CALLBACK EnumKidsProc(HWND hWnd,LPARAM lParam)        // used to create image map for help screens
{
    DWORD         dwParentStyle;
          
    dwParentStyle = GetWindowLong(GetParent(hWnd), GWL_STYLE);
    if (0 != GetParent(hWnd) && (dwParentStyle&CBS_DROPDOWN) == CBS_DROPDOWN)
        return  TRUE;

    if (IsWindowVisible(hWnd))
    {
        ULONG         *h = (ULONG *)lParam;
          
        if (999 > (ULONG)h[0])
        {
            h[0] = 1+h[0];
            h[h[0]] = (ULONG)hWnd;
        } 
        else
            return  FALSE;
    } 
    return  TRUE;
} 

void CreateSingleMap(HWND hWnd,FILE *f,char *title)
{
    RECT          dim;
    ULONG         handles[1000];
    UINT          a,b,c;
    RECT          rectWindow;
    TCHAR         szClassName[201];
    RECT          rectCurrent,rectCompare;
    HWND          current;
    TCITEM        tcitem;
    CHAR          *p;
          
    for (a = 0; a < 1000; a++)
        handles[a] = 0;
    EnumChildWindows(hWnd, EnumKidsProc, (LPARAM)handles);
    fprintf(f, "\n<script language=javascript>");
//    for (c = 1; c < handles[0]; c++)
//        for (b = c+1; b <= handles[0]; b++)
//            if (handles[c] == handles[b])
//                handles[b] = 0;

    GetWindowRect(hWnd, &dim);
    for (c = 1; c <= handles[0]; c++)
    {
        GetWindowRect((HWND)handles[c], &rectCurrent);
        OffsetRect(&rectCurrent, -dim.left, -dim.top);
        fprintf(f, "\n\tcoords['c_%ld']=new Array(%ld,%ld,%ld,%ld);", GetDlgCtrlID((HWND)handles[c]), rectCurrent.left, rectCurrent.top, 
            rectCurrent.right-rectCurrent.left, rectCurrent.bottom-rectCurrent.top);
    } 
    fprintf(f, "\n</script>");
    GetWindowRect(hWnd, &dim);
    fprintf(f, "\n<div id=\"Div%s\" class=\"innerDiv\" style=\"width:%ldpx; height:%ldpx\">", title, dim.right-dim.left, dim.bottom-dim.top)
        ;
    fprintf(f, "\n<img name=\"%s\" src=\"%s.gif\" border=\"0\" ", title, title);
    fprintf(f, "usemap=\"#%s\" width=\"%d\" height=\"%d\">", title, dim.right-dim.left, dim.bottom-dim.top);
    fprintf(f, "\n<map name=\"%s\">\n", title);
    for (c = 1; c <= handles[0]; c++)
        for (b = 1; b <= handles[0]; b++)
        {
            if (current = (HWND)handles[b])
            {
                GetWindowRect(current, &rectCurrent);
                for (a = 1; a <= handles[0] && current; a++)
                    if (a != b && handles[a])
                    {
                        RECT          intersect;
          
                        GetWindowRect((HWND)handles[a], &rectCompare);
                        if (IntersectRect(&intersect, &rectCurrent, &rectCompare))
                            if (EqualRect(&intersect, &rectCompare))
                                current = 0;               // compare overlays current, forget current for now
                    } 
                if (current)
                {
                    CHAR          szWindowText[201];
          
                    GetClassName(current, szClassName, 200);

                    if (!strcmp("SysTabControl32", szClassName))
                    {
                        LRESULT       n = SendMessage(current, TCM_GETITEMCOUNT, 0, 0);
          
                        for (LONG t = 0; t < n; t++)
                        {
                            RECT          rect;
          
                            *szWindowText = 0;
                            tcitem.pszText = szWindowText;
                            tcitem.cchTextMax = 200;
                            tcitem.mask = TCIF_TEXT;
                            SendMessage(current, TCM_GETITEM, t, (LPARAM)&tcitem);
                            SendMessage(current, TCM_GETITEMRECT, t, (LPARAM)&rect);
                            GetWindowRect(current, &rectWindow);
                            OffsetRect(&rectWindow, -dim.left, -dim.top);
                            OffsetRect(&rect, rectWindow.left, rectWindow.top);
                            fprintf(f, "\n<area shape=\"rect\" ");
                            fprintf(f, "coords=\"%ld,%ld,%ld,%ld\"", rect.left, rect.top, rect.right, rect.bottom);
                            fprintf(f, "\n\tonmouseover=\"OverProc('t_%ld_%ld','%s')\"", GetDlgCtrlID(current), t, szWindowText);
                            fprintf(f, "\n\tonmouseout=\"OutProc('t_%ld_%ld');\"", GetDlgCtrlID(current), t);
                            fprintf(f, ">");
                            fprintf(f, "\n<script>coords['t_%ld_%ld']=new Array(%ld,%ld,%ld,%ld);</script>", GetDlgCtrlID(current), t, 
                                rect.left, rect.top, rect.right-rect.left, rect.bottom-rect.top);

                        } 

                    } 
                    else
                    {

                        *szWindowText = 0;
                        GetWindowText(current, szWindowText, 200);
                        for (p = szWindowText; *p; p++)
                            if ('\'' == *p || '"' == *p || '\n' == *p)
                                *p = ' ';
                        GetWindowRect(current, &rectWindow);
                        OffsetRect(&rectWindow, -dim.left, -dim.top);
                        fprintf(f, "\n<area shape=\"rect\" ");
                        fprintf(f, "coords=\"%ld,%ld,%ld,%ld\"", rectWindow.left, rectWindow.top, rectWindow.right, rectWindow.bottom);
                        fprintf(f, "\n\tonmouseover=\"OverProc('c_%ld','%s');\" ", GetDlgCtrlID(current), szWindowText);
                        fprintf(f, "\n\tonmouseout=\"OutProc('c_%ld');\"", GetDlgCtrlID(current));
                        fprintf(f, "\n\tonclick=\"ClickProc('c_%ld');\"", GetDlgCtrlID(current));
                        fprintf(f, ">");
                        fprintf(f, " <!-- %s - %s -->", szClassName, szWindowText);
                    } 
                    handles[b] = 0L;                       // mark this handle unavailable for both check and compare
                } 
            } 
        } 

    fprintf(f, "\n</map>");
    fprintf(f, "\n</div>");

} 

DWORD WINAPI CreateHelpMaps(LPVOID phWnd)
{
    HWND          hWnd = (*(HWND *)phWnd);
    const char    *szFileName = "C:\\temp\\screenshot.htm";
    FILE          *f = fopen(szFileName, "w+");
    TCHAR         szWindowText[201];
    TCITEM        tcitem;
    RECT          rect,rectSrc;
          
    *szWindowText = 0;
    tcitem.pszText = szWindowText;
    tcitem.cchTextMax = 200;
    tcitem.mask = TCIF_TEXT;
    SendMessage(ItemHWnd(ID_TABBOX), TCM_GETITEM, 1, (LPARAM)&tcitem);
    fprintf(f, "<html><head>");
    fprintf(f, "\n<link href=\"helpStyle.css\" rel=\"STYLESHEET\" type=\"text/css\">");
    fprintf(f, "\n<link href=\"style.css\" rel=\"STYLESHEET\" type=\"text/css\">");
    fprintf(f, "\n<script language=\"JavaScript\" src=\"helpScript.js\"></script>");

    fprintf(f, "\n</head><body onload=\"firstPage()\">");
    fprintf(f, "\n<h1 class=\"header\">Iconoid Help</h1>");
    fprintf(f, "\n<p class=\"header\">Move your cursor over the screen shot for an explanation of each item.<hr>");
    fprintf(f, "\n<div class=\"center\" id=\"cent\"><p>&nbsp;</p>");
    fprintf(f, "\n<div id=\"DivHelp\" class=\"outerDiv\" >");
    fprintf(f, "\n<div id=\"leftpane\" class=\"leftpane\">");
    fprintf(f, "\n<div id=\"itemViewR\" class=\"ItemviewR\"></div>");
    fprintf(f, "\n<div id=\"itemViewL\" class=\"ItemviewL\"></div>");
    fprintf(f, "\n<div id=\"itemViewT\" class=\"ItemviewT\"></div>");
    fprintf(f, "\n<div id=\"itemViewB\" class=\"ItemviewB\"></div>");
    fprintf(f, "\n<div id=dropdown style=\"display:none;position:absolute;z-Index:5;top:0;left:0\">");
    fprintf(f, "\n\t<img src=\"dropdown.gif\">\n</div>");
    SendMessage(hDialog, WM_COMMAND, ID_CHKNEVERHIDE, 0);
    for (int a = 0; a < SendMessage(ItemHWnd(ID_TABBOX), TCM_GETITEMCOUNT, 0, 0); a++)
        if (a != TABABOUT)
        {
            SendMessage(ItemHWnd(ID_TABBOX), TCM_SETCURSEL, a, 0);
            SendMessage(ItemHWnd(ID_TABBOX), TCM_GETITEM, a, (LPARAM)&tcitem);
            ReInitializeControlSettings(hDialog);
            CaptureScreenAndSaveBitmap(f, hWnd, szWindowText);
        } 

    SendMessage(ItemHWnd(ID_TABBOX), TCM_SETCURSEL, TABABOUT, 0);
    ReInitializeControlSettings(hDialog);
    SendMessage(ItemHWnd(ID_TABBOX), TCM_GETITEM, TABABOUT, (LPARAM)&tcitem);
    ShowWindow(ItemHWnd(IDC_DONATE), SW_SHOW);
    ShowWindow(ItemHWnd(ID_SUPPORT), SW_SHOW);
    ShowWindow(ItemHWnd(ID_NEWVERSION), SW_SHOW);
    GetRelativeRect(IDC_FRAME7, IDC_ABOUTTAB, &rect);

    GetWindowRect(ItemHWnd(IDC_DONATE), &rectSrc);
    ScreenToClient(hWnd, (LPPOINT)&rectSrc.left);
    ScreenToClient(hWnd, (LPPOINT)&rectSrc.right);
    OffsetRect(&rectSrc, rect.left, rect.top);
    MoveWindow(ItemHWnd(IDC_DONATE), rectSrc.left, rectSrc.top, rectSrc.right-rectSrc.left, rectSrc.bottom-rectSrc.top, TRUE);

    GetWindowRect(ItemHWnd(ID_SUPPORT), &rectSrc);
    OffsetRect(&rectSrc, rect.left, rect.top);
    ScreenToClient(hWnd, (LPPOINT)&rectSrc.left);
    ScreenToClient(hWnd, (LPPOINT)&rectSrc.right);
    ;
    MoveWindow(ItemHWnd(ID_SUPPORT), rectSrc.left, rectSrc.top, rectSrc.right-rectSrc.left, rectSrc.bottom-rectSrc.top, TRUE);

    GetWindowRect(ItemHWnd(ID_NEWVERSION), &rectSrc);
    OffsetRect(&rectSrc, rect.left, rect.top);
    ScreenToClient(hWnd, (LPPOINT)&rectSrc.left);
    ScreenToClient(hWnd, (LPPOINT)&rectSrc.right);
    MoveWindow(ItemHWnd(ID_NEWVERSION), rectSrc.left, rectSrc.top, rectSrc.right-rectSrc.left, rectSrc.bottom-rectSrc.top, TRUE);
    CaptureScreenAndSaveBitmap(f, hWnd, szWindowText);
    SendMessage(ItemHWnd(ID_TABBOX), TCM_SETCURSEL, TABHIDING, 0);
    SendMessage(hDialog, WM_COMMAND, ID_CHKAUTOHIDE, 0);
    ReInitializeControlSettings(hDialog);
    CaptureScreenAndSaveBitmap(f, hWnd, "Hiding1");

    SendMessage(hDialog, WM_COMMAND, ID_CHKALWAYSHIDE, 0);
    ReInitializeControlSettings(hDialog);
    CaptureScreenAndSaveBitmap(f, hWnd, "Hiding2");
    SendMessage(hDialog, WM_COMMAND, ID_CHKNEVERHIDE, 0);
    SendMessage(ItemHWnd(ID_TABBOX), TCM_GETITEM, 0, (LPARAM)&tcitem);
    fprintf(f, "\n<p align=\"center\">[ <a href=\"index.html\">Main Help</a>");
    fprintf(f, "\n\t| <a href=\"faq.htm\" target=\"_top\">FAQ</a>");
    fprintf(f, "\n\t| <a href=\"Readme.htm\" target=\"_top\">ReadMe</a>");
    fprintf(f, "\n\t| <a href=\"http://www.sillysot.com\" target=\"_top\">Home</a> ]</p>");
    fprintf(f, "\n<p>Please also read the <br><a href=\"faq.htm\">Frequently Asked Questions (FAQ)</a><br>page for");
    fprintf(f, "\ninformation about things like Active Desktop, Tips, and other useful tidbits.");
    fprintf(f, "\n</p></div>");
    fprintf(f, "\n<div id=\"rightpane\" class=\"rightpane\">");
    fprintf(f, "\n\t<div class=\"helptext\" id=\"helptext\" style=\"display:none\"></div>");
    fprintf(f, "\n</div>");
    fprintf(f, "\n<script language=\"JavaScript\" src=\"custom.js\"></script>");
    fprintf(f, "\n<script>");
    fprintf(f, "\n\tactiveScreen=\"%s\";", szWindowText);
    fprintf(f, "\n\tdocument.getElementById('Div'+activeScreen).style.display='block';\n");
    fprintf(f, "\n</script>");
    fprintf(f, "\n</div>");
    fprintf(f, "\n</div>");
    fprintf(f, "\n</body></html>");
    fclose(f);
    ShellExecute(hWnd, "open", szFileName, NULL, szFileName, SW_SHOWNORMAL);
    return 0L;
} 

void CaptureScreenAndSaveBitmap(FILE *f,HWND hWnd,CHAR *title)
{
    RECT          dim;

    GetWindowRect(hWnd, &dim);
    int           height = dim.bottom-dim.top;
    int           width = dim.right-dim.left;
          
    InvalidateRect(hDialog, NULL, TRUE);
    UpdateWindow(hDialog);
    Sleep(500);
                //*************************
    HDC           hdcScreen = GetDC(0);
    HDC           hdcDialog = CreateCompatibleDC(hdcScreen);
    HBITMAP       hbmDialog = CreateCompatibleBitmap(hdcScreen, width, height);
          
    wsprintf(szBMPfile, "C:\\temp\\%s.bmp", title);
    SelectObject(hdcDialog, hbmDialog);
    if (!BitBlt(hdcDialog, 0, 0, width, height, hdcScreen, dim.left, dim.top, SRCCOPY))
        ProcessLastErr();
    CreateBMPFile(szBMPfile, hbmDialog, hdcDialog);

    wsprintf(szBMPfile, "\"C:\\temp\\%s.bmp\" \"C:\\temp\\%s.gif\"", title, title);
    SHELLEXECUTEINFO ShExecInfo;
          
    ZeroMemory(&ShExecInfo, sizeof ShExecInfo);
    ShExecInfo.cbSize = sizeof SHELLEXECUTEINFO;
    ShExecInfo.fMask = SEE_MASK_NOCLOSEPROCESS;
    ShExecInfo.hwnd = hDialog;
    ShExecInfo.lpVerb = NULL;
    ShExecInfo.lpDirectory = NULL;
    ShExecInfo.nShow = SW_HIDE;
    ShExecInfo.hInstApp = NULL;
    ShExecInfo.lpFile = "C:\\bin\\iconvert.exe";
    ShExecInfo.lpParameters = szBMPfile;
    ShellExecuteEx(&ShExecInfo);
    WaitForSingleObject(ShExecInfo.hProcess, INFINITE);
    wsprintf(szBMPfile, "C:\\temp\\%s.bmp", title);
    remove(szBMPfile);
    DeleteObject(hbmDialog);
    DeleteDC(hdcScreen);
    DeleteDC(hdcDialog);
    CreateSingleMap(hWnd, f, title);
} 

#endif