#include "stdafx.h"
#include "tr3.h"
#define  TOPEDGEOFFSET 2
void AlignSpecial(HWND hWnd,UINT iAlignType)

{
    LRESULT       spacingX,spacingY;
    int           a;
    LRESULT       ItemCount;
    int           scrHeight,scrWidth,iOffset;
    //int           iOldOffset = 0;
    int           iLowX,iHighX,iLowY,iHighY,r,c;
//   int           iWidth;              // width of icon text
    TCHAR         WorkString[200];
    DWORD         dwStyle;

    if (pICNData->bDancinFools)
    {
        pICNData->bDancinFools = FALSE;
        Sleep(200);
    } 
    dwStyle = GetWindowLong(hListView, GWL_STYLE);
    ItemCount = SendMessage(hListView, LVM_GETITEMCOUNT, 0, 0);
    if (LVS_AUTOARRANGE == (dwStyle&LVS_AUTOARRANGE))
    {
        MessageBox(hWnd, "Icons can not be moved while"    //
            "\nthe desktop is in \"Auto Arrange\" mode."   //
            "\n\nUncheck Arrange Icons->Auto Arrange.",    //
            szTitle, MB_APPLMODAL|MB_ICONASTERISK);
        return ;
    } 

    if (ItemCount > MAX_EXISTING_ICONS)
    {
        wsprintf(WorkString, "Iconoid can only reposition %d icons" //
            "\nthere are %d icons or less on the screen.",  //
            MAX_EXISTING_ICONS, ItemCount);
        ConditionalMessageBox(hWnd, WorkString, szTitle, MB_APPLMODAL|MB_ICONASTERISK);

        return ;
    } 
    spacingY = SendMessage(hListView, LVM_GETITEMSPACING, FALSE, 0);
    spacingX = HIWORD(spacingY);
    spacingY = LOWORD(spacingY);
        //
    iOffset = 0;
    for (a = 0; a < ItemCount; a++)
    {
        EnterCriticalSection(&crObject);
        SendMessage(hListView, pICNData->GetPosition, a, 0);
        iOffset = max(iOffset, pICNData->icnptPosition.x-pICNData->icnRectBounds.left); //
        LeaveCriticalSection(&crObject);
    } 
//  ShowVar("iOffset: %d",iOffset);

    scrWidth = GetSystemMetrics(SM_CXSCREEN);
    scrHeight = GetSystemMetrics(SM_CYSCREEN);
    iLowX = 0;
    iHighX = (scrWidth)/(int)spacingX-1;
    iLowY = 0;
    iHighY = (scrHeight)/(int)spacingY-1;
    spacingX = (scrWidth)/(iHighX+1);
    if (iAlignType == ALIGNEDGE)
        spacingY = (scrHeight)/(iHighY+1);
    if (ItemCount > (iHighX+1)*(iHighY+1))
    {
        wsprintf(WorkString, "At the current screen resolution (%dx%d)," //
            "\nIconoid can only line up %d icons but"      //
            "\n%d icons exist."                            //
            "\n\nThe icons were not repositioned.",        //
            scrWidth, scrHeight, (iHighX+1)*(iHighY+1), ItemCount);
        ConditionalMessageBox(hWnd, WorkString, szTitle, MB_APPLMODAL|MB_ICONASTERISK);

        return ;
    } 
    ShowWindow(hListView, SW_HIDE);

    a = 0;
    EnterCriticalSection(&crObject);
    switch (iAlignType)
    {
        case  ALIGNTOP :
            for (r = 0; r <= iHighY && a < ItemCount; r++)
                for (c = iLowX; c <= iHighX && a < ItemCount; c++)
                {
                    pICNData->icnptPosition.x = iOffset+c *(long)spacingX;
                    pICNData->icnptPosition.y = TOPEDGEOFFSET+r *(long)spacingY;
                    SendMessage(hListView, pICNData->SetPosition, a++, 0);
                } 
            break;
        case  ALIGNBOTTOM :
            for (r = iHighY-(((long)ItemCount+iHighX)/(iHighX+1))+1; r <= iHighY && a < (long)ItemCount; r++)
                for (c = iLowX; c <= iHighX && a < ItemCount; c++)
                {
                    pICNData->icnptPosition.x = iOffset+c *(long)spacingX;
                    pICNData->icnptPosition.y = TOPEDGEOFFSET+r *(long)spacingY;
                    SendMessage(hListView, pICNData->SetPosition, a++, 0);
                } 
            break;
        case  ALIGNLEFT :
            for (c = 0; a < ItemCount; c++)
                for (r = iLowY; r <= iHighY && a < ItemCount; r++)
                {
                    pICNData->icnptPosition.x = iOffset+c *(long)spacingX;
                    pICNData->icnptPosition.y = TOPEDGEOFFSET+r *(long)spacingY;
                    SendMessage(hListView, pICNData->SetPosition, a++, 0);
                } 
            break;
        case  ALIGNRIGHT :
//              for (c = iHighX-((ItemCount+iHighY)/(iHighY+1))+1;  a < ItemCount;c++)
            for (c = iHighX; a < ItemCount; c--)
                for (r = iLowY; r <= iHighY && a < ItemCount; r++)
                {
                    pICNData->icnptPosition.x = iOffset+c *(long)spacingX;
                    pICNData->icnptPosition.y = TOPEDGEOFFSET+r *(long)spacingY;
                    SendMessage(hListView, pICNData->SetPosition, a++, 0);
                } 
            break;

        case  ALIGNEDGE :
            while (a < ItemCount && iLowX <= iHighX && iLowY <= iHighY)
            {
                r = iLowY;                                 // run across top row
                for (c = iLowX; c <= iHighX && a < ItemCount; c++, a++)
                {
                    pICNData->icnptPosition.x = iOffset+c *(long)spacingX;
                    pICNData->icnptPosition.y = r *(long)spacingY;
                    SendMessage(hListView, pICNData->SetPosition, a, 0);
                } 
                iLowY++;                                   // done with top row so bump top row num
                c = iHighX;                                // go down right side
                for (r = iLowY; r <= iHighY && a < ItemCount; r++, a++)
                {
                    pICNData->icnptPosition.x = iOffset+c *(long)spacingX;
                    pICNData->icnptPosition.y = r *(long)spacingY;
                    SendMessage(hListView, pICNData->SetPosition, a, 0);
                } 
                iHighX--;                                  // done with right column, so decrease col num
                r = iHighY;                                // run across bottom row
                for (c = iHighX; c >= iLowX && a < ItemCount; c--, a++)
                {
                    pICNData->icnptPosition.x = iOffset+c *(long)spacingX;
                    pICNData->icnptPosition.y = r *(long)spacingY;
                    SendMessage(hListView, pICNData->SetPosition, a, 0);
                } 
                iHighY--;                                  // done with bottom row so bump bottom row num up
                c = iLowX;                                 // go up left side
                for (r = iHighY; r >= iLowY && a < ItemCount; r--, a++)
                {
                    pICNData->icnptPosition.x = iOffset+c *(long)spacingX;
                    pICNData->icnptPosition.y = r *(long)spacingY;
                    SendMessage(hListView, pICNData->SetPosition, a, 0);
                } 
                iLowX++;                                   // done with left column so move in 1 column
            } 
            break;

#ifdef   skipthis
        case 99 :
            {
                int           *hix = new int[iHighY+1];
                int           *lox = new int[iHighY+1];

                if (ItemCount <= 2*((iHighX+1)+(iHighY-1)))
                {
                    AlignSpecial(hWnd, 99);
                    return ;
                } 
                for (a = 0; a <= iHighY; a++)
                {
                    lox[a] = 0;
                    hix[a] = scrWidth;
                } 
                a = 0;
                while (a < ItemCount)
                {
//top
                    r = iLowY;                             // run across top row
                    c = lox[r];
                    SendMessage(hListView, pICNData->GetPosition, a, 0);
                    iWidth = pICNData->icnRectBounds.right-pICNData->icnRectBounds.left; //
                    iOffset = max(0, pICNData->icnptPosition.x-pICNData->icnRectBounds.left); //
                    while ((a < ItemCount) && (hix[r] > c+iWidth))
                    {
                        pICNData->icnptPosition.x = c+iOffset;
                        pICNData->icnptPosition.y = r *spacingY;
                        SendMessage(hListView, pICNData->SetPosition, a, 0);
                        SendMessage(hListView, pICNData->GetPosition, a, 0);
                        c = pICNData->icnRectBounds.right;
                        SendMessage(hListView, pICNData->GetPosition, ++a, 0);
                        iWidth = pICNData->icnRect.right-pICNData->icnRect.left; //
                        iOffset = max(0, pICNData->icnptPosition.x-pICNData->icnRectBounds.left); //
                    } 
                    iLowY++;                               // done with top row so bump top row num
// right
             //   c = iHighX;            // go down right side
                    for (r = iLowY; r <= iHighY && a < ItemCount; r++)
                    {
                       // if (!iLowX)    // first pass
                        hix[r] = spacingX *iHighX+iWidth-iOffset;
                        pICNData->icnptPosition.x = hix[r]-iWidth+iOffset;
                        pICNData->icnptPosition.y = r *spacingY;
                        SendMessage(hListView, pICNData->SetPosition, a, 0);
                        SendMessage(hListView, pICNData->GetPosition, a, 0);
                        hix[r] = pICNData->icnRectBounds.left;
                        SendMessage(hListView, pICNData->GetPosition, ++a, 0);
                        iWidth = pICNData->icnRectBounds.right-pICNData->icnRectBounds.left; //
                        iOffset = max(0, pICNData->icnptPosition.x-pICNData->icnRectBounds.left); //
                    } 
                    iHighX--;                              // done with right column, so decrease col num
// bottom
                    r = iHighY;                            // run across bottom row
                    SendMessage(hListView, pICNData->GetPosition, a, 0);
                    iWidth = pICNData->icnRectBounds.right-pICNData->icnRectBounds.left; //
                    iOffset = max(0, pICNData->icnptPosition.x-pICNData->icnRectBounds.left); //
                    c = hix[r];
                    while ((a < ItemCount) && (lox[r] < c-iWidth))
                    {
                        pICNData->icnptPosition.x = c-iWidth+iOffset;
                        pICNData->icnptPosition.y = r *spacingY;
                        SendMessage(hListView, pICNData->SetPosition, a, 0);
                        SendMessage(hListView, pICNData->GetPosition, a, 0);
                        c = min(pICNData->icnRectBounds.left, pICNData->icnRect.left);
                        SendMessage(hListView, pICNData->GetPosition, ++a, 0);
                        iWidth = pICNData->icnRectBounds.right-pICNData->icnRectBounds.left; //
                        iOffset = max(0, pICNData->icnptPosition.x-pICNData->icnRectBounds.left); //
                    } 
// left
                    c = iLowX;                             // go up left side
                    for (r = iHighY; r >= iLowY && a < ItemCount; r--)
                    {
                        pICNData->icnptPosition.x = lox[r]+iOffset;
                        pICNData->icnptPosition.y = r *spacingY;
                        SendMessage(hListView, pICNData->SetPosition, a, 0);
                        SendMessage(hListView, pICNData->GetPosition, a, 0);
                        lox[r] = pICNData->icnRectBounds.right;
                        SendMessage(hListView, pICNData->GetPosition, ++a, 0);
                        iWidth = pICNData->icnRectBounds.right-pICNData->icnRectBounds.left; //
                        iOffset = max(0, pICNData->icnptPosition.x-pICNData->icnRectBounds.left); //
                    } 
                    iHighY--;                              // done with bottom row so bump bottom row num up
                    iLowX++;                               // done with left column so move in 1 column
                } 
                delete        hix;
                delete        lox;
            } 
            break;
#endif
        default  :
            ;
    } 

    LeaveCriticalSection(&crObject);
    if (icSettings.bAutoAuto && !icSettings.bTransparent)
        SendMessage(hWnd, WM_COMMAND, ID_CMDAUTO, 0);
    ShowWindow(hListView, SW_SHOW);
    bIconsAreScrambled = TRUE;
    EnableWindow(GetDlgItem(hDialog, IDC_CMDSAVERELATIVE), FALSE);
    EnableWindow(GetDlgItem(hDialog, ID_CHKSAVEREST), FALSE);
} 
