//
// FUNCTION: DlgWndProc(HWND, unsigned, WORD, LONG)
//
// PURPOSE:  Processes messages for the main window.
//
// WM_COMMAND  - process the application menu
// WM_PAINT    - Paint the main window
// WM_DESTROY  - post a quit message and return
//
//
//#define WINVER 0x0500

#include "stdafx.h"
#include "windows.h"
#include "windowsx.h"
#define  APSTUDIO_INVOKED
#undef   APSTUDIO_READONLY_SYMBOLS
#include "resource.h"
#include "commctrl.h"
#include "commdlg.h"
#include <shellapi.h>
#include <Shlwapi.h>
#include <mmsystem.h>
#include <stdio.h>     
#include <process.h>
#include "tr3.h"
//COLORREF crWebPage;
//COLORREF crFAQ;
WNDPROC oldComboWndProc = NULL;

WNDPROC       oldListboxWndProc = NULL;
BOOL          bExitBoxActive = FALSE;

LPCTSTR       idc_hand = IDC_HAND;
RGBTRIPLE     *rgbBMPArray = NULL;
BITMAPINFO    bmi;
BOOL          bForceSample = FALSE;
BOOL          bSkipSample = FALSE;
BOOL          bUserPressedEscape = FALSE;
int           iOkToSampleScreen = 0;                       // 0 means it is OK
HWND          hItems[_APS_NEXT_CONTROL_VALUE-1000];
CHAR          *szTips[_APS_NEXT_CONTROL_VALUE-1000];
int           iCountDown = 1;
LONG          dwWindowHeight,dwWindowWidth;
HWND          hwndTip;
UINT          iTaskBarCreatedMsg = RegisterWindowMessage("TaskBarCreated");
CHAR          *THANKS1 = "  Original concept and programming by Doug Nadel\n\n x64 port with help from Phil, Highresolution Enterprises";
CHAR          *THANKS2 = "  If you like Iconoid, please consider paying\n whatever you feel it is worth to you.\n\t\t -- Thanks!";

UINT          SettingsChangedCount = 0;

#ifdef   RESIZABLE
DWORD         iXratio,iYratio = 1000;

DWORD         iXorigin[_APS_NEXT_CONTROL_VALUE-1000];
DWORD         iYorigin[_APS_NEXT_CONTROL_VALUE-1000];
DWORD         iXwidth[_APS_NEXT_CONTROL_VALUE-1000];
DWORD         iYheight[_APS_NEXT_CONTROL_VALUE-1000];
DWORD         OriginalClientWidth = 0,OriginalClientHeight = 0;
#endif
extern void WaitWind(HWND hOwner);
COLORREF      crNewVersion = BLUE;
COLORREF      crSupport = BLUE;
COLORREF      crBack = RGB(0xe9,0xf3,0xFA);
COLORREF      crWebPage = BLUE;
COLORREF      crFAQ = BLUE;
COLORREF      crDeskFrame = BLACK;
COLORREF      crAboutColor = ABOUTBOXCOLOR;
UINT          iPositionCycleVal = 5;

RECT          rectDisplayPropsOld,rectDialogBeforeMove;
HWND          hwndDisplayProps;
int           TrayWarningShown = 0;
int           AutoWarningShown = 0;
COLORREF      crUserFore = icSettings.crForeColor;

DWORD WINAPI ProcessChanges(LPVOID junk)
{
    if (0 == iOkToSampleScreen++)
    {
        BOOL          uc = FALSE;
          
        SetTimer(hDialog, 29, 500, 0);
        LockWindowUpdate(hListView);
        int           mode = (int)RegReadDWord("Control Panel\\Desktop", "WallpaperStyle");
          
        if (icSettings.bAutoFG                             //
            || bForceSample                                //
            || (icSettings.bAutoAuto && !icSettings.bTransparent) //
            || icSettings.bSetDesk                         //
            || (icSettings.bNormalize && '2' == mode)      //
            )
        {
            uc = TRUE;
            HBITMAP       hbmp = ReadWallPaper();
          
            if (icSettings.bNormalize && '2' == mode)
                ScaleWallpaper(&hbmp);
            if (hbmp)
                DeleteObject(hbmp);
        } 
        SetWindowBackgroundColor();
        if (((icSettings.bAutoAuto && !icSettings.bTransparent) || bForceSample) && !bSkipSample)
        {
            SendMessage(hDialog, WM_COMMAND, ID_CMDAUTO, 0);
            SampleScreen(hDialog, &icSettings.crBackColor, FALSE);
        } 
        bForceSample = FALSE;
        if (!icSettings.bAutoFG)
            icSettings.crForeColor = crUserFore;
        SetForeColor();
        EnableDisableFunctions();
        if (uc)
            wpUseCount--;
        LockWindowUpdate(NULL);
        bSkipSample = FALSE;
    } 
//      Sleep(1000);
//  InvalidateRect(hDialog, 0, TRUE);
//      UpdateWindow(hDialog);
    return  NULL;
} 

INT_PTR CALLBACK DlgWndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
    static HBRUSH hBrush;
    static HPEN   hPen;
    static NOTIFYICONDATA nid;
    static HBRUSH hBrushStatic;
    static BOOL   bForceExit = FALSE;
    static BOOL   InitialXPDropShadowStatus;
    static BOOL   bOriginalTraySetting;

    switch (message)
    {
        case  WM_INITDIALOG :
            {
                RECT          rect,rect2;
                //LONG          lp = 0;
                int           a;
                TTTOOLINFOA   ti;
                int           oldLeft;
                int           oldTop;
          
                hDialog = hWnd;

#ifdef   CAPTURE
                RegisterHotKey(hDialog, 0xBFD0, MOD_ALT|MOD_CONTROL, 'H');
#endif

#ifdef   RESIZABLE
                POINT         ptCoordinates;
          
                SetWindowLongPtr(hWnd, GWL_STYLE, (GetWindowLongPtr(hWnd, GWL_STYLE)|WS_SIZEBOX));
#endif
// Tooltip (start)
                hwndTip = CreateWindowEx(NULL, TOOLTIPS_CLASS, NULL, WS_POPUP|TTS_NOPREFIX|TTS_ALWAYSTIP, CW_USEDEFAULT, CW_USEDEFAULT, 
                CW_USEDEFAULT, CW_USEDEFAULT, hWnd, NULL, hInst, NULL);

                SetWindowPos(hwndTip, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE|SWP_NOSIZE|SWP_NOACTIVATE);
                SendMessage(hwndTip, TTM_SETMAXTIPWIDTH, 0, GetSystemMetrics(SM_CXSCREEN)/3);
                SetTips();
                GetCurrentWallpaper(szWallPaper);
                ti.cbSize = sizeof ti;                     // tooltip structure size
                ti.uFlags = TTF_IDISHWND|TTF_SUBCLASS;     // tool is a window
                ti.hinst = hInst;                          // instance
                ti.rect.bottom = 0;                        // ignored
                ti.rect.top = 0;                           // ignored
                ti.rect.left = 0;                          // ignored
                ti.rect.right = 0;                         // ignored
                ti.lParam = 0;                             // application can use as desired
                for (a = 0; a < _APS_NEXT_CONTROL_VALUE-1000; a++)
                {
                    hItems[a] = GetDlgItem(hWnd, a+1000);
                    if (szTips[a])
                    {
                        ti.hwnd = GetParent(hItems[a]);    // handle to window owning tooltip dialog
                        ti.uId = (UINT_PTR)hItems[a];      // handle to window for which tooltip is used
                        ti.lpszText = szTips[a];
                        SendMessage(                       // returns LRESULT in lResult
                            hwndTip,                       // handle to destination control
                            TTM_ADDTOOL,                   // message ID
                            wParam,                        // = 0; not used, must be zero
                            (LPARAM)(LPTOOLINFO)&ti        // = (LPARAM) (LPTOOLINFO) lpti;
                            );
                    } 
                } 
// Tooltip (end)
                SetWindowLongPtr(ItemHWnd(IDC_ABOUTTAB), GWLP_WNDPROC, (LONG_PTR)AboutWndProc); // about tab window proc
                SetWindowLongPtr(ItemHWnd(ID_WEBPAGE), GWLP_WNDPROC, (LONG_PTR)LinkWndProc); // webpage link window proc
                SetWindowLongPtr(ItemHWnd(ID_FAQ), GWLP_WNDPROC, (LONG_PTR)LinkWndProc); // faq link window proc
                SetWindowLongPtr(ItemHWnd(IDC_SAMPLEICON), GWLP_WNDPROC, (LONG_PTR)IconWndProc);
                oldComboWndProc = (WNDPROC)SetWindowLongPtr(ItemHWnd(IDC_WPCOMBO), GWLP_WNDPROC, (LONG_PTR)WPComboWndProc);
                oldListboxWndProc = (WNDPROC)SetWindowLongPtr(ItemHWnd(IDC_LIST1), GWLP_WNDPROC, (LONG_PTR)WPListboxWndProc);
                SetWindowLongPtr(ItemHWnd(IDC_WPH), GWLP_WNDPROC, (LONG_PTR)TestImageWndProc); // test image window proc
                InitializeCriticalSection(&crObject);
                bOriginalTraySetting = icSettings.bTrayIcon;
                oldLeft = icSettings.iWindowLeft;
                oldTop = icSettings.iWindowTop;
                GetTempPath(sizeof szBMPfile, szBMPfile);
                strcat(szBMPfile, "iconoid.bmp");
//               SetClassLong(hWnd, GCL_HICON, GetClassLong(hMainWnd, GCL_HICON));
                crWebPage = BLUE;
                crFAQ = BLUE;
                hBrushStatic = CreateSolidBrush(GetSysColor(COLOR_BTNFACE));
                GetWindowRect(hWnd, &rect);
                GetWindowRect(ItemHWnd(ID_TABBOX), &rect2);
                SetWindowText(ItemHWnd(IDC_STATIC10), THANKS1);
                MoveWindow(ItemHWnd(ID_TABBOX), 4, 1, (rect2.right-rect2.left), (rect2.bottom-rect2.top), TRUE);

#ifdef   RESIZABLE
                iXwidth[ID_TABBOX-1000] = rect2.right-rect2.left;
                iYheight[ID_TABBOX-1000] = rect2.bottom-rect2.top;
                iXorigin[ID_TABBOX-1000] = 4;
                iYorigin[ID_TABBOX-1000] = 1;
#endif
                TEXTMETRIC    tm;
                HDC           hdc;

                hdc = GetDC(hWnd);
                GetTextMetrics(hdc, &tm);
                ReleaseDC(hWnd, hdc);
                MoveWindow(hWnd, (GetSystemMetrics(SM_CXSCREEN)-(rect2.right-rect2.left+14))/2, (GetSystemMetrics(SM_CYSCREEN)-(rect.bottom-
                    rect.top))/2, (rect2.right-rect2.left+14), (rect.bottom-rect.top), TRUE);
                GetWindowRect(hWnd, &rect);
                GetWindowRect(ItemHWnd(ID_CMDHELP), &rect2);
            //            rect.bottom = rect2.bottom+4+(icSettings.bStatusBar?20:0);
                rect.bottom = rect2.bottom+4+(icSettings.bStatusBar?tm.tmHeight+tm.tmInternalLeading+tm.tmExternalLeading+2:0);
                MoveWindow(hWnd, (GetSystemMetrics(SM_CXSCREEN)-(rect.right-rect.left))/2, (GetSystemMetrics(SM_CYSCREEN)-(rect.bottom-
                    rect.top))/2, dwWindowWidth = rect.right-rect.left, dwWindowHeight = rect.bottom-rect.top, TRUE);
                if (oldLeft >= 0 && oldTop >= 0)
                    MoveWindow(hWnd, oldLeft, oldTop, dwWindowWidth, dwWindowHeight, TRUE);
//
                MoveChildWindows(hWnd);                    // set up child window locations
                GetRelativeRect(ID_TABBOX, IDC_FRAME7, &rect2);
                OffsetRect(&rect2, 7, 11);
                MoveWindow(ItemHWnd(IDC_ABOUTTAB), rect2.left, rect2.top, (rect2.right-rect2.left), (rect2.bottom-rect2.top-23), TRUE);

#ifdef   RESIZABLE
                for (a = 0; a < _APS_NEXT_CONTROL_VALUE-1000; a++)
                {
                    GetWindowRect(hItems[a], &rect);
                    ptCoordinates.x = rect.left;
                    ptCoordinates.y = rect.top;
                    ScreenToClient(hWnd, &ptCoordinates);
                    iXorigin[a] = ptCoordinates.x;
                    iYorigin[a] = ptCoordinates.y;
                    iXwidth[a] = rect.right-rect.left;
                    iYheight[a] = rect.bottom-rect.top;
                } 
#endif
                {
                    CHAR          *const keyName = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Advanced";
                    CHAR          *const valueName = "ListviewShadow";
          
                    xpDropShadow = IsXPatLeast() && (BOOL)RegReadDWord(keyName, valueName);
                } 
                ReInitializeControlSettings(hWnd);         // Setup child windows (settings, enabled etc)
//
///////////////////////////////////////////////
/// Add tooltips for webpage and faq links
///////////////////////////////////////////////
                RECT          rTabbox,rChild;

                GetWindowRect(ItemHWnd(ID_TABBOX), &rTabbox);
                GetWindowRect(ItemHWnd(ID_WEBPAGE), &rChild);
                SetRect(&ti.rect, rChild.left-rTabbox.left, rChild.top-rTabbox.top, rChild.right-rTabbox.left, rChild.bottom-rTabbox.top);
                ti.uFlags = TTF_SUBCLASS;
                ti.uId = 0;
                ti.lpszText = ItemTip(ID_WEBPAGE);
                SendMessage(hwndTip, TTM_ADDTOOL, wParam, (LPARAM)(LPTOOLINFO)&ti);
                GetWindowRect(ItemHWnd(ID_FAQ), &rChild);
                SetRect(&ti.rect, rChild.left-rTabbox.left, rChild.top-rTabbox.top, rChild.right-rTabbox.left, rChild.bottom-rTabbox.top);
                ti.uId = 1;
                ti.lpszText = ItemTip(ID_FAQ);
                SendMessage(hwndTip, TTM_ADDTOOL, wParam, (LPARAM)(LPTOOLINFO)&ti);
//////////// - end of tool tip additions - /////
                //ULONG         iUpTime = GetTickCount();

#ifdef   skipthis
                if (iWaitTime)
                {
                    if (iUpTime < iWaitTime && iUpTime > 0)
                    {
                        iCountDown = max(1, (iWaitTime-iUpTime)/1000);
                        DialogBox(hInst, "Startbox", hWnd, WaitWndProc);
                    } 
                } 
#endif
                InvalidateRect(hWnd, 0, TRUE);
            //      SetHotKeys();
            //      SendMessage(hDialog,WM_COMMAND,ID_HOTKEYSET,0); // lparam=1 means set
            //      SendMessage(hDialog,WM_COMMAND,ID_HOTKEYSET,1); // lparam=1 means set

                CheckAutoStart();
                SetAutoStart(icSettings.bAutoStart);
                if (icSettings.bAbsolutePosition)
                {
                    if (!CheckForSavedAbsolute())
                        SaveIcons(hWnd, FALSE);
                } 
                else
                    if (!CheckForSavedRelative())
                        SaveIcons(hWnd, FALSE);
                InitialXPDropShadowStatus = CheckXPDropShadow();
                SetTimer(hWnd, 0, 500, NULL);              // for hotkey on the right thread
                SetTimer(hWnd, IDT_TIMER_SAVESETTINGS, 2000, (TIMERPROC)SaveSettingsTimer);
                if (icSettings.bFade)
                    SetTimer(hWnd, IDT_TIMER7, 200, (TIMERPROC)TransTimerProc);
                SetMainTimer(hWnd);
                SetDesktopHide();                          // set desktop hiding
                if (icSettings.bDeskColorOnStart)
                    SetDesktopBackgroundColor(icSettings.crDeskColor);
                SendMessage(hwndTip, TTM_ACTIVATE, icSettings.bStatusBar, 0);
                crUserFore = icSettings.crForeColor;
                SendMessage(hWnd, WM_COMMAND, ID_AUTOFG, 0);

                GetWindowRect(hWnd, &rect);
                MoveWindow(hWnd,                           //
                    max(0, min(rect.left, GetSystemMetrics(SM_CXSCREEN)-(rect.right-rect.left))),  //
                    max(0, min(rect.top, GetSystemMetrics(SM_CYSCREEN)-(rect.bottom-rect.top))),  //
                    rect.right-rect.left, rect.bottom-rect.top, TRUE);

                if (icSettings.bHideWhenStarted)
                {
                    SendMessage(hWnd, USER_TRAY_ACTIVITY, 0, (LPARAM)WM_LBUTTONDOWN);
                    SendMessage(hWnd, USER_TRAY_ACTIVITY, 0, (LPARAM)WM_LBUTTONDOWN);
                } 
                oldSysColor = GetSysColor(COLOR_DESKTOP);
                SetDesktopBackgroundColor(oldSysColor);
//
                SendMessage(ItemHWnd(ID_HIDECOMBO), CB_ADDSTRING, 0, (LPARAM)(LPCTSTR)"Hide (Show Desktop)");
                SendMessage(ItemHWnd(ID_HIDECOMBO), CB_ADDSTRING, 0, (LPARAM)(LPCTSTR)"Start Screen Saver");
                if (m_LockWorkstation)
                    SendMessage(ItemHWnd(ID_HIDECOMBO), CB_ADDSTRING, 0, (LPARAM)(LPCTSTR)"Lock Workstation");
                if (icSettings.iHideMethod > (UINT)(1+(m_LockWorkstation?1:0)) || icSettings.iHideMethod < 0)
                    icSettings.iHideMethod = 0;
//  Enable the following code to move Iconoid to the upper right and WebShots to the lower left
//  by adding the -webshots parameter on startup.
//
                if (bTestingWithWebshots)
                {
                    GetWindowRect(hWnd, &rect);
                    SetWindowPos(hWnd, HWND_TOPMOST, GetSystemMetrics(SM_CXSCREEN)-(rect.right-rect.left), 0, 0, 0, SWP_NOSIZE|
                        SWP_SHOWWINDOW);
                    EnableWindow(hWnd, true);
                    HWND          hWebShots = FindWindow(0, "The Webshots Desktop - www.webshots.com");

                    if (!hWebShots)
                    {
                        if (32 < (LRESULT)ShellExecute(NULL, NULL, "C:\\Program Files\\Webshots\\Swebexec.exe",  //
                            NULL, NULL, SW_SHOWMINIMIZED))
                        {
                            for (a = 1; a <= 30 && !hWebShots; a++)
                            {
                                Sleep(100);
                                hWebShots = FindWindow(0, "The Webshots Desktop - www.webshots.com");
                            } 
                            Sleep(100);
                        } 
                    } 
                    if (hWebShots)
                    {
                        GetWindowRect(hWebShots, &rect);
                        ShowWindow(hWebShots, SW_RESTORE);
                        SetWindowPos(hWebShots, HWND_NOTOPMOST, 0, GetSystemMetrics(SM_CYSCREEN)/3, GetSystemMetrics(SM_CXSCREEN)/2, 2
                            *GetSystemMetrics(SM_CYSCREEN)/3, SWP_SHOWWINDOW);
                    } 
                } 
                if (vi.dwMajorVersion == 4 && vi.dwMinorVersion == 0) // win95
                    idc_hand = IDC_ARROW;
                Restart(hWnd);
                if (bEnableTestMode)
                {
                    bEnableTestMode = !bEnableTestMode;
                    EnableTestMode();
                } 
                if (icSettings.bAutoRestore)
                {
                    RestoreIcons(hWnd);
                } 

#ifdef   RESIZABLE
                GetClientRect(hWnd, &rect);
                OriginalClientWidth = rect.right-rect.left;
                OriginalClientHeight = rect.bottom-rect.top;
#endif
            } 

            break;
        case  WM_CTLCOLORSTATIC :
            if (hWnd == GetParent((HWND)lParam))
                switch (GetDlgCtrlID((HWND)lParam))
                {
                    case  ID_FGCOLOR :
                        DeleteObject(hBrush);
                        hBrush = CreateSolidBrush(icSettings.crForeColor);
                        return (BOOL)hBrush;
                    case  ID_BKCOLOR :
                        DeleteObject(hBrush);
                        hBrush = CreateSolidBrush(icSettings.crBackColor);
                        return (BOOL)hBrush;
                    case  ID_DESKCOLORBOX :
                        DeleteObject(hBrush);
                        hBrush = CreateSolidBrush(icSettings.crDeskColor);
                        return (BOOL)hBrush;
                    case  ID_WEBPAGE :
                        SetTextColor((HDC)wParam, crWebPage);
                        SetBkColor((HDC)wParam, GetSysColor(COLOR_BTNFACE));
                        return (BOOL)hBrushStatic;
                    case  ID_FAQ :
                        SetTextColor((HDC)wParam, crFAQ);
                        SetBkColor((HDC)wParam, GetSysColor(COLOR_BTNFACE));
                        return (BOOL)hBrushStatic;
                    case  IDC_ACTIVEMSG :
                        DeleteObject(hBrush);
                        hBrush = CreateSolidBrush(RGB(0xe0, 0xe0, 0xff));
                        SetBkColor((HDC)wParam, RGB(0xE0, 0xE0, 0xff));
                        return (BOOL)hBrush;
                    case  ID_DESKFRAME :
                        SetTextColor((HDC)wParam, crDeskFrame);
                        SetBkColor((HDC)wParam, GetSysColor(COLOR_BTNFACE));
                        return (BOOL)hBrushStatic;
                    case  IDC_LBLINSTR :
                        DeleteObject(hBrush);
                        hBrush = CreateSolidBrush(GetSysColor(COLOR_INFOBK));
                        SetTextColor((HDC)wParam, GetSysColor(COLOR_INFOTEXT));
                        SetBkColor((HDC)wParam, GetSysColor(COLOR_INFOBK));
                        return (BOOL)hBrush;
                } 
            break;
        case  WM_PAINT :                                   // tpaint
            if (TABABOUT == SendMessage(ItemHWnd(ID_TABBOX), TCM_GETCURSEL, 0, 0))
                InvalidateRect(ItemHWnd(IDC_ABOUTTAB), 0, TRUE);
            break;
        case  WM_HSCROLL :
            {
                char          szMsg[40];

                switch (GetDlgCtrlID((HWND)lParam))
                {
                    case  ID_SCROFFDESKTOP :
                        icSettings.tmrOffDesktop = SendMessage(ItemHWnd(ID_SCROFFDESKTOP), TBM_GETPOS, 0, 0);
                        wsprintf(szMsg, "%d Second%s", icSettings.tmrOffDesktop, icSettings.tmrOffDesktop > 1?"s":"");
                        SetWindowText(ItemHWnd(ID_SCROFFINFO), szMsg);
                        InvalidateRect(ItemHWnd(ID_SCROFFINFO), 0, TRUE);
                    case  ID_SCRONDESKTOP :
                        icSettings.tmrOnDesktop = SendMessage(ItemHWnd(ID_SCRONDESKTOP), TBM_GETPOS, 0, 0);
                        wsprintf(szMsg, "%d Second%s", icSettings.tmrOnDesktop, icSettings.tmrOnDesktop > 1?"s":"");
                        SetWindowText(ItemHWnd(ID_SCRONINFO), szMsg);
                        InvalidateRect(ItemHWnd(ID_SCRONINFO), 0, TRUE);
                    case  ID_SCRSHOWDELAY :
                        icSettings.tmrShowDelay = SendMessage(ItemHWnd(ID_SCRSHOWDELAY), TBM_GETPOS, 0, 0);
                        wsprintf(szMsg, "%d.%1d Sec", (icSettings.tmrShowDelay-1)/10, (icSettings.tmrShowDelay-1)%10);
                        SetWindowText(ItemHWnd(ID_SCRDELAYINFO), szMsg);
                        InvalidateRect(ItemHWnd(ID_SCRDELAYINFO), 0, TRUE);
                    case  IDC_TEMPSHOWTIME :
                        icSettings.tmrShowIconsInAlwaysHide = SendMessage(ItemHWnd(IDC_TEMPSHOWTIME), TBM_GETPOS, 0, 0);
                        wsprintf(szMsg, "%d Second%s", icSettings.tmrShowIconsInAlwaysHide, icSettings.tmrShowIconsInAlwaysHide > 1?"s":"");
                        SetWindowText(ItemHWnd(IDC_TEMPSHOWINFO), szMsg);
                        InvalidateRect(ItemHWnd(IDC_TEMPSHOWINFO), 0, TRUE);
                    case  IDC_WPTIME :
                        wptime = (int)SendMessage(ItemHWnd(IDC_WPTIME), TBM_GETPOS, 0, 0);
                        wsprintf(szMsg, "%2d:%2d", wptime/60, 100+wptime%60);
                        strcpy(szMsg+3, szMsg+4);
                        SetWindowText(ItemHWnd(IDC_WPTIMETXT), szMsg);
                        InvalidateRect(ItemHWnd(IDC_WPTIMETXT), 0, TRUE);
                        SendMessage(ItemHWnd(IDC_PROGRESS), PBM_SETRANGE, 0, MAKELPARAM(0, wptime *5));
                } 
            } 
            break;
        case  WM_CTLCOLORLISTBOX :
            {
                if (ItemHWnd(IDC_LIST1) == (HWND)lParam)
                {
             //       COLORREF      bk = (GetFocus() == (HWND)lParam)?GetSysColor(COLOR_WINDOW):RGB(0,120, 255);
                    SetTextColor((HDC)wParam, (GetFocus() == (HWND)lParam)?0:GetSysColor(COLOR_GRAYTEXT));
                    return (BOOL)GetSysColorBrush(COLOR_WINDOW);
                } 
            } 
            break;
        case  WM_COMMAND :
// wmEvent = HIWORD(wParam);
        // Parse the menu selections
            switch (LOWORD(wParam))
            {
                case  ID_HOTKEYS :
                    SendMessage(hDialog, WM_COMMAND, ID_HOTKEYSET, 0); // lparam=1 means set
                    DialogBox(hInst, "HOTKEYS", hWnd, KeysWndProc);
                    SendMessage(hDialog, WM_COMMAND, ID_HOTKEYSET, 1); // lparam=1 means set
                    break;
                case  IDC_EXPORT :
                    ImportExportSettings(FALSE);
                    break;
                case  IDC_IMPORT :
                    ImportExportSettings(TRUE);
                    break;
                case  ID_HOTKEYSET :
                    if (lParam)
                        SetHotKeys();
                    else
                    {
                        UnregisterHotKey(hWnd, 0xBFFC);
                        UnregisterHotKey(hWnd, 0xBFFD);
                        UnregisterHotKey(hWnd, 0xBFFE);
                        UnregisterHotKey(hWnd, 0xBFFF);
                    } 
                    return 0;
                case  IDM_TRANSPARENT :
                    SendMessage(hWnd, WM_COMMAND, icSettings.bTransparent?ID_OPTSOLID:ID_OPTTRANSPARENT, 0);
                    return 0;
                case  ID_OPTTRANSPARENT :
                    {
                        icSettings.bTransparent = TRUE;
                        CheckDlgButton(hWnd, ID_OPTSOLID, FALSE);
                        CheckDlgButton(hWnd, ID_OPTTRANSPARENT, TRUE);
                        SendMessage(hListView, LVM_SETTEXTBKCOLOR, 0, CLR_NONE);
                        SendMessage(hWnd, ID_SETTINGCHANGE, SPI_SETDESKWALLPAPER, 0);
                    } 
                    return 0;
                case  IDM_RESAMPLE :
                case  ID_CMDAUTO :
                    EnableWindow(ItemHWnd(ID_CMDAUTO), iOkToSampleScreen);
                    bForceSample = TRUE;
                                        // fall through
                case  ID_OPTSOLID :
                    {
                        icSettings.bTransparent = FALSE;
                        CheckDlgButton(hWnd, ID_OPTSOLID, TRUE);
                        CheckDlgButton(hWnd, ID_OPTTRANSPARENT, FALSE);
                        SendMessage(hWnd, ID_SETTINGCHANGE, SPI_SETDESKWALLPAPER, 0);
                                        //      SetForeColor();
                    } 
                    return 0;
                case  ID_AUTOFG :
                    icSettings.bAutoFG = IsDlgButtonChecked(hWnd, ID_AUTOFG);
                    SendMessage(hWnd, ID_SETTINGCHANGE, SPI_SETDESKWALLPAPER, 0);
                    return 0;
                case  ID_CHKAUTO :
                    icSettings.bAutoAuto = IsDlgButtonChecked(hWnd, ID_CHKAUTO);
                    return 0;
                case  IDC_DISABLEDROPSHADOWS :
                    {
                        SetXPDesktopSettings(0);
                        SystemParametersInfo(SPI_SETCURSORSHADOW, NULL, FALSE, SPIF_SENDCHANGE|SPIF_UPDATEINIFILE);
                        SendMessageTimeout(HWND_BROADCAST, WM_SETTINGCHANGE, 0, 0, SMTO_NORMAL, 1000, 0);
                        ReInitializeTabs(hWnd);
                    } 
                    return 0;
                case  IDC_ENABLEDROPSHADOWS :
                    {
                        SetXPDesktopSettings(1);
                        SystemParametersInfo(SPI_SETCURSORSHADOW, NULL, (PVOID)TRUE, SPIF_SENDCHANGE|SPIF_UPDATEINIFILE);
                        SendMessageTimeout(HWND_BROADCAST, WM_SETTINGCHANGE, 0, 0, SMTO_NORMAL, 1000, 0);
                        ReInitializeTabs(hWnd);
                    } 
                    return 0;
                case  ID_COMPLIMENT :
                    {
                        COLORREF      crBackground = GetSysColor(COLOR_DESKTOP);
          
                        icSettings.bCompliment = !icSettings.bCompliment;
                        crBackground ^= 0x00FFFFFF;
                        SetDesktopBackgroundColor(crBackground);
                        if (icSettings.bAutoAuto && !icSettings.bTransparent)
                            SendMessage(hWnd, WM_COMMAND, ID_CMDAUTO, 0);

                    } 
                    return 0;

                case  IDC_USESYSDESKTOPCOLOR :
                    if (!icSettings.bLeaveDeskColorAlone)
                    {
                        icSettings.bSetDesk = FALSE;
                        icSettings.bLeaveDeskColorAlone = TRUE;
                        icSettings.bDeskColorOnStart = FALSE;
                        EnableDisableFunctions();
                    } 
                    return 0;
                case  ID_SETDESK :
                    if (icSettings.bSetDesk)
                        return 0;
                    icSettings.bSetDesk = TRUE;
                    icSettings.bLeaveDeskColorAlone = FALSE;
                    icSettings.bDeskColorOnStart = FALSE;
                    EnableDisableFunctions();
            //fall through here because these all have a common action from here
                case  ID_IGNORESOLIDBORDER :
                case  ID_SAMPWHOLE :
                    switch (LOWORD(wParam))
                    {
                        case  ID_IGNORESOLIDBORDER :
                            icSettings.bIgnoreBorder = !icSettings.bIgnoreBorder;
                            break;
                        case  ID_SAMPWHOLE :
                            icSettings.bSampWhole = !icSettings.bSampWhole;
                            break;
                    } 
                    SendMessage(hWnd, ID_SETTINGCHANGE, SPI_SETDESKWALLPAPER, 0);
                    return 0;
                case  ID_SELECTDESKCOLOR :
                    icSettings.bSetDesk = FALSE;
                    icSettings.bLeaveDeskColorAlone = FALSE;
                    icSettings.bDeskColorOnStart = TRUE;
                    EnableDisableFunctions();
                    SetDesktopBackgroundColor(icSettings.crDeskColor);
                    break;
                case  IDC_STRETCH_INNER :
                    icSettings.bStretchInner = IsDlgButtonChecked(hWnd, IDC_STRETCH_INNER) == BST_CHECKED;
                    SendMessage(hDialog, WM_COMMAND, IDC_NORMALIZE, 0);
                    break;
                case  IDC_NORMALIZE :
                    {
                        DWORD         oldStyle = RegReadDWord("Control Panel\\Desktop", "WallpaperStyle");

                        icSettings.bNormalize = IsDlgButtonChecked(hWnd, IDC_NORMALIZE) == BST_CHECKED;
                        EnableWindow(ItemHWnd(IDC_STRETCH_INNER), icSettings.bNormalize);
                        if ('2' == oldStyle && icSettings.bNormalize) // if stretch and normalize
                        {
                                                        //ScaleWallpaper(NULL);              // do the stretch
                      //      DWORD         dummy = NULL;
                     //       ULONG         threadid;
                           //  CreateThread(NULL, 0, ScaleWallpaper, &dummy, NULL, &threadid);
                                                        // -----------------------------------
//                            HBITMAP       hbmp = ReadWallPaper();
//                            if (hbmp)
//                                ScaleWallpaper(&hbmp);
//                            if (hbmp)
//                                DeleteObject(hbmp);
//                            wpUseCount--;
                            SendMessage(hWnd, ID_SETTINGCHANGE, SPI_SETDESKWALLPAPER, 0);
                        } 
                        else                               // if not stretch or not normalize
                            if ('1' != oldStyle)           // if not tile (otherwise we can't tell state w/o another check)
                            {
                                RegWriteSz("Control Panel\\Desktop", "WallpaperStyle", "2"); // revert to streched
                                SystemParametersInfo(SPI_SETDESKWALLPAPER, 0, szWallPaper, SPIF_UPDATEINIFILE|SPIF_SENDWININICHANGE);
                            } 
                    } 
                    break;
                case  IDC_CMDSAVERELATIVE :
                case  IDM_SAVEICONS :
                    SaveIcons(hWnd, TRUE);
                    ReInitializeTabs(hWnd);
                    return 0;
                case  IDC_RESTORENOW :
                case  IDM_RESTOREICONS :
                    ShowWindow(hListView, SW_SHOW);
                    RestoreIcons(hWnd);
                    ReInitializeTabs(hWnd);
                    return 0;
                case  IDC_DANCE :
                    ShowWindow(hListView, SW_SHOW);
                case  IDM_DANCE :
                    pICNData->bDancinFools = !pICNData->bDancinFools;
                    SetWindowText(ItemHWnd(IDC_DANCE), pICNData->bDancinFools?"X":"?");
                    if (pICNData->bDancinFools)
                        DancingIcons();
                    else
                        SendMessage(hWnd, WM_COMMAND, IDC_RESTORENOW, 0);
                    return 0;
                case  IDC_CHKSTATUSBAR :
                    {
                        RECT          rect,rect2;
                        TEXTMETRIC    tm;
                        HDC           hdc;

                        hdc = GetDC(hWnd);
                        GetTextMetrics(hdc, &tm);
                        ReleaseDC(hWnd, hdc);

                        icSettings.bStatusBar = !icSettings.bStatusBar;
                        GetWindowRect(hWnd, &rect);
                        GetWindowRect(ItemHWnd(ID_CMDHELP), &rect2);
                        rect.bottom = rect2.bottom+4+(icSettings.bStatusBar?tm.tmHeight+tm.tmInternalLeading+tm.tmExternalLeading+4:0);
                        dwWindowWidth = rect.right-rect.left;
                        dwWindowHeight = rect.bottom-rect.top;
                        SetWindowPos(hWnd, HWND_TOP, 0, 0,  //
                            dwWindowWidth,                 //
                            dwWindowHeight,                //
                            SWP_NOMOVE|SWP_NOZORDER|SWP_SHOWWINDOW);
                        SendMessage(hwndTip, TTM_ACTIVATE, icSettings.bStatusBar, 0);
                    } 
                    return 0;
                case  IDC_SETCHG :
                    SendMessageTimeout(HWND_BROADCAST, WM_SETTINGCHANGE, 0, 0, SMTO_NORMAL, 1000, 0);
                    break;
                case  IDC_WPRELOAD :
                    InitBetaTab();
                    InvalidateRect(ItemHWnd(IDC_WPH), 0, TRUE);
                    return 0;
                case  IDC_WPPREV :
                    ShowNewWallpaper(-1);
                    break;
                case  IDC_WPNEXT :
                    ShowNewWallpaper(1);
                    break;
                case  IDC_WPSTAR :
                    {
                        LRESULT       count,cur,next;
          
                        next = count = SendMessage(ItemHWnd(IDC_WPCOMBO), CB_GETCOUNT, NULL, NULL);
                        cur = SendMessage(ItemHWnd(IDC_WPCOMBO), CB_GETCURSEL, NULL, NULL);
                        if (cur == CB_ERR)
                            cur = count-1;
                        next = (count == 0)?0:(rand()%count);
                        while (count > 1 && cur == next)
                            next = rand()%count;
                        SendMessage(ItemHWnd(IDC_WPCOMBO), CB_SETCURSEL, next, NULL);
                        InitBetaTab();
                        count = SendMessage(ItemHWnd(IDC_LIST1), LB_GETCOUNT, NULL, NULL);
                        next = (count == 0)?0:(rand()%count);
                        SendMessage(ItemHWnd(IDC_LIST1), LB_SETCURSEL, next, 0);
                        ShowNewWallpaper(0);
                    } 
                    break;
                case  IDC_WPNONE :
                    {
                        RegWriteSz("Control Panel\\Desktop", "TileWallpaper", "0");
                        RegWriteSz("Control Panel\\Desktop", "WallpaperStyle", "0");
                        SystemParametersInfo(SPI_SETDESKWALLPAPER, 0, "", SPIF_UPDATEINIFILE|SPIF_SENDWININICHANGE);
                    } 
                    break;
                case  IDC_WPTILE :
                    {
                        GetCurrentWallpaper(szWallPaper);
                        RegWriteSz("Control Panel\\Desktop", "TileWallpaper", "1");
                        RegWriteSz("Control Panel\\Desktop", "WallpaperStyle", "1");
                        SystemParametersInfo(SPI_SETDESKWALLPAPER, 0, szWallPaper, SPIF_UPDATEINIFILE|SPIF_SENDWININICHANGE);
                    } 
                    break;
                case  IDC_WPCENTER :
                case  IDC_WPSTRETCH :
                    {
                        GetCurrentWallpaper(szWallPaper);
                        RegWriteSz("Control Panel\\Desktop", "TileWallpaper", "0");
                        RegWriteSz("Control Panel\\Desktop", "WallpaperStyle", (IDC_WPCENTER == LOWORD(wParam))?"1":"2");
                        SystemParametersInfo(SPI_SETDESKWALLPAPER, 0, szWallPaper, SPIF_UPDATEINIFILE|SPIF_SENDWININICHANGE);
                    } 
                    break;
                case  IDC_WPRESET :
                    EnableTestMode();
                    EnableTestMode();
                    break;
                case  IDR_BETAMENU :
                case  IDC_WPEXIT :
                    EnableTestMode();
                    break;
                case  IDC_WPCOMBO :
                    switch (HIWORD(wParam))
                    {
                        case  CBN_EDITUPDATE :
                            InitBetaTab();
                            break;
                        case  CBN_SELCHANGE :
                            {
                                CHAR          p[MAX_PATH];
                                LRESULT       sel = SendMessage((HWND)lParam, CB_GETCURSEL, 0, 0);
          
                                if (sel != CB_ERR)
                                {
                                    SendMessage((HWND)lParam, CB_GETLBTEXT, sel, (LPARAM)p);
                                    SetWindowText((HWND)lParam, p);
                                    InitBetaTab();
                                    InvalidateRect(ItemHWnd(IDC_WPH), 0, TRUE);
                                } 
                            } 
                    } 
                    break;
                case  IDC_LIST1 :
                    switch (HIWORD(wParam))
                    {
                        case  LBN_DBLCLK :
                            SendMessage(hWnd, WM_COMMAND, IDC_WPSTART, 1);
                            break;
                        case  LBN_SELCHANGE :
                            InvalidateRect(ItemHWnd(IDC_WPH), 0, TRUE);
                    } 
                    break;
                case  IDC_WPSTART :
                    {
                        static BOOL   running = FALSE;
          
                        if (!running && lParam != 1)
                        {
                            EnableWindow(ItemHWnd(IDC_WPCOMBO), FALSE);
                            EnableWindow(ItemHWnd(IDC_WPRELOAD), FALSE);
                            SetWindowText(ItemHWnd(IDC_WPSTART), "&Stop");
                            SendMessage(ItemHWnd(IDC_PROGRESS), PBM_SETRANGE, 0, MAKELPARAM(0, wptime *5));
                            SendMessage(ItemHWnd(IDC_PROGRESS), PBM_SETPOS, wptime *5, 0);
                            ShowWindow(ItemHWnd(IDC_PROGRESS), (TABBETA == SendMessage(ItemHWnd(ID_TABBOX), TCM_GETCURSEL, 0, 0)));
                            ShowWindow(ItemHWnd(IDC_PROGRESS), SW_SHOW);
                            SetTimer(hWnd, 28, 200, 0);
                            ShowNewWallpaper(0);
                            running = TRUE;
                        } 
                        else
                        {
                            KillTimer(hWnd, 28);
                            SetWindowText(ItemHWnd(IDC_WPSTART), "&Start");
                            running = FALSE;
                            SetWindowText(ItemHWnd(IDC_WPFN), "");
                            SetWindowText(ItemHWnd(IDC_WPH), "");
                            ShowWindow(ItemHWnd(IDC_PROGRESS), SW_HIDE);
                            EnableWindow(ItemHWnd(IDC_WPRELOAD), TRUE);
                            EnableWindow(ItemHWnd(IDC_WPCOMBO), TRUE);
                            if (lParam == 1)
                                ShowNewWallpaper(0);
                        } 
                    } 
                    break;
                case  ID_BOSS :
                    icSettings.bBoss = IsDlgButtonChecked(hWnd, ID_BOSS) == BST_CHECKED;
                    ReInitializeTabs(hWnd);
                    return 0;
                case  IDC_POSBYRES :
                    icSettings.bAbsolutePosition = TRUE;
                    ReInitializeTabs(hWnd);
                    return 0;
                case  IDC_POSRELATIVE :
                    icSettings.bAbsolutePosition = FALSE;
                    ReInitializeTabs(hWnd);
                    return 0;
                case  ID_EDGE :
                    AlignSpecial(hWnd, ALIGNEDGE);
                    return 0;
                case  ID_ALONGTOP :
                    AlignSpecial(hWnd, ALIGNTOP);
                    return 0;
                case  ID_ALONGBOTTOM :
                    AlignSpecial(hWnd, ALIGNBOTTOM);
                    return 0;
                case  ID_ALONGRIGHT :
                    AlignSpecial(hWnd, ALIGNRIGHT);
                    return 0;
                case  ID_ALONGLEFT :
                    AlignSpecial(hWnd, ALIGNLEFT);
                    return 0;
                case  ID_CHKAUTOSTART :
                    {
                        //char          szMessage[500] = "";
                        icSettings.bAutoStart = !icSettings.bAutoStart;

                        SetAutoStart(icSettings.bAutoStart);

#ifdef   skipthis
                        if (icSettings.bAutoStart)
                            if (!AutoWarningShown++)
                            {
                                if (iWaitTime)
                                    wsprintf(szMessage, "Iconoid will start when Windows starts but"
                                        "\nwill not operate until the system has been running"
                                        "\nat least %d seconds in order to avoid system conflicts."
                                        "\n\nYou can change the delay when Windows starts by "
                                        "\nstarting Iconoid with the -wait nn parameter."
                                        "\n\nTo start Iconoid with the -wait parameter, edit the"
                                        "\nshortcut which starts Iconoid and add -wait nn after the "
                                        "\nprogram name (wher nn is the number of seconds to wait)."
                                        "\n\nSee the FAQ (frequently asked questions) for more details."
                                        "\n\nThis message will not be shown again until Iconoid is""\nrestarted.", iWaitTime/1000);
                                else
                                    strcpy(szMessage, "Iconoid will start when Windows starts."
                                        "\n\nIf you find that Iconoid settings get lost when you reboot"
                                        "\nWindows, add the -wait parameter to the shortcut you use""\nto start Iconoid."
                                        "\n\nSee the FAQ (frequently asked questions) for more details."
                                        "\n\nThis message will not be shown again until Iconoid is""\nrestarted.");
                                ConditionalMessageBox(hWnd, szMessage, "Iconoid", MB_ICONASTERISK|MB_APPLMODAL);
                            } 
#endif
                    } 
                    return 0;
                case  IDC_FADE :
                    icSettings.bFade = !icSettings.bFade;
                    if (icSettings.bFade)
                        SetTimer(hWnd, IDT_TIMER7, 200, (TIMERPROC)TransTimerProc);
                    else
                        KillTimer(hWnd, IDT_TIMER7);
                    return 0;
                case  IDC_CONTEXTMENU :
                    icSettings.bContextMenu = !icSettings.bContextMenu;
                    pICNData->bShowContextMenu = icSettings.bContextMenu;
                    return 0;
                case  IDCANCEL :
                case  ID_CMDHIDE :
                    ShowWindow(hWnd, SW_HIDE);
                    return 0;
                case  ID_CHKHIDEATSTART :
                    {
                        TCHAR         szMessage[400],szKey[40];

                        icSettings.bHideWhenStarted = !icSettings.bHideWhenStarted;
                        CheckDlgButton(hWnd, ID_CHKHIDEATSTART, icSettings.bHideWhenStarted);
                        if (!icSettings.bTrayIcon && icSettings.bHideWhenStarted)
                        {
                            InterpretHotKey((UINT)icSettings.iShowHideKey, szKey);
                            wsprintf(szMessage, TEXT("You have chosen to hide Iconoid when it starts."
                                "\n\nSince \"Show tray icon\" is not checked (on the \"Tray\" tab), you will"
                                "\nneed to use the Show/Hide hot key (%s) to ""\nshow the Iconoid window the next time Iconoid starts."), 
                                szKey);
                            ConditionalMessageBox(hWnd, szMessage, szTitle, MB_ICONASTERISK|MB_APPLMODAL);
                        } 
                    } 
                    break;
                case  ID_CHKTASKBAR :
                    {
                        TCHAR         szMessage[400],szKey[40];

                        icSettings.bTrayIcon = !icSettings.bTrayIcon || !bHotKeyIsActive;
                        CheckDlgButton(hWnd, ID_CHKTASKBAR, icSettings.bTrayIcon);
                        if (!icSettings.bTrayIcon)
                        {
                            if (!TrayWarningShown++)
                            {
                                InterpretHotKey((UINT)icSettings.iShowHideKey, szKey);
                                wsprintf(szMessage, TEXT("The Iconoid icon in the system tray will be removed."
                                    "\nUse the Show/Hide hot key (%s)""\nto hide and restore the window."
                                    "\n\nThis message will not be shown again until""\nIconoid is restarted."), szKey);
                                ConditionalMessageBox(hWnd, szMessage, szTitle, MB_ICONASTERISK|MB_APPLMODAL);
                            } 
                            Shell_NotifyIcon(NIM_DELETE, &nid);
                        } 
                        else                               // enable tray icon
                        {
                            nid.cbSize = sizeof nid;
                            nid.hIcon = LoadIcon(hInst, (LPCTSTR)IDI_TR3);
                            nid.hWnd = hWnd;
                            strcpy(nid.szTip, szTitle);
                            nid.uCallbackMessage = USER_TRAY_ACTIVITY;
                            nid.uFlags = NIF_ICON|NIF_TIP|NIF_MESSAGE;
                            nid.uID = NULL;
                            Shell_NotifyIcon(NIM_ADD, &nid);
                        } 
                        ReInitializeTabs(hWnd);
                    } 
                    return 0;
                case  ID_CHKSAVEREST :
                    icSettings.bShowSaveRest = !icSettings.bShowSaveRest;
                    ReInitializeTabs(hWnd);
                    return 0;
                case  IDC_TRAYDANCE :
                    icSettings.bShowDance = !icSettings.bShowDance;
                    return 0;
                case  ID_CHKSHOWHIDINGOPTIONS :
                    icSettings.bShowHidingOptions = !icSettings.bShowHidingOptions;
                    return 0;
                case  ID_CHKSHOWBACKGROUNDOPTIONS :
                    icSettings.bShowIconBackgroundOptions = !icSettings.bShowIconBackgroundOptions;
                    return 0;
                case  ID_AUTORESTORE :
                    icSettings.bAutoRestore = !icSettings.bAutoRestore;
                    return 0;
                case  ID_CHKSHOWHELP :
                    icSettings.bShowHelp = !icSettings.bShowHelp;
                    return 0;
                case  ID_CHKHOTCORNER :
                    icSettings.bHotCorner = !icSettings.bHotCorner;
                    CheckDlgButton(hWnd, ID_CHKHOTCORNER, icSettings.bHotCorner);
                    SetMainTimer(hWnd);
                    ReInitializeTabs(hWnd);
                    return 0;
                case  ID_UL :
                    icSettings.cornernum = 0;
                    return 0;
                case  ID_UR :
                    icSettings.cornernum = 1;
                    return 0;
                case  ID_LL :
                    icSettings.cornernum = 2;
                    return 0;
                case  ID_LR :
                    icSettings.cornernum = 3;
                    return 0;
                case  ID_CHKTWOSEC :
                    icSettings.bTwoSecondWait = !icSettings.bTwoSecondWait;
                    CheckDlgButton(hWnd, ID_CHKTWOSEC, icSettings.bTwoSecondWait);
                    return 0;
                case  ID_HIDECOMBO :
                    if (HIWORD(wParam) == CBN_SELCHANGE)
                        icSettings.iHideMethod = (UINT)SendMessage(ItemHWnd(ID_HIDECOMBO), CB_GETCURSEL, 0, 0);
                    return 0;
                case  ID_NEVEREND :
                    icSettings.bConfirmExit = FALSE;
                    icSettings.bNeverEnd = TRUE;
                    SaveICSettings(icSettings, hWnd);
                    return 0;
                case  ID_CHKCONFIRMEXIT :
                    if (!bExitBoxActive)
                    {
                        icSettings.bConfirmExit = TRUE;
                        icSettings.bNeverEnd = FALSE;
                        SaveICSettings(icSettings, hWnd);
                    } 
                    return 0;
                case  ID_EXITEXIT :
                    icSettings.bConfirmExit = FALSE;
                    icSettings.bNeverEnd = FALSE;
                    SaveICSettings(icSettings, hWnd);
                    return 0;
                case  ID_CHKOFFDESKTOP :
                    icSettings.bOffDesktop = !icSettings.bOffDesktop;
                    SetDesktopHide();
                    ReInitializeTabs(hWnd);
                    return 0;
                case  ID_CHKONDESKTOP :
                    icSettings.bOnDesktop = !icSettings.bOnDesktop;
                    SetDesktopHide();
                    ReInitializeTabs(hWnd);
                    return 0;
                case  ID_CHKSHOWDELAY :
                    icSettings.bShowDelay = !icSettings.bShowDelay;
                    SetDesktopHide();
                    ReInitializeTabs(hWnd);
                    return 0;
                case  IDC_TEMPSHOWTXT :
                    icSettings.bShowIconsInAlways = !icSettings.bShowIconsInAlways;
                    pICNData->bShowIconsWhenClickDesktop = icSettings.bShowIconsInAlways;
                    ReInitializeTabs(hWnd);
                    return 0;
                case  IDM_AUTOHIDE :
                case  ID_CHKAUTOHIDE :
                    icSettings.bAutoHide = TRUE;
                    icSettings.bAlwaysHide = FALSE;
                    CheckDlgButton(hWnd, ID_CHKAUTOHIDE, TRUE);
                    CheckDlgButton(hWnd, ID_CHKALWAYSHIDE, FALSE);
                    CheckDlgButton(hWnd, ID_CHKNEVERHIDE, FALSE);
                    pICNData->iCheckState = ID_CHKAUTOHIDE;
                    SetMainTimer(hWnd);
                    SetDesktopHide();
                    ReInitializeTabs(hWnd);
                    return 0;
                case  IDM_ALWAYSHIDE :
                case  ID_CHKALWAYSHIDE :
                    icSettings.bAutoHide = FALSE;
                    icSettings.bAlwaysHide = TRUE;
                    CheckDlgButton(hWnd, ID_CHKAUTOHIDE, FALSE);
                    CheckDlgButton(hWnd, ID_CHKALWAYSHIDE, TRUE);
                    CheckDlgButton(hWnd, ID_CHKNEVERHIDE, FALSE);
                    pICNData->iCheckState = ID_CHKALWAYSHIDE;
                    SetMainTimer(hWnd);
                    SetDesktopHide();
                    ReInitializeTabs(hWnd);
                    return 0;
                case  IDM_NEVERHIDE :
                case  ID_CHKNEVERHIDE :
                    icSettings.bAutoHide = FALSE;
                    icSettings.bAlwaysHide = FALSE;
                    CheckDlgButton(hWnd, ID_CHKAUTOHIDE, FALSE);
                    CheckDlgButton(hWnd, ID_CHKALWAYSHIDE, FALSE);
                    CheckDlgButton(hWnd, ID_CHKNEVERHIDE, TRUE);
                    pICNData->iCheckState = ID_CHKNEVERHIDE;
                    SetMainTimer(hWnd);
                    SetDesktopHide();
                    ShowTaskbar();
                    ReInitializeTabs(hWnd);
                    return 0;
                case  IDC_HIDECURSOR :
                    icSettings.bCursorHide = !icSettings.bCursorHide;
                    CheckDlgButton(hWnd, IDC_HIDECURSOR, icSettings.bCursorHide);
                    return 0;
                case  ID_HIDETASKBAR :
                    icSettings.bHideTaskBar = !icSettings.bHideTaskBar;
                    CheckDlgButton(hWnd, ID_HIDETASKBAR, icSettings.bHideTaskBar);
                    if (icSettings.bHideTaskBar)
                    {
                        if (icSettings.bAlwaysHide)
                            HideTaskbar();
                    } 
                    else
                        ShowTaskbar();
                    return 0;
                case  ID_WEBPAGE :
                case  IDM_WEBPAGE :
                    ShellExecute(hWnd, "open", WEBPAGE_URL, NULL, NULL, SW_SHOWNORMAL);
                    return 0;
                case  ID_DONATE :
                case  IDC_STATIC10 :
                    ShellExecute(hWnd, "open", DONATE_URL, NULL, NULL, SW_SHOWNORMAL);
                    return 0;
                case  ID_TABDEF :
                    ResetTabDefaults(hWnd);
                    crUserFore = icDefaults.crForeColor;
                    return 0;
                case  IDM_EXIT :
                    SendMessage(hWnd, WM_CLOSE, 0, 0);
                    return 0;
                case  ID_CONDITIONAL_EXIT :
                    if (icSettings.bNeverEnd && !bForceExit)
                        SendMessage(hWnd, WM_COMMAND, ID_CMDHIDE, 0);
                    else
                        if (icSettings.bConfirmExit && !bForceExit)
                        {
                            LONG          iReply = -1;

                            DialogBoxParam(hInst, "ConfirmExit", hWnd, CExitWndProc, (LPARAM)&iReply);
                            switch (iReply)
                            {
                                case  IDYES :
                                    SendMessage(hWnd, WM_CLOSE, 0, 0);
                                    break;
                                case  IDC_MINIMIZE :
                                    SendMessage(hWnd, WM_COMMAND, ID_CMDHIDE, 0);
                                    break;
                                default  :
                                    InvalidateRect(hWnd, 0, TRUE);
                            } 
                        } 
                        else
                            SendMessage(hWnd, WM_CLOSE, 0, 0);
                    return 0;
                case  ID_CMDHELP :
                    {
 //                       WIN32_FIND_DATA wfdFileData;
//                        TCHAR         szFileName[MAX_PATH];
//                        HANDLE        hHelpFile;
//                        size_t           i;
//                        char          *helpPages[8];
                // use mnemonics instead of initialization in case tab orders change!!!
           //             helpPages[TABCOLORS] = "colors.htm";
           //             helpPages[TABHIDING] = "hiding.htm";
           //            helpPages[TABPOS] = "positions.htm";
           //             helpPages[TABDESKTOP] = "desktop.htm";
           //             helpPages[TABTRAY] = "tray.htm";
           //             helpPages[TABOPTIONS] = "options.htm";
           //             helpPages[TABABOUT] = "index.html";
           //             helpPages[TABBETA] = "index.html";
//                        GetModuleFileName(hInst, szFileName, MAX_PATH);
//                        for (i = strlen(szFileName); szFileName[i] != '\\'; i--)
//                            ;
//                        szFileName[i] = 0;
//                        strcat(szFileName, "\\help\\");
//                        strcat(szFileName, helpPages[SendMessage(ItemHWnd(ID_TABBOX), TCM_GETCURSEL, 0, 0)]);
//                        hHelpFile = FindFirstFile(szFileName, &wfdFileData);
//                        if (INVALID_HANDLE_VALUE == hHelpFile)
//                        {
                        ShellExecute(hWnd, "open", HELPPAGE_URL, NULL, NULL, SW_SHOWNORMAL);
//                        }
//                        else
//                        {
//                            FindClose(hHelpFile);
//                            ShellExecute(hWnd, "open", szFileName, NULL, szFileName, SW_SHOWNORMAL);
//                        }

                    } 
                    return 0;
                case  ID_FAQ :
                    {
//                        WIN32_FIND_DATA wfdFileData;
//                        TCHAR         szFileName[MAX_PATH];
//                        HANDLE        hHelpFile;
//                        size_t           i;
//                        GetModuleFileName(hInst, szFileName, MAX_PATH);
//                        for (i = strlen(szFileName); szFileName[i] != '\\'; i--)
//                            ;
//                        szFileName[i] = 0;
//                        strcat(szFileName, "\\help\\faq.htm");
//                        hHelpFile = FindFirstFile(szFileName, &wfdFileData);
//                        if (INVALID_HANDLE_VALUE == hHelpFile)
//                        {
                        ShellExecute(hWnd, "open", FAQPAGE_URL, NULL, NULL, SW_SHOWNORMAL);
//                        }
//                       else
//                        {
//                            FindClose(hHelpFile);
//                            ShellExecute(hWnd, "open", szFileName, NULL, szFileName, SW_SHOWNORMAL);
//                        }

                    } 
                    return 0;
                case  ID_NEWVERSION :
//                    CheckForNewVersion( (LPVOID)0);
                    {
                        DWORD         dummy;
                        ULONG         threadid;

                        CreateThread(NULL, 0, CheckForNewVersion, &dummy, NULL, &threadid);
                        InvalidateRect(ItemHWnd(IDC_FRAME7), 0, TRUE);
                        return 0;
                    } 
                case  ID_SUPPORT :
                    HelpRequest();
                    return 0;
                case  ID_CYCLELAYOUT :
                    {
                        static boolean bFirstTime = true;

                        TCHAR         szStyle[2];

                        szStyle[1] = 0;
                        static DWORD  iStyle = RegReadDWord("Control Panel\\Desktop", "WallpaperStyle");

                        iStyle++;

                        if (iStyle > '2')
                            iStyle = '0';

                        szStyle[0] = (TCHAR)iStyle;
                        RegWriteSz("Control Panel\\Desktop", "WallpaperStyle", szStyle);
                        szStyle[0] = ('1' == szStyle[0])?'1':'0';
                        RegWriteSz("Control Panel\\Desktop", "TileWallpaper", szStyle);
                        SystemParametersInfo(SPI_SETDESKWALLPAPER, 0, szWallPaper, SPIF_UPDATEINIFILE|SPIF_SENDWININICHANGE);
                        SendMessage(hDialog, ID_SETTINGCHANGE, SPI_SETDESKWALLPAPER, 0);
                    } 
                    return 0;
                case  ID_CYCLEPOSITION :
                    {
                        if (iPositionCycleVal == 0)
                            iPositionCycleVal = 6;
                        if (--iPositionCycleVal < 5)
                            AlignSpecial(hWnd, iPositionCycleVal);
                        else
                            SendMessage(hWnd, WM_COMMAND, IDC_RESTORENOW, 0);
                    } 
                    return 0;
                default  :
                    return  FALSE;
            } 
            break;

        case  WM_RBUTTONDOWN :

        case  WM_LBUTTONDOWN :
            {
                POINT         ptCursor;
                RECT          rect;
                HWND          hFore,hBack;
                HWND          hControl = 0;
                BOOL          bTransparentWasSet = icSettings.bTransparent;
                BOOL          bAutoFGWasSet = icSettings.bAutoFG;
                BOOL          bSetDeskWasSet = icSettings.bSetDesk;
                //BOOL          bAutoAutoWasSet = icSettings.bAutoAuto;
                DWORD         dwTabID = (DWORD)SendMessage(ItemHWnd(ID_TABBOX), TCM_GETCURSEL, 0, 0);

                GetCursorPos(&ptCursor);
                if (TABCOLORS == dwTabID && m_pSHGetSettings != NULL && IsActiveDesktop())
                {
                    GetWindowRect(ItemHWnd(IDC_ACTIVEMSG), &rect);
                    if (PtInRect(&rect, ptCursor))
                        ShowDisplayProperties();
                } 

                if (TABCOLORS == dwTabID && !CheckXPDropShadow())
                {
                    hFore = ItemHWnd(ID_FGCOLOR);
                    hBack = ItemHWnd(ID_BKCOLOR);
                    GetWindowRect(hFore, &rect);
                    if (PtInRect(&rect, ptCursor))
                        hControl = hFore;
                    else
                    {
                        GetWindowRect(hBack, &rect);
                        if (PtInRect(&rect, ptCursor))
                        {
                            hControl = hBack;
                            //SendMessage(hWnd, WM_COMMAND, ID_OPTSOLID, 0);
                        } 
                    } 
                    if (hControl)
                    {
                        if (hFore == hControl)             // foreground color
                        {
                            if (WM_LBUTTONDOWN == message)
                                SelectColor(hControl, &icSettings.crForeColor);
                            else
                                SampleScreen(hWnd, &icSettings.crForeColor, TRUE);

                            crUserFore = icSettings.crForeColor;
                            CheckDlgButton(hWnd, ID_AUTOFG, bUserPressedEscape && bAutoFGWasSet);
                            SendMessage(hWnd, WM_COMMAND, ID_AUTOFG, 0);
                        } 
                        else                               // back color
                        {
                            bSkipSample = TRUE;
                            if (WM_LBUTTONDOWN == message)
                                SelectColor(hControl, &icSettings.crBackColor);
                            else
                                SampleScreen(hWnd, &icSettings.crBackColor, TRUE);
                            SendMessage(hWnd, WM_COMMAND,  //
                                (bUserPressedEscape && bTransparentWasSet) //
                                ?ID_OPTTRANSPARENT:ID_OPTSOLID, 0);
                        } 
                        InvalidateRect(hControl, 0, TRUE);
                        InvalidateRect(ItemHWnd(IDC_SAMPLETEXT), 0, TRUE);
                    } 
                } 
                else
                    if (TABDESKTOP == dwTabID)
                    {
                        GetWindowRect(ItemHWnd(ID_DESKCOLORBOX), &rect);
                        if (PtInRect(&rect, ptCursor))
                        {
                            hControl = ItemHWnd(ID_DESKCOLORBOX);
                            SendMessage(hWnd, WM_COMMAND, ID_SELECTDESKCOLOR, 0);
                            if (WM_LBUTTONDOWN == message)
                                SelectColor(hControl, &icSettings.crDeskColor);
                            else
                                SampleScreen(hWnd, &icSettings.crDeskColor, TRUE);
                            ReInitializeTabs(hWnd);
                            InvalidateRect(hControl, 0, TRUE);
                            if (!(bUserPressedEscape && bSetDeskWasSet))
                            {
                                InvalidateRect(hControl, 0, TRUE);
                                SetDesktopBackgroundColor(icSettings.crDeskColor);
                                oldSysColor = GetSysColor(COLOR_DESKTOP);
                            } 

                        } 
                        else
                        {
                            TEXTMETRIC    tm;
          
                            GetTextMetrics(GetDC(ItemHWnd(ID_DESKFRAME)), &tm);
                            GetWindowRect(ItemHWnd(ID_DESKFRAME), &rect);
                            rect.bottom = rect.top+tm.tmHeight;
                            if (PtInRect(&rect, ptCursor))
                            {
                                ShowDisplayProperties();
                                crDeskFrame = BLACK;
                                InvalidateRect(ItemHWnd(ID_DESKFRAME), 0, TRUE);
                                UpdateWindow(ItemHWnd(ID_DESKFRAME));
                            } 
                        } 
                    } 
            } 
            return  FALSE;

        case  WM_NOTIFY :
            {
                NMHDR         *pnmhdr;

                pnmhdr = (LPNMHDR)lParam;
                if (TCN_SELCHANGE == pnmhdr->code)
                    ReInitializeTabs(hWnd);
            } 
            break;
        case  WM_KEYDOWN :
            {
                static CHAR   *egg = "TEST";
                static int    pos = 0;
          
                if (egg[pos++] == (CHAR)wParam)
                {
                    if (!egg[pos])
                    {
                        EnableTestMode();
                        pos = 0;
                    } 
                } 
                else
                    pos = 0;
            } 
            if (bEnableTestMode && TABABOUT <= SendMessage(ItemHWnd(ID_TABBOX), TCM_GETCURSEL, 0, 0))
                switch ((UCHAR)wParam)
                {
                    case 188 :                             // comma
                        ShowNewWallpaper(-1);
                        break;
                    case 190 :                             // period
                        ShowNewWallpaper(1);
                        break;
                    case 191 :                             // slash
                        {
                            LRESULT       count;
          
                            count = SendMessage(ItemHWnd(IDC_WPCOMBO), CB_GETCOUNT, NULL, NULL);
                            SendMessage(ItemHWnd(IDC_WPCOMBO), CB_SETCURSEL, count-1, NULL);
                            InitBetaTab();
                            count = SendMessage(ItemHWnd(IDC_LIST1), LB_GETCOUNT, NULL, NULL);
                            SendMessage(ItemHWnd(IDC_LIST1), LB_SETCURSEL, count-1, 0);
                            ShowNewWallpaper(0);
                        } 
                } 
            return 0;
        case  USER_TRAY_ACTIVITY :
            {
                switch (lParam)
                {
                    case  WM_RBUTTONUP :
                        {
                            POINT         ptCursor;

                            GetCursorPos(&ptCursor);
                            DisplayContextMenu(hWnd, ptCursor);
                        } 
                        break;
                    case  WM_LBUTTONDBLCLK :
                        {
                            EnableWindow(hWnd, FALSE);
                            ShowWindow(hWnd, SW_HIDE);
                        } 
                        break;
                    case  WM_LBUTTONDOWN :
                        {
                            if (!GetFocus())
                            {
                                EnableWindow(hWnd, TRUE);
                                SetWindowPos(hWnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE|SWP_NOSIZE|SWP_SHOWWINDOW);
                                SetForegroundWindow(hWnd);
                                SetWindowPos(hWnd, HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOMOVE|SWP_NOSIZE|SWP_SHOWWINDOW);
                            } 
                            else
                            {
                                EnableWindow(hWnd, FALSE);
                                ShowWindow(hWnd, SW_HIDE);
                            } 
                        } 
                        break;
                } 
            } 
            return 0;
        case  WM_MOUSEWHEEL :
            if (TABBETA == SendMessage(ItemHWnd(ID_TABBOX), TCM_GETCURSEL, 0, 0))
            {
                POINT         csr;
          
                GetCursorPos(&csr);
                if (ItemHWnd(IDC_WPH) == WindowFromPoint(csr))
                {
                    HWND          hListbox = ItemHWnd(IDC_LIST1);
                    LRESULT       current = SendMessage(hListbox, LB_GETCURSEL, 0, 0);
                    int           scr = (short)HIWORD(wParam);
          
                    current += (scr < 0)?1:-1;
                    if (current < 0)
                        current = SendMessage(hListbox, LB_GETCOUNT, 0, 0)-1;
                    else
                        if (current >= SendMessage(hListbox, LB_GETCOUNT, 0, 0))
                            current = 0;
                    current = SendMessage(hListbox, LB_SETCURSEL, current, 0);
                    InvalidateRect(ItemHWnd(IDC_WPH), 0, true);
                } 
            } 
            break;
        case  WM_MOUSEMOVE :
            {
                BOOL          bDirections = FALSE;
                RECT          rect;
                POINT         ptCursor;
                LONG          iCurSel;
                COLORREF      oldcrWebPage = crWebPage;
                COLORREF      oldcrFAQ = crFAQ;

                GetWindowRect(hWnd, &rect);
                GetCursorPos(&ptCursor);

                iCurSel = (long)SendMessage(ItemHWnd(ID_TABBOX), TCM_GETCURSEL, 0, 0);
                if (TABCOLORS == iCurSel && m_pSHGetSettings != NULL && IsActiveDesktop())
                {
                    GetWindowRect(ItemHWnd(IDC_ACTIVEMSG), &rect);
                    if (PtInRect(&rect, ptCursor))
                    {
                        SetCursor(LoadCursor(NULL, idc_hand)); // hand
                    } 
                } 

                if (TABCOLORS == iCurSel)
                {
                    GetWindowRect(ItemHWnd(ID_FGCOLOR), &rect);
                    bDirections = PtInRect(&rect, ptCursor);
                    if (!bDirections)
                    {
                        GetWindowRect(ItemHWnd(ID_BKCOLOR), &rect);
                        bDirections = PtInRect(&rect, ptCursor);
                    } 
                    ShowWindow(ItemHWnd(IDC_LBLINSTR), (bDirections && !CheckXPDropShadow())?SW_SHOW:SW_HIDE);
                } 

                if (TABDESKTOP == iCurSel)
                {
                    TEXTMETRIC    tm;
                    CHAR          title[250];
                    SIZE          size;
                    HDC           hdc = GetDC(ItemHWnd(ID_DESKFRAME));
                    HFONT         hfnt,hOldFont;
          
                    hfnt = (HFONT)GetStockObject(ANSI_VAR_FONT);
                    hOldFont = (HFONT)SelectObject(hdc, hfnt);
                    GetTextMetrics(hdc, &tm);
                    GetWindowRect(ItemHWnd(ID_DESKFRAME), &rect);
                    GetWindowText(ItemHWnd(ID_DESKFRAME), title, 249);
                    GetTextExtentPoint32(hdc, title, GetWindowTextLength(ItemHWnd(ID_DESKFRAME)), &size);
                    SelectObject(hdc, hOldFont);
                    rect.bottom = rect.top+size.cy;
                    rect.left += 7;                        // this is just a guess since control calculates this
                    rect.right = rect.left+size.cx;
                    if (PtInRect(&rect, ptCursor))
                    {
                        SetCursor(LoadCursor(NULL, idc_hand)); // hand
                        crDeskFrame = BLUE;
                    } 
                    else
                        crDeskFrame = BLACK;
                    ReleaseDC(hWnd, hdc);
                    InvalidateRect(ItemHWnd(ID_DESKFRAME), 0, TRUE);

                } 

                crFAQ = crWebPage = BLUE;

                GetWindowRect(ItemHWnd(ID_WEBPAGE), &rect);
                if (PtInRect(&rect, ptCursor))
                    crWebPage = RED;
                if (oldcrWebPage != crWebPage)
                {
                    ScreenToClient(hWnd, (LPPOINT)&rect.left);
                    ScreenToClient(hWnd, (LPPOINT)&rect.right);
                    InvalidateRect(hWnd, &rect, TRUE);
                } 
                GetWindowRect(ItemHWnd(ID_FAQ), &rect);
                if (PtInRect(&rect, ptCursor))
                    crFAQ = RED;
                if (oldcrFAQ != crFAQ)
                {
                    ScreenToClient(hWnd, (LPPOINT)&rect.left);
                    ScreenToClient(hWnd, (LPPOINT)&rect.right);
                    InvalidateRect(hWnd, &rect, TRUE);
                } 
                UpdateWindow(hDialog);
            } 
            break;
        case  WM_MOVE :
            {
                RECT          rect;
          
                GetWindowRect(hWnd, &rect);                // use this because params refer to client
                icSettings.iWindowLeft = max(0, rect.left); // horizontal position
                icSettings.iWindowTop = max(0, rect.top);  // vertical position
                if (TABCOLORS == SendMessage(ItemHWnd(ID_TABBOX), TCM_GETCURSEL, 0, 0))
                {
                    InvalidateRect(ItemHWnd(IDC_SAMPLETEXT), 0, TRUE);
                    InvalidateRect(ItemHWnd(IDC_FRAMESAMP), 0, TRUE);
                    UpdateWindow(hDialog);
                } 
                hwndDisplayProps = FindWindow(0, "Display Properties");
                if (hwndDisplayProps                       //
                    && (rectDisplayPropsOld.top == rectDialogBeforeMove.top) //
                    && (rectDisplayPropsOld.left == rectDialogBeforeMove.right || rectDisplayPropsOld.left == rectDialogBeforeMove.left-
                    (rectDisplayPropsOld.right-rectDisplayPropsOld.left)))
                    MoveDisplayProperties(FindWindow(0, "Display Properties"), FALSE);
            } 
            break;
        case  WM_MOVING :
            if (hwndDisplayProps = FindWindow(0, "Display Properties"))
            {
                GetWindowRect(hwndDisplayProps, &rectDisplayPropsOld);
                GetWindowRect(hWnd, &rectDialogBeforeMove);
            } 
            break;
        case  WM_WINDOWPOSCHANGING :                       // insure that display props can't be offscreen when Iconoid closes
            {
                hwndDisplayProps = FindWindow(0, "Display Properties");
                if (hwndDisplayProps                       //
                    && (rectDisplayPropsOld.top == rectDialogBeforeMove.top) //
                    && (rectDisplayPropsOld.left == rectDialogBeforeMove.right || rectDisplayPropsOld.left == rectDialogBeforeMove.left-
                    (rectDisplayPropsOld.right-rectDisplayPropsOld.left)))
                {
                    int           size = GetSystemMetrics(SM_CXMENUSIZE);
          
                    if (((LPWINDOWPOS)lParam)->x < size)
                        ((LPWINDOWPOS)lParam)->x = size;
                    if (((LPWINDOWPOS)lParam)->x > GetSystemMetrics(SM_CXSCREEN)-((LPWINDOWPOS)lParam)->cx-size)
                        ((LPWINDOWPOS)lParam)->x = GetSystemMetrics(SM_CXSCREEN)-((LPWINDOWPOS)lParam)->cx-size;
                } 
            } 
            break;

#ifdef   RESIZABLE
        case  WM_SIZE :
            {
                int           a;
                RECT          rect;

                GetClientRect(hWnd, &rect);
                int           ClientHeight = rect.bottom-rect.top;
                int           ClientWidth = rect.right-rect.left;

                if (!(OriginalClientWidth *OriginalClientWidth))
                    return  FALSE;

                iXratio = (1000*ClientWidth)/OriginalClientWidth;
                iYratio = (1000*ClientHeight)/OriginalClientHeight;
                for (a = 0; a < _APS_NEXT_CONTROL_VALUE-1000; a++)
                {
                    if (iXorigin[a])
                        MoveWindow(hItems[a],              //
                            (iXratio *iXorigin[a])/1000,   //
                            (iYratio *iYorigin[a])/1000,   //
                            (iXratio *iXwidth[a])/1000,    //
                            (iYratio *iYheight[a])/1000,   //
                            TRUE);
                } 
                return  FALSE;
            } 
            break;
#endif

        case  WM_DISPLAYCHANGE :
            EnterCriticalSection(&crObject);
            if (icSettings.bAutoRestore)
            {
                if (CheckForSavedRelative() && !icSettings.bAbsolutePosition //
                    || (CheckForSavedAbsolute() && icSettings.bAbsolutePosition))
                    RestoreIcons(hWnd);
                else
                    SaveIcons(hWnd, TRUE);
            } 
            LeaveCriticalSection(&crObject);
            SendMessage(hWnd, ID_SETTINGCHANGE, SPI_SETDESKWALLPAPER, 0);
            break;
        case  WM_HOTKEY :
            switch (wParam)
            {
                case 0xBFFF :
                    SendMessage(hWnd, USER_TRAY_ACTIVITY, 0, (LPARAM)WM_LBUTTONDOWN);
                    break;
                case 0xBFFE :
                    if (icSettings.bAlwaysHide)
                    {
                        ShowWindow(hListView, SW_SHOW);
                        ShowTaskbar();
                    } 
                    break;
                case 0xBFFD :
                    SendMessage(hWnd, WM_COMMAND, ID_CYCLELAYOUT, 0);
                    break;
                case 0xBFFC :
                    SendMessage(hWnd, WM_COMMAND, ID_CYCLEPOSITION, 0);
                    break;

#ifdef   CAPTURE
                case 0xBFD0 :
                    {
                        ULONG         threadid;
          
                        CreateThread(NULL, 0, CreateHelpMaps, (LPVOID)&hDialog, NULL, &threadid);
                //    CreateHelpMaps(hWnd);
                    } 
                    break;
#endif
            } 
            break;
        case  WM_SYSCOMMAND :
            if (wParam == SC_MINIMIZE)
            {
                SendMessage(hWnd, WM_COMMAND, ID_CMDHIDE, 0);
                return 0;
            } 
            if (wParam == SC_CLOSE)
            {
                SendMessage(hWnd, WM_COMMAND, ID_CONDITIONAL_EXIT, 0);
                return 0;
            } 
            break;
//        case  WM_QUERYENDSESSION :
        case  WM_ENDSESSION :
        case  WM_CLOSE :
            {
            // kill timers though most will not be active anyway
                KillTimer(hWnd, IDT_TIMERCSR);
                KillTimer(hWnd, IDT_TIMER_SAVESETTINGS);
                KillTimer(hWnd, ID_TIMER_SETTINGSCHANGE);
                KillTimer(hWnd, IDT_TIMER2);
                KillTimer(hWnd, IDT_TIMER6);
                KillTimer(hWnd, IDT_TIMER7);
                KillTimer(hWnd, IDT_TIMER8);
                KillTimer(hWnd, IDT_TIMER_FLASH_ABOUT_BOX);
                KillTimer(hWnd, IDT_TIMER_MOVE_ABOUT_TEXT);
                if (bIconsAreScrambled)
                    RestoreIcons(hWnd);
                if (pICNData)
                    if (!pICNData->CursorState)
                        SendMessage(hListView, pICNData->ShowHideCursor, 0, 0);
                SetHook2(FALSE, NULL);
                SetHook(FALSE);
                UnregisterHotKey(hWnd, 0xBFFC);
                UnregisterHotKey(hWnd, 0xBFFD);
                UnregisterHotKey(hWnd, 0xBFFE);
                UnregisterHotKey(hWnd, 0xBFFF);

#ifdef   CAPTURE
                UnregisterHotKey(hWnd, 0xBFD0);
#endif
//                if (iaBMP)
//                    free(iaBMP);
                if (InitialXPDropShadowStatus)
                    SetXPDesktopSettings(InitialXPDropShadowStatus); // Do some XP cleanup
                SaveICSettings(icSettings, hWnd);
                Shell_NotifyIcon(NIM_DELETE, &nid);
                DeleteObject(hBrush);
                DeleteObject(hBrushStatic);
                if (bTestingWithWebshots)
                {
                    HWND          hWebShots;

                    if (hWebShots = FindWindow(0, "The Webshots Desktop - www.webshots.com"))
                        SendMessage(hWebShots, WM_CLOSE, 0, 0);
                } 
                ShowWindow(hListView, SW_SHOW);
                ShowWindow(FindWindow("Progman", 0), SW_SHOW);
                ShowTaskbar();
                if (IsXPatLeast() && message == WM_CLOSE)
                {
                    ShowWindow(hWnd, SW_HIDE);             // fake it to make the close look fast
          //          SendMessageTimeout(HWND_BROADCAST, WM_SETTINGCHANGE, 0, 0, SMTO_NORMAL, 1000, 0);
                } 
                SendMessage(hMainWnd, WM_CLOSE, 0, 0);
                break;
            } 
        case  ID_SETTINGCHANGE :
            {
                hListView = GetDeskTopListView();          // reset here and later in TimerSettingsChange

                SettingsChangedCount++;
                switch (wParam)
                {
                    case 0 :
                    case  SPI_SETDESKPATTERN :
                    case  SPI_SETDESKWALLPAPER :
                        {
                            DWORD         dummy = NULL;
                            ULONG         threadid;
          
                            CreateThread(NULL, 0, ProcessChanges, &dummy, NULL, &threadid);
                        } 
                        break;
                    case  SPI_SETCURSORSHADOW :
                        SetTimer(hWnd, ID_TIMER_SETTINGSCHANGE, 250, (TIMERPROC)TimerSettingsChange);
                        if (TABABOUT == SendMessage(ItemHWnd(ID_TABBOX), TCM_GETCURSEL, 0, 0))
                        {
                            InvalidateRect(hDialog, 0, TRUE);
                            UpdateWindow(hDialog);
                        } 
                        break;
                } 
            } 
            break;
        case  WM_DESTROY :
            PostQuitMessage(0);
            return 0;
        case  WM_TIMER :
            switch (wParam)
            {
                case 9 :
                    {
                        KillTimer(hWnd, wParam);
                        ShowNewWallpaper(0);
                    } 
                case 28 :
                    {
                        int           pos = (int)SendMessage(ItemHWnd(IDC_PROGRESS), PBM_GETPOS, 0, 0);
          
                        SendMessage(ItemHWnd(IDC_PROGRESS), PBM_SETPOS, --pos, 0);
                        if (!pos)
                        {
                            ShowNewWallpaper(1);
                            SendMessage(ItemHWnd(IDC_PROGRESS), PBM_SETPOS, wptime *5, 0);
                        } 
                        break;
                    } 
                case 29 :
                    if (0 == wpUseCount)
                    {
                        if (rgbBMPArray)
                        {
                            vfree(rgbBMPArray);
                            rgbBMPArray = NULL;
                        } 
                        KillTimer(hWnd, wParam);
                        iOkToSampleScreen = 0;
                    } 
                    break;
                default  :
                    {
                        KillTimer(hWnd, wParam);
                        SendMessage(hDialog, WM_COMMAND, ID_HOTKEYSET, 0); // lparam=1 means set
                        SendMessage(hDialog, WM_COMMAND, ID_HOTKEYSET, 1); // lparam=1 means set
                        icSettings.bTrayIcon = !bOriginalTraySetting;
                        TrayWarningShown = -1;             // prohibit message
                        SendMessage(hDialog, WM_COMMAND, ID_CHKTASKBAR, 0);
                        TrayWarningShown = 0;              // allow message if user changes stuff
                    } 
            } 
        default  :
            if (message == iTaskBarCreatedMsg)
            {
                Shell_NotifyIcon(NIM_DELETE, &nid);
                if (icSettings.bTrayIcon)
                    Shell_NotifyIcon(NIM_ADD, &nid);
            } 
    } 

    return  DefWindowProc(hWnd, message, wParam, lParam);
} 

LRESULT CALLBACK IconWndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)

{
    PAINTSTRUCT   ps;
    static HICON  hIcon = LoadIcon(hInst, MAKEINTRESOURCE(IDI_TR3));

    switch (message)
    {
        case  WM_PAINT :
            BeginPaint(hWnd, &ps);
            SetBkMode(ps.hdc, TRANSPARENT);
            DrawIcon(ps.hdc, 0, 0, hIcon);
            EndPaint(hWnd, &ps);
            return 0;
    } 
    return  DefWindowProc(hWnd, message, wParam, lParam);
} 

LRESULT CALLBACK SampleWndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
    PAINTSTRUCT   ps;
    RECT          rect;
    POINT         pt;
          
    switch (message)
    {
        case  WM_PAINT :
            BeginPaint(hWnd, &ps);
            GetDCOrgEx(ps.hdc, &pt);
            GetWindowRect(hWnd, &rect);
            if (rect.left == pt.x && rect.top == pt.y)     // cryptic workaround for phantom box
                if (0 == (WS_EX_LAYERED&GetWindowLong(hDialog, GWL_EXSTYLE)))
                    PaintDesktop(ps.hdc);
            GetClientRect(hWnd, &rect);
            DrawEdge(ps.hdc, &rect, EDGE_RAISED, BF_RECT);
            rect.left += 2;
            rect.top += 2;
            rect.bottom -= 2;
            rect.right -= 2;
            DrawEdge(ps.hdc, &rect, EDGE_RAISED, BF_RECT);
            EndPaint(hWnd, &ps);
            return 0;
            break;
    } 
    return  DefWindowProc(hWnd, message, wParam, lParam);
} 

LRESULT CALLBACK SampleTXWndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
    TCHAR         szText[40] = "Sample Text";
    HBRUSH        hBrush;
    HDC           hdc;
    PAINTSTRUCT   ps;
    RECT          rect;

    switch (message)
    {
        case  WM_PAINT :
            InvalidateRect(ItemHWnd(IDC_FRAMESAMP), 0, TRUE);
            UpdateWindow(ItemHWnd(IDC_FRAMESAMP));
            InvalidateRect(ItemHWnd(IDC_SAMPLEICON), 0, TRUE);
            UpdateWindow(ItemHWnd(IDC_SAMPLEICON));
            InvalidateRect(hWnd, 0, TRUE);
            GetClientRect(hWnd, &rect);
// GetWindowText (hWnd, szText, sizeof (szText)) ;
            hdc = BeginPaint(hWnd, &ps);
            SelectObject(hdc, GetStockObject(DEFAULT_GUI_FONT));
            SetTextColor(hdc, icSettings.crForeColor);
            if (icSettings.bTransparent)
            {
                if (0 == (WS_EX_LAYERED&GetWindowLong(hDialog, GWL_EXSTYLE)))
                    PaintDesktop(ps.hdc);
                SetBkMode(ps.hdc, TRANSPARENT);
            } 
            else
            {
                HPEN          hPen = CreatePen(PS_NULL, 1, 0);

                hPen = (HPEN)SelectObject(hdc, hPen);
                hBrush = CreateSolidBrush(icSettings.crBackColor);
                hBrush = (HBRUSH)SelectObject(hdc, hBrush);
                SetBkColor(hdc, icSettings.crBackColor);
            //SetBkMode(ps.hdc, OPAQUE);
                Rectangle(hdc, rect.left, rect.top, rect.right, rect.bottom);
                DeleteObject(SelectObject(hdc, hBrush));
                DeleteObject(SelectObject(hdc, hPen));
            } 
            DrawText(hdc, szText, -1, &rect, DT_SINGLELINE|DT_CENTER|DT_VCENTER|DT_NOCLIP);
            EndPaint(hWnd, &ps);
            return 0;
    } 
    return  DefWindowProc(hWnd, message, wParam, lParam);
} 

INT_PTR CALLBACK CExitWndProc(HWND hDlg,UINT message,WPARAM wParam,LPARAM lParam)
{
    static LONG   *p;
    static HICON  hIcon;
    RECT          rect;

    switch (message)
    {
        case  WM_INITDIALOG :
            bExitBoxActive = TRUE;
            p = (LONG *)lParam;
            hIcon = LoadIcon(NULL, IDI_QUESTION);
            GetWindowRect(hDlg, &rect);
            SetWindowPos(hDlg, HWND_TOPMOST, (GetSystemMetrics(SM_CXSCREEN)-(rect.right-rect.left))/2, (GetSystemMetrics(SM_CYSCREEN)-
                (rect.bottom-rect.top))/2, 0, 0, SWP_NOSIZE);
            EnableWindow(GetDlgItem(hDlg, ID_CHKEXITHIDE), !icSettings.bConfirmExit);
            EnableWindow(GetDlgItem(hDlg, IDYES),          //
                (icSettings.bConfirmExit)                  //
                || (!icSettings.bNeverEnd && !icSettings.bConfirmExit));
            EnableWindow(GetDlgItem(hDlg, IDC_MINIMIZE),   //
                (icSettings.bConfirmExit)                  //
                || icSettings.bNeverEnd);
            return 0;
        case  WM_COMMAND :
            {
                switch (LOWORD(wParam))
                {
                    case  IDC_CHKNOCONF :                  // ID_CHKEXITHIDE
                        icSettings.bConfirmExit = !icSettings.bConfirmExit;
                        ReInitializeTabs(hDialog);
                        icSettings.bNeverEnd = (BST_CHECKED == IsDlgButtonChecked(hDlg, ID_CHKEXITHIDE));
//icSettings.bConfirmExit=(BST_CHECKED!=IsDlgButtonChecked(hDlg,IDC_CHKNOCONF));
                        EnableWindow(GetDlgItem(hDlg, ID_CHKEXITHIDE), !icSettings.bConfirmExit);
                        EnableWindow(GetDlgItem(hDlg, IDYES),  //
                            (icSettings.bConfirmExit)      //
                            || (!icSettings.bNeverEnd && !icSettings.bConfirmExit));
                        EnableWindow(GetDlgItem(hDlg, IDC_MINIMIZE),  //
                            (icSettings.bConfirmExit)      //
                            || icSettings.bNeverEnd);
                        return 0;
                        break;
                    case  ID_CHKEXITHIDE :                 // ID_CHKEXITHIDE
                        icSettings.bNeverEnd = (BST_CHECKED == IsDlgButtonChecked(hDlg, ID_CHKEXITHIDE));
                        ReInitializeTabs(hDialog);
                        EnableWindow(GetDlgItem(hDlg, IDYES),  //
                            (icSettings.bConfirmExit)      //
                            || !icSettings.bNeverEnd);
                        EnableWindow(GetDlgItem(hDlg, IDC_MINIMIZE),  //
                            (icSettings.bConfirmExit)      //
                            || icSettings.bNeverEnd);
                        return 0;
                        break;
                    case  IDYES :
                    case  IDNO :
                    case  IDC_MINIMIZE :
                        *p = LOWORD(wParam);
                    default  :                             // fall through
                        EndDialog(hDlg, 0);
                        return 0;
                } 
                break;
            } 
            return  FALSE;

        case  WM_DESTROY :
            bExitBoxActive = FALSE;
            return  FALSE;

        case  WM_PAINT :
            {
                RECT          rect;
                PAINTSTRUCT   ps;

                BeginPaint(hDlg, &ps);
                GetClientRect(hDlg, &rect);
                DrawEdge(ps.hdc, &rect, EDGE_RAISED, BF_RECT);
// DrawIcon(ps.hdc,28,8,LoadIcon(NULL,IDI_QUESTION));
                EndPaint(hDlg, &ps);
                ;
            } 
    } 
    return  FALSE;
} 

void SetForeColor()
{
    static COLORREF crOldFore = !icSettings.crForeColor;
    static COLORREF crOldBack = !icSettings.crBackColor;
    static BOOL   OldTransparency = !icSettings.bTransparent;
    static BOOL   OldActiveDesktop = IsActiveDesktop();
    COLORREF      crSaveBack;
    BOOL          NewActiveDesktop = IsActiveDesktop();

    if (icSettings.bAutoFG)
    {
        crSaveBack = icSettings.crBackColor;
        if (icSettings.bTransparent)
            icSettings.crBackColor = SamplePartialScreen1(icSettings.crBackColor);
        icSettings.crForeColor = GetAutoFG();
        if (icSettings.bTransparent)
            icSettings.crBackColor = crSaveBack;
    } 
    if (crOldFore != icSettings.crForeColor                //
        || crOldBack != icSettings.crBackColor             //
        || OldTransparency != icSettings.bTransparent      //
        || NewActiveDesktop != OldActiveDesktop)
    {
        HWND          hAD = hListView;

        pICNData->icnFgColor = icSettings.crForeColor;
        pICNData->icnBkColor = (icSettings.bTransparent)?CLR_NONE:icSettings.crBackColor;
        InvalidateRect(hAD, 0, TRUE);
        InvalidateRect(ItemHWnd(ID_FGCOLOR), 0, TRUE);
        InvalidateRect(ItemHWnd(ID_BKCOLOR), 0, TRUE);
        InvalidateRect(ItemHWnd(IDC_SAMPLETEXT), 0, TRUE);
        crOldFore = icSettings.crForeColor;
        crOldBack = icSettings.crBackColor;
        OldTransparency = icSettings.bTransparent;
        NewActiveDesktop = OldActiveDesktop;
    } 
} 

LRESULT CALLBACK LinkWndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
    static HWND   hWindowWithFocus = 0;

    hWindowWithFocus = GetFocus();
    RECT          rect;

    switch (message)
    {
        case  WM_PAINT :
            {
                PAINTSTRUCT   ps;
                RECT          rect;
                CHAR          szText[101];

                BeginPaint(hWnd, &ps);
                GetClientRect(hWnd, &rect);
                SetBkMode(ps.hdc, TRANSPARENT);
            //              SetTextColor(ps.hdc, GetSysColor(COLOR_WINDOWTEXT));
                switch (GetDlgCtrlID(hWnd))
                {
                    case  ID_WEBPAGE :
                        SetTextColor(ps.hdc, crWebPage);
                        break;
                    case  ID_FAQ :
                        SetTextColor(ps.hdc, crFAQ);
                        break;
                } 
                SelectObject(ps.hdc, GetStockObject(DEFAULT_GUI_FONT));
                if (hWindowWithFocus == hWnd)
                    DrawFocusRect(ps.hdc, &rect);
                GetWindowText(hWnd, szText, 100);
                DrawText(ps.hdc, szText, -1, &rect, DT_LEFT|DT_VCENTER);
                EndPaint(hWnd, &ps);
                return 0;
            } 
            break;
        case  WM_GETDLGCODE :
            return (LRESULT)(hWindowWithFocus == hWnd)?0:DLGC_WANTTAB;
        case  WM_SETFOCUS :
            GetClientRect(hWnd, &rect);
            RedrawWindow(hWnd, &rect, 0, RDW_ERASE|RDW_INVALIDATE);
            break;
        case  WM_KILLFOCUS :
            InvalidateRect(hDialog, 0, TRUE);
            UpdateWindow(hDialog);
            break;
        case  WM_CHAR :
        case  WM_KEYDOWN :
            return 0;
        case  WM_KEYUP :
            if (wParam != VK_SPACE && wParam != VK_RETURN)
                return 0;
            SendMessage(hDialog, WM_COMMAND, GetDlgCtrlID(hWnd), 0);
            InvalidateRect(hDialog, 0, TRUE);
            UpdateWindow(hDialog);
            return 0;
        case  WM_LBUTTONUP :
        case  WM_LBUTTONDOWN :
            SetCursor(LoadCursor(NULL, idc_hand));         // hand
            if (message == WM_LBUTTONUP)
            {
                SendMessage(hDialog, WM_COMMAND, GetDlgCtrlID(hWnd), lParam);
                InvalidateRect(hDialog, 0, TRUE);
                UpdateWindow(hDialog);
            } 
            break;
        case  WM_MOUSEMOVE :
            {
            //    SendMessage(hDialog, WM_MOUSEMOVE, wParam, lParam);
                crNewVersion = crWebPage = crSupport = crFAQ = BLUE;
                switch (GetDlgCtrlID(hWnd))
                {
                    case  ID_WEBPAGE :
                        crWebPage = RED;
                        break;
                    case  ID_FAQ :
                        crFAQ = RED;
                        break;
                } 
                InvalidateRect(ItemHWnd(ID_WEBPAGE), 0, TRUE);
                InvalidateRect(ItemHWnd(ID_FAQ), 0, TRUE);
                UpdateWindow(hDialog);
                SetCursor(LoadCursor(NULL, idc_hand));     // hand
            } 
            break;
    } 
    return  DefWindowProc(hWnd, message, wParam, lParam);
} 
