Attribute VB_Name = "modLocalTimeZone"
'*******************************************************************************
' MODULE:       modLocalTimeZone
' FILENAME:     C:\Documents and Settings\Charlie McNeil\My Documents\bin\FreeClock\modLocalTimeZone.bas
' AUTHOR:       Charlie McNeil
' CREATED:      12-Sep-2003
' COPYRIGHT:    Copyright 2003 Charlie McNeil.
'
'               This file is part of FreeClock.
'
'               FreeClock is free software; you can redistribute it and/or modify
'               it under the terms of the GNU General Public License as published by
'               the Free Software Foundation; either version 2 of the License, or
'               (at your option) any later version.
'
'               FreeClock is distributed in the hope that it will be useful,
'               but WITHOUT ANY WARRANTY; without even the implied warranty of
'               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'               GNU General Public License for more details.
'
'               You should have received a copy of the GNU General Public License
'               along with FreeClock; if not, write to the Free Software
'               Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
'
' DESCRIPTION:
' ***Windows API routines.***
'
' MODIFICATION HISTORY:
' 1.0       14-Sep-2003
'           Charlie McNeil
'           Initial Version
'*******************************************************************************
Option Explicit

Public Type SYSTEMTIME
    wYear As Integer
    wMonth As Integer
    wDayOfWeek As Integer
    wDay As Integer
    wHour As Integer
    wMinute As Integer
    wSecond As Integer
    wMilliseconds As Integer
End Type

Public Type TIME_ZONE_INFORMATION
    Bias As Long
    StandardName(63) As Byte
    StandardDate As SYSTEMTIME
    StandardBias As Long
    DaylightName(63) As Byte
    DaylightDate As SYSTEMTIME
    DaylightBias As Long
End Type

Public Const TIME_ZONE_ID_INVALID As Long = &HFFFFFFFF
Public Const TIME_ZONE_ID_UNKNOWN As Long = 0&
Public Const TIME_ZONE_ID_STANDARD As Long = 1&
Public Const TIME_ZONE_ID_DAYLIGHT As Long = 2&

Public Declare Function GetTimeZoneInformation Lib "kernel32" _
    (lpTimeZoneInformation As TIME_ZONE_INFORMATION) As Long

Public Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" _
    (lpDest As Any, lpSource As Any, ByVal cBytes&)

Public Function GetLocalTimeZone() As String

    Dim tzi As TIME_ZONE_INFORMATION, sCurTimeName$, sMsg$

    Select Case GetTimeZoneInformation(tzi)
        Case TIME_ZONE_ID_UNKNOWN
            
            sMsg = "Unknown timezone ID."
            
        Case TIME_ZONE_ID_STANDARD

            With tzi
                sCurTimeName = String$(32, vbNullChar)
                CopyMemory ByVal StrPtr(sCurTimeName), ByVal VarPtr(.StandardName(0)), 64&

                sCurTimeName = StripNulls(sCurTimeName)

                frmFreeClock.lblLocalTimeZone = Left(sCurTimeName, 25)

                With .StandardDate
                    If .wYear Then
                        sMsg = sCurTimeName & " Begins On " & CStr(.wMonth) & "/" & CStr(.wDay) & "/" & CStr(.wYear) & " At " & CStr(.wHour) & ":" & Format$(.wMinute, "00") & ":" & Format$(.wSecond, "00")
                    Else
                        sMsg = sCurTimeName & " Begins On " & TranslateDay(.wDayOfWeek, .wDay) & " " & GetMonth(.wMonth) & " At " & .wHour & ":" & Format$(.wMinute, "00") & ":" & Format$(.wSecond, "00")
                    End If
                End With
            End With

            sMsg = sMsg & vbCrLf & vbCrLf
            
            Case TIME_ZONE_ID_DAYLIGHT
            
            With tzi
                sCurTimeName = String$(32, vbNullChar)
                CopyMemory ByVal StrPtr(sCurTimeName), ByVal VarPtr(.DaylightName(0)), 64&

                sCurTimeName = StripNulls(sCurTimeName)
                
                frmFreeClock.lblLocalTimeZone = Left(sCurTimeName, 25)

                With .DaylightDate
                    If .wYear Then
                        sMsg = sMsg & sCurTimeName & " Begins On " & CStr(.wMonth) & "/" & CStr(.wDay) & "/" & CStr(.wYear) & " At " & CStr(.wHour) & ":" & Format$(.wMinute, "00") & ":" & Format$(.wSecond, "00")
                    Else
                        sMsg = sMsg & sCurTimeName & " Begins On " & TranslateDay(.wDayOfWeek, .wDay) & " " & GetMonth(.wMonth) & " At " & .wHour & ":" & Format$(.wMinute, "00") & ":" & Format$(.wSecond, "00")
                    End If
                End With
            End With

            sMsg = sMsg & vbCrLf & vbCrLf

            With tzi
                sMsg = sMsg & "Overall Bias:     " & CStr(.Bias / 60) & " Hours Difference Between Current Local Time" _
                    & " & Coordinated Universal Time (UTC)" & vbCrLf & vbCrLf
                sMsg = sMsg & "Standard Bias:  " & CStr(.StandardBias / 60) & " Hours Difference Between Overall Bias" _
                    & " & Standard Time When Calculating Local To UTC Conversions" & vbCrLf & vbCrLf
                sMsg = sMsg & "Daylight Bias   " & CStr(.DaylightBias / 60) & " Hours Difference Between Overall Bias" _
                    & " & Daylight Time When Calculating Local To UTC Conversions"
            End With

        Case TIME_ZONE_ID_INVALID
            sMsg = "Invalid timzone ID.  Unable to return timezone information."

    End Select

    GetLocalTimeZone = sMsg

End Function

Private Function TranslateDay(ByVal nDayOfWeek&, ByVal nDay&) As String

    Dim sReturn$

    sReturn = "The "

    Select Case nDay
        Case 1: sReturn = sReturn & "First "
        Case 2: sReturn = sReturn & "Second "
        Case 3: sReturn = sReturn & "Third "
        Case 4: sReturn = sReturn & "Fourth "
        Case 5: sReturn = sReturn & "Last "
    End Select

    Select Case nDayOfWeek
        Case 0: sReturn = sReturn & "Sunday"
        Case 1: sReturn = sReturn & "Monday"
        Case 2: sReturn = sReturn & "Tuesday"
        Case 3: sReturn = sReturn & "Wednesday"
        Case 4: sReturn = sReturn & "Thursday"
        Case 5: sReturn = sReturn & "Friday"
        Case 6: sReturn = sReturn & "Saturday"
    End Select

    TranslateDay = sReturn & " In"

End Function

Private Function GetMonth(ByVal nMonth&) As String

    Select Case nMonth
        Case 1: GetMonth = "January"
        Case 2: GetMonth = "February"
        Case 3: GetMonth = "March"
        Case 4: GetMonth = "April"
        Case 5: GetMonth = "May"
        Case 6: GetMonth = "June"
        Case 7: GetMonth = "July"
        Case 8: GetMonth = "August"
        Case 9: GetMonth = "September"
        Case 10: GetMonth = "October"
        Case 11: GetMonth = "November"
        Case 12: GetMonth = "December"
    End Select
End Function

Public Function StripNulls(ByVal sText As String) As String
    
    Dim nPosition&

    StripNulls = sText

    nPosition = InStr(sText, vbNullChar)
    If nPosition Then StripNulls = Left$(sText, nPosition - 1)
    If Len(sText) Then If Left$(sText, 1) = vbNullChar Then StripNulls = ""
End Function

Public Function GetGmtTime(Optional StartingDate As Variant) As Date

    Dim lngDiff As Long

    lngDiff = GetTimeDifference()

    If IsMissing(StartingDate) Then
        GetGmtTime = DateAdd("s", -lngDiff, Now)
    Else
        GetGmtTime = DateAdd("s", -lngDiff, StartingDate)
    End If
End Function

Public Function GetTimeDifference() As Long

    Dim tzi As TIME_ZONE_INFORMATION
    Dim lngRetCode As Long
    Dim lngDiff As Long

    lngRetCode = GetTimeZoneInformation(tzi)

    lngDiff = -tzi.Bias * 60

    GetTimeDifference = lngDiff

    If lngRetCode = TIME_ZONE_ID_DAYLIGHT Then
        If tzi.DaylightDate.wMonth <> 0 Then
            GetTimeDifference = lngDiff - tzi.DaylightBias * 60
        End If
    End If

End Function

Public Function GetTimeHere(gmtTime As Date) As Date

    Dim lngDiff As Long

    lngDiff = GetTimeDifference()
    GetTimeHere = DateAdd("s", lngDiff, gmtTime)

End Function
