VERSION 5.00
Begin VB.Form frmFreeClock 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "FreeClock"
   ClientHeight    =   2745
   ClientLeft      =   45
   ClientTop       =   435
   ClientWidth     =   2640
   BeginProperty Font 
      Name            =   "Trebuchet MS"
      Size            =   8.25
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   Icon            =   "frmFreeClock.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   2745
   ScaleWidth      =   2640
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton cmdExit 
      Caption         =   "E&xit"
      Height          =   375
      Left            =   1440
      TabIndex        =   1
      Top             =   2280
      Width           =   1095
   End
   Begin VB.Timer Timer1 
      Left            =   120
      Top             =   2760
   End
   Begin VB.CommandButton cmdAbout 
      Caption         =   "&About"
      Height          =   375
      Left            =   120
      TabIndex        =   0
      Top             =   2280
      Width           =   1095
   End
   Begin VB.Label Label1 
      Caption         =   "UTC"
      BeginProperty Font 
         Name            =   "Trebuchet MS"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   120
      TabIndex        =   2
      Top             =   120
      Width           =   495
   End
   Begin VB.Line Line4 
      X1              =   120
      X2              =   2520
      Y1              =   1080
      Y2              =   1080
   End
   Begin VB.Label lblLocalTimeZone 
      Caption         =   "Local Time"
      BeginProperty Font 
         Name            =   "Trebuchet MS"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   120
      TabIndex        =   5
      Top             =   1200
      Width           =   2535
   End
   Begin VB.Label lblLocal 
      BeginProperty Font 
         Name            =   "Trebuchet MS"
         Size            =   27.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FF0000&
      Height          =   615
      Left            =   120
      TabIndex        =   4
      ToolTipText     =   "Click here to toggle ""Always On Top"" status."
      Top             =   1320
      Width           =   2295
   End
   Begin VB.Label lblUTC 
      BeginProperty Font 
         Name            =   "Trebuchet MS"
         Size            =   27.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   615
      Left            =   120
      TabIndex        =   3
      ToolTipText     =   "Click here to toggle ""Always On Top"" status."
      Top             =   240
      Width           =   2295
   End
   Begin VB.Line Line2 
      X1              =   120
      X2              =   2520
      Y1              =   2160
      Y2              =   2160
   End
   Begin VB.Label lblUTCDate 
      Height          =   255
      Left            =   120
      TabIndex        =   6
      Top             =   840
      Width           =   2295
   End
   Begin VB.Label lblLocalDate 
      Height          =   255
      Left            =   120
      TabIndex        =   7
      Top             =   1920
      Width           =   2295
   End
End
Attribute VB_Name = "frmFreeClock"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'*******************************************************************************
' MODULE:       frmFreeClock
' FILENAME:     C:\Documents and Settings\Charlie McNeil\My Documents\bin\FreeClock\frmFreeClock.frm
' AUTHOR:       Charlie McNeil
' CREATED:      14-Sep-2003
' COPYRIGHT:    Copyright 2003 Charlie McNeil.
'
'               This file is part of FreeClock.
'
'               FreeClock is free software; you can redistribute it and/or modify
'               it under the terms of the GNU General Public License as published by
'               the Free Software Foundation; either version 2 of the License, or
'               (at your option) any later version.
'
'               FreeClock is distributed in the hope that it will be useful,
'               but WITHOUT ANY WARRANTY; without even the implied warranty of
'               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'               GNU General Public License for more details.
'
'               You should have received a copy of the GNU General Public License
'               along with FreeClock; if not, write to the Free Software
'               Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
'
' DESCRIPTION:
' ***Main clock displays.***
'
' MODIFICATION HISTORY:
' 1.0       14-Sep-2003
'           Charlie McNeil
'           Initial Version
'*******************************************************************************
Option Explicit

Private Const HWND_TOPMOST = -1
Private Const HWND_NOTOPMOST = -2
Private Const SWP_NOMOVE = &H2
Private Const SWP_NOREDRAW = &H8
Private Const SWP_NOSIZE = &H1
Private Const WS_EX_TOPMOST = &H8&
Private Const GWL_EXSTYLE = (-20)

Private Declare Function GetWindowLong Lib "user32" Alias "GetWindowLongA" _
    (ByVal hwnd As Long, ByVal nIndex As Long) As Long

Private Declare Function SetWindowPos Lib "user32" _
    (ByVal hwnd As Long, ByVal hWndInsertAfter As Long, ByVal x _
    As Long, ByVal y As Long, ByVal cx As Long, ByVal cy As Long, _
    ByVal wFlags As Long) As Long

Private Declare Function InitCommonControls Lib "comctl32.dll" () As Long

Dim dtUTC As Date
Dim dtLocal As Date

Const LABEL_RED As Long = 3103971
Const LABEL_BLUE As Long = 14452580

Private Sub cmdAbout_Click()
    frmAbout.Show
    frmFreeClock.Hide
End Sub

Private Sub cmdExit_Click()
    Unload Me
End Sub

Private Sub Form_Activate()

    Timer1.Enabled = True
    Timer1.Interval = 1000

    lblUTC.ForeColor = LABEL_RED
    lblLocal.ForeColor = LABEL_BLUE

    Call GetLocalTimeZone

End Sub

Private Sub Form_Click()
    ToggleTopMost
End Sub

Private Sub Form_Initialize()
    InitCommonControls
End Sub

Private Sub lblLocal_Click()
    ToggleTopMost
End Sub

Private Sub lblUTC_Click()
    ToggleTopMost
End Sub

Private Sub Timer1_Timer()

    dtLocal = Now()
    dtUTC = GetGmtTime(Now())

    lblUTC.Caption = Format(dtUTC, "hh:mm:ss")
    lblUTCDate.Caption = Format(dtUTC, "Long Date")
    If frmFreeClock.WindowState = vbMinimized Then
        frmFreeClock.Caption = "UTC: " & Format(dtUTC, "hh:mm:ss")
    Else
        frmFreeClock.Caption = "FreeClock"
    End If

    lblLocal.Caption = Format(dtLocal, "hh:mm:ss")
    lblLocalDate.Caption = Format(dtLocal, "Long Date")

End Sub

Private Sub ToggleTopMost()
    Dim lRet As Long
    Dim lCurSettings As Long

    lCurSettings = GetWindowLong(Me.hwnd, GWL_EXSTYLE)

    If lCurSettings And WS_EX_TOPMOST Then

        lRet = SetWindowPos(Me.hwnd, HWND_NOTOPMOST, 0&, 0&, 0&, 0&, SWP_NOMOVE Or SWP_NOREDRAW Or SWP_NOSIZE)

    Else

        lRet = SetWindowPos(Me.hwnd, HWND_TOPMOST, 0&, 0&, 0&, 0&, SWP_NOMOVE Or SWP_NOREDRAW Or SWP_NOSIZE)

    End If

End Sub
