const
  M = 1.1e4932;

//----------------
function _Mul(const x1, x2: Real): Real;
var
  a1, a2: Real;
begin
  Result:= 1; if Error then Exit;

  a1:= Abs(x1);
  a2:= Abs(x2);

  if ((a2>1) and (a1>M/a2))
  or ((a1>1) and (a2>M/a1))
    then Er(ERR_OVERFLOW)
    else Result:= x1*x2;
end;

//----------------
function _Div(const x1, x2: Real): Real;
var
  a1, a2: Real;
begin
  Result:= 1; if Error then Exit;

  a1:= Abs(x1);
  a2:= Abs(x2);

  if (a2=0)
  or ((a1>1) and (a1/M>a2))
  or ((a2<1) and (a1>M*a2))
    then Er(ERR_OVERFLOW)
    else Result:= x1/x2;
end;

//----------------
function _Sign(const x: Real): Real;
begin
  if x>0 then Result:= 1 else
    if x<0 then Result:= -1 else Result:= 0;
end;

//----------------
function _Add(const x1, x2: Real): Real;
begin
  Result:= 1; if Error then Exit;

  if (_Sign(x1)=_Sign(x2)) and (Abs(x1)>M-Abs(x2))
    then Er(ERR_OVERFLOW)
    else Result:= x1+x2;
end;

//----------------
function _Sub(const x1, x2: Real): Real;
begin
  Result:= _Add(x1, -x2);
end;

//----------------
function _Ln(const x: Real): Real;
begin
  Result:= 1; if Error then Exit;

  if x<0 then Er(ERR_ARG_L0) else
    if x<1/M then Er(ERR_OVERFLOW) else
      Result:= Ln(x);
end;

//----------------
function _Exp(const x: Real): Real;
begin
  Result:= 1; if Error then Exit;

  if x>Ln(M) then Er(ERR_OVERFLOW) else
    if x<-Ln(M) then Result:= 0 else
      Result:= Exp(x);
end;

//----------------
function _ASin(const x: Real): Real;
const
  M_ASin = 1-(1e-19);
begin
  if Abs(x)>1 then begin Er('illegal |arg|>1'); Result:= 1; end else
    if x>M_ASin then Result:= Pi/2 else
      if x<-M_ASin then Result:= -Pi/2 else
        Result:= ArcTan(_Div(x, Sqrt(1-x*x)));
end;

//----------------
function _ACos(const x: Real): Real;
begin
  Result:= Pi/2-_ASin(x);
end;

//----------------
function _Sqrt(const x: Real): Real;
begin
  if x<0 then begin Er(ERR_ARG_L0); Result:= 1; end else
    Result:= Sqrt(x);
end;

//----------------
function _Fact(const x: Real): Real;
var
  i: Longint;
begin
  Result:= 1;
  if IsReal(x) then begin Er(ERR_ARG_REAL); Exit end;
  if x<0 then begin Er(ERR_ARG_L0); Exit end;
  if x>1754 then begin Er(ERR_OVERFLOW); Exit end;

  for i:= 2 to Trunc(x) do
    begin
    //if Result>M/i then begin Er(ERR_OVERFLOW); Exit end;
    Result:= Result*i;
    end;
end;

//----------------
function _PowI(const x: Real; n: Longint): Real;
var
  MaxRes: Real;
  DoCheck: Boolean;
  i: Longint;
begin
  DoCheck:= Abs(x)>1;
  if DoCheck then MaxRes:= Abs(M/x) else MaxRes:= 0;

  Result:= 1;
  for i:= 1 to Abs(n) do
    begin
    if DoCheck and (Abs(Result)>MaxRes) then
      if n>0
        then begin Er(ERR_OVERFLOW); Exit end
        else begin Result:= 0; Exit end;
    Result:= Result*x;
    end;

  if n<0 then Result:= _Div(1, Result);
end;

//----------------
function _PowR(const x1, x2: Real): Real;
begin
  if (x1<0) then begin Er('illegal arg1<0'); Result:= 1; end else
    if (x1<1/M) and (x2>=1) then Result:= 0 else
      Result:= _Exp(_Mul(x2, _Ln(x1)));
end;

//----------------
function _Pow(const x1, x2: Real): Real;
begin
  Result:= 1; if Error then Exit; 

  if (x2=0) then Result:= 1 else
    if (x1=0) and (x2>0) then Result:= 0 else
      if (IsReal(x2)) or (Abs(x2)>1e4)
        then Result:= _PowR(x1, x2)
        else Result:= _PowI(x1, Trunc(x2));
end;
