//----------------
function _Log(const x: TArgList): Real;
begin
  if x.num<>2 then begin Er('invalid arg list'); Result:= 1; Exit end;
  Result:= _Div(_Ln(x.val[2]), _Ln(x.val[1]));
end;

//----------------
// poly(x, a0, a1, a2, ...) = a0 + a1*x + a2*(x**2) + ...
function _Poly(const l: TArgList): Real; 
var
  x: Real;
  i: Longint;
begin
  x:= l.val[1];
  Result:= l.val[l.num];

  for i:= l.num downto 3 do
    begin
    Result:= _Add(_Mul(Result, x), l.val[i-1]);
    if Error then Exit;
    end;
end;
