//----------------
function _Round(const x: Real): Real;
begin
  if x<0 then begin Result:= -_Round(-x); Exit end;
  Result:= Int(x);
  if Frac(x)>=0.5 then Result:= Result+1;
end;

//----------------
function _Ceil(const x: Real): Real;
begin
  Result:= Int(x);
  if Frac(x)>0 then Result:= Result+1;
end;

//----------------
function _Floor(const x: Real): Real;
begin
  Result:= Int(x);
  if Frac(x)<0 then Result:= Result-1;
end;

//----------------
function _Gcd2(x, y: Longint): Longint;
var
  t: Longint;
begin
  x:= Abs(x);
  y:= Abs(y);
  while y<>0 do
    begin
    t:= x mod y;
    x:= y;
    y:= t;
    end;
  Result:= x;
end;

//----------------
function _Lcm2(x, y: Longint): Real;
begin
  if (x=0) or (y=0)
    then Result:= 0
    else Result:= Abs((x div _Gcd2(x, y))*1.0*y);
end;

//----------------
function IsListReal(const x: TArgList): Boolean;
var
  i: Longint;
begin
  Result:= true;
  for i:= 1 to x.num do
    begin
    if IsReal(x.val[i]) then begin Er(ERR_ARG_REAL); Exit end;
    if not IsDWord(x.val[i]) then begin Er('overflow in int arg'); Exit end;
    end;
  Result:= false;
end;

//----------------
function _Gcd(const x: TArgList): Real;
var
  n, i: Longint;
begin
  if IsListReal(x) then begin Result:= 1; Exit end;

  n:= Trunc(x.val[1]);
  for i:= 2 to x.num do
    n:= _Gcd2(n, Trunc(x.val[i]));
  Result:= n;
end;

//----------------
function _Lcm(const x: TArgList): Real;
var
  i: Longint;
begin
  if IsListReal(x) then begin Result:= 1; Exit end;

  Result:= x.val[1];
  for i:= 2 to x.num do
    begin
    if not IsDWord(Result) then begin Er(ERR_OVERFLOW); Exit end;
    Result:= _Lcm2(Trunc(Result), Trunc(x.val[i]));
    end;
end;
