//----------------
function _Shl(a, count: Longint): Longint;
asm
  cmp  count,31
  jle  @@1
@@0:  
  mov  eax,0
  jmp  @@q
@@1:  
  mov  eax,a
  mov  ecx,count
  shl  eax,cl
@@q:
end;

//----------------
function _Shr(a, count: Longint): Longint;
asm
  cmp  count,31
  jle  @@1
@@0:  
  mov  eax,0
  jmp  @@q
@@1:  
  mov  eax,a
  mov  ecx,count
  shr  eax,cl
@@q:
end;

//----------------
function _Sar(a, count: Longint): Longint;
asm
  cmp  count,31
  jle  @@1
  mov  count,31
@@1:
  mov  eax,a
  mov  ecx,count
  sar  eax,cl
end;

//----------------
function IsReal(const x: Real): Boolean;
begin
  Result:= Abs(Frac(x)) > 1e-18;
end;

//----------------
function IsDWord(const x: Real): Boolean;
begin
  Result:= (Int(x) >= -MaxLongint-1) and (Int(x) <= MaxLongint);
end;

//----------------
function IntOp(const func: String; const x1, x2: Real): Real;
var
  n1, n2: Longint;
begin
  Result:= 1;
  if IsReal(x1) then begin Er('illegal real arg1'); Exit end;
  if IsReal(x2) then begin Er('illegal real arg2'); Exit end;
  if not IsDWord(x1) then begin Er('overflow in int arg1'); Exit end;
  if not IsDWord(x2) then begin Er('overflow in int arg2'); Exit end;
  n1:= Trunc(x1);
  n2:= Trunc(x2);

  if (func='&') then begin Result:= n1 and n2; Exit end;
  if (func='|') then begin Result:= n1 or  n2; Exit end;
  if (func='^') then begin Result:= n1 xor n2; Exit end;
  if (func='~') then begin Result:=    not n2; Exit end;

  if (func='//') or (func='%') then
    begin
    if n2=0 then begin Er('illegal arg2=0'); Exit end;
    if (func='//') then begin Result:= n1 div n2; Exit end;
    if (func='%' ) then begin Result:= n1 mod n2; Exit end;
    end;

  //if (func='<<') or (func='>>') or (func='>>>') then
    begin
    if n2<0 then begin Er('illegal arg2<0'); Exit end;
    if (func='<<' ) then begin Result:= _Shl(n1, n2); Exit end;
    if (func='>>' ) then begin Result:= _Shr(n1, n2); Exit end;
    if (func='>>>') then begin Result:= _Sar(n1, n2); Exit end;
    end;
end;
