//----------------
function _SinH(const x: Real): Real;
begin
  Result:= (_Exp(x)-_Exp(-x))/2;
end;

//----------------
function _CosH(const x: Real): Real;
begin
  Result:= (_Exp(x)+_Exp(-x))/2;
end;

//----------------
function _TanH(const x: Real): Real;
const
  M_TanH = 1e3; //~Ln(M)/2
var
  y: Real;
begin
  if x>M_TanH then Result:= 1 else
    if x<-M_TanH then Result:= -1 else
      begin
      y:= Exp(2*x);
      Result:= (y-1)/(y+1);
      end;
end;

//----------------
function _CotH(const x: Real): Real;
begin
  Result:= _Div(1, _TanH(x));
end;

//----------------
function _ASinH(const x: Real): Real;
begin
  if x<0 then Result:= -_ASinH(-x) else
    if x>1e10 then Result:= Ln(2)+Ln(x) else
      Result:= Ln(x+Sqrt(x*x+1));
end;

//----------------
function _ACosH(const x: Real): Real;
begin
  if x<1 then begin Er('illegal arg<1'); Result:= 1; end else
    if x>1e10 then Result:= Ln(2)+Ln(x) else
      Result:= Ln(x+Sqrt(x*x-1));
end;

//----------------
function _ATanH(const x: Real): Real;
begin
  if Abs(x)>1 then begin Er('illegal |arg|>1'); Result:= 1; end else
    if x<0 then Result:= -_ATanH(-x) else
      Result:= _Ln(_Div(1+x, 1-x))/2;
end;

//----------------
function _ACotH(const x: Real): Real;
begin
  if Abs(x)<1 then begin Er('illegal |arg|<1'); Result:= 1; end else
    if x<0 then Result:= -_ACotH(-x) else
      Result:= _Ln(_Div(x+1, x-1))/2;
end;
