//----------------
function IsAngleOverflow(const x: Real): boolean;
begin
  Result:= Abs(x)>1e17;
  if Result then Er(ERR_ARG_BIG);
end;

//----------------
// we need sin(pi)=0 and cos(pi/2)=0, but
// standard Sin and Cos have too low precision

procedure Fix0(var x: Real);
begin
  if Abs(x)<1e-18 then x:= 0;
end;

function Sin(const x: Real): Real;
begin
  if IsAngleOverflow(x) then begin Result:= 1; Exit end;
  Result:= System.Sin(x);
  Fix0(Result);
end;

function Cos(const x: Real): Real;
begin
  if IsAngleOverflow(x) then begin Result:= 1; Exit end;
  Result:= System.Cos(x);
  Fix0(Result);
end;

//----------------
function _Deg(const x: Real): Real;
begin
  Result:= _Mul(x, 180/Pi);
end;

function _Rad(const x: Real): Real;
begin
  Result:= x*(Pi/180);
end;

//----------------
function NormByFactor(const x, factor: Real): Real;
begin
  if IsAngleOverflow(x) then begin Result:= 1; Exit end;
  Result:= x - Int(x/factor)*factor;
  if Result<0 then Result:= Result+factor;
end;

function _NormDeg(const x: Real): Real;
begin
  Result:= NormByFactor(x, 360);
end;

function _NormRad(const x: Real): Real;
begin
  Result:= NormByFactor(x, 2*Pi);
end;
