library StdMath;

{$H- important!}

uses CalcPlug;

var
  Error: LongBool;
  ErrorMsg: ShortString;

procedure Er(const msg: String);
begin
  Error:= true;
  ErrorMsg:= msg;
end;

const
  ERR_OVERFLOW : String[10] = 'overflow';
  ERR_ARG_BIG  : String[15] = 'overflow in arg';
  ERR_ARG_L0   : String[15] = 'illegal arg<0';
  ERR_ARG_REAL : String[20] = 'illegal real arg';

{$I _int  }
{$I _intx }
{$I _std  }
{$I _hyp  }
{$I _list }
{$I _angle}

//--------------------
function CalculateOp1(const func: String; const x: Real): Real;
begin
  if (func='+') then begin Result:= x;                 Exit end;
  if (func='-') then begin Result:= -x;                Exit end;
  if (func='~') then begin Result:= IntOp(func, 0, x); Exit end;
  if (func='!') then begin Result:= byte(x=0);         Exit end;
  Er(ERR_UNKNOWN_FUNC);
  Result:= 1;
end;

//--------------------
function CalculateOp2(const func: String; const x1, x2: Real): Real;
begin
  if (func='+' ) then begin Result:= _Add(x1, x2); Exit end;
  if (func='-' ) then begin Result:= _Sub(x1, x2); Exit end;
  if (func='*' ) then begin Result:= _Mul(x1, x2); Exit end;
  if (func='/' ) then begin Result:= _Div(x1, x2); Exit end;
  if (func='**') then begin Result:= _Pow(x1, x2); Exit end;

  if (func='=' ) or
     (func='==') then begin Result:= byte(x1= x2); Exit end;
  if (func='<>') or
     (func='!=') then begin Result:= byte(x1<>x2); Exit end;
  if (func='<' ) then begin Result:= byte(x1< x2); Exit end;
  if (func='<=') then begin Result:= byte(x1<=x2); Exit end;
  if (func='>' ) then begin Result:= byte(x1> x2); Exit end;
  if (func='>=') then begin Result:= byte(x1>=x2); Exit end;

  if (func='&&') then begin Result:= byte((x1<>0) and (x2<>0)); Exit end;
  if (func='||') then begin Result:= byte((x1<>0) or  (x2<>0)); Exit end;
  if (func='^^') then begin Result:= byte((x1<>0) xor (x2<>0)); Exit end;

  if (func='&' ) or (func='|' ) or (func='^' ) or (func='//') or
     (func='%' ) or (func='<<') or (func='>>') or (func='>>>')
                 then begin Result:= IntOp(func, x1, x2); Exit end;

  Er(ERR_UNKNOWN_FUNC);
  Result:= 1;
end;

//--------------------
function CalculateFunc1(const func: String; const x: Real): Real;
begin
  if (func='exp')    then begin Result:= _Exp(x);              Exit end;
  if (func='ln' ) or
     (func='log')    then begin Result:= _Ln(x);               Exit end;
  if (func='lg' ) or
     (func='log10')  then begin Result:= _Ln(x)/Ln(10);        Exit end;
  if (func='log2')   then begin Result:= _Ln(x)/Ln(2);         Exit end;

  if (func='sqr' )   then begin Result:= _Mul(x, x);           Exit end;
  if (func='sqrt')   then begin Result:= _Sqrt(x);             Exit end;

  if (func='sin' )   then begin Result:= Sin(x);               Exit end;
  if (func='cos' )   then begin Result:= Cos(x);               Exit end;
  if (func='tan' ) or                        
     (func='tg'  )   then begin Result:= _Div(Sin(x), Cos(x)); Exit end;
  if (func='cot' ) or                        
     (func='ctg' )   then begin Result:= _Div(Cos(x), Sin(x)); Exit end;

  if (func='asin' )  then begin Result:= _ASin(x);             Exit end;
  if (func='acos' )  then begin Result:= _ACos(x);             Exit end;
  if (func='atan' )  then begin Result:= ArcTan(x);            Exit end;
  if (func='acot' )  then begin Result:= Pi/2-ArcTan(x);       Exit end;

  if (func='fact' )  then begin Result:= _Fact(x);             Exit end;
  if (func='abs'  )  then begin Result:= Abs(x);               Exit end;
  if (func='sign' )  then begin Result:= _Sign(x);             Exit end;
  if (func='int'  )  then begin Result:= Int(x);               Exit end;
  if (func='frac' )  then begin Result:= Frac(x);              Exit end;

  if (func='round')  then begin Result:= _Round(x);            Exit end;
  if (func='ceil' )  then begin Result:= _Ceil(x);             Exit end;
  if (func='floor')  then begin Result:= _Floor(x);            Exit end;

  if (func='deg'  )  then begin Result:= _Deg(x);              Exit end;
  if (func='rad'  )  then begin Result:= _Rad(x);              Exit end;
  if (func='ndeg' )  then begin Result:= _NormDeg(x);          Exit end;
  if (func='nrad' )  then begin Result:= _NormRad(x);          Exit end;
                   
  if (func='sinh' ) or
     (func='sh'   )  then begin Result:= _SinH(x);             Exit end;
  if (func='cosh' ) or
     (func='ch'   )  then begin Result:= _CosH(x);             Exit end;
  if (func='tanh' ) or
     (func='th'   )  then begin Result:= _TanH(x);             Exit end;
  if (func='coth' ) or
     (func='cth'  )  then begin Result:= _CotH(x);             Exit end;

  if (func='asinh')  then begin Result:= _ASinH(x);            Exit end;
  if (func='acosh')  then begin Result:= _ACosH(x);            Exit end;
  if (func='atanh')  then begin Result:= _ATanH(x);            Exit end;
  if (func='acoth')  then begin Result:= _ACotH(x);            Exit end;

  if (func='sec')    then begin Result:= _Div(1, Cos(x));      Exit end;
  if (func='csc')    then begin Result:= _Div(1, Sin(x));      Exit end;
  if (func='asec')   then begin Result:= _ACos(_Div(1, x));    Exit end;
  if (func='acsc')   then begin Result:= _ASin(_Div(1, x));    Exit end;

  if (func='sech')   then begin Result:= _Div(1, _CosH(x));    Exit end;
  if (func='csch')   then begin Result:= _Div(1, _SinH(x));    Exit end;
  if (func='asech')  then begin Result:= _ACosH(_Div(1, x));   Exit end;
  if (func='acsch')  then begin Result:= _ASinH(_Div(1, x));   Exit end;

  if (func='??')
    then Er(StdMathId)
    else Er(ERR_UNKNOWN_FUNC);
  Result:= 1;
end;

//--------------------
function CalculateFuncL(const func: String; const x: TArgList): Real;
begin
  if (func='log' ) then begin Result:= _Log (x); Exit end;
  if (func='gcd' ) then begin Result:= _Gcd (x); Exit end;
  if (func='lcm' ) then begin Result:= _Lcm (x); Exit end;
  if (func='poly') then begin Result:= _Poly(x); Exit end;
  Er(ERR_UNKNOWN_FUNC);
  Result:= 1;
end;

//------------------
procedure CalcFunc(
  const FuncName: ShortString;
  const FuncArgs: TArgList;
  var ResultValue: Real;
  var ResultError: LongBool;
  var ResultErrorMsg: ShortString); stdcall;
const
  Signs=['+', '-', '*', '/', '^', '~', '&', '|', '%', '<', '>', '=', '!'];
begin
  if ResultError then begin ResultValue:= 1; Exit end;
  Error:= False;
  ErrorMsg:= '';

  if FuncName[1] in Signs
    then
      if FuncArgs.Num=1
        then ResultValue:= CalculateOp1(FuncName, FuncArgs.Val[1])
        else ResultValue:= CalculateOp2(FuncName, FuncArgs.Val[1], FuncArgs.Val[2])
    else
      if FuncArgs.Num=1
        then ResultValue:= CalculateFunc1(FuncName, FuncArgs.Val[1])
        else ResultValue:= CalculateFuncL(FuncName, FuncArgs);

  if Error then ResultValue:= 1;
  ResultError:= Error;
  ResultErrorMsg:= ErrorMsg;
end;

exports
  CalcFunc;

{
var
  TestFunc: TCalcFunc;
begin
  TestFunc:= CalcFunc;
}

end.
