//----------------------
function _Min(const x: TArgList): Real;
var
  i: Longint;
begin
  Result:= x.val[1];
  for i:= 2 to x.num do
    if x.val[i]<Result then Result:= x.val[i];
end;

//----------------------
function _Max(const x: TArgList): Real;
var
  i: Longint;
begin
  Result:= x.val[1];
  for i:= 2 to x.num do
    if x.val[i]>Result then Result:= x.val[i];
end;

//----------------------
function _Sum(const x: TArgList): Real;
var
  i: Longint;
begin
  Result:= 0;
  for i:= 1 to x.num do
    begin
    Result:= _Add(Result, x.val[i]);  if Error then Exit;
    end;
end;

//----------------------
function _SumSq(const x: TArgList): Real;
var
  i: Longint;
begin
  Result:= 0;
  for i:= 1 to x.num do
    begin
    Result:= _Add(Result, _Sqr(x.val[i]));  if Error then Exit;
    end;
end;

//----------------------
function _Prod(const x: TArgList): Real;
var
  i: Longint;
begin
  Result:= 1;
  for i:= 1 to x.num do
    begin
    Result:= _Mul(Result, x.val[i]);  if Error then Exit;
    end;
end;

//----------------------
function _Avg(const x: TArgList): Real;
begin
  Result:= _Sum(x)/x.num;
end;

//----------------------
function IsNegArgument(const x: TArgList): Boolean;
var
  i: Longint;
begin
  for i:= 1 to x.num do
    if x.val[i]<0 then begin SetError(ERR_ARG_L0); Result:= True; Exit end;
  Result:= False;
end;

//----------------------
function _GAvg(const x: TArgList): Real;
begin
  if IsNegArgument(x) then begin Result:= 1; Exit end;
  Result:= _Pow(_Prod(x), 1/x.num);
end;

//----------------------
function _HAvg(const x: TArgList): Real;
var
  i: Longint;
begin
  if IsNegArgument(x) then begin Result:= 1; Exit end;
  Result:= 0;
  for i:= 1 to x.num do
    begin
    Result:= _Add(Result, _Div(1, x.val[i]));  if Error then Exit;
    end;
  Result:= _Div(x.num, Result);
end;

//----------------------
function _QAvg(const x: TArgList): Real;
begin
  Result:= _Sqrt(_SumSq(x)/x.num);
end;

//----------------------
function _Norm(const x: TArgList): Real;
begin
  Result:= _Sqrt(_SumSq(x));
end;

//----------------------
function _VarT(const x: TArgList): Real;
var
  i: Longint;
  Avg: Real;
begin
  Result:= 1;
  Avg:= _Avg(x);  if Error then Exit;

  Result:= 0;
  for i:= 1 to x.num do
    begin
    Result:= _Add(Result, _Sqr(_Sub(x.val[i], Avg)));  if Error then Exit;
    end;
end;

//----------------------
function _VarP(const x: TArgList): Real;
begin
  Result:= _VarT(x)/x.num;
end;

//----------------------
function _VarS(const x: TArgList): Real;
begin
  Result:= _VarT(x)/(x.num-1);
end;

//----------------------
function _StdS(const x: TArgList): Real;
begin
  Result:= _Sqrt(_VarS(x));
end;

//----------------------
function _StdP(const x: TArgList): Real;
begin
  Result:= _Sqrt(_VarP(x));
end;
