library StatFunc;

{$H- to improve speed}

uses CalcPlug, StdMath;

//----------------------
var
  Error: LongBool;
  ErrorMsg: ShortString;

procedure SetError(const Msg: String);
begin
  Error:= True;
  ErrorMsg:= Msg;
end;

//----------------------
{$I StatFunc}

function CalculateList(const func: String; const x: TArgList): Real;
begin
  if (func='min' ) then begin Result:= _Min(x); Exit end;
  if (func='max' ) then begin Result:= _Max(x); Exit end;
  
  if (func='sum' ) then begin Result:= _Sum(x); Exit end;
  if (func='sumsq') then begin Result:= _SumSq(x); Exit end;
  if (func='prod') or
     (func='mul' ) then begin Result:= _Prod(x); Exit end;

  if (func='avg' ) then begin Result:= _Avg(x); Exit end;
  if (func='gavg') then begin Result:= _GAvg(x); Exit end;
  if (func='havg') then begin Result:= _HAvg(x); Exit end;
  if (func='qavg') or
     (func='rms' ) then begin Result:= _QAvg(x); Exit end;
  if (func='norm') then begin Result:= _Norm(x); Exit end;
  
  if (func='vart') then begin Result:= _VarT(x); Exit end;
  if (func='varp') or
     (func='var' ) then begin Result:= _VarP(x); Exit end;
  if (func='vars') then begin Result:= _VarS(x); Exit end;

  if (func='std' ) then begin Result:= _StdS(x); Exit end;
  if (func='stdp') then begin Result:= _StdP(x); Exit end;

  SetError(ERR_UNKNOWN_FUNC);
  Result:= 1;
end;

//----------------------
procedure CalcFunc(
  const FuncName: ShortString;
  const FuncArgs: TArgList;
  var ResultValue: Real;
  var ResultError: LongBool;
  var ResultErrorMsg: ShortString); stdcall;
begin
  if ResultError then begin ResultValue:= 1; Exit end;

  if FuncArgs.Num>1 
    then
      begin
      Error:= False;
      ErrorMsg:= '';
      ResultValue:= CalculateList(FuncName, FuncArgs);
      ResultError:= Error;
      ResultErrorMsg:= ErrorMsg;
      end
    else
      begin
      ResultValue:= 1;
      ResultError:= True;
      ResultErrorMsg:= ERR_UNKNOWN_FUNC;
      end;
end;

exports
  CalcFunc;

begin
  InitStdErrorAddr(@Error, @ErrorMsg);

end.
