unit StdMath;

{$H-}

interface

uses CalcPlug;

function _add(const x, y: Real): Real;
function _sub(const x, y: Real): Real;
function _mul(const x, y: Real): Real;
function _div(const x, y: Real): Real;
function _pow(const x, y: Real): Real;

function _sin  (const x: Real): Real;
function _cos  (const x: Real): Real;
function _tan  (const x: Real): Real;
function _cot  (const x: Real): Real;
function _sec  (const x: Real): Real;
function _csc  (const x: Real): Real;
function _asin (const x: Real): Real;
function _acos (const x: Real): Real;
function _atan (const x: Real): Real;
function _acot (const x: Real): Real;
function _asec (const x: Real): Real;
function _acsc (const x: Real): Real;

function _sinh (const x: Real): Real;
function _cosh (const x: Real): Real;
function _tanh (const x: Real): Real;
function _coth (const x: Real): Real;
function _sech (const x: Real): Real;
function _csch (const x: Real): Real;
function _asinh(const x: Real): Real;
function _acosh(const x: Real): Real;
function _atanh(const x: Real): Real;
function _acoth(const x: Real): Real;
function _asech(const x: Real): Real;
function _acsch(const x: Real): Real;

function _exp  (const x: Real): Real;
function _ln   (const x: Real): Real;
function _log10(const x: Real): Real;
function _log2 (const x: Real): Real;

function _sqr  (const x: Real): Real;
function _sqrt (const x: Real): Real;
function _fact (const x: Real): Real;
function _abs  (const x: Real): Real;
function _sign (const x: Real): Real;
function _int  (const x: Real): Real;
function _frac (const x: Real): Real;
function _round(const x: Real): Real;
function _ceil (const x: Real): Real;
function _floor(const x: Real): Real;

function _deg  (const x: Real): Real;
function _rad  (const x: Real): Real;
function _ndeg (const x: Real): Real;
function _nrad (const x: Real): Real;

function _log (const l: TArgList): Real;
function _gcd (const l: TArgList): Real;
function _lcm (const l: TArgList): Real;
function _poly(const l: TArgList): Real;

type
  PBool = ^LongBool;
  PStr = ^ShortString;

procedure InitStdErrorAddr(PError: PBool; PErrorMsg: PStr);
          { must be called once, before any _func() call }

implementation

procedure CalcFunc(
  const FuncName: ShortString;
  const FuncArgs: TArgList;
  var ResultValue: Real;
  var ResultError: LongBool;
  var ResultErrorMsg: ShortString); stdcall; external 'StdMath.dlc';

var
  ErrorPtr: PBool;
  ErrorMsgPtr: PStr;

procedure InitStdErrorAddr(PError: PBool; PErrorMsg: PStr);
begin
  ErrorPtr:= PError;
  ErrorMsgPtr:= PErrorMsg;
end;

function FuncL(const Args: TArgList; const Func: String): Real;
begin
  if ErrorPtr^ then begin Result:= 1; Exit end;
  CalcFunc(Func, Args, Result, ErrorPtr^, ErrorMsgPtr^);
end;

function Func1(const Arg1: Real; const Func: String): Real;
var
  Args: TArgList;
begin
  with Args do begin Num:= 1; Val[1]:= Arg1; end;
  Result:= FuncL(Args, Func);
end;

function Func2(const Arg1, Arg2: Real; const Func: String): Real;
var
  Args: TArgList;
begin
  with Args do begin Num:= 2; Val[1]:= Arg1; Val[2]:= Arg2; end;
  Result:= FuncL(Args, Func);
end;

function _add(const x, y: Real): Real;  begin Result:= Func2(x, y, '+')  end;
function _sub(const x, y: Real): Real;  begin Result:= Func2(x, y, '-')  end;
function _mul(const x, y: Real): Real;  begin Result:= Func2(x, y, '*')  end;
function _div(const x, y: Real): Real;  begin Result:= Func2(x, y, '/')  end;
function _pow(const x, y: Real): Real;  begin Result:= Func2(x, y, '**') end;

function _sin  (const x: Real): Real;  begin Result:= Func1(x, 'sin')   end;
function _cos  (const x: Real): Real;  begin Result:= Func1(x, 'cos')   end;
function _tan  (const x: Real): Real;  begin Result:= Func1(x, 'tan')   end;
function _cot  (const x: Real): Real;  begin Result:= Func1(x, 'cot')   end;
function _sec  (const x: Real): Real;  begin Result:= Func1(x, 'sec')   end;
function _csc  (const x: Real): Real;  begin Result:= Func1(x, 'csc')   end;
function _asin (const x: Real): Real;  begin Result:= Func1(x, 'asin')  end;
function _acos (const x: Real): Real;  begin Result:= Func1(x, 'acos')  end;
function _atan (const x: Real): Real;  begin Result:= Func1(x, 'atan')  end;
function _acot (const x: Real): Real;  begin Result:= Func1(x, 'acot')  end;
function _asec (const x: Real): Real;  begin Result:= Func1(x, 'asec')  end;
function _acsc (const x: Real): Real;  begin Result:= Func1(x, 'acsc')  end;

function _sinh (const x: Real): Real;  begin Result:= Func1(x, 'sinh')  end;
function _cosh (const x: Real): Real;  begin Result:= Func1(x, 'cosh')  end;
function _tanh (const x: Real): Real;  begin Result:= Func1(x, 'tanh')  end;
function _coth (const x: Real): Real;  begin Result:= Func1(x, 'coth')  end;
function _sech (const x: Real): Real;  begin Result:= Func1(x, 'sech')  end;
function _csch (const x: Real): Real;  begin Result:= Func1(x, 'csch')  end;
function _asinh(const x: Real): Real;  begin Result:= Func1(x, 'asinh') end;
function _acosh(const x: Real): Real;  begin Result:= Func1(x, 'acosh') end;
function _atanh(const x: Real): Real;  begin Result:= Func1(x, 'atanh') end;
function _acoth(const x: Real): Real;  begin Result:= Func1(x, 'acoth') end;
function _asech(const x: Real): Real;  begin Result:= Func1(x, 'asech') end;
function _acsch(const x: Real): Real;  begin Result:= Func1(x, 'acsch') end;

function _exp  (const x: Real): Real;  begin Result:= Func1(x, 'exp')   end;
function _ln   (const x: Real): Real;  begin Result:= Func1(x, 'ln')    end;
function _log10(const x: Real): Real;  begin Result:= Func1(x, 'log10') end;
function _log2 (const x: Real): Real;  begin Result:= Func1(x, 'log2')  end;

function _sqr  (const x: Real): Real;  begin Result:= Func1(x, 'sqr')   end;
function _sqrt (const x: Real): Real;  begin Result:= Func1(x, 'sqrt')  end;
function _fact (const x: Real): Real;  begin Result:= Func1(x, 'fact')  end;
function _abs  (const x: Real): Real;  begin Result:= Func1(x, 'abs')   end;
function _sign (const x: Real): Real;  begin Result:= Func1(x, 'sign')  end;
function _int  (const x: Real): Real;  begin Result:= Func1(x, 'int')   end;
function _frac (const x: Real): Real;  begin Result:= Func1(x, 'frac')  end;
function _round(const x: Real): Real;  begin Result:= Func1(x, 'round') end;
function _ceil (const x: Real): Real;  begin Result:= Func1(x, 'ceil')  end;
function _floor(const x: Real): Real;  begin Result:= Func1(x, 'floor') end;

function _deg  (const x: Real): Real;  begin Result:= Func1(x, 'deg')   end;
function _rad  (const x: Real): Real;  begin Result:= Func1(x, 'rad')   end;
function _ndeg (const x: Real): Real;  begin Result:= Func1(x, 'ndeg')  end;
function _nrad (const x: Real): Real;  begin Result:= Func1(x, 'nrad')  end;

function _log (const l: TArgList): Real;  begin Result:= FuncL(l, 'log')  end;
function _gcd (const l: TArgList): Real;  begin Result:= FuncL(l, 'gcd')  end;
function _lcm (const l: TArgList): Real;  begin Result:= FuncL(l, 'lcm')  end;
function _poly(const l: TArgList): Real;  begin Result:= FuncL(l, 'poly') end;

initialization

  InitStdErrorAddr(nil, nil);

end.
