
#ifndef __DESKTOPMANAGER
#define __DESKTOPMANAGER

#include <windows.h>

enum {
	DM_SETHOOK = WM_USER,
	DM_GETHOOK,
	DM_GETX,
	DM_SWITCHTOX,
	DM_MOVEWINTOX,
	DM_NEWREGSETTINGS,
	DM_QUIT,
	DM_HOOKRETURNMSG,
	DM_ENABLESAVER,
	DM_INVOKEPREFS,
} DM_COMMAND;

#define	HOOK_REMOVE		0x0000
#define	HOOK_CLOSING		0x0001
#define	HOOK_PRESWITCH		0x0002
#define	HOOK_POSTSWITCH		0x0004
#define	HOOK_SIZING		0x0008
#define	HOOK_HIDE		0x0010
#define HOOK_IGNORE		0x0020
#define HOOK_TRANSPARENT	0x0040
#define HOOK_PREPREFS		0x0080
#define HOOK_POSTPREFS		0x0100
#define HOOK_CONTROLPOS		0x0200

/*
	Plugin API

	Idea is simple, just send a message to the desktop manager window
	with one of the following commands:

	DM_SETHOOK:
		wParam is the HWND that will be getting DM_HOOKRETURNMSG messages.
				Note: unrelated usage to same name below.
		
		lParam one or more of the following:
				HOOK_REMOVE      removes hook
				HOOK_CLOSING	 message will be sent when DM is about to exit 
				HOOK_PRESWITCH   message will be sent before DM switches desktops
				HOOK_POSTSWITCH  message will be sent after DM switches desktops
				HOOK_SIZING      message will be sent for each DM WM_SIZING msg.
				HOOK_HIDE        message will be sent each time DM hides/shows.
				HOOK_IGNORE		 HWND will be ignored by DM
				HOOK_TRANSPARENT HWND will be sent Listview messages for 
								 transparent icon text
				HOOK_PREPREFS    message will be sent before DM changes it's settings.
				HOOK_POSTPREFS   message will be sent after DM changes it's settings.
				
				HOOK_CONTROLPOS	 HWND will be sent messages so it can move DM around itself.
								 All automatic DM window positioning will be disabled, 
								 Appbarmode is turned off. 
		
		return value is 1 for success, 0 for failure

		HWND will be sent a DM_HOOKRETURNMSG except for HOOK_IGNORE:
		wParam will be one of above HOOK_* values 
		lParam will be HOOK_* specific data
				HOOK_HIDE : lParam = 1 for hide, 0 for show
				HOOK_PRE/POSTSWITCH lParam = old << 16 + new.
				HOOK_CONTROLPOS lParam = width << 16 + height.
	
	DM_GETHOOK:
		wParam HWND you want hook flags for
		return value is the value passed in the DM_SETHOOK message for the HWND.
	
	DM_GETX:
		returns an integer representing the current desktop
	
	DM_SWITCHTOX:
		lParam is an index from 0..3 of the desktop to switch to.
	
	DM_MOVEWINTOX:
		wParam is the window, lParam is the desktop to move the window to.
	
	DM_NEWREGSETTINGS:
		Forces the program to read in current registry settings.

	DM_HOOKRETURNMSG
		*Not used*
	
	DM_ENABLESAVER
		wParam speedscale*256+speed to enable, 0 to disable.
		lParam HWND
		call from a screensaver as an option.
		ie: speed ranges from 1..12, current speed is 2:
			WM_CREATE:
				SendMessage(win, DM_ENABLESAVER, (12 << 8)+2. hWin);
			WM_DESTROY:
				SendMessage(win, DM_ENABLESAVER, 0. hWin);
	
	DM_INVOKEPREFS
		Brings up the DM prefs window
		wParam is parent window to use, can be NULL.

		
	Ex:

	HWND win = FindWindow(NULL, "Desktop Manager");

	if (win)
		SendMessage(win, DM_NEWREGSETTINGS, 0, 0); 
*/

#endif
