unit scrnsave;

// DPMS Screen Saver for Win 9X/NT to prolong your the lifetime of your monitor
// Copyright (C) 1999-2000, Daniel Marczisovszky
// mailto:marczi@kurt.hu
// http://www.kurt.hu/~marczi

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

interface

uses Windows, Classes, SysUtils;
procedure GetScreenSaverNames(sl: TStringList);

implementation

function ScreenSaverName(ScrName: string): string;
var h: THandle;
    i: integer;
    readbytes: DWORD;
    offset: integer;
    Buffer: array[0..$3F] of Byte;
begin
  result := '';

  // check if it is not PE
  h := CreateFile(PChar(ScrName), GENERIC_READ, FILE_SHARE_READ, nil, OPEN_EXISTING, 0, 0);
  if h = INVALID_HANDLE_VALUE then Exit;
  ReadFile(h, Buffer[0], $40, readbytes, nil);  // read the DOS header
  if (readbytes < $40) or (char(Buffer[0]) <> 'M') or (char(Buffer[1]) <> 'Z') then begin
    CloseHandle(h);
    Exit;
  end;
  if Buffer[$18] >= $40 then begin
    // offset to the segmented header
    offset := Buffer[$3C] + Buffer[$3D] shl 8;
    SetFilePointer(h, offset, nil, FILE_BEGIN);
    ReadFile(h, Buffer, $40, readbytes, nil);
    // NE executable
    if (char(Buffer[0]) = 'N') and (char(Buffer[1]) = 'E') then begin
      // offset to the non-resident table in the NE file
      // in the non-resident table the first string is the name of the screen saver
      offset := Buffer[$2F] shl 8;
      offset := offset shl 8 + Buffer[$2E];
      offset := offset shl 8 + Buffer[$2D];
      offset := offset shl 8 + Buffer[$2C];
      offset := offset + 1;
      // read the non-resident table
      SetFilePointer(h, offset, nil, FILE_BEGIN);
      ReadFile(h, Buffer, $40, readbytes, nil);
      // find the end of string
      i := 0;
      while (Buffer[i] <> 0) and (i < $40) do begin
        result := Result + char(Buffer[i]);
        Inc(i);
      end;
      i := Pos(':', result);
      Delete(result, 1, i);
    end;
  end;
  CloseHandle(h);

  // PE executable
  if (char(Buffer[0]) = 'P') and (char(Buffer[1]) = 'E') then begin
    try
      h := LoadLibrary(PChar(ScrName));
      if h <> 0 then begin
        SetLength(result, $40);
        LoadString(h, 1, PChar(result), $40);
        Result := StrPas(PChar(Result));
        FreeLibrary(h);
        if Result = '' then begin
          result := ExtractFileName(ScrName);
          i := Pos('.', result);
          if i <> 0 then Delete(result, i, Length(result) - i + 1);
        end;
      end;
    except
    end;
  end;

  Result := trim(Result);
end;

procedure GetScreenSavers(dir: string; sl: TStringList);

    procedure AddScreenSaver(scrname: string);
    var s: string;
    begin
       s := ScreenSaverName(scrname);
       if s <> '' then sl.Add(s + '===' + scrname);
    end;

var h: THandle;
    FindData: TWin32FindData;
begin
  h := FindFirstFile(PChar(dir + '\*.scr'), FindData);
  if h <> INVALID_HANDLE_VALUE then begin
    AddScreenSaver(dir + '\' + FindData.cFileName);
    while FindNextFile(h, FindData) do
      AddScreenSaver(dir + '\' + FindData.cFileName);
  end;
  Windows.FindClose(h);
end;

procedure GetScreenSaverNames(sl: TStringList);
var windir, sysdir: string;
begin
  SetLength(sysdir, MAX_PATH);
  GetSystemDirectory(PChar(sysdir), MAX_PATH);
  sysdir := StrPas(PChar(sysdir));

  SetLength(windir, MAX_PATH);
  GetWindowsDirectory(PChar(windir), MAX_PATH);
  windir := StrPas(PChar(windir));

  GetScreenSavers(sysdir, sl);
  GetScreenSavers(windir, sl);
end;

end.
