
// DPMS Screen Saver for Win 9X/NT to prolong your the lifetime of your monitor
// Copyright (C) 1999-2000, Daniel Marczisovszky
// mailto:marczi@kurt.hu
// http://www.kurt.hu/~marczi

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// Based on GIVEIO.SYS by Dale Roberts and GWIOPM by Graham Wideman
// Compile:    Use DDK BUILD facility


*********************************************************************/

#include <ntddk.h>

typedef LONG VP_STATUS;

#ifdef  _X86_
#define ALLOC_PRAGMA
#define VIDEOPORT_API __declspec(dllimport)
#else
#define VIDEOPORT_API
#endif


typedef struct _VIDEO_X86_BIOS_ARGUMENTS {
    ULONG Eax;
    ULONG Ebx;
    ULONG Ecx;
    ULONG Edx;
    ULONG Esi;
    ULONG Edi;
    ULONG Ebp;
} VIDEO_X86_BIOS_ARGUMENTS, *PVIDEO_X86_BIOS_ARGUMENTS;


/*
 *  The name of our device driver.
 */
#define DEVICE_NAME_STRING	L"dpmsdrv"

// Device type           -- in the "User Defined" range."
#define IOPMD_TYPE 0xF100               // used several places

#define IOCTL_DPMSDRV_NORMAL      CTL_CODE(IOPMD_TYPE, 0x900, METHOD_NEITHER, FILE_ANY_ACCESS )
#define IOCTL_DPMSDRV_STANDBY     CTL_CODE(IOPMD_TYPE, 0x901, METHOD_NEITHER, FILE_ANY_ACCESS )
#define IOCTL_DPMSDRV_SUSPEND     CTL_CODE(IOPMD_TYPE, 0x902, METHOD_NEITHER, FILE_ANY_ACCESS )
#define IOCTL_DPMSDRV_OFF         CTL_CODE(IOPMD_TYPE, 0x903, METHOD_NEITHER, FILE_ANY_ACCESS )
#define IOCTL_DPMSDRV_REDUCED     CTL_CODE(IOPMD_TYPE, 0x904, METHOD_NEITHER, FILE_ANY_ACCESS )

VIDEOPORT_API
VP_STATUS
VideoPortInt10(
    PVOID HwDeviceExtension,
    PVIDEO_X86_BIOS_ARGUMENTS BiosArguments
    );

VOID DPMSMode(PVOID* DeviceExt, int mode);

VOID DPMSUnload(IN PDRIVER_OBJECT DriverObject);

NTSTATUS DPMSDispatch(
    IN  PDEVICE_OBJECT  DeviceObject,
    IN  PIRP            Irp
    );

/*********************************************************************
  Driver Entry routine.
*********************************************************************/

NTSTATUS DriverEntry(
    IN PDRIVER_OBJECT DriverObject,
    IN PUNICODE_STRING RegistryPath
    )
{
	PDEVICE_OBJECT deviceObject;
	NTSTATUS status;
	WCHAR NameBuffer[] = L"\\Device\\" DEVICE_NAME_STRING;
	WCHAR DOSNameBuffer[] = L"\\DosDevices\\" DEVICE_NAME_STRING;
	UNICODE_STRING uniNameString, uniDOSString;

	RtlInitUnicodeString(&uniNameString, NameBuffer);
	RtlInitUnicodeString(&uniDOSString, DOSNameBuffer);

	status = IoCreateDevice(DriverObject, 4, &uniNameString, FILE_DEVICE_UNKNOWN,
					0, TRUE, &deviceObject);

	if(!NT_SUCCESS(status))
		return status;

	status = IoCreateSymbolicLink (&uniDOSString, &uniNameString);

	if (!NT_SUCCESS(status))
		return status;

  DriverObject->MajorFunction[IRP_MJ_CREATE] = DPMSDispatch;
  DriverObject->MajorFunction[IRP_MJ_CLOSE] = DPMSDispatch;
  DriverObject->MajorFunction[IRP_MJ_DEVICE_CONTROL] = DPMSDispatch;
	DriverObject->DriverUnload = DPMSUnload;
  return STATUS_SUCCESS;
}

/*********************************************************************
  Service handler for a CreateFile() user mode call.
*********************************************************************/
NTSTATUS DPMSDispatch(
    IN  PDEVICE_OBJECT  DeviceObject,
    IN  PIRP            Irp
    )

{
    VIDEO_X86_BIOS_ARGUMENTS x86regs;

    PIO_STACK_LOCATION  irpStack;
    PVOID deviceExt = DeviceObject->DeviceExtension;


    irpStack = IoGetCurrentIrpStackLocation (Irp);
    Irp->IoStatus.Information = 0;
    Irp->IoStatus.Status = STATUS_SUCCESS;


    if (irpStack->MajorFunction == IRP_MJ_DEVICE_CONTROL) {
        switch (irpStack->Parameters.DeviceIoControl.IoControlCode) {
            case IOCTL_DPMSDRV_NORMAL: 
                DPMSMode(deviceExt, 0);
                break;
            case IOCTL_DPMSDRV_STANDBY:
                DPMSMode(deviceExt, 1);
                break;
            case IOCTL_DPMSDRV_SUSPEND:
                DPMSMode(deviceExt, 2);
                break;
            case IOCTL_DPMSDRV_OFF:
                DPMSMode(deviceExt, 4);
                break;
            case IOCTL_DPMSDRV_REDUCED:
                DPMSMode(deviceExt, 8);
                break;
        }
    }

    IoCompleteRequest (Irp, IO_NO_INCREMENT);
    return STATUS_SUCCESS;
}

/*********************************************************************
  Call VGA BIOS.
*********************************************************************/
VOID DPMSMode(PVOID* DeviceExt, int mode)
{
  VIDEO_X86_BIOS_ARGUMENTS x86regs;

  VideoPortZeroMemory(&x86regs, sizeof(VIDEO_X86_BIOS_ARGUMENTS));
  x86regs.Eax = 0x4F10;
  x86regs.Ebx = (mode << 8) + 1 ;
  VideoPortInt10(DeviceExt, &x86regs);
}


/*********************************************************************
  Driver Unload routine.
*********************************************************************/
VOID DPMSUnload(IN PDRIVER_OBJECT DriverObject)
{
	WCHAR DOSNameBuffer[] = L"\\DosDevices\\" DEVICE_NAME_STRING;
	UNICODE_STRING uniDOSString;

	RtlInitUnicodeString(&uniDOSString, DOSNameBuffer);
	IoDeleteSymbolicLink (&uniDOSString);
	IoDeleteDevice(DriverObject->DeviceObject);
}

