unit common;

// THIS CODE WAS WRITTEN BY DANIEL MARCZISOVSZKY, IN 1999. (MARCZI@KURT.HU)
// IF YOU MAKE MODIFICATIONS PLEASE SEND IT TO ME
// DPMS SCREEN SAVER IS FREEWARE, NO ONE IS ALLOWED TO ASK MONEY FOR IT.
// THIS CODE CAN BE FREELY IN USED IN EVERY FREEWARE PRODUCT.

interface

uses Classes, Forms, Windows, DPMSDrv, IniFiles, SysUtils, ShellAPI;

procedure ReadSettings;
function InitDriver(log: TStrings): DWORD;
procedure TerminateDriver(stopit: boolean);
procedure RemoveDriver(log: TStrings);
function ScreenSaveFileName(screenSaverName: string): string;
procedure StartExtScreenSaver(scrname, params: string);

procedure Log(s: string);

var time_standby, time_suspend, time_off: integer;
    use_standby, use_suspend, use_off, use_ext, use_time_interval: boolean;
    stop_mousemove, stop_mouseclick, stop_keypress: boolean;
    mouse_sens: integer;
    ext_screen_name: string;
    interval_from, interval_till: TDateTime;
    ExtScrSavers: TStringList;         // stores the external screen savers

implementation

procedure ReadSettings;
begin
  with TIniFile.Create(ExtractFilePath(Application.ExeName) + 'dpms_scr.ini') do begin
    stop_mouseclick := ReadBool('Stop', 'mouse_click', true);
    stop_mousemove := ReadBool('Stop', 'mouse_move', true);
    stop_keypress := ReadBool('Stop', 'keypress', true);
    mouse_sens := ReadInteger('Stop', 'mouse_sensitivity', 5);

    use_standby := ReadBool('Modes', 'standby', true);
    use_suspend := ReadBool('Modes', 'suspend', true);
    use_off := ReadBool('Modes', 'off', true);
    time_standby := ReadInteger('Timeout', 'standby', 0);
    time_suspend := ReadInteger('Timeout', 'suspend', 5);
    time_off := ReadInteger('Timeout', 'off', 10);

    ext_screen_name := ReadString('External', 'screen_saver', '');
    use_ext := ReadBool('External', 'use_external', false);

    use_time_interval := ReadBool('Interval', 'use_time_interval', false);
    try
      interval_from := StrToTime(ReadString('Interval', 'from', '6:00:00AM'));
      interval_till := StrToTime(ReadString('Interval', 'till', '10:00:00PM'));
    except
      use_time_interval := false;
    end;

    if (time_suspend <= time_standby) then begin
      if use_standby then
        time_suspend := time_standby + 1
      else
        time_suspend := time_standby;
    end;

    if (time_off <= time_suspend) then begin
      if use_suspend then
        time_off := time_suspend + 1
      else
        time_off := time_suspend;
    end;

    Free;
  end;
end;


function InitDriver(log: TStrings): DWORD;
var status: DWORD;

    procedure AppendLog(s: string);
    begin
      if log <> nil then log.Add(s);
    end;

begin
  if log <> nil then log.Clear;

  Result := ERROR_SUCCESS;
  if Win32Platform = VER_PLATFORM_WIN32_WINDOWS	then exit;

  // opening SCM
  Status := DPMSDriver.OpenSCM;
  AppendLog('Opening Service Control Manager: ' + DPMSDriver.ErrorLookup(Status));

    // starting the service
  Status := DPMSDriver.Start;
  AppendLog('Starting the driver: ' + DPMSDriver.ErrorLookup(Status));

  if (Status = ERROR_PATH_NOT_FOUND) or (Status = ERROR_FILE_NOT_FOUND) then begin
    Status := DPMSDriver.Remove;
    AppendLog('Removing old Driver Entry: ' + DPMSDriver.ErrorLookup(Status));
    Status := ERROR_SERVICE_DOES_NOT_EXIST;
  end;

  // if not installed
  if Status = ERROR_SERVICE_DOES_NOT_EXIST then begin
    Status := DPMSDriver.Install('');
    AppendLog('Installing DPMSDRV.SYS: ' + DPMSDriver.ErrorLookup(Status));
    // starting the service
    Status := DPMSDriver.Start;
    AppendLog('Starting the driver (2nd attempt): ' + DPMSDriver.ErrorLookup(Status));
  end;

  // if it's already running then everything is fine...
  if Status = ERROR_SERVICE_ALREADY_RUNNING then Status := ERROR_SUCCESS;

  result := Status;
end;

procedure TerminateDriver(stopit: boolean);
begin
  if Win32Platform = VER_PLATFORM_WIN32_WINDOWS	then exit;
  if stopit then DPMSDriver.Stop;
  DPMSDriver.CloseSCM;
end;

procedure RemoveDriver(log: TStrings);
var status: DWORD;
begin
  if Win32Platform = VER_PLATFORM_WIN32_WINDOWS	then exit;
  Status := DPMSDriver.Remove;
  if log <> nil then
    log.Add('Removing Driver Entry: ' + DPMSDriver.ErrorLookup(Status));
end;

function ScreenSaveFileName(screenSaverName: string): string;
var i, p: integer;
begin
  for i := 0 to ExtScrSavers.Count - 1 do begin
    p := Pos(screenSaverName, ExtScrSavers.Strings[i]);
    if p = 1 then begin
      result := ExtScrSavers.Strings[i];
      p := Pos('===', Result);
      Delete(result, 1, p + 2);
      break;
    end;
  end;
end;

procedure StartExtScreenSaver(scrname, params: string);
var StartupInfo: TStartupInfo;
    ProcessInformation: TProcessInformation;
begin
  FillChar(StartupInfo, SizeOf(TStartupInfo), #0);
  StartupInfo.cb := SizeOf(TStartupInfo);
  StartupInfo.wShowWindow := SW_SHOWNORMAL;
  StartupInfo.dwFlags := STARTF_USESHOWWINDOW;
  FillChar(ProcessInformation, SizeOf(TProcessInformation), #0);
  CreateProcess(nil, PChar('"' + scrname + '" ' + params), nil, nil, false, 0, nil,
                PChar(ExtractFilePath(scrname)),
                StartupInfo, ProcessInformation);
end;

procedure Log(s: string);
var h: THandle;
    written: DWORD;
begin
  exit; // remove this line if you want the log file
  s := DateTimeToStr(now) + ': ' + s + #13#10;
  h := CreateFile('c:\dpmsscr.log', GENERIC_WRITE, 0, nil, OPEN_ALWAYS, 0, 0);
  SetFilePointer(h, 0, nil, FILE_END);
  WriteFile(h, s[1], Length(s), written, nil);
  CloseHandle(h);
end;


end.
