unit Preview;

// DPMS Screen Saver for Win 9X/NT to prolong your the lifetime of your monitor
// Copyright (C) 1999-2000, Daniel Marczisovszky
// mailto:marczi@kurt.hu
// http://www.kurt.hu/~marczi

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

interface

uses Windows, Forms, Classes, SysUtils, Graphics;

procedure ExecPreview;

implementation

procedure ExecPreview;            // this code comes from a Borland TI with small modifications
var
  DemoWnd     : HWnd;
  MyRect      : TRect;
  MyCanvas    : TCanvas;
  x, y,
  dx, dy      : Integer;
  MyBkgBitmap,
  InMemBitmap : TBitmap;
  ScrWidth,
  ScrHeight   : Integer;
begin
  DemoWnd := StrToInt(ParamStr(2));
  while not IsWindowVisible(DemoWnd) do
    Application.ProcessMessages;
  GetWindowRect(DemoWnd,MyRect);
  ScrWidth := MyRect.Right-MyRect.Left+1;
  ScrHeight := MyRect.Bottom-MyRect.Top+1;
  MyRect := Rect(0,0,ScrWidth-1,ScrHeight-1);
  MyCanvas := TCanvas.Create;
  MyCanvas.Handle := GetDC(DemoWnd);
  x := (ScrWidth div 2)-16;
  y := (ScrHeight div 2)-16;
  dx := 1;
  dy := 1;
  MyBkgBitmap := TBitmap.Create;
  with MyBkgBitmap do begin
    Width := ScrWidth;
    Height := ScrHeight;
    Canvas.Brush.Color := clWhite;
    Canvas.FillRect(Rect(0,0,ScrWidth-1,ScrHeight-1));
  end;
  InMemBitmap := TBitmap.Create;
  with InMemBitmap do begin
    Width := ScrWidth;
    Height := ScrHeight;
  end;
  while IsWindowVisible(DemoWnd) do begin
    InMemBitmap.Canvas.CopyRect(MyRect,MyBkgBitmap.Canvas,MyRect);
    InMemBitmap.Canvas.Draw(x,y,Application.Icon);
    MyCanvas.CopyRect(MyRect,InMemBitmap.Canvas,MyRect);
    Sleep(10);
    Application.ProcessMessages;
    if (x = 0) or (x = (ScrWidth-33)) then
      dx := -dx;
    if (y = 0) or (y = (ScrHeight-33)) then
      dy := -dy;
    x := x+dx;
    y := y+dy;
  end;
  MyBkgBitmap.Free;
  InMemBitmap.Free;
  MyCanvas.Free;
  Halt;
end;


end.
