unit Main;

// DPMS Screen Saver for Win 9X/NT to prolong your the lifetime of your monitor
// Copyright (C) 1999-2000, Daniel Marczisovszky
// mailto:marczi@kurt.hu
// http://www.kurt.hu/~marczi

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, IniFiles;

type
  TFormMain = class(TForm)
    Timer1: TTimer;
    procedure Timer1Timer(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDestroy(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormShow(Sender: TObject);
  private
    already_ext_started: boolean;
    already_standby: boolean;
    already_suspend: boolean;
    already_off: boolean;
    ignore_activation: boolean;

    minutes: integer;
    state: integer;
    crs: TPoint;

    procedure WMSysCommand (var Msg : TWMSysCommand); message WM_SYSCOMMAND;
    procedure WMKeyDown (var Msg : TWMKeyDown); message WM_KEYDOWN;
    procedure WMSysKeyDown (var Msg : TWMSysKeyDown); message WM_SYSKEYDOWN;
    procedure WMEraseBkgnd (var Msg : TMessage); message WM_ERASEBKGND;

    procedure DoScreenSaver;
    procedure StopExtScreenSaver;
    procedure ApplicationActivate(Sender: TObject);
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FormMain: TFormMain;

const
  ONEMINUTE = 60000;

  SCR_RUNNING = 0;
  SCR_CLOSING = 1;

implementation

uses DPMSdrv, common, scrnsave;

{$R *.DFM}

procedure TFormMain.FormShow(Sender: TObject);
begin
  already_standby := false;
  already_suspend := false;
  already_off := false;
  already_ext_started := false;
  minutes := 0;
  state := SCR_RUNNING;
  ignore_activation := true;

  ReadSettings;

  // read external screen savers
  ExtScrSavers := TStringList.Create;
  ExtScrSavers.Sorted := True;
  ExtScrSavers.Duplicates := dupIgnore;
  GetScreenSaverNames(ExtScrSavers);

  GetCursorPos(crs);  // store current position of mouse
  ShowCursor(false);

  if InitDriver(nil) <> ERROR_SUCCESS then begin
    // if it was not successful, then remove the driver and install again
    RemoveDriver(nil);
    TerminateDriver(true);
    InitDriver(nil);
  end;

  // fullscreen window + always on top + no resize + no movement
  SetWindowPos(Handle,HWND_TOPMOST,0,0,0,0,SWP_NOSIZE + SWP_NOMOVE);
  DoScreenSaver;

  // any external screen saver?
  if use_ext then begin
    already_ext_started := true;
    StartExtScreenSaver(ScreenSaveFileName(ext_screen_name), '/S');
  end;

  Timer1.Interval := ONEMINUTE;  // timer occurs in every minute
  Timer1.Enabled := true;

  Application.OnActivate := ApplicationActivate;
end;

procedure TFormMain.Timer1Timer(Sender: TObject);
begin
  if state = SCR_RUNNING then begin
    inc(minutes);
    DoScreenSaver;
  end
end;

{ STOP EXTERNAL SCREEN SAVER }
procedure TFormMain.StopExtScreenSaver;
begin
  keybd_event(VK_SPACE, 0, 0, 0);
  keybd_event(VK_SPACE, 0, 0, KEYEVENTF_KEYUP);
  // the external screen saver is not running any more...
  already_ext_started := false;
end;

{ SCREEN SAVER MAIN PROCEDURE }
procedure TFormMain.DoScreenSaver;
begin
  if use_time_interval then begin
    if interval_from <= interval_till then begin
      if (time < interval_from) or (time > interval_till) then Exit
    end
    else begin
      if (time < interval_from) and (time > interval_till) then Exit;
    end;
  end;

  if not already_standby and use_standby then begin
    if (minutes >= time_standby) and (minutes < time_suspend) then begin
      already_standby := true;
      if already_ext_started then StopExtScreenSaver;
      DPMSDriver.PowerSavingMode(DPMS_MODE_STANDBY);
      if not use_suspend and not use_off then Timer1.Enabled := false;
      exit;
    end;
  end;

  if not already_suspend and use_suspend then begin
    if (minutes >= time_suspend) and (minutes < time_off) then begin
      already_suspend := true;
      if already_ext_started then StopExtScreenSaver;
      DPMSDriver.PowerSavingMode(DPMS_MODE_SUSPEND);
      if not use_off then Timer1.Enabled := false;
      exit;
    end;
  end;

  if not already_off and use_off then begin
    if (minutes >= time_off) then begin
      already_off := true;
      if already_ext_started then StopExtScreenSaver;
      DPMSDriver.PowerSavingMode(DPMS_MODE_OFF);
      Timer1.Enabled := false;
      exit;
    end;
  end;
end;

// *****************************************
// *                MESSAGES               *
// *****************************************

procedure TFormMain.WMSysCommand (var Msg : TWMSysCommand);
begin
  Log('SysCommand: ' + IntToStr(Msg.CmdType));
  // Bill wants to start the screen saver again, although is already running
  if Msg.CmdType = SC_SCREENSAVE then
    Msg.Result := 1              // don't let him to do that
  else
    inherited;
end;

procedure TFormMain.WMEraseBkGnd;
begin
  Msg.Result := 0; // oh no, never write the background
end;

procedure TFormMain.WMKeyDown (var Msg : TWMKeyDown);
begin
  Log('KeyDown');
  if stop_keypress then begin
    state := SCR_CLOSING;
    Close;
  end;
end;

procedure TFormMain.WMSysKeyDown (var Msg : TWMSysKeyDown);
begin
  Log('SysKeyDown');
  if stop_keypress then begin
    state := SCR_CLOSING;
    Close;
  end;
end;

procedure TFormMain.FormMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  Log('MouseDown');
  if stop_mouseclick then begin
    state := SCR_CLOSING;
    Close;
  end;
end;

procedure TFormMain.FormMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
var dx, dy: integer;
begin
  if (x <> crs.x) and (y <> crs.y) then
    Log('MouseMove');
  dx := Abs(x - crs.x);
  dy := Abs(y - crs.y);
  if stop_mousemove and ((dx > mouse_sens) or (dy > mouse_sens)) then begin
    state := SCR_CLOSING;
    Close;
  end;
end;

procedure TFormMain.ApplicationActivate;
begin
  // at first time, the screen saver will receive the Activation message
  if already_ext_started and not ignore_activation then begin
    state := SCR_CLOSING;
    Close;
  end;

  // next time ApplicationActive is called when the external screen saver is terminated
  ignore_activation := false;
end;

procedure TFormMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if state <> SCR_CLOSING then begin
    Log('Form Close, not allowed');
    Action := caNone
  end
  else begin
    Log('Form Close, accepted');
    Application.OnActivate := nil;
    DPMSDriver.PowerSavingMode(DPMS_MODE_NORMAL);
  end;
end;

procedure TFormMain.FormDestroy(Sender: TObject);
begin
  Log('Form Destroy');
  ShowCursor(true);
  DPMSDriver.Free;
  ExtScrSavers.Free;
end;

end.


