program DPMS;

uses
  Forms,
  SysUtils,
  Windows,
  Main in 'Main.pas' {FormMain},
  Config in 'Config.pas' {FormConfig},
  Preview in 'Preview.pas',
  About in 'About.pas' {FormAbout},
  common in 'common.pas',
  dpmsdrv in 'dpmsdrv.pas',
  constant in 'constant.pas',
  scrnsave in 'scrnsave.pas';

{$R SCRN.RES}
{$R *.RES}
{$E SCR}

const
   scrsavername = 'DPMS Screen Saver';

var s: string;

begin
  Log('-----------------------------');
  Application.Initialize;
  Application.Title := 'DPMS Screen Saver';

  s := UpperCase(ParamStr(1));
  if (pos('/C', s) > 0) or (s = '') then begin
    Log('DPMS Screen Saver is started in config mode.');
    Application.CreateForm(TFormConfig, FormConfig);
  end
  else if pos('/S', s) > 0 then begin
    Log('DPMS Screen Saver is started in full screen mode.');
    Application.CreateForm(TFormMain, FormMain);
  end
  else if pos('/P', s) > 0 then begin
    Log('DPMS Screen Saver is started in preview mode.');
    ExecPreview;
  end
  else begin
    Application.Terminate;
  end;

  Application.Run;

  Log('DPMS Screen Saver is terminated.');
  Log('-----------------------------');
end.
