        PAGE    60,132
NAME    Current
        TITLE   Current.Com version 1.5

COMMENT 

Precis:

Current.Com emulates two 4DOS functions to let you find out the
current drive and directory.  Effectively it does a:

SET _DISK=C
SET _CWP=\MyPath

if the current directory is C:\Mypath

If 4DOS is active, this program does nothing since 4DOS
automatically handles these reserved set variables, and other
related ones as well.

Current also displays the current drive and directory in the form:

C:\MyPath

Usage:

Current.Com
Echo current drive is %_Disk%:
Echo current directory is %_CWP%

Subroutines trash all registers except DS: ES: SS: SP.  If
caller wants a register preserved, he must do it himself.

Please report bugs and problems to:

Roedy Green
Canadian Mind Products
#208 - 525 Ninth Street
New Westminster BC Canada
V5H 2N6
tel:(604) 777-1804
mailto:roedy@mindprod.com
http://mindprod.com

This program may be freely copied and used for any purpose
except military.


version 1.0 released to BIX 91/11/29

version 1.1 91/11/30
        - added CrLf after display
        - tidied up banner

Version 1.2 91/12/20
        - changed name from _CWD to _CWP to be compatible with 4DOS

Version 1.3 93/06/10
        - embedded new address and phone number

Version 1.4 1996 October 25
        - embed POB 707 Quathiaski Cove address

version 1.51998 November 8
        - embed Barker address


 ; end comment

stack   segment stack           ; keep MS link happy by providing null stack
stack   ends

CODE    SEGMENT PARA            ; start off in code.

;==============================================================

data    segment byte            ; provide a separate DATA segment
                                ; actually comes after the code

;==============================================================

;  V A R I A B L E S

EnvSeg  DW      0               ; segment of environment

EnvSize DW      0               ; current size of environment in
                                ; bytes, including the double null.

EnvRoom DW      0               ; free space remaining for the
                                ; environment to grow.

CurDrive        DB      0       ; letter A B C etc

CurDir          DB      65d DUP (0)
                                ; work area
                                ; for current directory name
                                ; THIS IS NOT THE SAME AS THE
                                ; COMMAND LINE.
                                ; not including lead \

CurDirLen       DW      0       ; Not including lead \


;  C O N S T A N T S

ColonSlashMsg   LABEL   BYTE
                DB      ':\',"$"

CrMsg           db      13,10,'$'

BackSlash       DB      "\"

Equals          DB      "="

Nulls           db      0,0

_DISK           DB      "_DISK"

_CWP            DB      "_CWP"

CopyrightMsg    label byte

;               This message is not displayed, just embedded in the file.
        db      13,10
        DB      ' CURRENT 1.5 ۲'
        db      13,10
        db      13,10
        DB      'Effects a SET _DISK=C and _CWP=\CurPath'
        db      13,10
        DB      'to allow access to current drive/directory.'
        db      13,10
        DB      'Copyright (c) 1991-1999 Roedy Green Canadian Mind Products'
        db      13,10
        DB      '#208 - 525 Ninth Street, New Westminster, BC Canada V3M 5T9',13,10
        DB      'tel:(604) 777-1804   mailto:roedy@mindprod.com   http://mindprod.com',13,10
        DB      'May be freely distributed and used for any purpose except military.'
        db      13,10,"$"

;========================

data            ends
;======================================

SAY     MACRO   Msg
;       display message on screen
        LEA     DX,&Msg         ; use LEA rather than
                                ; MOV Offset for more generality
        MOV     AH,09h
        INT     21h
        ENDM

;======================================

com     group   code,data       ; force data segment to go at the end

        ASSUME  CS:com,DS:com,ES:com,SS:com
                                ; seg regs cover everything
        ORG     100H            ; in Code segment

;==========================

Main    proc    far

;       M A I N L I N E   R O U T I N E

Start:

        Call    GetCurDrive             ; get defalt drive
        Call    GetCurDir               ; get default directory

        Call    ShowCurDrive            ; display defalt drive
        Say     ColonSlashMsg           ; write the :\
        Call    ShowCurDir              ; display default directory
        say     CrMsg

        Call    Test4DOSExist           ; see if 4DOS present
        test    ax,ax
        jnz     Let4DOSDoIt             ; yes, bypass the work

        Call    FindEnv                 ; find master environment
        mov     EnvSeg,ES               ; environment at ES:0
        mov     EnvSize,cx              ; current length of env
        mov     EnvRoom,ax              ; room to grow

        Call    Set_Disk                ; put _DISK=C into env
        Call    Set_CWP                 ; put _CWP=\MyPath into env

Let4DOSDoIt:
        mov     ax, 4c00h               ; ERRORLEVEL = 0
        int     21h                     ; normal bye

Main    endp
;=======================================

GetCurDrive    PROC    near

;       Get default drive, store as char in CurDrive

        mov     ah,19h          ; ask DOS what default drive is
        int     21h
                                ; result it AL, 0=A 1=B
                                ; NOTE THIS IS NOT THE USUAL DOS
                                ; CONVENTION WHERE 1=A
        add     al,'A'          ; convert to letter

        mov     CurDrive,al
        ret

GetCurDrive     EndP

;=======================================

GetCurDir PROC    near

;       Get current directory on given drive without leading C:\

        mov     dl,0
                                ; DL = 0 means get directory for default drive
                                ; DL = 1 means drive A:
                                ; DL = 2 means drive B:
        lea     si,CurDir
        mov     ah,47h
        int     21h
                                ; result appears in CurDir
                                ; in form XXX\XXX with trailing null
                                ; but no lead or trailing backslash
                                ; If default directory is root
                                ; just a null.
                                ; Calculate its length
        mov     cx,64d          ; max poss length
        mov     di,si
        mov     al,0
        repne   scasb           ; search for null
        sub     cx,63d
        neg     cx              ; CX contains length of string
        mov     CurDirLen,cx
        ret

GetCurDir ENDP

;=======================================

ShowCurDrive    PROC    near

;       Display the default drive
;       as C

        mov     dl,CurDrive     ; get the letter C in C:
        mov     ah,02h          ; WRITE 1 char
        int     21h
        ret

ShowCurDrive    ENDP

;=======================================

ShowCurDir PROC    near

;       Display current directory on given drive without leading C:\

        mov     bx,1            ; prefined file handle 1 = screen
        lea     dx,CurDir       ; DS:DX points to CurDir
        mov     cx,CurDirLen    ; cx is length of string
        mov     ah,40h          ; WRITE HANDLE
        int     21h
                                ; cannot use SAY because of possible
                                ; embedded $ in names.
        ret

ShowCurDir ENDP

;=======================================

Test4DOSExist Proc      Near

;       Test for presence of 4DOS, leave 1 in AX if found
;       Method from 4DOS manual
;       To detect 4DOS, call INT 2Fh with:
;                    AX = D44Dh
;                    BX = 0
;
;              If 4DOS is not loaded, AX should be returned unchanged.  If
;              4DOS is loaded, it will return the following (no other
;              registers are modified):
;                    AX = 44DDh
;                    BX = Version number (BL = major version, BH = minor
;                         version)
;                    CX = 4DOS PSP segment address
;                    DL = 4DOS shell number
;
;       4DOS will be detected, even if COMMAND.COM is used under 4DOS.

        mov     al,02fh
        call    SafeVector      ; see if 2fh is hooked up to anything
        jc      FDOSAbsent
        mov     ax,0D44Dh
        mov     bx,0
        int     2Fh
        cmp     ax,0D44Dh       ; see if AX changed
        je      FDOSAbsent

FDOSPresent:
        mov     ax,1
        ret

FDOSAbsent:
        mov     ax,0            ; presume not present.
        ret

Test4DOSExist EndP

;=======================================

SafeVector      Proc    Near

;       Ensures that a vector exists and his hooked up to something
;       before we call the corresponding interrupt.
;       Many oddball machines are missing vectors.
;       on entry AL has the vector number
;       on exit carry flag set if problems, carry clear if ok
;       all registers preserved
;       see page 393 Ray Duncan's Advanced MS DOS

        push    es
        push    bx
        push    ax
        mov     ah,35h          ; get vector
        int     21h
                                ; ES:BX points to interrupt handler
        mov     ax,ES
        or      ax,BX
        jz      BadVector
        cmp     byte ptr ES:[bx],0cfh   ; is it an iret?
        je      BadVector
GoodVector:
        clc
        jmp     VectorDone
badVector:
        stc
VectorDone:
        pop     ax
        pop     bx
        pop     es
        ret

SafeVector      EndP

;=======================================

FindENV Proc    Near

;       This code was provided compliments of Jay Vanderbilt.
;       It this same code he uses in ROOM! and ASK!
;       Return free space in the current master environment in DX:AX
;       The current master environment is the one a SET command would
;       affect.  It can be several levels back if for example a program
;       spawned NEED directly, rather than through COMMAND.COM or 4DOS.
;       The current master environment is NOT necessarily the great mother
;       of environments -- the original autoexec environment.
;
;       TestEnv considers all the space from the first double null
;       to the end of the reserved environment region to be free.
;       Some of it may contain the name of the program currently
;       executing, so the free space calculated is a tad optimistic.
;       Hovever, it is the size that SET is concerned with when it
;       decides if the environment is overflowing.
;
;       Finds current master environment two ways.  By going
;       child to parent to current Command and either getting
;       the address of the environment from the PSP of Command
;       or searching the MCB chain for a block that belongs to
;       Command and matches the program's env.
;
;       Finds the environment leaving address as ES:0,  current
;       size in CX, including the double 0.  Free space at the end
;       is returned in AX.
;
;       Assumes that DS=ES=PSP_segment on entry
;
;       If you use 4DOS it inserts a SET command called CMDLINE that
;       places the entire command line into the SET environment, including
;       the program name.  If this routine does not give you the answers
;       you expect, chances are you forgot to account for this parameter
;       inserted near the head of the environment string.
;
EnvParentLoop:
        mov     es,ES:[016h]            ; segment of parent program
                                        ; see Undocumented DOS p 108
        mov     di,es
        mov     ax,ES:[016h]            ; parent's parent
        cmp     di,ax                   ; if same - COMMAND
        jne     EnvParentLoop           ; try again
        mov     ax,ES:[02Ch]            ; master env segment
                                        ; see MS DOS Encyclopedia p109
        cmp     ax,0                    ; if 0 need to get env
        jne     EnvFound
        call    EnvWalk                 ; returns env_seg in ax
        jc      EnvFail                 ; not found

EnvFound:
        dec     ax                      ; point to mcb
        mov     es,ax
        mov     cx,ES:[03h]             ; size of env region in paragraphs
        shl     cx,1                    ; multiply by 16
        shl     cx,1
        shl     cx,1
        shl     cx,1                    ; size of entire region in bytes
        push    cx
        inc     ax
        mov     es,ax                   ; point to start of env
                                        ; ES:0 points to THE environment
                                        ; CX is the size of the whole region
                                        ; in bytes.
        mov     ax,0                    ; looking for double null at end of env
        mov     di,1                    ; allow for first dec di

EnvLookForNulls:
        dec     cx                      ; size of env
        dec     di                      ; step ahead by bytes
                                        ; scasw goes by twos.
                                        ; NOTE: this is just scasw not
                                        ; REPNE SCASW
        scasw                           ; look for double null at end of env
                                        ; two steps forward, then one step back
        jne     EnvLookForNulls
        dec     cx                      ; allow for double null at end
        mov     ax,cx                   ; and return in ax
        pop     cx                      ; full size of environment region
        sub     cx,ax                   ; size of in-use part
EnvDone:
        ret

EnvFail:
        mov     ax,0                   ; indicate failure as 0 bytes free
        jmp     Short EnvDone

; = = = = = = = = = = = = = = = = = = = = = =

EnvWalk Proc    Near

;       Finds master environment by walking up mcb chain looking for block
;       owned by COMMAND.  If not found, returns carry flag set.
;       Used by TESTEnv.
;       Should only be needed for DOS 2.x.
;
;       called with es=command_seg
;       returns env seg in ax

        push    bp
        push    es
        mov     ax,es
        mov     bp,es                   ; save for checking owner
        dec     ax
        mov     es,ax                   ; point to mcb

EnvNextMCB:
        add     ax,ES:[03h]             ; size of block
        inc     ax                      ; point to next mcb
        mov     es,ax
        cmp     bp,ES:[01]              ; owned by command.com?
        je      EnvFoundShell
        cmp     ES:byte ptr[0],05Ah     ; last block?
        je      EnvWalkFailed
        jmp     Short EnvNextMCB

EnvFoundShell:
        push    ds
        push    es
        inc     ax                      ; move on from mcb
        mov     es,ax
        mov     di,0                    ; es:di now points to possible env
        mov     ds,DS:[02ch]            ; point to our copy of env
        mov     si,0

EnvMatchLoop:
        cmpsb                           ; do Environments match?
                                        ; note, cmpsb not REPE cmpsb
        jne     EnvTryNextBlock         ; they don't so try next block
        cmp     DS:word ptr[si],0       ; look for 0 0 at end of env
        jne     EnvMatchLoop
        pop     es
        pop     ds

EnvWalkDone:
        pop     es
        pop     bp
        ret

EnvTryNextBlock:
        pop     es
        pop     ds
        cmp     byte ptr ES:[0],05Ah    ; last block?
        je      EnvWalkFailed           ; already checked
        jmp     Short EnvNextMCB        ; go get next blocke

EnvWalkFailed:
        stc                             ; not found
        jmp     short EnvWalkDone

EnvWalk endp
FindEnv EndP

;=======================================

UnSet           Proc    Near

;       on entry DS:SI points to a set variable name e.g. _DISK
;       with trailing null. CX is its length.
;       Unset searches the environment for a string of the form:
;       _DISK=xxx and removes it.
;       If there is no such string, that is fine.
;       EnvSize and EnvRoom will be updated to reflect the new shorter
;       environment.  The double null will be maintained.
;
        push    cx              ; save length of string seaching for
        Call    GetSet          ; cx is length of value string
                                ; ES:di points to value string
        pop     bx
        jcxz    AlreadyUnset
                                ; if we want delete X=YYY we have
                                ; aaa=xxx0X=YYY0ccc=zzzz00 to start and
                                ; aaa=xxx0ccc=zzzz00 when we are done
                                ; we remove bx+cx+2 chars
                                ; we slide the tail end back.
                                ; di points to YYY0ccc=zzzz00
        mov     ax,bx
        add     ax,cx
        add     ax,2            ; number of chars we are removing
        mov     si,di           ; si points to YYY0ccc=zzzz00
        add     si,cx
        inc     si              ; si points to ccc=zzz00, the source
        sub     di,bx
        dec     di              ; di points to X=YYY, target
        mov     cx,EnvSize
        sub     cx,si           ; length of tail to move
                                ; will always be at least 2 bytes (for nulls)
        mov     dx,DS           ; temporarily set DS to point to ENV too.
        mov     bx,ES
        mov     DS,bx
        rep     movsb           ; slide string down, work left to right
        mov     DS,dx
        sub     EnvSize,ax      ; track new size of environment
        add     EnvRoom,ax
AlreadyUnset:
        ret

Unset           EndP

;=======================================

Getset  Proc    near

;       Finds values of variable in the SET environment.
;
;       Let us presume you had put the command:
;       SET  MYVAR=XXXX
;       Into your bat file.  You want to find the current value
;       of MYVAR
;
;       On entry DS:SI CX=len points to a string MYVAR all upper case
;       ES:0 points to the environment.
;       GetSet will search the environment for that string.
;       On Exit ES:DI CX=len points to the value string XXXX
;       If there is so such string CX will be 0.
;
;       How it works:
;       The segment to the environment is at offset 2Ch in the PSP
;       See Ray Duncan's Advanced MS DOS page 23.
;       The environment has strings of the form YYY=XXXX terminated
;       by a null.  The last string is terminated by two nulls.
;
;
        push    si                      ; save start of var wanted
        mov     dx,cx                   ; save length of variable wanted
        jcxz    GetSetFail
        sub     di,di                   ; ES:0 ES:di points to env

GetSetLookAgain:
                                        ; DS:si len dx points to var
                                        ;  we are looking for
                                        ; ES:di points to char after null i.e.
                                        ;  the start of new variable,
                                        ;  or to first parm in env,
                                        ;  or to double null in empty env,
                                        ;  or to null, second in terminating pair

        cmp     byte ptr ES:[di],0
        je      GetSetFail              ; we hit double null without finding
                                        ; the variable we wanted.

        mov     bx,di                   ; save start of string
        mov     cx,32768                ; largest possible environment
        mov     al,'='                  ; scan for end of variable
        repne   scasb                   ; terminated by =
        jne     GetSetFail
                                        ; have found =
                                        ; di points just past it
        mov     cx,di
        sub     cx,bx
        dec     cx                      ; cx = len of variable
        cmp     cx,dx                   ; length candidiate variable same
                                        ; as one wanted?
        jne     GetSetBypass            ; no, was not this one
        pop     si
        push    si                      ; DS:si pointer to start of var wanted
        xchg    bx,di                   ; ES:di points to candidate var
                                        ; cx is length, some for both
        repe    cmpsb                   ; has candidate same name?
        mov     di,bx                   ; di points just past equal
        jne     GetSetBypass

GetSetSucceed:
                                        ; we have found the parameter
                                        ; di points just past =
                                        ; at start of value
        mov     bx,di                   ; save start of parm string
        mov     cx,32768                ; string could be very long
        mov     al,0                    ; null terminates string
        repne   scasb
        jne     GetSetFail

                                        ; di points 1 past null
                                        ; ES:bx points to start of value
        mov     cx,di
        sub     cx,bx
        dec     cx                      ; cx = len value
        mov     di,bx                   ; customers want to see start
                                        ; of value
        pop     si                      ; balance the stack
        ret                             ; we are done
;

GetSetBypass:
;                                       ; Variable was not the one
                                        ; wanted, scan over the
                                        ; following value ready to
                                        ; test the nex variable.
                                        ; ES:di point just past the = at end
                                        ; of the candidate variable
        mov     cx,32768                ; max env len
        mov     al,0                    ; search for null
        repne   scasb
        jnz     GetSetFail
                                        ; ES:di now points just past the
                                        ; null at the end of the value
        jmp     GetSetLookAgain

GetSetFail:
        sub     di,di                   ; return dummy ES:0
        mov     cx,di                   ; cx=0
        pop     si                      ; balance the stack
        ret

Getset  EndP


;============================================

Set_DISK        Proc    Near

;       append _DISK=C to the master environment
;       Presumes CurDrive already set.

        lea     si,_DISK                ; get rid of _DISK=xxx0
        mov     cx,5                    ; length of _DISK
        call    UnSet

        lea     si,nulls                ; tack on to the end.
        mov     cx,1                    ; tack handles appending
        call    Tack                    ; the double null.
        lea     si,_DISK                ; set *_DISK=C** *=null
        mov     cx,5
        call    Tack
        lea     si,Equals
        mov     cx,1
        call    Tack
        lea     si,CurDrive
        mov     cx,1
        call    Tack
        ret

Set_Disk        EndP

;=======================================

Set_CWP Proc    Near

;       appends SET _CWP=\MyPath to the environment
;       Presumes CurDir and CurDirLen set

        lea     si,_CWP                 ; get rid of _CWP=xxxx0
        mov     cx,4                    ; length of _DISK
        call    UnSet

        lea     si,nulls                ; tack on to the end.
        mov     cx,1                    ; tack handles appending
        call    Tack                    ; the double null.
        lea     si,_CWP                 ; set *_CWP=\Pathname** *=null
        mov     cx,4
        call    Tack
        lea     si,Equals
        mov     cx,1
        call    Tack
        lea     si,BackSlash
        mov     cx,1
        call    Tack
        lea     si,CurDir
        mov     cx,CurDirLen
        call    Tack
        ret

Set_CWP EndP

;=======================================

Tack    Proc    Near

;       Tack string pointed at by DS:SI length CX to the end of the
;       environment.  It goes in just before the double null ending.
;       EnvSize and EnvRoom will be updated to reflect the new longer
;       environment.  The double null will automatically be reappended.
;       If there is not enough room, we abort with errorlevel 1

        cmp     cx,EnvRoom              ; enough room to add?
        jae     Abort
        sub     Envroom,cx
        mov     di,EnvSize
        sub     di,2                    ; point to first byte of double null
        add     EnvSize,cx
        rep     movsb                   ; copy string to end of environment
        mov     ax,0
        stosw                           ; plop terminating double null
        ret

Abort:  mov     ax, 4c01h               ; ERRORLEVEL = 1
        int     21h                     ; DIE

Tack    Endp

;=======================================

Code    EndS

        End     Start
