/***************************************************************************/
/*                Button.Hpp : Contains the class for 'Button'             */
/*                             object. Besides all the features            */
/*                             a button has, this class assumes            */
/*                             back color is not BLACK.          	     */
/*                                   (Palette Entry 1).	               */
/*                                                                         */
/*                By : Nikhil V.               Dt. : 9/23/1997.            */
/***************************************************************************/
#ifndef BUTTON
#define BUTTON

#include "utils.h"

class Button {
	int startx, starty, height, width, midx, midy;
	char caption[30];
	public:
		Button() {                   // Empty constructor. Required.
			}
		Button(int x, int y, int h, char *cap) {
			startx = x; starty = y; // Position.
			height = h;             // Height.
			width = textwidth(cap) + 20;   // Calculate the width.
			midx = x + width/2; midy = y + h/2;
			strcpy(caption, cap);   // Store the caption.
			}
		Button operator =(Button &arg) {
			startx = arg.startx; starty = arg.starty;
			height = arg.height; width = arg.width;
			midx = arg.midx; midy = arg.midy;
			strcpy(caption, arg.caption);
			return *this;
			}
		void show() {
			struct textsettingstype textinfo;
			gettextsettings(&textinfo); // Save current drawing state.
			Color temp = (Color)getcolor();
			setcolor(M_DARKGRAY);
			settextjustify(CENTER_TEXT, CENTER_TEXT);
			// Print the caption.
			outtextxy(midx, midy, caption);
			// Draw the embossing effect.
			setcolor(M_BLACK);
			line(startx, starty + height, startx + width, starty + height);
			line(startx + width, starty, startx + width, starty + height);
			setcolor(M_WHITE);
			line(startx, starty, startx + width, starty);
			line(startx, starty, startx, starty + height);
			setcolor(temp);
			settextjustify(textinfo.horiz, textinfo.vert);
			}
		void release() {             // Shows the button with pressed
			setcolor(M_BLACK);      // appearence.
			line(startx, starty + height, startx + width, starty + height);
			line(startx + width, starty, startx + width, starty + height);
			setcolor(M_WHITE);
			line(startx, starty, startx + width, starty);
			line(startx, starty, startx, starty + height);
			}
		void press() {               // Shows the button in normal state.
			setcolor(M_WHITE);
			line(startx, starty + height, startx + width, starty + height);
			line(startx + width, starty, startx + width, starty + height);
			setcolor(M_BLACK);
			line(startx, starty, startx + width, starty);
			line(startx, starty, startx, starty + height);
			}
		int click(int x, int y) {    // Returns true if the point (x, y)
			if((x >= startx) && (x <= startx + width) &&  // is inside.
			   (y >= starty) && (y <= starty + height)) return 1;
			else return 0;
			}
	};

#endif
/***************************************************************************/
