﻿using System;
using System.Collections;
using System.IO;
using CSPCUtil;
using ICSPCAPI;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;

[assembly:Tab("Main",          1)]
[assembly:Tab("Math",          2)]
[assembly:Tab("Trig",          3)]
[assembly:Tab("Angles",        4)]
[assembly:Tab("Memory",        5)]
[assembly:Tab("Finance",       6)]
[assembly:Tab("Dates & Times", 7)]

namespace NS
{
  public class Functions : IAPIUser
  {
    private static Object[] globals = new Object[1024];

    private static IAPI iapi;

    public Functions()
    {
    }

    public void SaveAPI(IAPI iapi)
    {
      Functions.iapi = iapi;
    }
  
    // Display numerical values as floating point.
    [Button("Main")]
    public static void FloatingPoint()
    {
      iapi.DisplayFormat = "";
    }

    // Display numerical values as fixed-point with thousands seperators
    // with the specified number of digits to the right of the decimal 
    // point.    
    [Button("Main")]
    public static void FixedPoint(int digits)
    {
      if (digits >= 0 && digits < 100)
      {
        iapi.DisplayFormat = "N" + digits;
      }
    }

    [Button("Math", "|x|")]
    public static double AbsoluteValue(double x)
    {
      return Math.Abs(x);
    }

    /*
     * Memo-ized version of Fibonacci number calculation, avoids
     * redundant calculations.
     */

    private static long CalcFib(int x, long[] memo)
    {
      long result;

      if (x == 1 || x == 2)
      {
        result = 1;
      }
      else
      {
        if (memo[x - 2] == 0)
        {
          memo[x - 2] = CalcFib(x - 2, memo);
        }

        if (memo[x - 1] == 0)
        {
          memo[x - 1] = CalcFib(x - 1, memo);
        }

        result = memo[x - 2] + memo[x - 1];
      }

      return result;
    }

    [Button("Math")]
    public static long Fib(int x)
    {
      return CalcFib(x, new long[x]);
    }

    [Button("Trig")]
    public static double Sin(double x)
    {
      return Math.Sin(x);
    }
    
    [Button("Trig")]
    public static double Cos(double x)
    {
      return Math.Cos(x);
    }
    
    [Button("Trig")]
    public static double Tan(double x)
    {
      return Math.Tan(x);
    }
    
    [Button("Trig")]
    public static double ASin(double x)
    {
      return Math.Asin(x);
    }
    
    [Button("Trig")]
    public static double ACos(double x)
    {
      return Math.Acos(x);
    }
    
    [Button("Trig")]
    public static double ATan(double x)
    {
      return Math.Atan(x);
    }

    [Button("Trig")]
    public static double Cosh(double x)
    {
      return Math.Cosh(x);
    }

    [Button("Trig")]
    public static double Sinh(double x)
    {
      return Math.Sinh(x);
    }

    [Button("Trig")]
    public static double Tanh(double x)
    {
      return Math.Tanh(x);
    }

    [Button("Trig")]
    public static double ACosh(double x)
    {
      return Math.Log(x + Math.Sqrt(x + 1.0) * Math.Sqrt(x - 1.0));
    }

    [Button("Trig")]
    public static double ASinh(double x)
    {
      return Math.Log(x + Math.Sqrt(1.0 + x * x));
    }

    [Button("Trig")]
    public static double ATanh(double x)
    {
      return (Math.Log(1.0 + x) - Math.Log(1.0 - x)) / 2.0;
    }

    [Button("Math", "n!")]
    public static long Factorial(int n)
    
      // Calculates n! using a recursive algorithm.
    
    {
      long result = 1;

      // By default, C# code will not throw
      // exceptions when overflows happen.  To
      // ensure that an exception is thrown when
      // overflows occur, enclose the code in a 
      // checked block.

      checked
      {
        if (n > 1)
        {
          result = n * Factorial(n - 1);
        }
      }
    
      return result;
    }

    [Button("Main", "%")]
    public static double Percent(double x)
    
      // Converts a value to a percent.
    
    {
      return x / 100.0;
    }

    [Button("Main")]
    public static double SciNot(double n, double PowerOf10)
    
      // Allow the user to enter numbers in scientific notation.
      // Return n * 10 ^ PowerOf10.
    
    {
      return n * Math.Pow(10.0, PowerOf10);
    }

    [Button("Math", "Pi")]
    public static double Pi()
    {
      return Math.PI;
    }

    // Stores the value in the register specified by index.
    [Button("Memory")]
    public static void Store(Object o, int index)
    {
      globals[index] = o;
    }
    
    // Returns the value in the register specified by Index.
    
    [Button("Memory")]
    public Object Recall(int index)
    {
      return globals[index];
    }

    [Button("Angles")]
    public static double Radians(double degrees)
    {
      return degrees * Math.PI / 180.0;
    }
    
    [Button("Angles")]
    public static double Degrees(double radians)
    {
      return radians * 180.0 / Math.PI;
    }

    [Button("Angles")]
    public static double DMS2Decimal(double Degrees, double Minutes, double Seconds)
    {
      return Degrees + Minutes / 60.0 + Seconds / 3600.0;
    }

    [Button("Angles")]
    public static double AngleBetweenLocations(double Lat1Degrees, 
      double Lon1Degrees, 
      double Lat2Degrees, 
      double Lon2Degrees)
    {
      double Lat1Radians = Radians(Lat1Degrees);
      double Lon1Radians = Radians(Lon1Degrees);
      double Lat2Radians = Radians(Lat2Degrees);
      double Lon2Radians = Radians(Lon2Degrees);
    
      double a = Lon1Radians - Lon2Radians;
    
      if (a < 0.0)
      {
        a = -a;
      }
    
      if (a > Math.PI)
      {
        a = 2.0 * Math.PI - a;
      }
    
      return Math.Acos(
        Math.Sin(Lat2Radians) * Math.Sin(Lat1Radians) + 
        Math.Cos(Lat2Radians) * Math.Cos(Lat1Radians) * Math.Cos(a)
        );
    }
    
    [Button("Angles")]
    public static double DistanceBetweenLocations(double Lat1Degrees, 
      double Lon1Degrees, 
      double Lat2Degrees, 
      double Lon2Degrees)
    {
      double Angle = AngleBetweenLocations(Lat1Degrees, Lon1Degrees,
        Lat2Degrees, Lon2Degrees);
    
      double Circumference = 24830.0; // miles at equator
    
      return Circumference * Angle / (2.0 * Math.PI);
    }
    
    [Button("Math")]
    public static double LN(double x)
    
      // Return natural logarithm of x.
    
    {
      return Math.Log(x);
    }
    
    [Button("Math", "e^X")]
    public static double eToX(double x)
    
      // Return inverse natural logarithm of x.
    
    {
      return Math.Pow(Math.E, x);
    }
    
    [Button("Math")]
    public static double e()
    
      // Return Euler's constant.
    
    {
      return Math.E;
    }
    
    [Button("Math")]
    public static double Log(double x)
    
      // Return the decimal logarithm of x.
    
    {
      return Math.Log(x) / Math.Log(10.0);
    }
    
    [Button("Math", "10^X")]
    public static double TenToX(double x)
    
      // Return the inverse decimal logarithm of x.
    
    {
      return Math.Pow(10.0, x);
    }

    [Button("Math")]
    public static String FindFraction(double Fraction, int NumberOfTries)
    {
      String Prefix = "";
    
      if (Fraction < 0.0)
      {
        Prefix = "-";
      }
    
      Fraction = Math.Abs(Fraction);
    
      int    Numerator       = 0;
      int    Denominator     = 1;
      int    BestNumerator   = 0;
      int    BestDenominator = 0;
      double Error           = 0.0;
    
      for (int i = 0; i < NumberOfTries; i++)
      {
        double TmpFraction = (double) Numerator / (double) Denominator;
        double TmpError    = Math.Abs(TmpFraction - Fraction);
    
        if (i == 0 || TmpError < Error)
        {
          Error           = TmpError;
          BestNumerator   = Numerator;
          BestDenominator = Denominator;
        }
    
        if (TmpFraction < Fraction)
        {
          Numerator++;
        }
        else
        {
          Denominator++;
        }
      }
      
      return Prefix + BestNumerator.ToString() + "/"   + 
        BestDenominator.ToString() + "=" + 
        (double) BestNumerator / (double) BestDenominator;
    }

    [Button("Math")]
    public static double Random()
    {
      Random r = new Random();
      return (double) r.Next() / (double) int.MaxValue;
    }

    [Button("Main")]
    public static double IntegerPart(double d)
    {
      int sign = Math.Sign(d);
    
      return (sign * Math.Floor(Math.Abs(d)));
    }

    [Button("Main")]
    public static double FractionalPart(double d)
    {
      return d - IntegerPart(d);
    }
  
    [Button("Main")]
    public static double Round(double d)
    {
      return Math.Round(d);
    }
  
    [Button("Main")]
    public static double Floor(double d)
    {
      return Math.Floor(d);
    }
  
    [Button("Main")]
    public static double Ceiling(double d)
    {
      return Math.Ceiling(d);
    }

    private static String FormatMoney(double amount)
    {
      return amount.ToString("C");
    }
    
    [Button("Finance")]
    public static void Amortize(double principal, double interestRatePercent, int lengthOfLoanInYears)
    
      // US loan amortization
      //
      // This code demonstrates how to display results in HTML
      // and display them in Internet Explorer.
    
    {
      StringBuilder html = new StringBuilder();
  
      // Prompt the user for an optional monthly principal pre-payment.
      double monthlyPrincipalPayment;
  
      try
      {
        monthlyPrincipalPayment = (double) Util.Prompt(iapi.TheMainForm, "Extra Monthly Principal Payment", "Extra monthly principal payment:", "0.00", typeof(double));
      }
      catch (Exception)
      {
        monthlyPrincipalPayment = 0.0;
      }
  
      html.Append("<HTML>");
      
      double J = interestRatePercent / (12 * 100);
      int N = lengthOfLoanInYears * 12;
      double D = 1.0 - Math.Pow(1.0 + J, -N);
      double M = principal * (J / D);
      double T = M * N;
      
      html.Append("<BODY>");
      
      html.Append("Details:<BR/><BR/>");
      html.Append("<TABLE border='1'>");
      html.Append("<TR><TD>Principal</TD><TD>" + FormatMoney(principal) + "</TD></TR>");
      html.Append("<TR><TD>Term in Years</TD><TD>" + lengthOfLoanInYears + "</TD></TR>");
      html.Append("<TR><TD>Interest Rate</TD><TD>" + interestRatePercent + "%</TD></TR>");
      html.Append("<TR><TD>Monthly Normal Payment</TD><TD>" + FormatMoney(M) + "</TD></TR>");
      html.Append("<TR><TD>Monthly Extra Principal Payment</TD><TD>" + FormatMoney(monthlyPrincipalPayment) + "</TD></TR>");
      html.Append("<TR><TD>Monthly Total Payment</TD><TD>" + FormatMoney(M + monthlyPrincipalPayment) + "</TD></TR>");
      html.Append("<TR><TD>Total Payments</TD><TD>" + FormatMoney(T) + "</TD></TR>");
      html.Append("</TABLE><BR/>");
      
      html.Append("Schedule:<BR/><BR/>");
      
      html.Append("<TABLE border='1'>");
      
      html.Append("<THEAD>");
      html.Append("<TH>Month</TH>");
      html.Append("<TH>Principal</TH>");
      html.Append("<TH>Interest</TH>");
      html.Append("<TH>Balance</TH>");
      html.Append("</THEAD>");
      
      int totalMonths = 0;
  
      for (int Month = 1; Month <= N && principal > 0.0; totalMonths++, Month++)
      {
        double H = principal * J;
        double C = M - H;
        double newPrincipal = principal - C - monthlyPrincipalPayment;
        
        double Q = newPrincipal;
        
        html.Append("<TR>");
        html.Append("<TD>" + Month + "</TD>");
        html.Append("<TD>" + FormatMoney(C) + "</TD>");
        html.Append("<TD>" + FormatMoney(H) + "</TD>");
        html.Append("<TD>" + FormatMoney(Q) + "</TD>");
        html.Append("</TR>");
        
        principal = Q;
      }
      
      html.Append("</TABLE>");
  
      if (monthlyPrincipalPayment > 0.0)
      {
        // Calculate saved years.
        int savedMonths = N - totalMonths;
        
        html.Append("<P>");
        html.Append("Your monthly prepayment of " + FormatMoney(monthlyPrincipalPayment) + " reduced the term of your loan by " + savedMonths + " months or " + (savedMonths / 12.0).ToString("N") + " years.");
        html.Append("</P>");
      }
  
      html.Append("</BODY>");
      html.Append("</HTML>");
  
      Util.DisplayBrowser(iapi.TheMainForm, "USA Amortization Schedule", html.ToString(), true);    
    }

    [Button("Dates & Times")]
    // Returns the current date and time (in local timezone).
    public DateTime Now()
    {
      return DateTime.Now;
    }

    [Button("Dates & Times")]
    // Returns the current date (in the local timezone).  Time is midnight.
    public DateTime Today()
    {
      return DateTime.Today;
    }

    [Button("Dates & Times")]
    // Converts the specified date and time to Tniversal Time (GMT).
    public DateTime ToUniversalTime(DateTime dateTime)
    {
      return dateTime.ToUniversalTime();
    }

    [Button("Dates & Times")]
    // Converts the specified date and time from Universal Time to 
    // the local time zone.
    public DateTime ToLocalTime(DateTime dateTime)
    {
      return dateTime.ToLocalTime();
    }

    [Button("Dates & Times")]
    // If the user selects a date, a DateTime object will be placed
    // on the stack.
    //
    // If the user cancels the dialog box, a null value will be placed on the
    // stack.
    public object GetDate()
    {
      return Util.GetDate(iapi.TheMainForm, "Select Date", DateTime.Today);
    }

    [Button("Dates & Times")]
    // If the user selects a date range, a SelectionRange object will be placed
    // on the stack.  To extract the start and end date from the SelectionRange
    // object, use SelectionRange.Begin and SelectionRange.End.
    //
    // If the user cancels the dialog box, a null value will be placed on the
    // stack.
    public object GetDateRange()
    {
      return Util.GetDateRange(iapi.TheMainForm, "Select Date", DateTime.Today, 365);
    }

    [Button("Dates & Times")]
    // Adds the specified number of days to a date.
    public DateTime AddDays(DateTime date, int days)
    {
      return date.AddDays(days);
    }

    [Button("Dates & Times")]
    // Subtracts the specified number of days from a date.
    public DateTime SubtractDays(DateTime date, int days)
    {
      return date.AddDays(-days);
    }

    [Button("Dates & Times")]
    // Subtracts the dates and returns the resulting TimeSpan.
    public TimeSpan SubtractDates(DateTime date1, DateTime date2)
    {
      return date1.Subtract(date2);
    }

  }
}