name   CONFIRM
title  CONFIRM.Com 1.0
; copyright (c) 1998 Canadian Mind Products

Comment |

 Written in Microsoft Assembler MASM 5.0 or OptAsm 1.61b
 Last Updated:  1999 Sept 5 Roedy Green

Please report bugs and problems to:

Roedy Green
Canadian Mind Products
#208 - 525 Ninth Street
New Westminster BC Canada
V5H 2N6
tel:(604) 777-1804
mailto:roedy@mindprod.com
http://mindprod.com

Purpose
=======

 To ask the user to confirm some action.  User keys Y or N,
 which sets ERRORLEVEL to 0 or 1 respectively.


Syntax
======

 Echo "Are you sure you want to delete your files?"
 CONFIRM
 if errorlevel 1 GoTo NO
 del *.*
:NO


Version History:

Version 1:

| ; End of comment.


;======
stack   segment stack           ; keep MS link happy by providing null stack
stack   ends

;==============================================================

CODE    SEGMENT PARA            ; start off in code.

;==============================================================

data    segment word            ; provide a separate DATA segment
                                ; Even though it appears in the source
                                ; before the code, it the COM file it

YorNMsg         label byte
                db   13,10,"Hit Y for yes, or N for no.",13,10,"$"


YesMsg          label byte
                db  "  Yes",13,10,"$"

NoMsg           label byte
                db  "  No",13,10,"$"

BeepMsg         label byte
                db  7,"$"

data    endS


com     group   code,data

        ASSUME  CS:COM,DS:COM,ES:NOTHING
        ORG     100H
Start:
        ; prompt user to hit Y or N
        lea     dx,YorNMsg
        call    say
AGAIN:
        ; get char, wait,  without echo.
        MOV     AX,0700h        ; AH=07 signifies read char
        INT     21h             ; without Ctrl-C Ctrl-Break or
        cmp     al,"Y"
        je      YES
        cmp     al,"y"
        je      YES
        cmp     al,"N"
        je      NO
        cmp     al,"n"
        je      NO
        cmp     al,27           ; esc
        je      NO
        cmp     al,3            ; ctrl-C
        je     NO
        ; invalid char
        lea     dx,BeepMsg
        call    say
        jmp     Again

NO:
        lea     dx,NoMsg
        call    say
        mov     ax,4c01h        ; exit back to DOS, with 1 errorlevel
        int     21h

YES:
        lea     dx,YesMsg
        call    say
        mov     ax,4c00h        ; exit back to DOS, with 0 errorlevel
        int     21h

;=======================================

Say             Proc    Near
;       on entry DX points to a string to display on screen
        MOV     AH,9
        Int     21h
        ret
Say             EndP

;=======================================


;=======================================

CODE ends
end start
